package gov.va.med.mhv.bluebutton.web.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;

import org.apache.commons.lang.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.event.SelectEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@SessionScoped
public class BlueButtonFormBean implements Serializable {

	private static final long serialVersionUID = -4753567075660359376L;
	private static Logger logger = LogManager.getLogger(BlueButtonFormBean.class);

	//ADD DATE START-END
	private String selectForTypesOfInformation = "custom";
	private String dateSelection = "6";
	private Date startDate = DateUtils.addMonths(new Date(), -6);
	private Date endDate = new Date();
	
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getDateSelectionCustom() {
		this.startDate = startDate;
		setDateSelection("custom");
		return "custom";
	}
	
	public String getDateSelection() {
		return dateSelection;
	}

	public void setDateSelection(String dateSelection) {
		this.dateSelection = dateSelection;
	}

	public String getSelectForTypesOfInformation() {
		return selectForTypesOfInformation;
	}

	public void setSelectForTypesOfInformation(String selectForTypesOfInformation) {
		this.selectForTypesOfInformation = selectForTypesOfInformation;
		
		switch( selectForTypesOfInformation ) {
		case "all":
			if(logger.isDebugEnabled()) {
				logger.debug("User Selected ALL Options");
			}
			allappointments = true;
			allmedications = true;
			alllabs = true;
			allelectronic = true;
			allallergies = true;
			allimmunizations = true;
			allvitals = true;
			allselfreported = true;
			alljournals = true;
			allgoals = true;
			alldemographics = true;
			
			dodmilitaryservice = true;
			break;
		case "custom":
			if(logger.isDebugEnabled()) {
				logger.debug("User Selected Custom Options");
			}
			break;
		}
		
	}

	//Appointments
	private boolean allappointments;
	private boolean futureappointments;
	private boolean pastappointments;
	
	//Medications (automatically includes Allergy information)
	private boolean allmedications;
	private boolean prescriptions; //VA Medication History
	private boolean medications; //Medications and Supplements, Self-Reported

	//Labs and Tests
	private boolean alllabs;
	private boolean vachemlabs; //VA Laboratory Results   (3 day hold period applies) 
	private boolean vapathology; //VA Pathology Reports   (14 day hold period applies)  
	private boolean varadiology; //VA Radiology Reports   (3 day hold period applies)  
	private boolean vaekg; //VA Electrocardiogram (EKG) History (a list of EKG studies performed at VA Treating Facilities)  
	private boolean labsandtests; //Labs and Tests, Self-Reported  

	//VA Electronic Health Record History and Wellness Reminders 
	private boolean allelectronic;
	private boolean vaproblemlist; // VA Problem List   (3 day hold period applies)  
	private boolean vaadmissionsanddischarges; // VA Admissions and Discharges   (for Discharge Summary, 3 day hold period applies)   
	private boolean vaprogressnotes; // VA Notes   (from 01 JAN 2013 forward, 3 day hold period applies)  
	private boolean wellness; // VA Wellness Reminders 

	//Allergies
	private boolean allallergies;
	private boolean vaallergies; // VA Allergies  
	private boolean seiallergies; // Allergies, Self-Reported  

	//Immunizations 
	private boolean allimmunizations;
	private boolean vaimmunizations; // VA Immunizations  
	private boolean seiimmunizations; // Immunizations, Self-Reported  

	//Vitals and Readings 
	private boolean allvitals;
	private boolean vavitals; // VA Vitals and Readings  
	private boolean vitalsandreadings; // Vitals and Readings, Self-Reported  

	//Self-Reported Health History 
	private boolean allselfreported;
	private boolean medicalevents; // Medical Events, Self-Reported  
	private boolean familyhealthhistory; // Family Health History, Self-Reported  
	private boolean militaryhealthhistory; // Military Health History, Self-Reported  
	private boolean treatmentfacilities; // Treatment Facilities, Self-Reported  
	private boolean healthcareproviders; // Health Care Providers, Self-Reported  

	//Food and Activity Journals 
	private boolean alljournals;
	private boolean seiactivityjournal; // Activity Journal, Self-Reported 
	private boolean seifoodjournal; // Food Journal, Self-Reported  

	//Goals 
	private boolean allgoals;
	private boolean seimygoalscurrent; // My Goals: Current Goals, Self-Reported  
	private boolean seimygoalscompleted; // My Goals: Completed Goals, Self-Reported  

	//Demographics and Health Insurance
	private boolean alldemographics;
	private boolean vademographics; // VA Demographics (Demographic information from VA Treating Facilities in the last 3 years)  
	private boolean seidemographics; // Demographics, Self-Reported  
	private boolean healthinsurance; // Health Insurance, Self-Reported 

	//Department of Defense Information
	private boolean dodmilitaryservice; //Department of Defense Military Service Information

	
	public boolean isFutureappointments() {
		return futureappointments;
	}

	public void setFutureappointments(boolean futureappointments) {
		this.futureappointments = futureappointments;
	}

	public boolean isPastappointments() {
		return pastappointments;
	}

	public void setPastappointments(boolean pastappointments) {
		this.pastappointments = pastappointments;
	}

	public boolean isDodmilitaryservice() {
		return dodmilitaryservice;
	}

	public void setDodmilitaryservice(boolean dodmilitaryservice) {
		this.dodmilitaryservice = dodmilitaryservice;
	}

	public boolean isFamilyhealthhistory() {
		return familyhealthhistory;
	}

	public void setFamilyhealthhistory(boolean familyhealthhistory) {
		this.familyhealthhistory = familyhealthhistory;
	}

	public boolean isHealthcareproviders() {
		return healthcareproviders;
	}

	public void setHealthcareproviders(boolean healthcareproviders) {
		this.healthcareproviders = healthcareproviders;
	}

	public boolean isHealthinsurance() {
		return healthinsurance;
	}

	public void setHealthinsurance(boolean healthinsurance) {
		this.healthinsurance = healthinsurance;
	}

	public boolean isLabsandtests() {
		return labsandtests;
	}

	public void setLabsandtests(boolean labsandtests) {
		this.labsandtests = labsandtests;
	}

	public boolean isMedicalevents() {
		return medicalevents;
	}

	public void setMedicalevents(boolean medicalevents) {
		this.medicalevents = medicalevents;
	}

	public boolean isMedications() {
		return medications;
	}

	public void setMedications(boolean medications) {
		this.medications = medications;
	}

	public boolean isMilitaryhealthhistory() {
		return militaryhealthhistory;
	}

	public void setMilitaryhealthhistory(boolean militaryhealthhistory) {
		this.militaryhealthhistory = militaryhealthhistory;
	}

	public boolean isPrescriptions() {
		return prescriptions;
	}

	public void setPrescriptions(boolean prescriptions) {
		this.prescriptions = prescriptions;
	}

	public boolean isSeiactivityjournal() {
		return seiactivityjournal;
	}

	public void setSeiactivityjournal(boolean seiactivityjournal) {
		this.seiactivityjournal = seiactivityjournal;
	}

	public boolean isSeiallergies() {
		return seiallergies;
	}

	public void setSeiallergies(boolean seiallergies) {
		this.seiallergies = seiallergies;
	}

	public boolean isSeidemographics() {
		return seidemographics;
	}

	public void setSeidemographics(boolean seidemographics) {
		this.seidemographics = seidemographics;
	}

	public boolean isSeifoodjournal() {
		return seifoodjournal;
	}

	public void setSeifoodjournal(boolean seifoodjournal) {
		this.seifoodjournal = seifoodjournal;
	}

	public boolean isSeiimmunizations() {
		return seiimmunizations;
	}

	public void setSeiimmunizations(boolean seiimmunizations) {
		this.seiimmunizations = seiimmunizations;
	}

	public boolean isSeimygoalscompleted() {
		return seimygoalscompleted;
	}

	public void setSeimygoalscompleted(boolean seimygoalscompleted) {
		this.seimygoalscompleted = seimygoalscompleted;
	}

	public boolean isSeimygoalscurrent() {
		return seimygoalscurrent;
	}

	public void setSeimygoalscurrent(boolean seimygoalscurrent) {
		this.seimygoalscurrent = seimygoalscurrent;
	}

	public boolean isTreatmentfacilities() {
		return treatmentfacilities;
	}

	public void setTreatmentfacilities(boolean treatmentfacilities) {
		this.treatmentfacilities = treatmentfacilities;
	}

	public boolean isVaadmissionsanddischarges() {
		return vaadmissionsanddischarges;
	}

	public void setVaadmissionsanddischarges(boolean vaadmissionsanddischarges) {
		this.vaadmissionsanddischarges = vaadmissionsanddischarges;
	}

	public boolean isVaallergies() {
		return vaallergies;
	}

	public void setVaallergies(boolean vaallergies) {
		this.vaallergies = vaallergies;
	}

	public boolean isVachemlabs() {
		return vachemlabs;
	}

	public void setVachemlabs(boolean vachemlabs) {
		this.vachemlabs = vachemlabs;
	}

	public boolean isVademographics() {
		return vademographics;
	}

	public void setVademographics(boolean vademographics) {
		this.vademographics = vademographics;
	}

	public boolean isVaekg() {
		return vaekg;
	}

	public void setVaekg(boolean vaekg) {
		this.vaekg = vaekg;
	}

	public boolean isVaimmunizations() {
		return vaimmunizations;
	}

	public void setVaimmunizations(boolean vaimmunizations) {
		this.vaimmunizations = vaimmunizations;
	}

	public boolean isVapathology() {
		return vapathology;
	}

	public void setVapathology(boolean vapathology) {
		this.vapathology = vapathology;
	}

	public boolean isVaproblemlist() {
		return vaproblemlist;
	}

	public void setVaproblemlist(boolean vaproblemlist) {
		this.vaproblemlist = vaproblemlist;
	}

	public boolean isVaprogressnotes() {
		return vaprogressnotes;
	}

	public void setVaprogressnotes(boolean vaprogressnotes) {
		this.vaprogressnotes = vaprogressnotes;
	}

	public boolean isVaradiology() {
		return varadiology;
	}

	public void setVaradiology(boolean varadiology) {
		this.varadiology = varadiology;
	}

	public boolean isVavitals() {
		return vavitals;
	}

	public void setVavitals(boolean vavitals) {
		this.vavitals = vavitals;
	}

	public boolean isVitalsandreadings() {
		return vitalsandreadings;
	}

	public void setVitalsandreadings(boolean vitalsandreadings) {
		this.vitalsandreadings = vitalsandreadings;
	}

	public boolean isWellness() {
		return wellness;
	}

	public void setWellness(boolean wellness) {
		this.wellness = wellness;
	}

	public boolean isAllappointments() {
		return allappointments;
	}

	public void setAllappointments(boolean allappointments) {
		this.allappointments = allappointments;
	}

	public boolean isAllmedications() {
		return allmedications;
	}

	public void setAllmedications(boolean allmedications) {
		this.allmedications = allmedications;
	}

	public boolean isAlllabs() {
		return alllabs;
	}

	public void setAlllabs(boolean alllabs) {
		this.alllabs = alllabs;
	}

	public boolean isAllelectronic() {
		return allelectronic;
	}

	public void setAllelectronic(boolean allelectronic) {
		this.allelectronic = allelectronic;
	}

	public boolean isAllallergies() {
		return allallergies;
	}

	public void setAllallergies(boolean allallergies) {
		this.allallergies = allallergies;
	}

	public boolean isAllimmunizations() {
		return allimmunizations;
	}

	public void setAllimmunizations(boolean allimmunizations) {
		this.allimmunizations = allimmunizations;
	}

	public boolean isAllvitals() {
		return allvitals;
	}

	public void setAllvitals(boolean allvitals) {
		this.allvitals = allvitals;
	}

	public boolean isAllselfreported() {
		return allselfreported;
	}

	public void setAllselfreported(boolean allselfreported) {
		this.allselfreported = allselfreported;
	}

	public boolean isAlljournals() {
		return alljournals;
	}

	public void setAlljournals(boolean alljournals) {
		this.alljournals = alljournals;
	}

	public boolean isAllgoals() {
		return allgoals;
	}

	public void setAllgoals(boolean allgoals) {
		this.allgoals = allgoals;
	}

	public boolean isAlldemographics() {
		return alldemographics;
	}

	public void setAlldemographics(boolean alldemographics) {
		this.alldemographics = alldemographics;
	}

	public void initialize() {
		futureappointments=false;
		pastappointments=false;
		dodmilitaryservice=false;
		familyhealthhistory=false;
		healthcareproviders=false;
		healthinsurance=false;
		labsandtests=false;
		medicalevents=false;
		medications=false;
		militaryhealthhistory=false;
		prescriptions=false;
		seiactivityjournal=false;
		seiallergies=false;
		seidemographics=false;
		seifoodjournal=false;
		seiimmunizations=false;
		seimygoalscompleted=false;
		seimygoalscurrent=false;
		treatmentfacilities=false;
		vaadmissionsanddischarges=false;
		vaallergies=false;
		vachemlabs=false;
		vademographics=false;
		vaekg=false;
		vaimmunizations=false;
		vapathology=false;
		vaproblemlist=false;
		vaprogressnotes=false;
		varadiology=false;
		vavitals=false;
		vitalsandreadings=false;
		wellness=false;
		
		allappointments=false;
		allmedications=false;
		alllabs=false;
		allelectronic=false;
		allallergies=false;
		allimmunizations=false;
		allvitals=false;
		allselfreported=false;
		alljournals=false;
		allgoals=false;
		alldemographics=false;
		selectForTypesOfInformation = "custom";
		dateSelection = "6";
		startDate = DateUtils.addMonths(new Date(), -6);
		setStartDate(startDate);
		endDate = new Date();
		setEndDate(endDate);

	}

	public List<String> getSelectedValues() {
		checkSelectForTypesOfInformation();
		List<String> selections = new ArrayList<String>();
		if(!selections.contains("futureappointments")) {
			if(futureappointments) selections.add("futureappointments");
		}
		if(!selections.contains("pastappointments")) {
			if (pastappointments) selections.add("pastappointments");
		}
		if(!selections.contains("dodmilitaryservice")) {
			if (dodmilitaryservice) selections.add("dodmilitaryservice");
		}
		if(!selections.contains("familyhealthhistory")) {
			if (familyhealthhistory) selections.add("familyhealthhistory");
		}
		if(!selections.contains("healthcareproviders")) {
			if (healthcareproviders) selections.add("healthcareproviders");
		}
		if(!selections.contains("healthinsurance")) {
			if (healthinsurance) selections.add("healthinsurance");
		}
		if(!selections.contains("labsandtests")) {
			if (labsandtests) selections.add("labsandtests");
		}
		if(!selections.contains("medicalevents")) {
			if (medicalevents) selections.add("medicalevents");
		}
		if(!selections.contains("medications")) {
			if (medications) selections.add("medications");
		}
		if(!selections.contains("militaryhealthhistory")) {
			if (militaryhealthhistory) selections.add("militaryhealthhistory");
		}
		if(!selections.contains("prescriptions")) {
			if (prescriptions) selections.add("prescriptions");
		}
		if(!selections.contains("seiactivityjournal")) {
			if (seiactivityjournal) selections.add("seiactivityjournal");
		}
		if(!selections.contains("seiallergies")) {
			if (seiallergies) selections.add("seiallergies");
		}
		if(!selections.contains("seidemographics")) {
			if (seidemographics) selections.add("seidemographics");
		}
		if(!selections.contains("seifoodjournal")) {
			if (seifoodjournal) selections.add("seifoodjournal");
		}
		if(!selections.contains("seiimmunizations")) {
			if (seiimmunizations) selections.add("seiimmunizations");
		}
		if(!selections.contains("seimygoalscompleted")) {
			if (seimygoalscompleted) selections.add("seimygoalscompleted");
		}
		if(!selections.contains("seimygoalscurrent")) {
			if (seimygoalscurrent) selections.add("seimygoalscurrent");
		}
		if(!selections.contains("treatmentfacilities")) {
			if (treatmentfacilities) selections.add("treatmentfacilities");
		}
		if(!selections.contains("vaadmissionsanddischarges")) {
			if (vaadmissionsanddischarges) selections.add("vaadmissionsanddischarges");
		}
		if(!selections.contains("vaallergies")) {
			if (vaallergies) selections.add("vaallergies");
		}
		if(!selections.contains("vachemlabs")) {
			if (vachemlabs) {
				selections.add("vachemlabs");
				selections.add("vamicrobiology");
			}
		}
		if(!selections.contains("vademographics")) {
			if (vademographics) selections.add("vademographics");
		}
		if(!selections.contains("vaekg")) {
			if (vaekg) selections.add("vaekg");
		}
		if(!selections.contains("vaimmunizations")) {
			if (vaimmunizations) selections.add("vaimmunizations");
		}
		if(!selections.contains("vapathology")) {
			if (vapathology) selections.add("vapathology");
		}
		if(!selections.contains("vaproblemlist")) {
			if (vaproblemlist) selections.add("vaproblemlist");
		}
		if(!selections.contains("vaprogressnotes")) {
			if (vaprogressnotes) selections.add("vaprogressnotes");
		}
		if(!selections.contains("varadiology")) {
			if (varadiology) selections.add("varadiology");
		}
		if(!selections.contains("vavitals")) {
			if (vavitals) selections.add("vavitals");
		}
		if(!selections.contains("vitalsandreadings")) {
			if (vitalsandreadings) selections.add("vitalsandreadings");
		}
		if(!selections.contains("wellness")) {
			if (wellness) selections.add("wellness");
		}

		if( allappointments ) { 
			if(!selections.contains("futureappointments")) {
				selections.add("futureappointments");
			}
			if(!selections.contains("pastappointments")) {
				selections.add("pastappointments");
			}
		}
		if( allmedications ) { 
			if(!selections.contains("medications")) {
				selections.add("medications");
			}
			if(!selections.contains("prescriptions")) {
				selections.add("prescriptions");
			}
		}
		if( alllabs ) { 
			if(!selections.contains("vachemlabs")) {
				selections.add("vachemlabs");
				selections.add("vamicrobiology");
			}
			if(!selections.contains("varadiology")) {
				selections.add("varadiology");
			}
			if(!selections.contains("vaekg")) {
				selections.add("vaekg");
			}
			if(!selections.contains("vapathology")) {
				selections.add("vapathology");
			}
			if(!selections.contains("labsandtests")) {
				selections.add("labsandtests");
			}
		}
		if( allelectronic ) { 
			if(!selections.contains("vaadmissionsanddischarges")) {
				selections.add("vaadmissionsanddischarges");
			}
			if(!selections.contains("vaproblemlist")) {
				selections.add("vaproblemlist");
			}
			if(!selections.contains("wellness")) {
				selections.add("wellness");
			}
			if(!selections.contains("vaprogressnotes")) {
				selections.add("vaprogressnotes");
			}
		}
		if( allallergies ) { 
			if(!selections.contains("seiallergies")) {
				selections.add("seiallergies");
			}
			if(!selections.contains("vaallergies")) {
				selections.add("vaallergies");
			}
		}
		if( allimmunizations ) { 
			if(!selections.contains("vaimmunizations")) {
				selections.add("vaimmunizations");
			}
			if(!selections.contains("seiimmunizations")) {
				selections.add("seiimmunizations");
			}
		}
		if( allvitals ) { 
			if(!selections.contains("vavitals")) {
				selections.add("vavitals");
			}
			if(!selections.contains("vitalsandreadings")) {
				selections.add("vitalsandreadings");
			}
		}
		if( allselfreported ) { 
			if(!selections.contains("treatmentfacilities")) {
				selections.add("treatmentfacilities");
			}
			if(!selections.contains("medicalevents")) {
				selections.add("medicalevents");
			}
			if(!selections.contains("militaryhealthhistory")) {
				selections.add("militaryhealthhistory");
			}
			if(!selections.contains("familyhealthhistory")) {
				selections.add("familyhealthhistory");
			}
			if(!selections.contains("healthcareproviders")) {
				selections.add("healthcareproviders");
			}
		}
		if( alljournals ) { 
			if(!selections.contains("seiactivityjournal")) {
				selections.add("seiactivityjournal");
			}
			if(!selections.contains("seifoodjournal")) {
				selections.add("seifoodjournal");
			}
		}
		if( allgoals ) { 
			if(!selections.contains("seimygoalscompleted")) {
				selections.add("seimygoalscompleted");
			}
			if(!selections.contains("seimygoalscurrent")) {
				selections.add("seimygoalscurrent");
			}
		}
		if( alldemographics ) { 
			if(!selections.contains("vademographics")) {
				selections.add("vademographics");
			}
			if(!selections.contains("seidemographics")) {
				selections.add("seidemographics");
			}
			if(!selections.contains("healthinsurance")) {
				selections.add("healthinsurance");
			}
		}
		return selections;
	}
	
	private void checkSelectForTypesOfInformation() {
		if(getSelectForTypesOfInformation().equals("all")) {
			futureappointments=true;
			pastappointments=true;
			dodmilitaryservice=true;
			familyhealthhistory=true;
			healthcareproviders=true;
			healthinsurance=true;
			labsandtests=true;
			medicalevents=true;
			medications=true;
			militaryhealthhistory=true;
			prescriptions=true;
			seiactivityjournal=true;
			seiallergies=true;
			seidemographics=true;
			seifoodjournal=true;
			seiimmunizations=true;
			seimygoalscompleted=true;
			seimygoalscurrent=true;
			treatmentfacilities=true;
			vaadmissionsanddischarges=true;
			vaallergies=true;
			vachemlabs=true;
			vademographics=true;
			vaekg=true;
			vaimmunizations=true;
			vapathology=true;
			vaproblemlist=true;
			vaprogressnotes=true;
			varadiology=true;
			vavitals=true;
			vitalsandreadings=true;
			wellness=true;
			
			allappointments=true;
			allmedications=true;
			alllabs=true;
			allelectronic=true;
			allallergies=true;
			allimmunizations=true;
			allvitals=true;
			allselfreported=true;
			alljournals=true;
			allgoals=true;
			alldemographics=true;

			
		}
	}
}
