package gov.va.med.mhv.bluebutton.service.impl;

import gov.va.med.mhv.bluebutton.DownloadYourReportService;
import gov.va.med.mhv.bluebutton.bbdownload.util.BlueButtonUtil;
import gov.va.med.mhv.bluebutton.bbdownload.util.PdfXHTMLWrapper;
import gov.va.med.mhv.bluebutton.converter.MhvDownloadReportConverter;
import gov.va.med.mhv.bluebutton.model.MhvDownloadData;
import gov.va.med.mhv.bluebutton.model.MhvDownloadReport;
import gov.va.med.mhv.bluebutton.repository.MhvDownloadDataRepository;
import gov.va.med.mhv.bluebutton.repository.MhvDownloadReportRepository;
import gov.va.med.mhv.bluebutton.transfer.BlueButtonReport;
import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportSelectionsDTO;
import gov.va.med.mhv.bluebutton.transfer.MhvDownloadReportDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.ReportTypeEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.integration.phr.service.ServiceResponse;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.usermgmt.service.PatientWebService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Resource;
import javax.ws.rs.core.Response;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.itextpdf.text.DocumentException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;



public class DownloadYourReportServiceImpl implements DownloadYourReportService{

	@Resource
	private MhvDownloadReportRepository mhvDownloadReportRepository;

	@Resource
	private MhvDownloadDataRepository mhvDownloadDataRepository;

	@Resource
	private PatientWebService patientProxy;
	
	@Resource
	private UserMgmtService userProxy;

	@Resource
	private MhvDownloadReportConverter mhvDownloadReportConverter;
	
	@Autowired
	PdfXHTMLWrapper pdfWrapper;
	
	@Value("${phrManagerendpointUrl}")
	private String phrManagerendpointUrl;

	@Value("${phrmgr.xauth.key}")
	private String authenticationHeaderValue;
	
	@Autowired
	private ObjectMapper mapper;

	protected static final String authenticationHeader = "X-Authorization-Key";

	private static final Log log = LogFactory.getLog(DownloadYourReportServiceImpl.class);
	
	private static final String CONTENT_TYPE = "application/json";
	
//	@Override
//	public BlueButtonReport getReportbyReportId(Long downloadReportId, ReportTypeEnum reportType) {
//
//		//TODO: get report XHTML/TXT from database
//
//		BlueButtonReport report = new BlueButtonReport();
//		report.setData("This is a test".getBytes());
//		report.setFilename("Filename");
//
//		switch(reportType) {
//		case PDF: report.setFilename(report.getFilename()+"."+ReportTypeEnum.PDF); 
//		break;
//		case TXT: report.setFilename(report.getFilename()+"."+ReportTypeEnum.TXT); 
//		break;
//		default:
//
//		}
//
//		return report;
//	}

	@Override
	public Response getPHRRefreshStatus(Long patientId) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void doRefresh(String icn) {
		// TODO Auto-generated method stub
		try {
			refreshAllPhrData(icn);
		} catch (MHVException e) {
			// TODO Auto-generated catch block
			log.error("Exception occured while calling PHR-R");
		}
	}

	@Override
	public Response generateSelectedDownload(Long userprofileId, BlueButtonReportSelectionsDTO genRepTO) {

		String optionList=null;

		Set<String> set = new HashSet<>(Arrays.asList(genRepTO.getDataClasses()));
		Collection dataClasses = Arrays.asList(set);

		if(genRepTO.getDataClasses() != null) {
			optionList=StringUtils.join(dataClasses.iterator(),',');
		}

		Date start = BlueButtonUtil.convertRFC1123PatterntoDate(genRepTO.getFromDate());
		Date end = BlueButtonUtil.convertRFC1123PatterntoDate(genRepTO.getToDate());

		java.sql.Date startDate = start != null ? new java.sql.Date(start.getTime()): null;
		java.sql.Date endDate = end != null ? new java.sql.Date(end.getTime()): null;	

		ResponseBuilderImpl builder = new ResponseBuilderImpl();

		try {
			//		mhvDownloadReportRepository.generateDownload(userprofileId.longValue(), optionList, startDate, 
			//										endDate, genRepTO.getDateSelection().longValue(), genRepTO.getTypeSelection().longValue());
			//		String[] dataClassArray = genRepTO.getDataClasses();
			//		String options = Arrays.toString(dataClassArray);

			String options2=StringUtils.join(genRepTO.getDataClasses(),',');
			
			if(log.isDebugEnabled())
				log.debug("The Requested Report for "+userprofileId + " has options: "+options2);
			if(options2.isEmpty())
				log.error("The Requested Report for "+userprofileId +" has NO options set: "+options2);
			System.out.println("Start Date " + startDate.toString() + " End Date " + endDate.toString());
			mhvDownloadReportRepository.generateDownload(
					userprofileId.longValue(),	options2, startDate,endDate, 
					(genRepTO.getDateRange()!= null)?genRepTO.getDateRange().getValue(): 4l, 
							(genRepTO.getSelectionType()!= null)?genRepTO.getSelectionType().getValue(): 4l
					);

		} catch(NegativeArraySizeException nArrayEx){
			// Do Nothing
			log.error("Error Occured:: " + nArrayEx );
			String r = "{\"status\" : \"OK\",\"description\" : null,\"nextDate\" : {} }";
			return builder.entity(r).status(200).build();
		}

		String r = "{\"status\" : \"OK\",\"description\" : null,\"nextDate\" : {} }";
		return builder.entity(r).status(200).build();
	}

	@Override
	public MhvDownloadReportDTO getDownloadedReport(Long userProfileId) {
		List<MhvDownloadReport> mhvDownloadReportList = mhvDownloadReportRepository.findLatestReportByUserProfileId(userProfileId);
		MhvDownloadReport mhvDownloadReport = mhvDownloadReportList.get(0);
		MhvDownloadReportDTO mhvDownloadReportDTO = mhvDownloadReportConverter.convert(mhvDownloadReport);
		return mhvDownloadReportDTO;
	}

	@Override
	public Response generateDownload(Long userId, Long downloadReportId, ReportTypeEnum reportType) {
		
		List<MhvDownloadData> mhvDownloadDataList = null;
		if (reportType.isTXT(reportType)) {
			mhvDownloadDataList = mhvDownloadDataRepository.findReportByReportId(downloadReportId, "TXT");
			if(mhvDownloadDataList.size() > 1) {
				return null;
			}
		}
		else if (reportType.isPDF(reportType) || reportType.isXHTML(reportType)) {
			mhvDownloadDataList = mhvDownloadDataRepository.findReportByReportId(downloadReportId, "XHTML");
			if(mhvDownloadDataList.size() > 1) {
				return null;
			}
			
		} else if (reportType.isPDFDL(reportType) ) {
			mhvDownloadDataList = mhvDownloadDataRepository.findReportByReportId(downloadReportId, "XHTML");
			if(mhvDownloadDataList.size() > 1) {
				return null;
			}
			
		} else if (reportType.isTXTDL(reportType)) {
			mhvDownloadDataList = mhvDownloadDataRepository.findReportByReportId(downloadReportId, "TXT");
			if(mhvDownloadDataList.size() > 1) {
				return null;
			}
		}
		MhvDownloadData mhvDownloadData = mhvDownloadDataList.get(0);

		MhvDownloadReport mhvDownloadReport = mhvDownloadReportRepository.findByReportId(downloadReportId);

		String result = null;
		Clob valueClob = mhvDownloadData.getFileContents();
		try {
			if(valueClob != null && valueClob.length() > 0L) {
				result = valueClob.getSubString(1L, (int)valueClob.length());
			} 
		}catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		switch(reportType) {
		case XHTML:
			try {
				PatientDTO patDTO = patientProxy.getPatientByUserProfileId(userId);
				UserProfileDTO userProfile = patDTO.getUserProfile();
				StringBuffer userFirstLastName = new StringBuffer();

				userFirstLastName.append(userProfile.getName().getLastName() != null ? 
						userProfile.getName().getLastName(): "");

				if(userProfile.getName().getFirstName() != null) {
					userFirstLastName.append(", ");
					userFirstLastName.append(userProfile.getName().getFirstName());
				}
				else {
					userFirstLastName.append("");
				}
				if(userProfile.getName().getMiddleName() != null) {
					userFirstLastName.append(" " +userProfile.getName().getMiddleName());
				}
				StringBuffer pdfFileName = new StringBuffer();
				pdfFileName.append(mhvDownloadReport.getFileName().substring(0, mhvDownloadReport.getFileName().indexOf(".")));
				pdfFileName.append(".pdf");
				String fileName = pdfFileName.toString();
				
				return Response.ok().entity(result).header("Content-Type","text/plain").header
						("Content-Length", result.getBytes().length).header("Content-Disposition","inline; filename="+fileName).build();
				
			} catch (MHVException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
			break;
		case PDF: 
			//Do Funky Stuff....
			try {
				PatientDTO patDTO = patientProxy.getPatientByUserProfileId(userId);
				UserProfileDTO userProfile = new UserProfileDTO();
				StringBuffer userFirstLastName = new StringBuffer();
				if(patDTO == null) {  //patDTO will only be null on basic users
					userProfile = userProxy.getUserProfileById(userId);
					userFirstLastName.append(userProfile.getName().getLastName() != null ? 
							userProfile.getName().getLastName(): "");
					if(userProfile.getName().getFirstName() != null) {
						userFirstLastName.append(", ");
						userFirstLastName.append(userProfile.getName().getFirstName());
					}
					else {
						userFirstLastName.append("");
					}
					if(userProfile.getMiddleName() != null) {
						userFirstLastName.append(" " + userProfile.getName().getMiddleName());
					}
				} else {
					userProfile = patDTO.getUserProfile();
					userFirstLastName.append(userProfile.getName().getLastName() != null ? 
							userProfile.getName().getLastName(): "");
					if(userProfile.getName().getFirstName() != null) {
						userFirstLastName.append(", ");
						userFirstLastName.append(userProfile.getName().getFirstName());
					}
					else {
						userFirstLastName.append("");
					}
					if(userProfile.getName().getMiddleName() != null) {
						userFirstLastName.append(" " +userProfile.getName().getMiddleName());
					}
				}
				StringBuffer pdfFileName = new StringBuffer();
				pdfFileName.append(mhvDownloadReport.getFileName().substring(0, mhvDownloadReport.getFileName().indexOf(".")));
				pdfFileName.append(".pdf");
				String fileName = pdfFileName.toString();

				byte[] allPdfBytes = pdfWrapper.makePdfFromXhtml(userFirstLastName.toString(), result);
				return Response.ok().entity(allPdfBytes).header("Content-Type","application/pdf").header
						("Content-Length", allPdfBytes.length).header("Content-Disposition","inline; filename="+fileName).build();
			} catch (DocumentException | IOException | MHVException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
			break;
		case TXT: 

			StringBuffer txtFileName = new StringBuffer();
			txtFileName.append(mhvDownloadReport.getFileName().substring(0, mhvDownloadReport.getFileName().indexOf(".")));
			txtFileName.append(".txt");
			String fileName = txtFileName.toString();
			return Response.ok().entity(result).header("Content-Type","text/plain").header
					("Content-Length", result.getBytes().length).header("Content-Disposition","inline; filename="+fileName).build();
			//break;
		case PDFDL: 
			//Needed for downloading report as attachment
			//Do Funky Stuff....
			try {
				PatientDTO patDTO = patientProxy.getPatientByUserProfileId(userId);
				UserProfileDTO userProfile = new UserProfileDTO();
				StringBuffer userFirstLastName = new StringBuffer();
				if(patDTO == null) { //patDTO will only be null on basic users
					userProfile = userProxy.getUserProfileById(userId);
					userFirstLastName.append(userProfile.getName().getLastName() != null ? 
							userProfile.getName().getLastName(): "");
					if(userProfile.getName().getFirstName() != null) {
						userFirstLastName.append(", ");
						userFirstLastName.append(userProfile.getName().getFirstName());
					}
					else {
						userFirstLastName.append("");
					}
					if(userProfile.getMiddleName() != null) {
						userFirstLastName.append(" " + userProfile.getName().getMiddleName());
					}
				} else {
					userProfile = patDTO.getUserProfile();
					userFirstLastName.append(userProfile.getName().getLastName() != null ? 
							userProfile.getName().getLastName(): "");
					if(userProfile.getName().getFirstName() != null) {
						userFirstLastName.append(", ");
						userFirstLastName.append(userProfile.getName().getFirstName());
					}
					else {
						userFirstLastName.append("");
					}
					if(userProfile.getName().getMiddleName() != null) {
						userFirstLastName.append(" " +userProfile.getName().getMiddleName());
					}
				}
				StringBuffer pdfFileName = new StringBuffer();
				pdfFileName.append(mhvDownloadReport.getFileName().substring(0, mhvDownloadReport.getFileName().indexOf(".")));
				pdfFileName.append(".pdf");
				String fileNameDL = pdfFileName.toString();

				byte[] allPdfBytes = pdfWrapper.makePdfFromXhtml(userFirstLastName.toString(), result);
				return Response.ok().entity(allPdfBytes).header("Content-Type","application/pdf").header
						("Content-Length", allPdfBytes.length).header("Content-Disposition","attachment; filename="+fileNameDL).build();
			} catch (DocumentException | IOException | MHVException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
			break;
		case TXTDL: 
			//Needed for downloading report as attachment
			StringBuffer txtFileNameDL = new StringBuffer();
			txtFileNameDL.append(mhvDownloadReport.getFileName().substring(0, mhvDownloadReport.getFileName().indexOf(".")));
			txtFileNameDL.append(".txt");
			String fileNameDL = txtFileNameDL.toString();
			return Response.ok().entity(result).header("Content-Type","text/plain").header
					("Content-Length", result.getBytes().length).header("Content-Disposition","attachment; filename="+fileNameDL).build();

		default:

		}



		return null;
	}

	@Override
	public Response updateLastAccess(Long downloadReportId) {
		// TODO Auto-generated method stub
		return null;
	}

	private void refreshAllPhrData(String icn) throws MHVException {
		if(log.isDebugEnabled()) {
			log.debug("Submitting a PHR refresh request for " + icn);
		}
		
		WebClient client = getPHRManagerWebClient().path("refresh")
				.path(icn).accept(CONTENT_TYPE)
				.type(CONTENT_TYPE)
				.header(authenticationHeader, getAuthenticationHeaderValue());
		Response webserviceResponse = client.post(null);
		if (webserviceResponse.getStatus() == 200) {
			if(log.isDebugEnabled()) {
				log.debug("Response from PHR refresh service: " + webserviceResponse.getEntity().toString());				
			}
			Reader responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
			try {
				ServiceResponse r = mapper.readValue(responseReader, ServiceResponse.class);
				if(log.isDebugEnabled()) {
					log.debug("Refresh has been submitted with status of "  + r.getStatus());
				}
			} catch (Exception e) {
				log.error("Unable to process the results from a PHR Refresh request",e);
				throw new MHVException("Unable to determine the refresh status");
			}
		} else {
			log.error("Unable to submit the PHR Refresh to the webservice");
			throw new MHVException("Unable to submit a request to refresh");
		}
	}

	@Override
	public PatientExtractStatus getPatientExtractStatus(String icn) throws MHVException {
		PatientExtractStatus patientExtractStatus = null;
		
		if (icn != null) {
			GsonBuilder builder = new GsonBuilder();
			builder.registerTypeAdapter(Date.class,
					new JsonDeserializer<Date>() {
						@Override
						public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
							return new Date(json.getAsJsonPrimitive().getAsLong());
						}
					});
			Gson gson = builder.create();
			WebClient client = getPHRManagerWebClient()
					.path("status")
					.path(icn)
					.accept(CONTENT_TYPE)
					.header(authenticationHeader, getAuthenticationHeaderValue());
			Response webserviceResponse = client.get();

			if (webserviceResponse.getStatus() == 200) {
				Reader responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				patientExtractStatus = gson.fromJson(responseReader, PatientExtractStatus.class);
				if(log.isDebugEnabled()) {
					log.debug("Retrieved PHR status: " + patientExtractStatus);
				}
			} else {
				log.error("Error invoking PHR status service: " + BlueButtonUtil.formatErrorMessage(client, webserviceResponse));
				throw new MHVException("Error resulted from attempting to get a phr refresh status");
			}
		}
		return patientExtractStatus;
	}
	
	
	private WebClient getPHRManagerWebClient() {
		if(log.isDebugEnabled()) {
			log.debug("PHR Manager endpoint: " + phrManagerendpointUrl);
		}
		return WebClient.create(getPhrManagerendpointUrl());
	}
	
	public String getPhrManagerendpointUrl() {
		return phrManagerendpointUrl;
	}
	
	public void setPhrManagerendpointUrl(String phrManagerendpointUrl) {
		this.phrManagerendpointUrl = phrManagerendpointUrl;
	}

	public String getAuthenticationHeaderValue() {
		return authenticationHeaderValue;
	}

	public void setAuthenticationHeaderValue(String authenticationHeaderValue) {
		this.authenticationHeaderValue = authenticationHeaderValue;
	}


}
