package gov.va.med.mhv.bluebutton.service.impl;

import gov.va.med.mhv.bluebutton.BBMIMdbService;
import gov.va.med.mhv.bluebutton.bbmi.imaging.util.EncryptedStudy;
import gov.va.med.mhv.bluebutton.model.StudyJob;
import gov.va.med.mhv.bluebutton.repository.StudyJobRepository;
import gov.va.med.mhv.bluebutton.transfer.BbmiEventMessage;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.service.PatientWebService;

import java.io.IOException;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class BBMIMdbServiceImpl implements BBMIMdbService {

	@Resource
	private StudyJobRepository studyJobRepository;

	@Resource
	private EncryptedStudy encryptedStudy;

	private static final Log log = LogFactory.getLog(BBMIMdbServiceImpl.class);

	@Value("${folder}")
	private String FOLDER_PROP;

	@Override
	public void doCvixServiceJob(BbmiEventMessage bbmiEventMessage) throws MHVException {
		StudyJob job = studyJobRepository.findOne(bbmiEventMessage.getStudyJobId());
		
		encryptedStudy.setLocalFolder(FOLDER_PROP);
		encryptedStudy.setPatientId(bbmiEventMessage.getPatientId());
		encryptedStudy.setStudyId(bbmiEventMessage.getStudyId());
		encryptedStudy.setIcn(bbmiEventMessage.getIcn());
		encryptedStudy.setServerNode(job.getServerNode());

		try {
			encryptedStudy.writeStudy(job);
		} catch (IOException e) {
			log.error("exception occurred" + e);
		}

	}

}
