package gov.va.med.mhv.bluebutton.service.impl;

import gov.va.med.mhv.bluebutton.BBMIMdbResumeService;
import gov.va.med.mhv.bluebutton.bbmi.BbmiMdbSender;
import gov.va.med.mhv.bluebutton.bbmi.imaging.util.StudyJobConstants;
import gov.va.med.mhv.bluebutton.model.StudyJob;
import gov.va.med.mhv.bluebutton.repository.StudyJobRepository;
import gov.va.med.mhv.bluebutton.transfer.BbmiEventMessage;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.service.SessionAPIService;
import gov.va.med.mhv.usermgmt.service.PatientWebService;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.ws.rs.core.Response;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class BBMIMdbResumeServiceImpl implements BBMIMdbResumeService, ApplicationListener<ContextRefreshedEvent>{ 
	private static Logger logger = LogManager.getLogger(BBMIMdbResumeServiceImpl.class);

	@Resource
	private StudyJobRepository studyJobRepository;
	
	@Resource
	private PatientWebService patientProxy;
	
	@Autowired
	BbmiMdbSender jmsBBMIStudySender;
	
	private static final Log log = LogFactory.getLog(BBMIMdbResumeServiceImpl.class);
	
	@Override
	public void onApplicationEvent(ContextRefreshedEvent arg0) {
		
		String serverNode = System.getProperty("weblogic.Name","None");
		try {
			if(logger.isDebugEnabled()) {
				logger.debug("*************** BBMIMdbResumeServiceImpl Initiated...  *****************");	
			}
			// FIRST CHECK IF THE JOB IS ALREADY CREATED
			List<StudyJob> jobs = studyJobRepository.getPhrStudyJobsByStatus(StudyJobConstants.PROCESSING, serverNode);

			if(log.isInfoEnabled()) {
				if( jobs.size() > 0 ) {
					if (log.isInfoEnabled())
					log.info("Attempting to restart " + jobs.size() + " Phr Study jobs");
				}
			}

			// CHECK IF THE JOB WAS CANCELLED THEN RE-QUEUE IT; IF IT IS ERRORED THEN ALLOW A RETRY
			for( StudyJob job: jobs ) {
				try {
					job.setStatus(StudyJobConstants.NEW);
					job.setCreatedDate(new Date()); // reset the created date
					job.setTempFileName("");
					job.setFileName("");
					studyJobRepository.save(job);
					
					// ADD THE JOB TO THE BACKGROUND QUEUE
					BbmiEventMessage bbmiEventMesg = new BbmiEventMessage(job.getPatientId(), job.getStudyIdUrn(), null, job.getId() );
					jmsBBMIStudySender.sendMessage(bbmiEventMesg);
				} catch (Exception e1) {
					log.error("exception occured" + e1);
				}
			}
		} catch (Exception e) {
			log.error("Unable to restart jobs due to " + e.getMessage(),e);
		}
	}
}
