package gov.va.med.mhv.bluebutton.essapi.service.impl;

import gov.va.med.mhv.bluebutton.DownloadYourReportService;
import gov.va.med.mhv.bluebutton.essapi.service.BBAPIService;
import gov.va.med.mhv.bluebutton.essapi.transfer.DataClassTO;
import gov.va.med.mhv.bluebutton.essapi.transfer.FacilityExtractStatusTO;
import gov.va.med.mhv.bluebutton.essapi.transfer.FacilityExtractStatusesTO;
import gov.va.med.mhv.bluebutton.essapi.transfer.GenerateReportTO;
import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportSelectionsDTO;
import gov.va.med.mhv.bluebutton.transfer.MhvDownloadReportDTO;
import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.DateRangeEnum;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.enumeration.InformationSelectionTypeEnum;
import gov.va.med.mhv.common.api.enumeration.ReportTypeEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.Session;
import gov.va.med.mhv.common.api.util.MHVApiUtility;
import gov.va.med.mhv.common.api.util.MHVEssApiUtility;
import gov.va.med.mhv.common.api.util.PropertiesHelper;
import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatusEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationWebService;
import gov.va.med.mhv.usermgmt.service.PatientWebService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import javax.annotation.Resource;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;


public class BBAPIServiceImpl implements BBAPIService{
	private static final Log log = LogFactory.getLog(BBAPIServiceImpl.class);

	@Context
	MessageContext mc;
	
	@Resource
	private UserMgmtService userMgmtServiceProxy;
	
	@Resource
	private PatientWebService patientWebProxy;
	
	@Resource
	private DownloadYourReportService downloadYourReportService;
	
	@Resource
	private InPersonAuthenticationWebService ipaWebProxy;
	
	@Resource(name = "activityProxy")
	private AccountActivityCreatorService activityProxy;
	
	@Override
	public String getBlueButtonReport() {
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = null;
		try {
			uf = userMgmtServiceProxy.getUserProfileById(session.getUserId());
		} catch (MHVException e2) {
			// TODO Auto-generated catch block
		}
		return null;
	}

	@Override
	public Response doRefresh() {
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		if(uf != null) {
			PatientDTO pat = getPatientDTO(uf);
			if(pat != null) {
				try {
					downloadYourReportService.doRefresh(pat.getIcn());
				}catch (Exception e) {
					log.error("Exception Occurred in PHR-R Refresh",e);
					MHVEssApiUtility.throwException(ErrorEnum.UNKNOWN_99);
				}
			}

		}
		ResponseBuilderImpl builder = new ResponseBuilderImpl();
		String r = "{\"status\" : \"OK\",\"description\" : null,\"nextDate\" : {} }";
		return builder.entity(r).status(200).build();
	}

	@Override
	public Response generateBBReport(GenerateReportTO genRepTO) {
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);

		Date fromDate = null;
		Date toDate = null;
		
		fromDate = MHVApiUtility.convertRFCPatterntoDate(genRepTO.getFromDate());
		toDate = MHVApiUtility.convertRFCPatterntoDate(genRepTO.getToDate());
		
		if(fromDate == null || toDate == null) {
			log.error("Exception Occurred in Generate BB Report");
			MHVEssApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
		}
		
		PatientDTO pat = getPatientDTO(uf);
		if(pat == null) {
			MHVEssApiUtility.throwException(ErrorEnum.UNKNOWN_99);
		}
				
		Collection dataList = constructEligibleDataClassList(pat, genRepTO.getDataClasses());
		Response response = null;
		if(uf != null && dataList != null) {
			BlueButtonReportSelectionsDTO bbReportSelectionsDTO = new BlueButtonReportSelectionsDTO(genRepTO.getDataClasses(), 
																									genRepTO.getFromDate(), 
																									genRepTO.getToDate(), 
																									DateRangeEnum.CUSTOM, 
																									InformationSelectionTypeEnum.CUSTOM); 
			response = downloadYourReportService.generateSelectedDownload(uf.getId(),bbReportSelectionsDTO);
		}
		else {
			try {
				activityProxy.createAccountActivityLog(
											ActivityHelper.createActivityDTOForSelf(
											uf.getId(), false, 
											ActivityTypeEnumeration.DOWNLOAD, 
											ActivityActionTypeEnumeration.CUSTOM_DOWNLOAD_REQUESTED, 
											MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
											);
			} catch (MHVException e) {
				log.error("Exception occured in Activity Track", e);
				MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
			}
			MHVEssApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
		}
		if (response == null || (response.getStatus() != 200)) {
			try {
				activityProxy.createAccountActivityLog(
											ActivityHelper.createActivityDTOForSelf(
											uf.getId(), false, 
											ActivityTypeEnumeration.DOWNLOAD, 
											ActivityActionTypeEnumeration.CUSTOM_DOWNLOAD_REQUESTED, 
											MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
											);
			} catch (MHVException e) {
				log.error("Exception occured in Activity Track", e);
				MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
			}
		}
		
		try {
			activityProxy.createAccountActivityLog(
										ActivityHelper.createActivityDTOForSelf(
										uf.getId(), true, 
										ActivityTypeEnumeration.DOWNLOAD, 
										ActivityActionTypeEnumeration.CUSTOM_DOWNLOAD_REQUESTED, 
										MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
										);
		} catch (MHVException e) {
			log.error("Exception occured in Activity Track");
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e);
		}
		ResponseBuilderImpl builder = new ResponseBuilderImpl();
		String r = "{\"status\" : \"OK\",\"description\" : null,\"nextDate\" : {} }";
		return builder.entity(r).status(200).build();
	}

	@Override
	public FacilityExtractStatusesTO getExtractStatus() {
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		
		List<FacilityExtractStatusTO> facilityExtractStatusList = new ArrayList<FacilityExtractStatusTO>();
		if(uf != null) {
			PatientDTO pat = getPatientDTO(uf);
			if(pat != null) {
				try {
					PatientExtractStatus patientExtractStatusRes =
							downloadYourReportService.getPatientExtractStatus(pat.getIcn());
					
					Collection<FacilityExtractStatus> statusses = patientExtractStatusRes.getFacilityExtractStatusList();
					//MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, facilityExtractStatusRes);
					for(FacilityExtractStatus status : statusses) {
						FacilityExtractStatusTO fac = new FacilityExtractStatusTO();
						if(status.getLastRequested() != null)
							fac.setCreatedOn(MHVApiUtility.convertDateToRFC1123Pattern(status.getLastRequested()));
						else
							fac.setCreatedOn("");
						fac.setExtractType(status.getExtract());
						//fac.setFacility(status.getFacility());
						fac.setStatus(status.getLoadStatus());
						if(status.getLastModified() != null)
							fac.setLastUpdated(MHVApiUtility.convertDateToRFC1123Pattern(status.getLastModified()));
						else
							fac.setLastUpdated("");
						if(fac.getStationNumber() != null)
							fac.setStationNumber(fac.getStationNumber());
						else
							fac.setStationNumber("");
						facilityExtractStatusList.add(fac);
					}
				}catch ( Exception e) {
					log.error("Exception occured", e);
					MHVEssApiUtility.throwException(ErrorEnum.UNKNOWN_99);
				}
			}

		}

		return new FacilityExtractStatusesTO(facilityExtractStatusList);

	}


	@Override
	public Response getBBReport(String filetype) {
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		if(uf == null ) {
			MHVEssApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
		}
		
		MhvDownloadReportDTO downloadReport = null;
		String expectedFileType = null;
		FileTypes fileTEnum = null;
		String contentType =null;
		String fileName = null;
		try {
			fileTEnum = FileTypes.valueOf(filetype);
		} catch (Exception e) {
			e.printStackTrace();
			//TODO: Activity
			//Auditor.auditBBEventFromMHVAPI(uf.getId(),false, session.getClientApplication().getName(),ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA);
			MHVEssApiUtility.throwException(ErrorEnum.DOC_TYPE_NOT_SUPPORTED_133);
		}
		if(uf != null) {
			downloadReport = downloadYourReportService.getDownloadedReport(uf.getId());
		}
		if(downloadReport == null) {
			MHVEssApiUtility.throwException(ErrorEnum.UNKNOWN_99);
		}

		switch (fileTEnum) {
		case pdf:
			expectedFileType = "pdfFormat";
			contentType = "application/pdf";
			StringBuffer pdfFileName = new StringBuffer();
			pdfFileName.append(downloadReport.getFileName().substring(0, downloadReport.getFileName().indexOf(".")));
			pdfFileName.append(".pdf");
			fileName = pdfFileName.toString();
			break;
		case txt:
			expectedFileType = "textFormat";
			contentType = "text/plain";
			StringBuffer txtFileName = new StringBuffer();
			txtFileName.append(downloadReport.getFileName().substring(0, downloadReport.getFileName().indexOf(".")));
			txtFileName.append(".txt");
			fileName = txtFileName.toString();
			break;
		case bb:
			expectedFileType = "bbFormat";
			contentType = "application/octet-stream";
			StringBuffer bbFileName = new StringBuffer();
			bbFileName.append(downloadReport.getFileName().substring(0, downloadReport.getFileName().indexOf(".")));
			bbFileName.append(".txt");
			fileName = bbFileName.toString();
			break;
		default:
			expectedFileType = "pdfFormat";
			contentType = "application/octet-stream";
			break;
		}
		byte[] allPdfBytes = null;
		byte[] fileBytes =null;
		
			try {
				if(expectedFileType.equals("pdfFormat")) {
				
					//Auditor.auditBBEventFromMHVAPI(uf.getId(), true,session.getClientApplication().getName(),ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA_PDF );
					Response res = downloadYourReportService.generateDownload(uf.getId(), downloadReport.getDownloadReportId(), ReportTypeEnum.PDF);
					if (res != null && (res.getStatus() == 200)) {
						try {
							activityProxy.createAccountActivityLog(
														ActivityHelper.createActivityDTOForSelf(
														uf.getId(), true, 
														ActivityTypeEnumeration.DOWNLOAD, 
														ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA_PDF, 
														MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
														);
						} catch (MHVException eX) {
							log.error("Exception occured in Activity Track",  eX);
						}
					}
					return res;
				}
				else {
					Response res = downloadYourReportService.generateDownload(uf.getId(), downloadReport.getDownloadReportId(), ReportTypeEnum.TXT);
					if (res != null && (res.getStatus() == 200)) {
						try {
							activityProxy.createAccountActivityLog(
														ActivityHelper.createActivityDTOForSelf(
														uf.getId(), true, 
														ActivityTypeEnumeration.DOWNLOAD, 
														ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA, 
														MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
														);
						} catch (MHVException eX) {
							log.error("Exception occured in Activity Track");
							MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, eX);
						}
					}
					return res;
					
				}
			} 
			catch (Exception e) {
				try {
					activityProxy.createAccountActivityLog(
												ActivityHelper.createActivityDTOForSelf(
												uf.getId(), false, 
												ActivityTypeEnumeration.DOWNLOAD, 
												ActivityActionTypeEnumeration.DOWNLOAD_MY_CUSTOM_DATA, 
												MHVEssApiUtility.makeActivityDetailValue(session.getClientApplication().getName()))
												);
				} catch (MHVException eX) {
					log.error("Exception occured in Activity Track");
					MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, eX);
				}
			}
		
		//Logically unReachable..
		String r = "{\"status\" : \"ERROR\",\"description\" : null,\"nextDate\" : {} }";	
		return (new ResponseBuilderImpl()).entity(r).status(400).build();

	}

	@Override
	public DataClassTO getEligibleDataClasses() {
		Session session = CacheHandler.getInstance().getSession();
		UserProfileDTO uf = getUserProfileDTO(session);
		PatientDTO patient = getPatientDTO(uf);
		
		String account_type = null;
		
		Properties p = PropertiesHelper.getProperties();
		account_type = getPatientAcctType(patient);
	   	String acctTypepropname = "bb."+account_type+".eligible.dataclasses";
		String dataClassesList = p.getProperty(acctTypepropname);
		String[] dataClasses = dataClassesList.split(",");
		return new DataClassTO(dataClasses);
	}

	public String getUserFNameLName(UserProfileDTO userProfile) {
		StringBuffer userFirstLastName = new StringBuffer();
		userFirstLastName.append(userProfile.getLastName() != null ? userProfile.getLastName(): "");

		if(userProfile.getFirstName() != null) {
			userFirstLastName.append(", ");
			userFirstLastName.append(userProfile.getFirstName());
		}
		else {
			userFirstLastName.append("");
		}
		if(userProfile.getMiddleName() != null) {
			userFirstLastName.append(" " +userProfile.getMiddleName());
		}

		return userFirstLastName.toString();
	}

	private Collection constructEligibleDataClassList(PatientDTO patient, String[] array) {

		if(isValidList(patient, array)) {
			Set<String> set = new HashSet<String>(Arrays.asList(array));
			Collection dataClasses = Arrays.asList(set);
			return dataClasses;
		}

		return null;
	}
	private boolean isValidList(PatientDTO patient, String[] selectedDataListArray) {

		Properties p = PropertiesHelper.getProperties();
		String account_type = getPatientAcctType(patient);
	   	String acctTypepropname = "bb."+account_type+".eligible.dataclasses";
		String eligibleDataClassesList = p.getProperty(acctTypepropname);
		String[] eligibleDataClassesArray = eligibleDataClassesList.split(",");
		List eligibleDataClasses = Arrays.asList(eligibleDataClassesArray);

		for (String selectedDataList: selectedDataListArray)	{
			if(!eligibleDataClasses.contains(selectedDataList.toLowerCase())) {
				return false;
			}
		}
		return true;
	}
	
	private UserProfileDTO getUserProfileDTO( Session session) {
		UserProfileDTO uf = null;
		try {
			uf = userMgmtServiceProxy.getUserProfileById(session.getUserId());
		} catch (MHVException e2) {
			log.error("Exception occured in User Mangement Service Proxy", e2);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e2);
		}
		return uf;
	}

	private PatientDTO getPatientDTO(UserProfileDTO uf) {
		PatientDTO pat = null;
		try {
			pat = patientWebProxy.getPatientByUserProfileId(uf.getId());
		} catch (MHVException e1) {
			// TODO Auto-generated catch block
			log.error("Exception occured in Patient Proxy", e1);
			MHVEssApiUtility.throwExceptionOnErrors(ErrorEnum.UNKNOWN_99, e1);
		}
		return pat;
	}
	
	private String getPatientAcctType(PatientDTO patient) {
		String account_type = null;
	   	if(patient != null) {
	   		
	   	//	gov.va.med.mhv.common.api.util.ResponseUtil<Boolean> responseUtil = ipaWebProxy.isPatientAuthenticated(patient.getId());
	   		
	   		Boolean isPatientAuthenticated = false;
	   		
	   		try {
	   			isPatientAuthenticated = userMgmtServiceProxy.isPatientIPA(patient.getId());
			} catch (MHVException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	   		
	   		if(patient.getMatchedDateTime() != null){
	    		if(isPatientAuthenticated != null) {
	    			if(isPatientAuthenticated == true && patient.getCorrelationStatus().equals(PatientCorrelationStatusEnumeration.CORRELATED.getValue()))
	        			account_type = "premium";
	    			else if(isPatientAuthenticated == true && !patient.getCorrelationStatus().equals(PatientCorrelationStatusEnumeration.CORRELATED.getValue()))
	    				account_type = "advanced";
	        		else if(isPatientAuthenticated == false)
	        			account_type = "advanced";
	    		}
	    		else {
	    			account_type = "basic";
	    		}
    		}else{
    			account_type = "basic";
    		}
    	}else {
    		account_type = "basic";
    	}
		return account_type;
	}

}

enum FileTypes {
  pdf,
  txt,
  bb,
}
