package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.bluebutton.model.MhvDownloadReport;
import gov.va.med.mhv.bluebutton.transfer.MhvDownloadReportDTO;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class MhvDownloadReportConverter implements Converter<MhvDownloadReport, MhvDownloadReportDTO>{

	@Override
	public MhvDownloadReportDTO convert(MhvDownloadReport mhvDownloadReport) {
		MhvDownloadReportDTO mhvDownloadReportDTO = new MhvDownloadReportDTO();
		
		mhvDownloadReportDTO.setCreatedTime(mhvDownloadReport.getCreatedTime());
		mhvDownloadReportDTO.setDownloadReportId(mhvDownloadReport.getDownloadReportId());
		mhvDownloadReportDTO.setErrorMessage(mhvDownloadReport.getErrorMessage());
		mhvDownloadReportDTO.setFileName(mhvDownloadReport.getFileName());
		mhvDownloadReportDTO.setFileSize(mhvDownloadReport.getFileSize());
		mhvDownloadReportDTO.setLastAccess(mhvDownloadReport.getLastAccess());
		mhvDownloadReportDTO.setModifiedTime(mhvDownloadReport.getModifiedTime());
		mhvDownloadReportDTO.setStatus(mhvDownloadReport.getStatus());
		mhvDownloadReportDTO.setUserProfileId(mhvDownloadReport.getUserProfileId());
		
		return mhvDownloadReportDTO;
		
	}

	
}
