package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.common.api.dto.FacilityInfoDTO;
import gov.va.med.mhv.common.data.model.FacilityInfo;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class FacilityInfoConverter implements Converter<FacilityInfo, FacilityInfoDTO> {

	@Override
	public FacilityInfoDTO convert(FacilityInfo source) {
		FacilityInfoDTO d = new FacilityInfoDTO();
		d.setActive(source.getActive());
		d.setDomainName(source.getDomainName());
		d.setId(source.getId());
		d.setIpAddess(source.getIpAddess());
		d.setName(source.getName());
		d.setOplock(source.getOplock());
		d.setPort(source.getPort());
		d.setStationNumber(source.getStationNumber());
		d.setTimeout(source.getTimeout());
		d.setTreatment(source.getTreatment());
		return d;
	}
}
