package gov.va.med.mhv.bluebutton.bbmi.imaging.util;

import gov.va.med.mhv.bluebutton.model.Study;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RadiologyReportHelper {
	
	public static String generateXHTMLReport(String raw, Study study) {
		StringBuffer sb = new StringBuffer();
		try {
			SimpleDateFormat sdfDtTm = new SimpleDateFormat("dd MMM yyyy @ HHmm");
			Map<String,String> m = parseRadiologyReport(raw);
			
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Sorted By:</td>");
			sb.append("<td class=\"right_2col_value\" style=\"border-right:2px solid black;\">Date/Time Exam Performed (Descending)</td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td colspan=\"2\" class=\"1col_embedded_label\" style=\"padding-left: 10px;\"><pre style=\"white-space:normal;\">VA Radiology Reports are available 3 calendar days after they have been completed. Some studies done at a non-VA facility may not be available or they may not necessarily include an interpretation. If you have any questions about your information please visit the FAQs or contact the provider who ordered the study or your primary care provider.</pre></td>");
			sb.append("</tr>");
			sb.append("</table>");
			sb.append("<br />");
			sb.append("<table style=\"border-bottom:1px solid black;\">");
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Procedure/Test Name:</td>");
			sb.append("<td colspan=\"3\" class=\"right_2col_value\">"+study.getProcedureName()+"</td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Date/Time Exam Performed:</td>");
			sb.append("<td class=\"right_2col_value\">"+sdfDtTm.format(study.getPerformedDate().getDatePrecise())+"</td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Ordering Location:</td>");
			sb.append("<td colspan=\"3\" class=\"right_2col_value\">--</td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Requesting Provider:</td>");
			sb.append("<td colspan=\"3\" class=\"right_2col_value\">"+m.get("Req Phys")+"</td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Reason for Study:</td>");
			sb.append("<td colspan=\"3\" class=\"right_2col_value\">"+m.get("Reason for Study")+"</td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Performing Location:</td>");
			sb.append("<td colspan=\"3\" class=\"right_2col_value\">" + study.getFacilityInfo().getName() + "</td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Clinical History:</td>");
			sb.append("<td colspan=\"3\" class=\"right_2col_value\"><pre>");
			sb.append(m.get("Clinical History"));
			sb.append("</pre></td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_2col_label\">Radiologist:</td>");
			sb.append("<td colspan=\"3\" class=\"right_2col_value\">--</td>");
			sb.append("</tr>");
			sb.append("</table>");
			sb.append("<table style=\"border:0px solid black;\">");
			sb.append("<tr>");
			sb.append("<td style=\"background-color:#b5b5b5;width:100%;height:15px;border-left:2px solid black;border-right:2px solid black;\"></td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td style=\"text-align:left;font-size:12pt;font-family:Calibri;font-weight:bold;color:#000080;background-color:#f3f3f3;padding-right:5px;width:100%;border:1px solid black;border-left:2px solid black;border-right:2px solid black;\">Report</td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_1col_value\" style=\"border-left:2px solid black;border-right:2px solid black;\"><pre>Report: "+m.get("Report")+"</pre></td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td style=\"height:15px;width:100%;border-left:2px solid black;border-right:2px solid black;\"></td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td class=\"left_1col_value\" style=\"border-left:2px solid black;border-right:2px solid black;\"><pre>Impression: "+m.get("Impression")+"</pre></td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td style=\"height:15px;width:100%;border-left:2px solid black;border-right:2px solid black;\"></td>");
			sb.append("</tr>");
			sb.append("<tr>");
			sb.append("<td style=\"background-color:#b5b5b5;width:100%;height:15px;border-top:1px solid black;border-left:2px solid black;border-right:2px solid black;border-bottom:2px solid black;\"></td>");
			sb.append("</tr>");
		} catch( Exception e ) {
			e.printStackTrace();
		}
		return sb.toString();
	}
	
	public static String generateTXTReport(String raw, Study study) {
		StringBuffer result = new StringBuffer();
		try {
			Map<String,String> m = parseRadiologyReport(raw);
			SimpleDateFormat sdfDtTm = new SimpleDateFormat("dd MMM yyyy @ HHmm");
			result.append("Sorted By: Date/Time Exam Performed (Descending)").append(System.lineSeparator()).append(System.lineSeparator());
			result.append("VA Radiology Reports are available 3 calendar days after they have been").append(System.lineSeparator());
			result.append("completed. Some studies done at a non-VA facility may not be available or").append(System.lineSeparator());
			result.append("they may not necessarily include an interpretation. If you have any").append(System.lineSeparator());
			result.append("questions about your information please visit the FAQs or contact the").append(System.lineSeparator());
			result.append("provider who ordered the study or your primary care provider.").append(System.lineSeparator()).append(System.lineSeparator());
			result.append("=========================================================================").append(System.lineSeparator());
			result.append("Procedure/Test Name:          " + study.getProcedureName()).append(System.lineSeparator());
			result.append("Date/Time Exam Performed:     " + sdfDtTm.format(study.getPerformedDate().getDatePrecise())).append(System.lineSeparator());
			result.append("Ordering Location:            " + "--").append(System.lineSeparator()); //STD_INSTITUTION.NAME
			result.append("Requesting Provider:          " + m.get("Req Phys")).append(System.lineSeparator());
			result.append("Reasons for Study:            " + m.get("Reason for Study")).append(System.lineSeparator());
			result.append("Clinical History:             " + m.get("Clinical History")).append(System.lineSeparator());
			result.append("Performing Location:          " + study.getFacilityInfo().getName()).append(System.lineSeparator());
			result.append("Radiologist:                  " + "--").append(System.lineSeparator());
			result.append("-------------------------------------------------------------------------").append(System.lineSeparator());
			result.append("RADIOLOGY REPORT").append(System.lineSeparator()).append(System.lineSeparator());
			result.append("Report: " + m.get("Report")).append(System.lineSeparator()).append(System.lineSeparator());
			result.append("Impression: " + m.get("Impression")).append(System.lineSeparator());
			result.append("=========================================================================");

		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return result.toString();
	}
	
	public static String generateTXTViewReport(String raw, Study study) {
		StringBuffer result = new StringBuffer();
		try {
			Map<String,String> m = parseRadiologyReport(raw);
			SimpleDateFormat sdfDtTm = new SimpleDateFormat("dd MMM yyyy @ HHmm");
			result.append("=========================================================================").append(System.lineSeparator());
			result.append("Procedure/Test Name:          " + study.getProcedureName()).append(System.lineSeparator());
			result.append("Date/Time Exam Performed:     " + sdfDtTm.format(study.getPerformedDate().getDatePrecise())).append(System.lineSeparator());
			result.append("Performing Location:          " + study.getFacilityInfo().getName()).append(System.lineSeparator());
			result.append("=========================================================================").append(System.lineSeparator());
			result.append("RADIOLOGY REPORT").append(System.lineSeparator());
			result.append(System.lineSeparator());
			result.append(raw);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return result.toString();
	}
	
    public static Map<String, String> parseRadiologyReport(String radiologyReportText) throws IOException {
        Map<String, String> radiologyReportMap = new HashMap<String, String>();
        InputStream is = new ByteArrayInputStream(radiologyReportText.getBytes());
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = "";
        String key = "";
        String value = "";
        String reportText = "";
        String impressionText = "";
        String[] dataValues = new String[2];
        while ((line = br.readLine()) != null) {
                key = "";
                value = "";
                //get specific items out of the report text
                if(line.contains("Exm Date") || line.contains("Date Verified") || line.contains("Reason for Study") || line.contains("Clinical History") || line.contains("Req Phys"))  {
                        if(line.contains("Additional Clinical History")) {
                                //do nothing for additional Clinical History
                        } else {
                                if(line.contains("Exm Date")) {
                                        //split a different way to so that the time value is not lost
                                        dataValues = line.split(": ");
                                } else {
                                        dataValues = line.split(":");
                                }
                                key = dataValues[0].trim();
                                if(line.contains("Date Verified")) {
                                        if(dataValues.length > 1) {
                                                dataValues[1] = dataValues[1].trim();
                                                //check for correct pattern
                                                Pattern p = Pattern.compile(".*([a-z]{3} [0-9]{1,2}, [0-9]{4}).*", Pattern.CASE_INSENSITIVE);
                                                Matcher matcher = p.matcher(dataValues[1]);
                                                if(!matcher.matches()) {
                                                        dataValues[1] = "[Unknown]";
                                                }
                                        }
                                } else if(line.contains("Req Phys")) {
                                        //remove Pat Loc text from split.  There are two data elements in line of text
                                        dataValues[1] = dataValues[1].replace("Pat Loc", "").trim();
                                        radiologyReportMap.put(key, value);
                                } else if(line.contains("Clinical History")) {
                                        if(dataValues.length == 1 || dataValues[1].trim().equals("")) {
                                                StringBuffer clinicalSB = new StringBuffer();
                                                clinicalSB.append("\r\n");
                                                for(int i = 1;i<100; i++) {
                                                        line = br.readLine();
                                                        key = "Clinical History";
                                                        if(line.contains("Report Status")) {
                                                                //put clinical history data into map because the end was found
                                                                value = clinicalSB.toString();
                                                                radiologyReportMap.put(key, value);
                                                                dataValues = line.split(": ");
                                                                key = "Report Status";
                                                                value = dataValues[1].trim();
                                                                if(value.contains("Date Reported")) {
                                                                        value = value.replace("Date Reported", "").trim();
                                                                }
                                                                break;
                                                        } else if(line.equals("")) {
                                                                clinicalSB.append("\r\n");
                                                        } else {
                                                                clinicalSB.append(line.trim() + "\r\n");
                                                         }
                                                 }
                                         } else {
                                                 key = dataValues[0].trim();
                                                 value = dataValues[1].trim();
                                         }
                                 }
                                 if(dataValues.length > 1 && !key.equals("Report Status")) {
                                         value = dataValues[1].trim();
                                 }
                         }
                 } else if(line.contains("Report:")) {
                         StringBuffer reportSB = new StringBuffer();
                         reportSB.append("\r\n");
                         StringBuffer impressionSB = new StringBuffer();
                         impressionSB.append("\r\n");
                         boolean impression = false;
                         for(int i = 1;i<1000; i++) {
                                 line = br.readLine();
                                 if(line != null) {
                                         //start creating the impression text part of the report
                                         if(line.contains("Impression:") || impression) {
                                                 impression = true;
                                                 if(line.contains("Primary Interpreting Staff:")) {
                                                         impression = false;
                                                         break;
                                                 } else if(!line.contains("Impression:")){
                                                         if(line.equals("")) {
                                                                 impressionSB.append("\r\n");
                                                         } else {
                                                                 impressionSB.append(line.trim() + "\r\n");
                                                         }
                                                 }
                                         } else {
                                                 if(line.equals("")) {
                                                         reportSB.append("\r\n");
                                                 } else {
                                                         reportSB.append(line.trim() + "\r\n");
                                                 }
                                         }
                                 } else if(line == null) {
                                         //break out if reaching end of file while reading impression text
                                         break;
                                 }
                         }
                         reportText = reportSB.toString();
                         key = "Report";
                         value = reportText;
                         radiologyReportMap.put(key, value);
                         impressionText = impressionSB.toString();
                         key = "Impression";
                         value = impressionText;
                 }
                 //fill the map
                 if(!key.isEmpty()) {
                         radiologyReportMap.put(key, value);
                 }
         }
         br.close();
         
         return radiologyReportMap;
 }

}
