package gov.va.med.mhv.bluebutton.bbdownload.util;

import gov.va.med.mhv.common.api.util.ConfigurationManager;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Calendar;
import java.util.Properties;



import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;


public class PdfXHTMLWrapper {
	private static Log LOG = LogFactory.getLog(PdfXHTMLWrapper.class);

	private static Image img;

	// Configuration Properties
	// private static final Properties properties = ConfigurationManager.getConfiguration("/downloadData.properties");

	private static final String KEYSTORE_FILENAME="bb.keystoreFileName";
	private static final String KEYSTORE_PASSWORD="bb.keystorePassword";
	private static final String PRIVATEKEY_PASSWORD="bb.privateKeyPassword";

	private static final String DIGITAL_SIGN_ENABLE="bb.digitalSign.enable";
	private static final String IS_CERTIFIED="bb.isCertified";
	private static final String IS_VISIBLE="bb.isVisible";

	ClassLoader classLoader;

	public PdfXHTMLWrapper () {
		classLoader = this.getClass().getClassLoader();
	}

	public byte[] makePdfFromXhtmlAPI(String currentUserFullName, String xhtml) throws DocumentException, IOException {
		byte[] result = null;


		StringBuffer watermarkLocation = new StringBuffer();
		long st = System.currentTimeMillis();
		String imgRelativePath = "/images/watermark_7_25pct_10pct.jpg";
		URL imgUrl = classLoader.getResource(imgRelativePath);
		img = Image.getInstance(imgUrl);
		if(LOG.isInfoEnabled())
			LOG.info("Image.getInstance for watermark took " + (System.currentTimeMillis() - st));
		result = generate(currentUserFullName, xhtml);

		return result;
	}

	public byte[] makePdfFromXhtml( String currentUserFullName, String xhtml) throws DocumentException, IOException {
		byte[] result = null;
		long st = System.currentTimeMillis();
		String imgRelativePath = "/images/watermark_7_25pct_10pct.jpg";
		URL imgUrl = classLoader.getResource(imgRelativePath);

		//Make synchronized one time call
//		img = Image.getInstance(context.getResource("/resources/images/watermark_7_25pct_10pct.jpg"));
		img = Image.getInstance(imgUrl);
		if(LOG.isInfoEnabled())
			LOG.info("Image.getInstance for watermark took " + (System.currentTimeMillis() - st));
		result = generate(currentUserFullName, xhtml);

		return result;
	}

	@SuppressWarnings("unchecked")
	private byte[] generate(String name, String xhtml) throws DocumentException, IOException {
		long st = System.currentTimeMillis();

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ByteArrayOutputStream os = new ByteArrayOutputStream();

		ITextRenderer renderer = new ITextRenderer();
		ITextFontResolver r = renderer.getFontResolver();

		try {
			r.addFont("/fonts/CALIBRI.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED
			r.addFont("/fonts/CALIBRII.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED
			r.addFont("/fonts/CALIBRIB.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED
			r.addFont("/fonts/CALIBRIZ.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED
			r.addFont("/fonts/TIMESBI.TTF", BaseFont.WINANSI, BaseFont.NOT_EMBEDDED); //EMBEDDED

			String escapedXhtml = xhtml.replaceAll("(?i)&(?!(amp|apos|lt|gt|quot);)", "&amp;");
			renderer.setDocumentFromString(escapedXhtml);
			renderer.layout();
			renderer.createPDF(baos, false); // to stream
			renderer.finishPDF();		
		
		} catch (com.lowagie.text.DocumentException e) {
			LOG.error("Exception Occured: " +e);
		} 


		// Second pass to setup the page headers
		os.write(addHeaderAndWatermark(name, baos));
		os.flush();
		os.close();

		if(LOG.isInfoEnabled())
			LOG.info("PDF generate took " + (System.currentTimeMillis() - st) + " ms (final size=" + baos.size() + "bytes) for user="+name);
		return os.toByteArray();
	}

	private byte[] addHeaderAndWatermark(String name, ByteArrayOutputStream baos) throws IOException, DocumentException {
		ByteArrayOutputStream baosout = new ByteArrayOutputStream(baos.size());
		PdfReader reader;

		reader = new PdfReader(baos.toByteArray());

		reader.getCatalog().put(PdfName.LANG, new PdfString("EN-US"));
		// Create a stamper
		PdfStamper stamper = new PdfStamper(reader, baosout);
		// Loop over the pages and add a header to each page
		int n = reader.getNumberOfPages();
		for (int i = 1; i <= n; i++) {
			//Add Header
			getHeaderTable(name, i, n).writeSelectedRows(0, -1, 34, 783, stamper.getOverContent(i));

			//Add Watermark
			img.scaleToFit(800, 800);
			img.setAbsolutePosition(0, 0);
			img.setAlt("Medical Confidential");
			stamper.getUnderContent(i).addImage(img);
		}
		// Close the stamper
		stamper.close();

		return baosout.toByteArray();
	}

	public static PdfPTable getHeaderTable(String name, int x, int y) {
		BaseFont bf = null;
		PdfPTable table = new PdfPTable(3);
		try {
			table.setWidths(new int[] { 24, 20, 15 });
			table.setTotalWidth(527);
			table.setLockedWidth(true);
			table.getDefaultCell().setFixedHeight(20);
			table.getDefaultCell().setBorder(Rectangle.NO_BORDER);
			table.getDefaultCell().setHorizontalAlignment(Element.ALIGN_MIDDLE);

			PdfPCell cell0 = new PdfPCell(new Phrase(name, new Font(bf, 10, Font.NORMAL, BaseColor.BLACK)));
			cell0.setVerticalAlignment(Element.ALIGN_BOTTOM);
			cell0.setHorizontalAlignment(Element.ALIGN_LEFT);
			cell0.setBorder(Rectangle.NO_BORDER);
			table.addCell(cell0);

			PdfPCell cell1 = new PdfPCell(new Phrase("CONFIDENTIAL", new Font(bf, 14, Font.BOLD, BaseColor.BLACK)));
			cell1.setBorder(Rectangle.NO_BORDER);
			cell1.setHorizontalAlignment(Element.ALIGN_MIDDLE);
			cell1.setVerticalAlignment(Element.ALIGN_TOP);
			table.addCell(cell1);
			
			PdfPCell cell2 = new PdfPCell(new Phrase(String.format("Page %d of %d", x, y), new Font(bf, 10, Font.NORMAL, BaseColor.BLACK)));
			cell2.setHorizontalAlignment(Element.ALIGN_RIGHT);
			cell2.setVerticalAlignment(Element.ALIGN_BOTTOM);
			cell2.setBorder(Rectangle.NO_BORDER);
			table.addCell(cell2);
		} catch (DocumentException de) {
			throw new ExceptionConverter(de);
		}
		return table;
	}

	/*
	 * *** Commenting out as it is NOT in USE.. Do NOT REMOVE
	public static ByteArrayOutputStream sign(byte pdf[]) throws Exception{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		String keystorePassword = properties.getProperty(KEYSTORE_PASSWORD,"password");
		String privateKeyPassword = properties.getProperty(PRIVATEKEY_PASSWORD,"password");
		String keyStoreFileName = properties.getProperty(KEYSTORE_FILENAME,"keystore.jks");
		boolean isCertified = Boolean.parseBoolean(properties.getProperty(IS_CERTIFIED,"true"));
		boolean isVisible = Boolean.parseBoolean(properties.getProperty(IS_VISIBLE,"true"));

		try {
			KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
			//ks.load(new FileInputStream("resources/keystore/keystore.ks"), "password".toCharArray());
			FileInputStream fis = new FileInputStream(keyStoreFileName);
			try {
				ks.load(fis, keystorePassword.toCharArray());
			}
			finally {
				fis.close();
			}
			String alias = (String)ks.aliases().nextElement();
			PrivateKey key = (PrivateKey)ks.getKey(alias, privateKeyPassword.toCharArray());
			Certificate[] certificateChain = ks.getCertificateChain(alias);
			PdfReader reader = new PdfReader(pdf);
			//FileOutputStream fout = new FileOutputStream("c://temp//signed.pdf");
			//PdfStamper stp = PdfStamper.createSignature(reader, fout, '\0');
			PdfStamper pdfStamper = PdfStamper.createSignature(reader, baos, '\0');
			PdfSignatureAppearance pdfSignAppearance = pdfStamper.getSignatureAppearance();
			//Need to know who issued the CA..verisign, VA or some other
			pdfSignAppearance.setCrypto(key, certificateChain, null, PdfSignatureAppearance.SELF_SIGNED);
			pdfSignAppearance.setReason("Blue Button Certified Content");
			pdfSignAppearance.setLocation("Washington D.C. USA");
			pdfSignAppearance.setContact("Department of Veteran Affairs");
			pdfSignAppearance.setSignDate(Calendar.getInstance());

			//No Change allowed in the PDF
			if(isCertified)
				pdfSignAppearance.setCertificationLevel(PdfSignatureAppearance.CERTIFIED_NO_CHANGES_ALLOWED);

			// comment next line to have an invisible signature
			if(isVisible)
				pdfSignAppearance.setVisibleSignature(new Rectangle(100, 100, 200, 200), 1, null);

			pdfStamper.close();

		}
		catch (KeyStoreException key) {
			throw new SignatureException(key);
		}
		catch (NoSuchAlgorithmException nsa) {
			throw new SignatureException(nsa);
		}
		catch (CertificateException ce) {
			throw new SignatureException(ce);
		}
		catch (UnrecoverableKeyException ur) {
			throw new SignatureException(ur);
		}
		catch (DocumentException e) {
			throw new DocumentException(e);
		}
		catch (IOException e) {
			e.printStackTrace();
			throw new Exception(e);
		}

		//return baos.toByteArray();
		return baos;
	}
	*/

}