package gov.va.med.mhv.bluebutton.repository;

import gov.va.med.mhv.bluebutton.model.Study;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface StudyRepository extends JpaRepository<Study, Long> {
	
	@Query("select s from Study s where s.patientId = :patientId")
	List<Study> findByPatientId(@Param("patientId") Long patientId);
	
	@Query("select s from Study s where s.patientId = :patientId and s.studyIdUrn = :studyIdUrn")
	List<Study> findByPatientIdAndStudyIdUrn(@Param("patientId") Long patientId, @Param("studyIdUrn") String studyIdUrn);

}
