package gov.va.med.mhv.bluebutton.repository;

import java.sql.Date;
import java.util.List;

import javax.persistence.QueryHint;

import gov.va.med.mhv.bluebutton.model.MhvDownloadData;
import gov.va.med.mhv.bluebutton.model.MhvDownloadReport;
import gov.va.med.mhv.bluebutton.model.Study;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.data.jpa.repository.query.Procedure;


public interface MhvDownloadReportRepository extends JpaRepository<MhvDownloadReport, Long> {
	
	@Query(value ="SELECT * FROM (SELECT * FROM MHV_DOWNLOAD_REPORT  "
			+ "WHERE USER_PROFILE_ID = ?1"
			+ " ORDER BY CREATED_DATE DESC) WHERE ROWNUM =1", nativeQuery=true)
	List<MhvDownloadReport> findLatestReportByUserProfileId(Long userProfileId);

	
	@Procedure(value ="MHVREPORTCREATE")
	public void generateDownload(Long userId, String options, Date start, Date end, 
					Long dateSelection, Long typeSelection);
	
	@Query("select r from MhvDownloadReport r where r.downloadReportId = :downloadReportId")
	MhvDownloadReport findByReportId(@Param("downloadReportId") Long downloadReportId);
}
