package gov.va.med.mhv.bluebutton.model;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;


@Entity
@Table(name = "PHR_STUDY_JOB")
public class StudyJob implements Serializable{

	private static final long serialVersionUID = 4862427496711310250L;
	
	@Id
	@Column(name = "PHR_STUDY_JOB_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Version 
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "PATIENT_ID")
	private long patientId;

	@Column(name = "STUDY_ID_URN")
	private String studyIdUrn;
	
	@Column(name = "FILE_NAME")
	private String fileName;
	
	@Column(name = "FILE_SIZE")
	private Long fileSize;
	
	@Column(name = "TEMP_FILE_NAME")
	private String tempFileName;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name = "STATUS")
	private String status;
	
	@Column(name = "STATUS_TEXT")
	private String statusText;

	@Column(name = "SERVER_NODE")
	private String serverNode;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public long getPatientId() {
		return patientId;
	}

	public void setPatientId(long patientId) {
		this.patientId = patientId;
	}

	public String getStudyIdUrn() {
		return studyIdUrn;
	}

	public void setStudyIdUrn(String studyIdUrn) {
		this.studyIdUrn = studyIdUrn;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public Long getFileSize() {
		return fileSize;
	}

	public void setFileSize(Long fileSize) {
		this.fileSize = fileSize;
	}

	public String getTempFileName() {
		return tempFileName;
	}

	public void setTempFileName(String tempFileName) {
		this.tempFileName = tempFileName;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatusText() {
		return statusText;
	}

	public void setStatusText(String statusText) {
		this.statusText = statusText;
	}

	public String getServerNode() {
		return serverNode;
	}

	public void setServerNode(String serverNode) {
		this.serverNode = serverNode;
	}
	
	

}
