package gov.va.med.mhv.bluebutton.model;

import java.io.Serializable;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.mhv.common.data.model.FacilityInfo;

@Entity
@Table(name = "PHR_STUDY")
public class Study implements Serializable {
	
	private static final long serialVersionUID = -6600603725383660228L;

	@Id
	@Column(name = "PHR_STUDY_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "STATION_NUMBER")
	private String stationNumber;
	
	@Column(name = "PROCEDURE_NAME")
	private String procedureName;
	
	@Column(name = "EVENT")
	private String event;
	
	@Column(name = "PATIENT_ID")
	private long patientId;
	
	@Column(name = "STUDY_ID_URN")
	private String studyIdUrn;
	
	@Column(name = "IMAGE_COUNT")
	private long imageCount;
	
	@Embedded
	@AttributeOverrides({
		@AttributeOverride(name="datePrecise", column=@Column(name="PERFORMED_DATE_PRECISE")),
		@AttributeOverride(name="dateImprecise", column=@Column(name="PERFORMED_DATE_IMPRECISE"))
	})
	private ImpreciseDate performedDate; 
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "FACILITY_INFO_ID")
	private FacilityInfo facilityInfo;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getProcedureName() {
		return procedureName;
	}

	public void setProcedureName(String procedureName) {
		this.procedureName = procedureName;
	}

	public String getEvent() {
		return event;
	}

	public void setEvent(String event) {
		this.event = event;
	}

	public long getPatientId() {
		return patientId;
	}

	public void setPatientId(long patientId) {
		this.patientId = patientId;
	}

	public String getStudyIdUrn() {
		return studyIdUrn;
	}
	
	public void setStudyIdUrn(String studyIdUrn) {
		this.studyIdUrn = studyIdUrn;
	}

	public long getImageCount() {
		return imageCount;
	}

	public void setImageCount(long imageCount) {
		this.imageCount = imageCount;
	}

	public ImpreciseDate getPerformedDate() {
		return performedDate;
	}

	public void setPerformedDate(ImpreciseDate performedDate) {
		this.performedDate = performedDate;
	}

	public FacilityInfo getFacilityInfo() {
		return facilityInfo;
	}

	public void setFacilityInfo(FacilityInfo facilityInfo) {
		this.facilityInfo = facilityInfo;
	}
}
