package gov.va.med.mhv.bluebutton.model;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;

@Entity
@Table(name = "MHV_DOWNLOAD_REPORT")
public class MhvDownloadReport implements Serializable {

	private static final long serialVersionUID = 7303026602556562430L;

	@Id
	@Column(name = "MHV_DOWNLOAD_REPORT_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long		downloadReportId;
	
	@Version 
	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "FILE_NAME")
	private String		fileName;
	
	@Column(name = "MODIFIED_DATE")
	private Timestamp		modifiedTime;
	
	@Column(name = "USER_PROFILE_ID")
	private Long		userProfileId;
	
	@Column(name = "ERROR_MESSAGE")
	private String		errorMessage;
	
	@Column(name = "STATUS")
	private String	status;
	
	@Column(name = "FILE_SIZE")
	private Long		fileSize;
	
	@Column(name = "LAST_ACCESS")
	private Timestamp		lastAccess;
	
	@Column(name = "CREATED_DATE")
	private Timestamp		createdTime;

	public Long getDownloadReportId() {
		return downloadReportId;
	}

	public void setDownloadReportId(Long downloadReportId) {
		this.downloadReportId = downloadReportId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public Timestamp getModifiedTime() {
		return modifiedTime;
	}

	public void setModifiedTime(Timestamp modifiedTime) {
		this.modifiedTime = modifiedTime;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Long getFileSize() {
		return fileSize;
	}

	public void setFileSize(Long fileSize) {
		this.fileSize = fileSize;
	}

	public Timestamp getLastAccess() {
		return lastAccess;
	}

	public void setLastAccess(Timestamp lastAccess) {
		this.lastAccess = lastAccess;
	}

	public Timestamp getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Timestamp createdTime) {
		this.createdTime = createdTime;
	}

	
}
