package gov.va.med.mhv.bluebutton.webservice;

import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportDTO;
import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportSelectionsDTO;
import gov.va.med.mhv.bluebutton.transfer.MhvDownloadReportDTO;
import gov.va.med.mhv.common.api.enumeration.ReportTypeEnum;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;

@Path("/")
@Service("bluebutton")
public interface BlueButtonWebService {

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("report/create/{userProfileId}")
	public BlueButtonReportDTO generateReport(@PathParam("userProfileId") Long userProfileId, BlueButtonReportSelectionsDTO selections);

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("report/downloadreport/{userProfileId}")
	public MhvDownloadReportDTO getDownloadedReport(@PathParam("userProfileId") Long userProfileId);
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Path("report/generatereport/userprofileId/{userprofileId}")	
	public Response generateSelectedDownload(@PathParam("userprofileId") Long userprofileId,BlueButtonReportSelectionsDTO genRepTO);


	@GET
	@Path("report/reportStream/userprofileId/{userprofileId}/{downloadReportId}/{reportType}")
	public Response generateDownload(@PathParam("userprofileId") Long userprofileId,
									@PathParam("downloadReportId") Long downloadReportId, 
									@PathParam("reportType") ReportTypeEnum reportType);
		
	
	//-----------------------------------------------------------------------------------------------
	//------ EXTERNAL FACING API's-------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.WILDCARD)
	@Path("external/stream/report/{reportId}/type/{type}")
	public Response getBluebuttonReport(@PathParam("reportId") Long reportId, @PathParam("type") String type);

	//-----------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------

}
