package gov.va.med.mhv.bluebutton.transfer;

import java.io.Serializable;

public class StudyJobDTO implements Serializable {
	private static final long serialVersionUID = -6536881081127052773L;
	
	private String status;
	private String statusText;
	private String studyIdUrn;
	private Integer percentComplete;
	private String fileSize;
	private Long fileSizeNumber;

	public StudyJobDTO(){
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	
	public String getStatusText() {
		return statusText;
	}
	public void setStatusText(String statusText) {
		this.statusText = statusText;
		if( statusText != null && statusText.length() != 0 ) {
			try {
				setPercentComplete(Integer.parseInt(statusText));
			}
			catch(NumberFormatException e) {
				//do nothing
			}
		}
	}
	public String getStudyIdUrn() {
		return studyIdUrn;
	}
	public void setStudyIdUrn(String studyIdUrn) {
		this.studyIdUrn = studyIdUrn;
	}
	
	/**
	 * PercentComplete is derived from statusText
	 * 
	 * @return
	 */
	public Integer getPercentComplete() {
		return percentComplete;
	}
	public void setPercentComplete(Integer percentComplete) {
		this.percentComplete = percentComplete;
	}

	public String getFileSize() {
		return fileSize;
	}
	public void setFileSize(String fileSize) {
		this.fileSize = fileSize;
	}
	public Long getFileSizeNumber() {
		return fileSizeNumber;
	}
	public void setFileSizeNumber(Long fileSizeNumber) {
		this.fileSizeNumber = fileSizeNumber;
	}
	
}
