package gov.va.med.mhv.bluebutton;

import gov.va.med.mhv.bluebutton.transfer.StudyJobDTO;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;

@Path("/")
@Service("studyjob")
public interface StudyJobBusinessService {

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("studyjob/{patientId}/icn/{icn}/studyid/{studyId}")
	public StudyJobDTO createZipFile(@PathParam("patientId") Long patientId, @PathParam("icn") String icn, @PathParam("studyId") String studyId) throws MHVException;

	@GET
	@Produces(MediaType.WILDCARD)
	@Path("studyjob/zip/stream/{patientId}/studyidUrn/{studyIdUrn}")
	public Response getZipFileAsStream(@PathParam("patientId") Long patientId, @PathParam("studyIdUrn") String studyIdUrn);

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("studyjob/{patientId}")
	public List<StudyJobDTO> getStudyJobs(@PathParam("patientId") Long patientId);

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("studyjob/zip/preview/list/{patientId}/studyidUrn/{studyIdUrn}")
	public List<String> getImagePreviewList(@PathParam("patientId") Long patientId, @PathParam("studyIdUrn") String studyIdUrn) throws MHVException;
	
	//-----------------------------------------------------------------------------------------------
	//------ EXTERNAL FACING API's-------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------

	@GET
	@Produces(MediaType.WILDCARD)
	@Path("external/studyjob/zip/stream/studyidUrn/{studyIdUrn}")
	public Response getZipFileAsStreamNoPat(@PathParam("studyIdUrn") String studyIdUrn) throws MHVException;

	@GET
	@Produces(MediaType.WILDCARD)
	@Path("external/studyjob/image/studyidUrn/{studyIdUrn}/series/{series}/image/{image}")
	public Response getImageNoPat(@PathParam("studyIdUrn") String studyIdUrn, @PathParam("series") Long series, @PathParam("image") Long image) throws MHVException;
	
	@GET
	@Produces(MediaType.WILDCARD)
	@Path("external/studyjob/report/studyidUrn/{studyIdUrn}")
	public Response getReportNoPat(@PathParam("studyIdUrn") String studyIdUrn) throws MHVException;

	@GET
	@Produces(MediaType.WILDCARD)
	@Path("external/studyjob/bbreport/studyidUrn/{studyIdUrn}/downloadReportId/{downloadReportId}/type/{type}")
	public Response getBBReportNoPat(@PathParam("studyIdUrn") String studyIdUrn, @PathParam("downloadReportId") Long downloadReportId, @PathParam("type") String type) throws MHVException;

	//-----------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------
	//-----------------------------------------------------------------------------------------------

}
