package gov.va.med.mhv.bluebutton;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.osccd.client.DocStatus;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;

@Path("/")
@Service("healthsummary")
public interface HealthSummaryBusinessService {

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("healthsummary/{patientId}/{lastName}/{format}")
	public List<DocStatus> getStatus(@PathParam("patientId") String patientId, @PathParam("lastName") String lastName, @PathParam("format") String format) throws MHVException;
	
	@GET
	@Produces(MediaType.APPLICATION_XML)
	@Path("healthsummary/{requestDate}/fileFormat/{fileFormat}/ccdType/{ccdType}")
	public Response getDocument(@PathParam("requestDate") String requestDate, @PathParam("fileFormat") String fileFormat, @PathParam("ccdType") String ccdType) throws MHVException;
	
}
