package gov.va.med.mhv.bluebutton;

import gov.va.med.mhv.bluebutton.transfer.BlueButtonReport;
import gov.va.med.mhv.bluebutton.transfer.BlueButtonReportSelectionsDTO;
import gov.va.med.mhv.bluebutton.transfer.MhvDownloadReportDTO;
import gov.va.med.mhv.common.api.enumeration.ReportTypeEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;

@Path("/")
@Service("downloadreport")
public interface DownloadYourReportService {
	
	/**
	 * Execute the GetPHRRefreshStatus operation
	 *
	 * @param patient The patient to refresh extract data for
	 * @return BBPHRRefreshStatusServiceResponse
	 */
	public Response getPHRRefreshStatus(Long patientId);

	/**
	 * Execute the DoRefresh operation
	 *
	 * @param patient The patient to refresh extract data for
	 * @return VoidServiceResponse
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("downloadreport/refresh/{icn}")
	public void doRefresh(String icn);

	/**
	 * Method to call pl/sql script to generate the report
	 *
	 * @param 
	 * @return Response
	 */	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Path("downloadreport/generatereport/userprofileId/{userprofileId}")	
	public Response generateSelectedDownload(@PathParam("userprofileId") Long userprofileId,BlueButtonReportSelectionsDTO genRepTO);

	/**
	 * Execute the GetExtractStatusList operation
	 *
	 * @param patient The patient to refresh extract data for
	 * @return FacilityExtractStatusCollectionServiceResponse
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("downloadreport/extractstatus/{icn}")
	public PatientExtractStatus getPatientExtractStatus(@PathParam("icn") String icn) throws MHVException ;

	/**
	 * Method to get the latest report
	 *
	 * @param 
	 * @return Response
	 */	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("downloadreport/userprofileId/{userprofileId}")
	public MhvDownloadReportDTO getDownloadedReport(@PathParam("userprofileId") Long userprofileId);


	/**
	 * Method to Download the report in pdf or txt format
	 *
	 * @param 
	 * @return Response
	 */

	@GET
	@Path("downloadreport/reportStream/userprofileId/{userprofileId}/{downloadReportId}/{reportType}")
	public Response generateDownload(@PathParam("userprofileId") Long userprofileId,
									@PathParam("downloadReportId") Long downloadReportId, 
									@PathParam("reportType") ReportTypeEnum reportType);

	/**
	 * Execute the UpdateLastAccess operation
	 *
	 * @param downloadReportId  
	 * @return VoidServiceResponse
	 */
	public Response updateLastAccess(Long downloadReportId);


}
