<%@ taglib uri="http://tiles.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib prefix="s" uri="/struts-tags"%>

<%@ page session="true"
	import="gov.va.med.mhv.sm.web.smActions.AbstractInboxAction" 
	import="gov.va.med.mhv.sm.util.DateUtils"
	import="gov.va.med.mhv.sm.model.Folder"
	import="gov.va.med.mhv.sm.enumeration.SystemFolderEnum"
	import="gov.va.med.mhv.sm.enumeration.UserTypeEnum"
	import="gov.va.med.mhv.sm.model.User"
	import="gov.va.med.mhv.sm.dto.SearchFormDTO"%>

<script language="JavaScript" src="js/calendar_us.js"></script>
<script>
function clearForm(showFrom,showTo){
	
	if(showFrom=='true'){
		document.messageForm.SearchMessageFrom.value='';
	}
	if(showTo=='true'){
		document.messageForm.SearchMessageTo.value='';
	}
	document.messageForm.SearchMessageSubject.value='';
	document.messageForm.SearchMessageFromDate.value='';
	document.messageForm.SearchMessageToDate.value='';
	document.messageForm.exactMatch.checked=false;
}
</script>
<link rel="stylesheet" href="css/calendar.css">

<%
  User user = (User)request.getSession().getAttribute("user");
  Folder curFolder=(Folder)session.getAttribute(AbstractInboxAction.CURRENT_FOLDER);
  SearchFormDTO sf = (SearchFormDTO) session.getAttribute(AbstractInboxAction.SEARCH_FORM);
  String fromDt = "";
  String toDt = "";
  String to = "";
  String from = "";
  String subject = "";
  boolean exactMatch = false;
  
  if( sf != null ) {
  
	  to = (sf.getTo()==null?"":sf.getTo());
	  from = (sf.getFrom()==null?"":sf.getFrom());
	  subject = (sf.getSubject()==null?"":sf.getSubject());
	  exactMatch = sf.isExactMatch();
	  
	  try {
		  fromDt = DateUtils.getEnglishDate(sf.getFromDate());
	  } catch( Exception e) {
		 //nothing 
	  }
	  
	  try {
		  toDt = DateUtils.getEnglishDate(sf.getToDate());
	  } catch( Exception e) {
		 //nothing 
	  }
  }
  
  boolean showFrom = curFolder.getId() != SystemFolderEnum.SENT.getId();
  boolean showTo = user.getUserType() == UserTypeEnum.CLINICIAN || ( user.getUserType() == UserTypeEnum.PATIENT && curFolder.getId() == SystemFolderEnum.SENT.getId());
%>

<b>Search Criteria</b>
<br />
<form name="SearchForm">
<table width="100%" cellpadding="0" cellspacing="0" border="0" align="right">
	<tr>
	
		<% if(showFrom){ %>
		<td width="200" valign="middle" align="left"><label for="searchMessageFrom">From:</label>&nbsp;
		<input id="searchMessageFrom" name="SearchMessageFrom" type="text" size="20" value="<%=from %>"/></td>
	    <% } %>
	    <% if(showTo){ %>
		<td width="180" valign="middle" align="left"><label for="SearchMessageTo">To:</label>&nbsp;
		<input name="SearchMessageTo" id="SearchMessageTo" type="text" size="20" value="<%=to %>"/></td>
	    <% } %>
		<td width="270" valign="middle" align="left"><label for="SearchMessageSubject">Subject:</label>&nbsp;
		<input id="SearchMessageSubject" name="SearchMessageSubject" type="text" size="30" value="<%=subject %>"/></td>
		<td valign="middle" align="center">Date Range:&nbsp;
		<label for="SearchMessageFromDate">
			<img id="SearchMessageFromDateLabel" width="1" border="0" height="1" align="left" alt="Search Date Range From" src="images/spacer.gif">
		</label>
		<input id="SearchMessageFromDate" name="SearchMessageFromDate" type="text" size="10" value="<%=fromDt %>"/><script language="JavaScript">
			new tcal ({'formname': 'messageForm','controlname': 'SearchMessageFromDate'});
 		</script>
		&nbsp;--&nbsp;
		<label for="SearchMessageToDate">
			<img id="SearchMessageToDateLabel" width="1" border="0" height="1" align="left" alt="Search Date Range To" src="images/spacer.gif">
		</label>
		<input id="SearchMessageToDate" name="SearchMessageToDate" type="text" size="10"  value="<%=toDt %>"/><script language="JavaScript">
			new tcal ({'formname': 'messageForm','controlname': 'SearchMessageToDate'});
		</script>
		</td>
	</tr>
	<tr height="10"> &nbsp; </tr>
	<tr><td valign="middle"><input type="checkbox" id="exactMatch" name="exactMatch" title="Exact match only" value="true" <s:if test="%{exactMatch}">checked</s:if>><label for="exactMatch">&nbsp;Exact match only</label></input></td></tr>
	<tr align="right">
		<td colspan="4"><input type="submit" style="" name="msgSubmit" title="Search" value="Search" class="sm_input_button">
		<input type="button" onClick="javascript:clearForm('<%=showFrom%>','<%=showTo%>')" style="" name="msgSubmit" title="Clear" value="Clear" class="sm_input_button" >
		<input type="submit" name="msgSubmit" title="Cancel" value="Cancel" class="sm_input_button"></td>
	</tr>
</table>
