
<%@ taglib uri="http://tiles.apache.org/tags-tiles" prefix="tiles"%>

<%@ page
  import="org.apache.commons.logging.Log"
  import="org.apache.commons.logging.LogFactory"
  import="gov.va.med.mhv.sm.model.Addressee"
  import="gov.va.med.mhv.sm.model.Folder"
  import="gov.va.med.mhv.sm.model.Message"
  import="gov.va.med.mhv.sm.model.MessagesPage"
  import="gov.va.med.mhv.sm.model.MailParticipant"
  import="gov.va.med.mhv.sm.model.User"
  import="gov.va.med.mhv.sm.model.Patient"
  import="gov.va.med.mhv.sm.model.Clinician"
  import="gov.va.med.mhv.sm.model.Thread"
  import="gov.va.med.mhv.sm.util.DateUtils"
  import="gov.va.med.mhv.sm.enumeration.SystemFolderEnum"
  import="gov.va.med.mhv.sm.web.smActions.AbstractInboxAction"
%>
<%	String selectMsgsOption = "none";
	try{
	  selectMsgsOption = (request.getParameter("selectMsgsOpt") == null)?"none":request.getParameter("selectMsgsOpt");
	}catch(Exception e){selectMsgsOption="none";}
	String checkedVal = "";
	if(selectMsgsOption.equalsIgnoreCase("all")){
	  checkedVal = "checked";
	}
%>
<%--
  This page should not be repsonsible for fetching the messages.
  Only for displaying the messages that happen to exist in the
  session("activeFolder").getMessagesPage()
--%>
<%!private static Log log =LogFactory.getLog("jsp.gov.va.med.mhv.sm.clinician_Inbox_messages");%>

<%
  Folder folder=(Folder)session.getAttribute(AbstractInboxAction.CURRENT_FOLDER);
	String activeFolderName = folder.getName();
	String messageChkType = "checkbox";
	String textForCheckbox = "";
	if(activeFolderName.equals("Sent")){messageChkType = "hidden";}
	String messageChkImg  = "";
  MessagesPage messages = folder.getMessages();
  boolean isDraftsFolder = folder.getId().equals(SystemFolderEnum.DRAFTS.getId());
  boolean isSentFolder = folder.getId().equals(SystemFolderEnum.SENT.getId());

  if(messages == null){
	log.error("The messages object is not valid");
	%>
	  <tr ><td colspan="5" valign="middle" align="center"><br /><strong>No Messages Found (Error Occurred)</strong><br />&nbsp;</td></tr>
	<%
	return;
  }
  if(messages.getElementCount() == 0){
    %>
      <tr ><td colspan="5" valign="middle" align="center"><br /><strong>No Messages Found</strong><br />&nbsp;</td></tr>
    <%
	return;
  }

  boolean odd = false;
  String unread;
  for(Addressee a : messages.getElements()){
	  Message m = a.getMessage();
	  Thread t = m.getThread();
	  if(a.getReadDate() == null){
		  unread="font-weight:bold;";
		  if(selectMsgsOption.equalsIgnoreCase("unread")){
		  	checkedVal = "checked";
		  }else if(selectMsgsOption.equalsIgnoreCase("read")){
		  	checkedVal = "";
		  }
	  }else{
		  unread="";
		  if(selectMsgsOption.equalsIgnoreCase("read")){
		  	checkedVal = "checked";
		  }else if(selectMsgsOption.equalsIgnoreCase("unread")){
		  	checkedVal = "";
		  }
	  }
	  odd = !odd;
	  String style = "";
	  if(odd){
        style = "sm_inbox_odd";
	  }else{
		style =  "sm_inbox_even";
	  }
	  if(messageChkType.equals("hidden"))
		{
	    if(odd)
			{
        messageChkImg="<img src='images/sms/inbox_white.jpg' alt=''>";
	    }
			else
			{
		    messageChkImg="<img src='images/sms/inbox_blue.jpg' alt=''>";
			}
		}
		else
		{
			messageChkImg="";
		}
	%>
	   <tr class="<%=style %>">
			<td width="18">
				<%=messageChkImg%>
				<%
				if(messageChkType.equals("checkbox")){
				%>	
				<label for="messageChk-<%=m.getId()%>">
					<%
					if(!isDraftsFolder){
						textForCheckbox = "Message from " + m.getSenderName();						
					}else{
						textForCheckbox = "Draft message.";
					}
						textForCheckbox += " Subject: " + t.getSubject();
					%>
					<img width="1" height="1" alt="<%=textForCheckbox%>" src="images/spacer.gif">
				</label>	
				<%	
				}
				%>
				<input type="<%=messageChkType%>" name="messageChk" id="messageChk-<%=m.getId()%>" value="<%=m.getId()%>" <%=checkedVal%> />
			</td>
	    <td style="<%=unread %>"><%= isSentFolder ? m.getRecipientName() : m.getSenderName() %></td>
	    <td style="<%=unread %>">
	      <% if(!isDraftsFolder){ %>
            <a href="ReadMessage.action?messageId=<%=m.getId() %>">
              <%=t.getSubject()%>
              </a>&nbsp;&nbsp;
	        	<%
	        		if(m.isAttachment()){
		        %>
		        <img src='images/attachment.gif' border="0" alt="Attachment"> 
	    	    <%}%>
            </a>
          <% }else
          {
        	  String editDraftUrl = "";
        	  if(t.getMessages().size()==1)
        	  {
        		 editDraftUrl = "editDraft.action?messageId="+m.getId();
        	  }
        	  else
        	  {
				 editDraftUrl = "editReplyDraft.action?messageId="+m.getId();        		  
        	  }
        	  %>
             <a href="<%=editDraftUrl%>">
              <%=t.getSubject()%>
            </a>
          <%} %>
        </td>
	    <td style="<%=unread %>"><%=DateUtils.getEnglishDateTime( (folder.getId() == SystemFolderEnum.DRAFTS.getId()?m.getCreatedDate():m.getSentDate()) ) %></td>
		<%if(isSentFolder){ 
			String readReceipt = m.getReadReceipt();
			if(readReceipt==null)readReceipt = "";
		
		%>
				
	    	<td style="<%=unread %>"><%=readReceipt%></td>
		<%}%>	    
</tr>
	<%
  }
%>
