<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ page session="true" 
	import="gov.va.med.mhv.sm.model.User" 
	import="gov.va.med.mhv.sm.enumeration.UserStatusEnum" 
	import="gov.va.med.mhv.sm.web.smActions.AbstractInboxAction"
	import="gov.va.med.mhv.foundation.util.Precondition"
	import="gov.va.med.mhv.sm.web.utils.SMHelpUtil"
	
%>
<%!
	private static final String CHECKED_ATTRIBUTE = " checked";
	
	private UserStatusEnum getStatus(HttpSession session) {
		Precondition.assertNotNull("session", session);
		User user = (User) session.getAttribute(AbstractInboxAction.CURRENT_USER);
		if (user == null) { 
			Precondition.fail("User not logged in");
		}
		return user.getStatus();
	}
%>
<%
	UserStatusEnum status = getStatus(session); 
	final String statusText = (UserStatusEnum.OPT_IN.equals(status)) 
		? "Opted In to use" : ((UserStatusEnum.OPT_OUT.equals(status)) 
		   ? "Opted Out of ": null);
	final String optInOutHeading = (statusText != null) 
		? "<h2>You are currently " + statusText + " Secure Messaging</h2>" : "";
	final String optInChecked = (UserStatusEnum.OPT_IN.equals(status)) ? CHECKED_ATTRIBUTE : "";  
	final String optOutChecked = (UserStatusEnum.OPT_OUT.equals(status)) ? CHECKED_ATTRIBUTE : "";  
%>


<tr>
	<td colspan="2" valign="top" align="left" class="sm_main_cell">
		<s:actionerror cssStyle="color:#990000;font-weight:bold;"/>	
		<table width="100%" cellpadding="0" cellspacing="0" border="0"  
		    id="sm_boxTable">
		<tr>
			<td valign="top" align="left" width="6" class="sm_boxLeft">
				<img src="images/sms/border_topLeft.gif" width="6" height="13" alt="top left border" border="0" />
			</td><td valign="top" align="left" class="sm_box" >
				<p>
				<h2>Welcome to Secure Messaging</h2>
				</p>
				<!-- START INTRO TEXT -->
				<p>If you agree to the following Terms and Conditions, 
				   please select 'Opt In' to enter Secure Messaging
				</p>
				<!-- END INTRO TEXT -->
				<%= optInOutHeading %>				
				<form name="optin_Form" id="optin_Form" action="optInOptOut.action" method="POST">			
					<table width="100%" cellpadding="0" cellspacing="0" border="0">
					<tr>
						<td colspan="2">					
							<%-- Note that white space within textarea tags IS 
							     significant 
							  --%>
							<label for="termsBox"><img width="1" height="1" alt="Terms and Conditions" src="images/spacer.gif"></label>
							<textarea class="termsBox" name="termsBox"  id="termsBox" rows="20" 
							    cols="82" readonly
							    ><%=SMHelpUtil.getContent("help/terms_and_conditions.html")%></textarea>
							<br/>
							&nbsp;
						</td>
					</tr><tr>
						<td width="75%" valign="top" align="left">
							<table cellpadding="0" cellspacing="0" border="0">
							<tr>
								<td valign="middle" align="center" width="6%">
									<input type="radio" name="optIn" id="optIn" <%= optInChecked%> 
										value="<%= UserStatusEnum.OPT_IN.getId() %>" />
								</td><td valign="middle" align="left">
									<label for="optIn">
										I have read the terms and conditions and would like to Opt in
									</label>
								</td>
							</tr><tr>
								<td valign="middle" align="center">
									<input type="radio" name="optIn" id="optOut" <%= optOutChecked%>  
										value="<%= UserStatusEnum.OPT_OUT.getId() %>" />
								</td>
								<td valign="middle" align="left">
									<label for="optOut">Opt out</label>
								</td>
							</tr>
							</table>
						</td>
						<td width="25%" valign="bottom" align="right">
							<input type="submit" id="optIn_submit" name="optIn_submit" value="Submit" 
								class="blueSubmitBtn" title="Submit"/>
							&nbsp;
							<s:if test="%{userReacceptTerms==true}">
								<input type="submit" id="opt_cancel" name="opt_cancel" value="Cancel" class="blueSubmitBtn" title="Cancel"/>
							</s:if>
							<s:else>
								<input type="submit" id="btn_cancel" name="btn_cancel" value="Cancel" class="blueSubmitBtn" title="Cancel"/>
							</s:else>	
						</td>
					</tr>
					</table>
				</form>
			</td>
			<td valign="top" align="left" width="7" class="sm_boxRight">
				<img src="images/sms/border_topRight.gif" width="7" height="13" alt="top right border" border="0" />
			</td>
		</tr><tr class="borderLine">
			<td valign="top" align="left" width="6">
				<img src="images/sms/border_btmLeft.gif" width="6" height="13" alt="bottom left border" border="0" />
			</td><td valign="top" align="left" class="sm_boxBottom">
				<img src="images/spacer.gif" width="1" height="1" alt="" border="0" />
			</td>
			<td valign="top" align="left" width="7">
				<img align="absbottom" src="images/sms/border_btmRight.gif" width="7" height="13" 
					alt="bottom right border" border="0" />
			</td>
		</tr>
		</table>
	</td>
</tr>