package gov.va.med.mhv.sm.web.utils;

import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.dao.SurrogateDao;
import gov.va.med.mhv.sm.dao.TriageGroupDao;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.enumeration.ClinicianStatusEnum;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Annotation;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Mailbox;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.SubFolder;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.web.smActions.AbstractInboxAction;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ut
{

	
  public static String[] getConfigLocations() {
	return new String[] {
				"gov/va/med/mhv/sm/persist-context.xml",
				"gov/va/med/mhv/sm/resource-context.xml",
				"gov/va/med/mhv/sm/service-context.xml",
				"gov/va/med/mhv/sm/dao/dao-sms-context.xml",
				"gov/va/med/mhv/sm/service/service-sms-context.xml",
				"gov/va/med/mhv/sm/wsclient-context.xml",
				"gov/va/med/mhv/sm/ad-context.xml"
				};
  }

  public static Log log =LogFactory.getLog(ut.class);

  public static String UnitName="gov.va.med.mhv.sm.web.utils.ut";

  public static boolean isClinician(gov.va.med.mhv.sm.model.User u)
  {
    java.lang.String ProcName="isClinician";
		boolean retval=false;
    try
    {
      if(u.getUserType().getDescription().equals("Clinician")){retval=true;}
			return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return false;
    }
  }

  public static boolean isUserClinician(HttpSession session)
  {
    java.lang.String ProcName="isUserClinician";
	gov.va.med.mhv.sm.model.User u;
	boolean retval=false;
    try
    {
	  u=getUser(session);
	  retval=isClinician(u);
	  return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return false;
    }
  }

	// If a user is not logged in yet, the only way to find out what type
	// the user is is based on the host name
	// Check host name to see if clinician is in the host name.  For
	// example smclinician.myhealth.DNS   , tstsmclinician.myhealth.DNS   
	public static UserTypeEnum getUserTypeBasedOnHostInRequest(HttpServletRequest request)
	{
		UserTypeEnum userType = UserTypeEnum.PATIENT;

		String host = request.getHeader("Host");

		log.debug("Host header: " + host);

		if (host.indexOf("clinician") > 0) {
			userType = UserTypeEnum.CLINICIAN;
		} else if (host.indexOf("admin") > 0) {
			userType = UserTypeEnum.ADMINISTRATOR;
		}

		return userType;
	}


  public static String getHTMLclinicianPreferencesInboxView(HttpServletRequest request)
  {
    java.lang.String ProcName="getHTMLclinicianPreferencesInboxView";
		gov.va.med.mhv.sm.enumeration.MessageFilterEnum currentValue=null;
		gov.va.med.mhv.sm.model.User u=null;
		HttpSession session=request.getSession();
		java.lang.String MessageFilterName="";
		java.lang.String spacer="              ";
		java.lang.String indent="  ";
		java.lang.String EOL="\r\n";
		java.lang.String tempRetval="";
		java.lang.String tempSelected0="";
		java.lang.String tempSelected1="";
		java.lang.String tempSelected2="";
		String retOpt ="";
		java.lang.String retval=
			"<select name=\"clinicianPreferencesInboxViewType\">"+EOL+
			spacer+indent+"<option value=\"0\""+tempSelected0+">All Messages</option>"+EOL+
			spacer+indent+"<option value=\"1\""+tempSelected1+">Only Messages Assigned to Me</option>"+EOL+
			spacer+indent+"<option value=\"2\""+tempSelected2+">Only Unassigned Messages</option>"+EOL+
			spacer+"</select>"+EOL+
			spacer+"<!-- Exception Thrown -->";
    try
    {
			u=getUser(session);
			if(u.getMessageFilter().getId()==0){tempSelected0="SELECTED";}
			if(u.getMessageFilter().getId()==1){tempSelected1="SELECTED";}
			if(u.getMessageFilter().getId()==2){tempSelected2="SELECTED";}
            tempRetval=
				"<select name=\"clinicianPreferencesInboxViewType\">"+EOL+
				spacer+indent+"<option value=\"0\""+tempSelected0+">All Messages</option>"+EOL+
				spacer+indent+"<option value=\"1\" "+tempSelected1+">Only Messages Assigned to Me</option>"+EOL+
				spacer+indent+"<option value=\"2\"     "+tempSelected2+">Only Unassigned Messages</option>"+EOL+
				spacer+"</select>"+EOL;
			retval=tempRetval;
			return retval;
    }
    catch(Exception e)
    {
          raiseError(UnitName, ProcName, e);
          return retval+
			spacer+"<!-- getHTMLclinicianPreferencesInboxView exception thrown -->"+EOL+
			spacer+"<!-- "+e.getMessage()+" -->"+EOL;
    }
  }

  public static String getHTMLNotificationStatus(HttpServletRequest request)
  {



    java.lang.String ProcName="getHTMLNotificationStatus";
		gov.va.med.mhv.sm.enumeration.EmailNotificationEnum currentValue=null;
		gov.va.med.mhv.sm.model.User u=null;
		boolean isDoc=false;
		HttpSession session=request.getSession();
		java.lang.String emailNotificationName="";
		java.lang.String spacer="              ";
		java.lang.String indent="  ";
		java.lang.String EOL="\r\n";
		java.lang.String tempRetval="";
		java.lang.String tempSelected0="";
		java.lang.String tempSelected1="";
		java.lang.String tempSelected2="";
		java.lang.String tempSelected3="";
    java.lang.String retval=
			"<select id=\"newMsgNotif_NOTIFY\" name=\"newMsgNotif_NOTIFY\" title=\"Select whether you want to be notified\">"+EOL;

    		if(!isUserClinician(request.getSession())){    // Implemented for CR#4651 (None option should be removed for clinician)
    			retval = retval+spacer+indent+"<option value=\"None\" selected>None</option>"+EOL;
    		}
			retval = retval+spacer+indent+"<option value=\"Each message\">Each message</option>"+EOL;
			retval = retval+spacer+indent+"<option value=\"Once daily\">Once daily</option>"+EOL;
			retval = retval+spacer+"</select>"+EOL;
			retval = retval+spacer+"<!-- Exception Thrown -->";
    try
    {
			u=getUser(session);
			isDoc=isClinician(u);
			currentValue=u.getEmailNotification();
			emailNotificationName=currentValue.getName();
			if(emailNotificationName.equals("None"        ))
			{
					tempSelected0="SELECTED";
			}
			if(emailNotificationName.equals("Each message"))
			{
					tempSelected1="SELECTED";
			}
			if(emailNotificationName.equals("Once daily"  ))
			{
					tempSelected2="SELECTED";
			}
			if(emailNotificationName.equals("On assignment to me"))
			{
				if(isDoc)
				{
				  tempSelected3="SELECTED";
				}
				else
				{
					tempSelected0="SELECTED";
				}
			}
      tempRetval=
				"<select id=\"newMsgNotif_NOTIFY\" name=\"newMsgNotif_NOTIFY\" title=\"Select whether you want to be notified\">"+EOL;
      			if(!isUserClinician(request.getSession())){ // Implemented for CR#4651 (None option should be removed for clinician)
      				tempRetval = tempRetval+spacer+indent+"<option value=\"None\" "+tempSelected0+">None</option>"+EOL;
      			}
				tempRetval = tempRetval+spacer+indent+"<option value=\"Each message\" "+tempSelected1+">Each message</option>"+EOL;
				tempRetval = tempRetval+spacer+indent+"<option value=\"Once daily\" "+tempSelected2+">Once daily</option>"+EOL;
			if(isDoc)
			{
				tempRetval=
					tempRetval+
					spacer+indent+"<option value=\"On assignment to me\" "+tempSelected3+">On assignment to me</option>"+EOL;
			}
			tempRetval=
				tempRetval+
				spacer+"</select>"+EOL;
			retval=tempRetval;
			return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return
			  retval+
				spacer+"<!-- getHTMLNotificationStatus exception thrown -->"+EOL+
				spacer+"<!-- "+e.getMessage()+" -->"+EOL;
    }
  }

  public static String getUserEmailAddress(HttpServletRequest request)
  {


    java.lang.String ProcName="getUserEmailAddress";
    java.lang.String retval="Enter an Email Address";
		gov.va.med.mhv.sm.model.User u=null;
		HttpSession session=request.getSession();

    try
    {
    		u=getUser(session);
			try
			{
				retval=u.getEmail();

			}catch(Exception e)
			{

			}
			if(retval==null){return "Enter an Email Address";}
			if(retval.equals("")){return "Enter an Email Address";}
      return retval;
    }catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "Enter an Email Address";
    }
  }

  public static boolean isDigit(char s)
  {
    java.lang.String ProcName="isDigit";
    java.lang.String c="";
    try
    {
      c=s+c;
      if(c.equals("0")){return true;}
      if(c.equals("1")){return true;}
      if(c.equals("2")){return true;}
      if(c.equals("3")){return true;}
      if(c.equals("4")){return true;}
      if(c.equals("5")){return true;}
      if(c.equals("6")){return true;}
      if(c.equals("7")){return true;}
      if(c.equals("8")){return true;}
      if(c.equals("9")){return true;}
      return false;
    }catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return false;
    }
  }

  public static String numbersOnly(String s)
  {
    java.lang.String ProcName="numbersOnly";
    java.lang.String retval="";
    char c;
    try
    {
      if(s==null){return "";}
      for(int i=0;i<s.length();i++)
      {
        c=s.charAt(i);
        if(isDigit(c))
        {
          retval=retval+c;
        }
      }
      return retval;
    }catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getHTMLLoggedInUser(HttpSession session)
  {
    java.lang.String ProcName="getHTMLLoggedInUser";
    java.lang.String userstring="";
    try
    {
      userstring=getLoggedInUser(session);
      if(userstring.equals("")){return "";}
      return "<br />You are logged in as: <span class=\"sm_username\">"+userstring+"</span>";
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getHTMLUserFilterCombo(HttpServletRequest request)
  {
    java.lang.String ProcName="getHTMLUserFilterCombo";
    HttpSession session=request.getSession();
    String ActiveFolderName="";
    String FormName="FilterMessages";
    String FieldName="FilterMessageID";
    String FormAction=FormName+".action";
    String sgSelected="";
    String retval="";
    String spacer="                ";
    String header=
      spacer+"<form name=\""+FormName+"Form\" action=\""+FormAction+"\" id=\""+FormName+"Form\" method=\"POST\">\r\n"+
      spacer+"<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" align=\"right\">\r\n"+
      spacer+"<tr>\r\n"+
      spacer+"  <td valign=\"middle\" align=\"right\">\r\n"+
      spacer+"    <p>\r\n"+
      spacer+"    &nbsp;<label for=\""+FieldName+"\">Display</label>:&nbsp;\r\n"+
      spacer+"    </p>\r\n"+
      spacer+"  </td>\r\n"+
      spacer+"  <td valign=\"middle\" align=\"left\">\r\n"+
      spacer+"  <select name=\"FilterMessageID\" class=\"sm_DisplayDropDown\">\r\n";
    String footer=
      spacer+"  </td>\r\n"+
      spacer+"  <td>\r\n"+
      spacer+"  <input type=\"submit\" style=\"background-color:#345DAF;color:white;font-family:helvetica;border:1px solid;border-top-color:#696;border-left-color:#696;border-right-color:#363;border-bottom-color:#363;\" name=\"FilterMessageApply\" title=\"Apply message filter\" value=\"Apply\">\r\n"+
      spacer+"  </td>\r\n"+
      spacer+"</tr>\r\n"+
      spacer+"</table>\r\n"+
      spacer+"</form>\r\n";
    String valueWas="";
    gov.va.med.mhv.sm.enumeration.MessageFilterEnum currentValue=null;
    gov.va.med.mhv.sm.model.User u=null;
    try
    {
      u=getUser(session);
      if(!u.getUserType().getDescription().equals("Clinician")){return retval;}
      ActiveFolderName=getActiveFolderName(request);
      if(!ActiveFolderName.equals("Inbox")){return retval;}
      currentValue=getUserFilter(session);
      for(gov.va.med.mhv.sm.enumeration.MessageFilterEnum s : gov.va.med.mhv.sm.enumeration.MessageFilterEnum.values())
      {
        if(currentValue.getName().equals(s.getName()))
        {
          sgSelected="selected ";
          valueWas=s.getId()+"";
        }
        else
        {
          sgSelected="";
        }
        retval=retval+spacer+"    <option "+sgSelected+"value=\""+s.getId()+"\">"+s.getName()+"</option>\r\n";
      }
      retval=retval+spacer+"  </select>\r\n";
      valueWas=spacer+"  <input type=\"hidden\" name=\""+FieldName+"Was\" value=\""+valueWas+"\">\r\n";
      return header+retval+valueWas+footer;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static gov.va.med.mhv.sm.enumeration.MessageFilterEnum getUserFilter(HttpSession session)
  {
    String ProcName="getUserFilter";
    gov.va.med.mhv.sm.enumeration.MessageFilterEnum retval=null;
    gov.va.med.mhv.sm.model.User u=null;
    try
    {
      u=getUser(session);
      retval=u.getMessageFilter();
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return null;
    }
  }

  public static String getHTMLforMessageAnnotations(HttpSession session)
  {
    String ProcName="getHTMLforMessageAnnotations";
    String retval="";
    String spacer1="";
    String spacer2="  ";
    String header=
      spacer1+"<hr size=\"1\" />\r\n"+
      spacer1+"<table width=\"100%\" cellpadding=\"0\" cellspacing=\"5\" border=\"0\" class=\"sm_commentsTable\">\r\n"+
      spacer1+spacer2+"<tr><td><h5>Previous Comments([COUNT]):</h5></td></tr>\r\n";
    String footer=spacer1+"</table>\r\n";
    String CreatedDate="";
    String Author="";
    String Body="";
    String Annot="";
    gov.va.med.mhv.sm.model.Message currentMessage=null;
    try
    {
      try{currentMessage=(Message)session.getAttribute(AbstractInboxAction.CURRENT_MESSAGE);}catch(Exception e){}
      if(currentMessage==null){return retval;}
      List<gov.va.med.mhv.sm.model.Annotation> annotations=null;
      try{annotations=currentMessage.getThread().getAnnotations();}catch(Exception e){}
      if(annotations==null){return retval;}
      for(Annotation a: annotations)
      {
        Annot="";
        CreatedDate="";
        Author="";
        Body="";
        try{CreatedDate=a.getCreatedDate()+"";}catch(Exception e){}
        try{Author=a.getAuthor().getName();}catch(Exception e){}
        try{Body=a.getAnnotation();}catch(Exception e){}
        if(!CreatedDate.equals("")){Annot=Annot+CreatedDate+"<br>";}
        if(!Author.equals("")){Annot=Annot+Author+"<br>";}
        if(!Body.equals("")){Annot=Annot+Body;}
        if(!Annot.equals("")){retval=retval+spacer1+spacer2+"<tr><td class=\"commentCell\">"+Annot+"</td></tr>\r\n";}
      }
      if(!retval.equals(""))
      {

        retval=header.replace("[COUNT]",String.valueOf(annotations.size()))+retval+footer;
      }
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }


  public static String getHTMLforMessageStatusCombo(HttpSession session)
  {
    String ProcName="getHTMLforMessageStatusCombo";
    String formField="MessageStatusID";
    String spacer="                                                ";
    String retval="";
    String header=spacer+"<select name=\""+formField+"\" onchange=' messageStatusChange()' >\r\n";
    String valueWas="";
    String footer=spacer+"</select>";
    gov.va.med.mhv.sm.model.Message currentMessage=null;
    User u=getUser(session);
    String sgSelected="";
    boolean oneIsSelected=false;
    try
    {
      if(!u.getUserType().getDescription().equalsIgnoreCase("Clinician")){return retval;}
      try{currentMessage=(Message)session.getAttribute(AbstractInboxAction.CURRENT_MESSAGE);}catch(Exception e){}
      if(currentMessage==null){return retval;}
      for(gov.va.med.mhv.sm.enumeration.ClinicianStatusEnum s : ClinicianStatusEnum.values())
      {
    	// skip the INCOMPLETE status
    	if(s == ClinicianStatusEnum.INCOMPLETE) continue;

        if(currentMessage.getStatus().equals(s))
        {
          sgSelected="selected ";
          oneIsSelected=true;
          valueWas=s.getId()+"";
        }
        else
        {
          sgSelected="";
        }
        retval=retval+spacer+"<option "+sgSelected+"value=\""+s.getId()+"\">"+s.getStatusAlt()+"</option>\r\n";
      }
      if(retval.equals(""))
      {
        return retval;
      }
      else
      {
        if(!oneIsSelected)
        {
          retval=spacer+"<option selected value=\"\"></option>\r\n"+retval;
        }
        valueWas="<input type=\"hidden\" name=\""+formField+"Was\" value=\""+valueWas+"\">\r\n";
        return valueWas+header+retval+footer;
      }
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getHTMLforMessageAssignedToCombo(HttpSession session)
  {
    String ProcName="getHTMLforMessageAssignedTo";
    String formField="Assignee";
    String spacer="                                                ";
    String retval="";
    String header=spacer+"<select id=\"assignee\" name=\""+formField+"\" onchange=\"onchangeAssignTo()\">\r\n";
    String footer=spacer+"</select>";
    gov.va.med.mhv.sm.model.Message currentMessage=null;
    Clinician assignedTo=null;
    User u=getUser(session);
    String sgSelected="";
    String valueWas="";
    String title = "";
    boolean oneIsSelected=false;
    boolean isCurrentUserPartOfThisTriage = false;
    UserManagementService userService;
    WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(session.getServletContext());
    userService = (UserManagementService) ctx.getBean("userManagementService");
    SurrogateDao surrogateDao= (SurrogateDao)ctx.getBean("surrogateDao");
    TriageGroupDao triageGroupDao = (TriageGroupDao)ctx.getBean("triageGroupDao");
    try
    {
	  //System.out.println("<<<<<<<<<<<<<<<<< getUserType:: "+u.getUserType().getDescription());
	  //System.out.println("<<<<<<<<<<<<<<<<< getId():: "+u.getId());
	  //System.out.println("<<<<<<<<<<<<<<<<< getName():: "+u.getName());

      if(!u.getUserType().getDescription().equalsIgnoreCase("Clinician")){return retval;}
      try{currentMessage=(Message)session.getAttribute(AbstractInboxAction.CURRENT_MESSAGE);}catch(Exception e){}
      if(currentMessage==null){return retval;}
      assignedTo=currentMessage.getAssignedTo();

      List<Clinician> TriageMembers=currentMessage.getThread().getMailGroup().getClinicians();

      for(Clinician c: TriageMembers)
      {

    	if(c.getId().equals(u.getId())){
    		isCurrentUserPartOfThisTriage = true;
    	}
    	if(c.getStatus() == UserStatusEnum.OPT_OUT) continue;

        if(c.equals(assignedTo))
        {
          sgSelected="selected ";
          oneIsSelected=true;
          valueWas=c.getId()+"";
        }
        else
        {
          sgSelected="";
        }

        title = c.getName();

        Surrogate currentSurrogate = surrogateDao.getCurrentSurrogateFor(c);
        if(currentSurrogate!=null){
        	if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN)){
        		Clinician nc = userService.fetchClinician(currentSurrogate.getSurrogateId()).getPayload();
        		title += " - surrogate enabled: " + nc.getName();
        	}else if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)){
        		TriageGroup triageGroup = triageGroupDao.findById(currentSurrogate.getSurrogateId());
        		title += " - surrogate enabled: " + triageGroup.getName();
        	}
        }
        retval=retval+spacer+"<option title=\"" + title + "\" " + sgSelected + "value=\"" + c.getId() + "\">" + c.getName() + "</option>\r\n";
      }

      // The following condition for the bug 5920.
      // Write the logic to include <option> check the current logged in user is surrogate and belongs to different triage group.
      if(!isCurrentUserPartOfThisTriage){
    	  retval=retval+spacer+"<option title=\"" + u.getName() + "\" " + "value=\"" + u.getId() + "\">" + u.getName() + "</option>\r\n";
      }


      if(retval.equals(""))
      {
        return retval;
      }
      else
      {
        if(!oneIsSelected)
        {
          retval=spacer+"<option selected value=\"\">Select Assignee</option>\r\n"+retval;
        }
        valueWas="<input type=\"hidden\" name=\""+formField+"Was\" value=\""+valueWas+"\">\r\n";
        return valueWas+header+retval+footer;
      }
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getLoggedInUser(HttpSession session)
  {
    String ProcName="getLoggedInUser";
    try
    {
      User user=getUser(session);
      return user.getFirstName()+" "+user.getLastName();
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

   public static Folder getActiveFolder(HttpServletRequest request) {
	   Precondition.assertNotNull("request", request);
	   User user = getUser(request.getSession());
	   final String activeFolderName = getActiveFolderName(request);
	   Mailbox mailbox = user.getMailbox();
	   for (Folder folder: mailbox.getFolders().values()){
		   if (folder.getName().equalsIgnoreCase(activeFolderName)){
		 	   return folder;
		   }
	   }
	   return null;
   }

   public static Folder getActiveFolder(HttpServletRequest request, String folderName) {
	   Precondition.assertNotNull("request", request);
	   Precondition.assertNotNull("folderName", folderName);
	   User user = getUser(request.getSession());
	   Mailbox mailbox = user.getMailbox();
	   for (Folder folder: mailbox.getFolders().values()){
		   if (folder.getName().equalsIgnoreCase(folderName)){
		 	   return folder;
		   }
	   }
	   return null;
   }

   public static SubFolder getActiveSubFolder(HttpServletRequest request, Folder folder) {
	   Precondition.assertNotNull("request", request);
	   Precondition.assertNotNull("folder", folder);
	   final String activeSubFolderName = getActiveFolderName(request);
	   for (SubFolder sf: folder.getSubfolderList()){
		   if (sf.getName().equalsIgnoreCase(activeSubFolderName)){
		 	   return sf;
		   }
	   }
	   return null;
   }


  public static String getActiveFolderType(HttpServletRequest request)
  {
    String ProcName="getActiveFolderType";
    String activeFolderName="";
    try
    {
      activeFolderName=getActiveFolderName(request);
      if(activeFolderName.equals("Inbox") || activeFolderName.equals("Escalated") || activeFolderName.equals("Sent") || activeFolderName.equals("Deleted") || activeFolderName.equals("Completed"))
      {
        return "system";
      }
      else
      {
        return "user";
      }
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "system";
    }
  }

  public static String getActiveFolderType(String activeFolderName)
  {
    String ProcName="getActiveFolderType";
    try
    {
      if(activeFolderName.equals("Inbox") || activeFolderName.equals("Escalated") || activeFolderName.equals("Sent") || activeFolderName.equals("Deleted") || activeFolderName.equals("Completed"))
      {
        return "system";
      }
      else
      {
        return "user";
      }
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "system";
    }
  }

   public static String getActiveFolderName(HttpServletRequest request) {
	  Precondition.assertNotNull("request", request);

	  final String parameterName = "MBLeftNavSubmit";
	  final String defaultFolderName = "Inbox";
      String activeFolderName = null;
      try {
         activeFolderName = request.getParameter(parameterName);
   	  	 return (StringUtils.isBlank(activeFolderName)) ? defaultFolderName :
   	  		 activeFolderName;
      } catch(Exception e) {
         raiseError(UnitName, "getActiveFolderName", e);
         return defaultFolderName;
      } finally {
         if (StringUtils.isBlank(activeFolderName)) {
             request.setAttribute(parameterName, defaultFolderName);
         }
      }
  }

  public static void raiseError(String UnitName, String ProcName,Exception e)
  {
    try
    {
      log.error(UnitName+": "+ProcName+": "+e.getMessage());
    }
    catch(Exception E)
    {
    }
  }

  public static User getUser(HttpSession session)
  {
    String ProcName="getUser";
    User retval;
    try
    {
      retval=(User)session.getAttribute(AbstractInboxAction.CURRENT_USER);
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName,ProcName,e);
      return null;
    }
  }

  public static Clinician getClinician(HttpSession session)
  {
    String ProcName="getClinician";
    User u;
    Clinician retval=null;
    String userType="";
    try
    {
      u=getUser(session);
      if(u.equals(null)){return null;}
      userType=u.getUserType().getDescription();
      if(userType.equals("Clinician"))
      {
        retval=(Clinician)u;
      }
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName,ProcName,e);
      return null;
    }
  }

  public static String getRequestAsString(HttpServletRequest request)
  {
    String ProcName="getRequestAsString";
    String retval="HttpServletRequest Values:\r\n\r\n";
    try
    {
      retval=retval + getRequestParameterNames(request) + getRequestHeaderNames(request) + getRequestAttributeNames(request) + getRequestStrings(request);
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName,ProcName,e);
      return ProcName + ":ERROR" + e.getMessage();
    }
  }

  @SuppressWarnings("unused")
  public static String getRequestStrings(HttpServletRequest request)
  {
    String ProcName="getRequestStrings";
    String spacer="  ";
    String retval="Request Strings:\r\n";
    try
    {
      /*
      retval=retval + spacer + "BASIC_AUTH" + "=" + request.BASIC_AUTH + "//String identifier for Basic authentication.\r\n" + spacer + "CLIENT_CERT_AUTH" + "=" + request.CLIENT_CERT_AUTH + "//String identifier for Basic authentication.\r\n" + spacer
          + "DIGEST_AUTH" + "=" + request.DIGEST_AUTH + "//String identifier for Basic authentication.\r\n" + spacer + "FORM_AUTH" + "=" + request.FORM_AUTH + "//String identifier for Basic authentication.\r\n" + spacer + "getAuthType()" + "="
          + request.getAuthType() + "//Returns the name of the authentication scheme used to protect the servlet.\r\n" + spacer + "getCharacterEncoding()" + "=" + request.getCharacterEncoding()
          + "//Returns the name of the character encoding used in the body of this request.\r\n" + spacer + "getContentLength()" + "=" + request.getContentLength()
          + "//Returns the length, in bytes, of the request body and made available by the input stream, or -1 if the length is not known.\r\n" + spacer + "getContentType()" + "=" + request.getContentType()
          + "//Returns the MIME type of the body of the request, or null if the type is not known.\r\n" + spacer + "getContextPath()" + "=" + request.getContextPath()
          + "//Returns the portion of the request URI that indicates the context of the request.\r\n" + spacer + "getMethod()" + "=" + request.getMethod()
          + "//Returns the name of the HTTP method with which this request was made, for example, GET, POST, or PUT.\r\n" + spacer + "getPathInfo()" + "=" + request.getPathInfo()
          + "//Returns any extra path information associated with the URL the client sent when it made this request.\r\n" + spacer + "getPathTranslated()" + "=" + request.getPathTranslated()
          + "//Returns any extra path information after the servlet name but before the query string, and translates it to a real path.\r\n" + spacer + "getProtocol()" + "=" + request.getProtocol()
          + "//Returns the name and version of the protocol the request uses in the form protocol/majorVersion.minorVersion, for example, HTTP/1.1.\r\n" + spacer + "getQueryString()" + "=" + request.getQueryString()
          + "//Returns the query string that is contained in the request URL after the path.\r\n" + spacer + "getRemoteAddr()" + "=" + request.getRemoteAddr() + "//Returns the Internet Protocol (IP) address of the client that sent the request.\r\n"
          + spacer + "getRemoteHost()" + "=" + request.getRemoteHost() + "//Returns the fully qualified name of the client that sent the request.\r\n" + spacer + "getRemoteUser()" + "=" + request.getRemoteUser()
          + "//Returns the login of the user making this request, if the user has been authenticated, or null if the user has not been authenticated.\r\n" + spacer + "getRequestedSessionId()" + "=" + request.getRequestedSessionId()
          + "//Returns the session ID specified by the client.\r\n" + spacer + "getRequestURI()" + "=" + request.getRequestURI()
          + "//Returns the part of this request's URL from the protocol name up to the query string in the first line of the HTTP request.\r\n" + spacer + "getRequestURL()" + "=" + request.getRequestURL()
          + "//Reconstructs the URL the client used to make the request.\r\n" + spacer + "getScheme()" + "=" + request.getScheme() + "//Returns the name of the scheme used to make this request, for example, http, https, or ftp.\r\n" + spacer
          + "getServerName()" + "//Returns the host name of the server that received the request.\r\n" + spacer + "getServerPort()" + "=" + request.getServerPort() + "//Returns the port number on which this request was received.\r\n" + spacer
          + "getServletPath()" + "=" + request.getServletPath() + "//Returns the part of this request's URL that calls the servlet.\r\n" + spacer + "isRequestedSessionIdFromCookie()" + "=" + request.isRequestedSessionIdFromCookie()
          + "//Checks whether the requested session ID came in as a cookie.\r\n" + spacer + "isRequestedSessionIdFromURL()" + "=" + request.isRequestedSessionIdFromURL() + "//Checks whether the requested session ID came in as part of the request URL.\r\n"
          + spacer + "isRequestedSessionIdFromUrl()" + "=" + request.isRequestedSessionIdFromUrl() + "//Deprecated. As of Version 2.1 of the Java Servlet API, use isRequestedSessionIdFromURL() instead.\r\n" + spacer + "isRequestedSessionIdValid()" + "="
          + request.isRequestedSessionIdValid() + "//Checks whether the requested session ID is still valid.\r\n" + spacer + "isSecure()" + "=" + request.isSecure()
          + "//Returns a boolean indicating whether this request was made using a secure channel, such as HTTPS.\r\n";
      return retval;
      */
      return "";
    }
    catch(Exception e)
    {
      raiseError(UnitName,ProcName,e);
      return ProcName + ":ERROR" + e.getMessage();
    }
  }

  public static String getRequestParameterNames(HttpServletRequest request)
  {
    String ProcName="getRequestParameterNames";
    String spacer="  ";
    String retval="Parameter Names:  //request.ParameterNames():\r\n";
    try
    {
      java.util.Enumeration E=request.getParameterNames();
      while(E.hasMoreElements())
      {
        String key=(String)E.nextElement();
        String[] values=request.getParameterValues(key);
        retval=retval + spacer + key + "=";
        for(int i=0; i < values.length; i++)
        {
          retval=retval + values[i] + "\r\n";
        }
      }
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName,ProcName,e);
      return ProcName + ":ERROR" + e.getMessage();
    }
  }

  public static String getRequestAttributeNames(HttpServletRequest request)
  {
    String ProcName="getRequestAttributeNames";
    String spacer="  ";
    String retval="Attribute Names:  //request.AttributeNames():\r\n";
    try
    {
      java.util.Enumeration E=request.getAttributeNames();
      while(E.hasMoreElements())
      {
        String key=(String)E.nextElement();
        Object value=request.getAttribute(key);
        retval=retval + spacer + key + "=" + value.toString() + "\r\n";
      }
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName,ProcName,e);
      return ProcName + ":ERROR" + e.getMessage();
    }
  }

  public static String getRequestHeaderNames(HttpServletRequest request)
  {
    String ProcName="getRequestHeaderNames";
    String spacer="  ";
    String retval="Header Names:  //request.getHeaderNames():\r\n";
    try
    {
      java.util.Enumeration E=request.getHeaderNames();
      while(E.hasMoreElements())
      {
        String key=(String)E.nextElement();
        String value=request.getHeader(key);
        String[] values=request.getParameterValues(key);
        retval=retval + spacer + key + "=" + value + "\r\n";
      }
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName,ProcName,e);
      return ProcName + ":ERROR" + e.getMessage();
    }
  }

  public static String getCSSFolderClass(Folder f, Folder activeFolder){
    try{
      if(f.equals(activeFolder)){
        return "sm_folders_item_active";
      }else{
        if(f.isSystemFolder()){
        	return "sm_folders_item";
        }else{
        	return "sm_myFolders_item";
        }
      }
    }catch(Exception e){
      log.error("getCssFolderClass", e);
      return "";
    }
  }

  public static String getFolderCountStartBracket(Folder f)
  {
    String ProcName="getFolderCountStartBracket";
    try
    {
      if(f.getId().equals(SystemFolderEnum.DRAFTS.getId()) || f.getId().equals(SystemFolderEnum.ESCALATED.getId()) || f.getId().equals(SystemFolderEnum.DELETED.getId()) || f.getId().equals(SystemFolderEnum.INBOX.getId()))
      {
        if(f.getId().equals(SystemFolderEnum.DRAFTS.getId()) || f.getId().equals(SystemFolderEnum.ESCALATED.getId()) || f.getId().equals(SystemFolderEnum.DELETED.getId()))
        {
          return "[";
        }
        else
        {
          return "(";
        }
      }
      else
      {
        return "";
      }
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getFolderCountEndBracket(Folder f)
  {
    String ProcName="getFolderCountEndBracket";
    try
    {
      if(f.getId().equals(SystemFolderEnum.DRAFTS.getId()) || f.getId().equals(SystemFolderEnum.ESCALATED.getId()) || f.getId().equals(SystemFolderEnum.INBOX.getId()) || f.getId().equals(SystemFolderEnum.DELETED.getId()) )
      {
        if(f.getId().equals(SystemFolderEnum.DRAFTS.getId()) || f.getId().equals(SystemFolderEnum.ESCALATED.getId()) || f.getId().equals(SystemFolderEnum.DELETED.getId()))
        {
          return "]";
        }
        else
        {
          return ")";
        }
      }
      else
      {
        return "";
      }
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getFolderCount(Folder f)
  {
    String ProcName="getFolderCount";
    try
    {
      if(f.getId().equals(SystemFolderEnum.DRAFTS.getId()) || f.getId().equals(SystemFolderEnum.ESCALATED.getId()) || f.getId().equals(SystemFolderEnum.INBOX.getId()) || f.getId().equals(SystemFolderEnum.DELETED.getId()))
      {
        if(f.getId().equals(SystemFolderEnum.DRAFTS.getId()) || f.getId().equals(SystemFolderEnum.ESCALATED.getId())|| f.getId().equals(SystemFolderEnum.DELETED.getId()))
        {
          return f.getCount() + "";
        }
        else
        {
          return f.getUnreadCount() + "";
        }
      }
      else
      {
        return "";
      }
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getFolderCountBracketed(Folder f)
  {
    String ProcName="getFolderCountBracketed";
    try
    {
      String cnt=getFolderCount(f);
      if(cnt == "")
      {
        return "";
      }
      return getFolderCountStartBracket(f) + cnt + getFolderCountEndBracket(f);
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static boolean isFolderActive(Folder f, Folder activeFolder)
  {
    String ProcName="isFolderActive";
    try
    {
      if(f.equals(activeFolder))
      {
        return true;
      }
      else
      {
        return false;
      }
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return false;
    }
  }

  public static String getFolderAnchorStart(Folder f, Folder activeFolder)
  {
    String ProcName="getFolderAnchorStart";
    try
    {
      String retval="";
      boolean isSystemFolder=f.isSystemFolder();
      if(isFolderActive(f, activeFolder))
      {
        return retval;
      }
      retval="<a href=\"" + getFolderAnchorHref(f, activeFolder) + "\" title=\"" + f.getName() + "\">";
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getFolderAnchorEnd(Folder f, Folder activeFolder)
  {
    String ProcName="getFolderAnchorEnd";
    try
    {
      String retval="";
      boolean isSystemFolder=f.isSystemFolder();
      if(isFolderActive(f, activeFolder))
      {
        return retval;
      }
      retval="</a>";
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getFolderAnchor(Folder f, Folder activeFolder)
  {
    String ProcName="getFolderAnchor";
    try
    {
      String retval;
      retval=getFolderAnchorStart(f, activeFolder) + f.getName() + getFolderAnchorEnd(f, activeFolder);
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getFolderAnchorHref(Folder f, Folder activeFolder)
  {
    String ProcName="getFolderAnchorHref";
    String retval="";
    try
    {
      User u;
      String prefix="?";
      UserTypeEnum UserType;
      retval="";
      String href="";
      boolean isSystemFolder=f.isSystemFolder();
      if(isFolderActive(f, activeFolder))
      {
        return retval;
      }
      if(!isSystemFolder)
      {
        return "#zzz#";
      }
      u=f.getOwner();
      if(u.getUserType().getDescription() == "Patient")
      {
        prefix="p";
      }
      else
      {
        if(u.getUserType().getDescription() == "Clinician")
        {
          prefix="c";
        }
        else
        {
          if(u.getUserType().getDescription() == "Administrator")
          {
            prefix="a";
          }
        }
      }
      href=prefix + f.getName() + ".action";
      return href;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getFolderAnchorAndCount(Folder f, Folder activeFolder)
  {
    String ProcName="getFolderAnchorAndCount";
    String retval="";
    try
    {
      retval=getFolderAnchor(f, activeFolder) + "<span class=\"sm_green\">" + getFolderCountBracketed(f) + "</span>";
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getAnchorFolderHTML(Folder f, Folder activeFolder)
  {
    String ProcName="getAnchorFolderHTML";
    String retval="";
    try
    {
      retval="<tr><td valign=\"middle\" align=\"left\" class=\"" + getCSSFolderClass(f, activeFolder) + "\">" + getFolderAnchorAndCount(f, activeFolder) + "</td></tr>";
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }

  public static String getAnchorFoldersHTML(List<Folder> folders, Folder activeFolder)
  {
	Locale.setDefault(Locale.ENGLISH);
    String ProcName="getAnchorFoldersHTML";
    String retval="";
    try
    {
      String filler="                                                                                ";
      retval=filler + "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" style=\"border:0px;text-align:left;\">\r\n";

      Collections.sort(folders,FOLDER_NAME_COMPARATOR);
      for(Folder f: folders)
      {
        retval=retval + filler + getAnchorFolderHTML(f, activeFolder) + "\r\n";
      }
      retval=retval + filler + "</table>\r\n";
      return retval;
    }
    catch(Exception e)
    {
      raiseError(UnitName, ProcName, e);
      return "";
    }
  }
  /*
   * FOLDER_NAME_COMPARATOR compare the user defined folder names and return the order. (Bug# 5922).
   */
  public static final Comparator<Folder> FOLDER_NAME_COMPARATOR = new Comparator<Folder>() {
		public int compare(Folder folder1, Folder folder2) {
			if(folder1 == null || folder2 == null) return 0;
			int result = folder1.getName().toUpperCase().compareTo(folder2.getName().toUpperCase());
			return result;
		}
	};

  public static String getSubmitFoldersHTML(List<Folder> folders, Folder activeFolder){

    String retval="";
    try{
      String filler="                                                                                ";
      retval=filler + "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" style=\"border:0px;text-align:left;\">\r\n";
      for(Folder f: folders){
        retval=retval + filler + getSubmitFolderHTML(f, activeFolder) + "\r\n";
      }
      retval=retval + filler + "</table>\r\n";
      return retval;
    }
    catch(Exception e){
      log.error("getSubmitFoldersHTML", e);
      return "";
    }
  }


  public static String getSubmitFolderHTML(Folder f, Folder activeFolder){

    String retval="";
    try{
      String folderCount=getFolderCountBracketed(f);
      boolean isActive=isFolderActive(f, activeFolder);
      retval="<tr><td title=\"" + f.getName() + "\" valign=\"middle\" align=\"left\" class=\"" + getCSSFolderClass(f, activeFolder) + "\">";
      if(isActive){
		retval=retval + "<input type=\"submit\" style=\"white-space: normal;\" title=\"" + f.getName() + "\" name=\"MBLeftNavSubmit\" value=\"" + f.getName() + "\" class=\"sm_folders_submit_active\">";
        if(folderCount != ""){
          retval=retval + "&nbsp;&nbsp;&nbsp;" + "<span id=\"folderCnt"+f.getName()+"\" class=\"sm_green\">" + folderCount + "</span>";
        }
        //6598
        if(f.getSubfolderList()!=null && f.getSubfolderList().size()>0) {
	        retval=retval + "<font size=\"2\">" +"<table align=\"right\"><tbody>";
	        for( SubFolder sub: reorderSubFoldersForDisplay(f,f.getSubfolderList()) ) {
	        	retval=retval + "<tr><td><input type=\"submit\" title=\"" + sub.getName() + "\" name=\"MBLeftNavSubmit\" value=\"" + sub.getName() + "\" class=\"sm_folders_submit_active\">&nbsp;<span title=\""+sub.getUnreadCount()+" Unread, "+sub.getCount()+" Total\">("+ sub.getUnreadCount() +"/" + sub.getCount() + ")</span></td></tr>";
	        }
	        retval=retval + "</tbody></table></font>";
	        retval=retval + "</td></tr>";
        }
        retval=retval + "</td></tr>";
      }else{
        retval=retval + "<input type=\"submit\" style=\"white-space: normal;\" title=\"" + f.getName() + "\" name=\"MBLeftNavSubmit\" value=\"" + f.getName() + "\" class=\"sm_folders_submit\">";
        if(folderCount != ""){
          retval=retval + "&nbsp;&nbsp;&nbsp;" + "<span id=\"folderCnt"+f.getName()+"\" class=\"sm_green\">" + folderCount + "</span>";
        }
        //6598
        if(f.getSubfolderList()!=null && f.getSubfolderList().size()>0) {
	        retval=retval + "<font size=\"2\">" +"<table align=\"right\"><tbody>";
	        for( SubFolder sub: reorderSubFoldersForDisplay(f,f.getSubfolderList()) ) {
	        	retval=retval + "<tr><td><input type=\"submit\" title=\"" + sub.getName() + "\" name=\"MBLeftNavSubmit\" value=\"" + sub.getName() + "\" class=\"sm_folders_submit\">&nbsp;<span title=\""+sub.getUnreadCount()+" Unread, "+sub.getCount()+" Total\">("+ sub.getUnreadCount() +"/" + sub.getCount() + ")</span></td></tr>";
	        }
	        retval=retval + "</tbody></table></font>";
	        retval=retval + "</td></tr>";
        }
      }
      return retval;
    }catch(Exception e){
      log.error("getSubmitFolderHTML", e);
      return "";
    }
  }

  private static List<SubFolder> reorderSubFoldersForDisplay(Folder f, List<SubFolder> list) {
	  List<SubFolder> newlist = new ArrayList<SubFolder>();
	  SubFolder sf= null;
	  if( f.getId().equals(SystemFolderEnum.INBOX.getId()) ) {
		  sf = extractSubFolder(MessageCategoryTypeEnum.APPOINTMENTS, list);
		  if( sf != null) newlist.add(sf);
		  sf = extractSubFolder(MessageCategoryTypeEnum.MEDICATIONS, list);
		  if( sf != null) newlist.add(sf);
		  sf = extractSubFolder(MessageCategoryTypeEnum.TEST_RESULTS, list);
		  if( sf != null) newlist.add(sf);
		  sf = extractSubFolder(MessageCategoryTypeEnum.OTHER, list);
		  if( sf != null) newlist.add(sf);
		  sf = extractSubFolder(MessageCategoryTypeEnum.EDUCATION, list);
		  if( sf != null) newlist.add(sf);
	  } else {
		  //No sort for this folder's subfolders
		  newlist=list;
	  }
	  return newlist;
  }

   private static SubFolder extractSubFolder(MessageCategoryTypeEnum type, List<SubFolder> list) {
	for( SubFolder sf: list) {
		if( sf.getId().equals(type.getId()) ) {
			return sf;
		}
	}
	return null;
}

public static String getMyFoldersHTML(List<Folder> folders, Folder activeFolder){
      String retval="";
      try{
        for(Folder f: folders){
          retval=retval + getMyFolderListHTML(f, activeFolder) + "</td></tr>\r\n";
        }
        return retval;
      }
      catch(Exception e){
        log.error("getMyFoldersHTML", e);
        return "";
      }
    }

    public static String getMyFolderListHTML(Folder f, Folder activeFolder){
      String retval="";
      try{
        String folderCount=f.getCount()+"";
  	    String unreadCount=f.getUnreadCount()+"";
        boolean isActive=isFolderActive(f, activeFolder);
        retval=retval +"<tr><td>"+ f.getName()+"&nbsp;(<a href=\"renameFolders.action?pwin=refolder&myFolderName=" + f.getName() + "\">rename</a>)</td><td>&nbsp;&nbsp;&nbsp;";
        if(folderCount != ""){
            retval=retval + folderCount ;
        }
        retval=retval + "</td><td>&nbsp;&nbsp;&nbsp;";
        if(unreadCount != ""){
          retval=retval + unreadCount ;
        }
        retval=retval + "</td><td valign=\"middle\" align=\"center\">";
  		retval=retval + "<a href=\"deleteFolders.action?pwin=delfolder&myFolderName=" + f.getName() + "\"><img src=\"images/deleteicon.jpg\" width=\"18\" height=\"18\" alt=\"Delete Folder\" border=\"0\" /></a></td>";
        return retval;
      }catch(Exception e){
        log.error("getMyFolderListHTML", e);
        return "";
      }
	}

    public static String getUserSSNLastFour(User user){
      String retval="";
      try{
		if(user==null){return retval;}
		retval=user.getNssn();
		retval=retval.substring(1,5);
        return retval;
      }catch(Exception e){
        log.error("getUserSSNLastFour", e);
        return retval;
      }
	}


    public static String getPatientLastFourSSN(HttpSession session, Long userId)
    {
    	String patientSignature="";
    	UserDao userDao;
    	WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(session.getServletContext());
    	userDao = (UserDao)ctx.getBean("userDao");
        Patient patient  = userDao.findPatientById(userId);
        if(patient!=null){
        	patientSignature=" <i>[ SSN: ";
        	if(patient.getNssn()!=null){
        		patientSignature = patientSignature+patient.getNssn().substring(1,5);
        	}

        	if(patient.getDob()!=null){
        		patientSignature = patientSignature+", DOB: "+DateUtils.getEnglishDate(patient.getDob());
        	}
        	patientSignature = patientSignature+" ]</i>";
        }
        userDao=null;
        patient=null;
        ctx=null;
        return patientSignature;
    }




    public static String getPatientSignature(HttpSession session,Long Id){
		java.lang.String ProcName="getPatientSignature";
		gov.va.med.mhv.sm.model.User u;
		gov.va.med.mhv.sm.model.User messageSender;
		String SSNLastFour="";
		String retval="";
		try{
			if(!isUserClinician(session)){return retval;}
			messageSender=(User)session.getAttribute("MESSAGE_SENDER");
			if(messageSender==null){return retval;}
			if(!messageSender.getId().equals(Id)){return retval;}
			//SSNLastFour=getUserSSNLastFour(messageSender);

			//if(SSNLastFour.equals("")){return retval;}
			//retval="&nbsp;<i>[&nbsp;SSN:&nbsp;"+SSNLastFour+"&nbsp;]</i>";
			retval = getPatientLastFourSSN(session,Id);
			return retval;
		}catch(Exception e){
			log.error("getUserSSNLastFour", e);
			return "";
		}
	}


}
