package gov.va.med.mhv.sm.web.utils;

import gov.va.med.mhv.foundation.util.ConfigurationManager;

import java.io.File;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesIrisHelper {
	
	private static final Log log = LogFactory.getLog(PropertiesIrisHelper.class);
	private static final String PROPERTIES_FILE_NAME = File.separator + "sm-iris.properties";
	private static Properties properties;

	static {
		//Initialize the sm-web.properties load into memory
		try {
			loadProperties();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private static void loadProperties() throws Exception {
		try {
			Properties props = ConfigurationManager.getConfiguration(PROPERTIES_FILE_NAME);
			if (props == null) {
				log.error("Could not load properties file: " + PROPERTIES_FILE_NAME);
			} else {
				properties = props;
			}
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}
	}

	public static Properties getProperties() {
		return properties;
	}
}
