package gov.va.med.mhv.sm.web.utils;

import gov.va.med.mhv.foundation.util.ConfigurationManager;

import java.io.File;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesHelper {
	private static final Log log = LogFactory.getLog(PropertiesHelper.class);
	private static final String PROPERTIES_FILE_NAME = File.separator + "sm-web.properties";
	private static Properties properties;

	static {
		//Initialize the sm-web.properties load into memory
		loadProperties();
	}
	
	private static void loadProperties() {
		Properties props = ConfigurationManager.getConfiguration(PROPERTIES_FILE_NAME);
		if (props == null) {
			if(log.isErrorEnabled()){
				log.error("Could not load properties file: " + PROPERTIES_FILE_NAME);
			}
		} else {
			properties = props;
		}
	}

	public static Properties getProperties() {
		return properties;
	}

}
