package gov.va.med.mhv.sm.web.utils;

import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.util.IntegrationUtils;

import java.sql.Timestamp;
import java.util.SortedSet;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;

public class MHVIntegrationUtil {

	private static final String INVALID_CHECKSUM = "Invalid checksum";

	private IntegrationUtils utils = null;
	
	public MHVIntegrationUtil(IntegrationUtils utils) {
		Precondition.assertNotNull("utils", utils);
		this.utils = utils;
	}
	
	public String isValid(HttpServletRequest request) {
		if (!hasValidCheckSum(request)) {
			return INVALID_CHECKSUM;
		}
		return null; 
	}
	
	private boolean hasValidCheckSum(HttpServletRequest request) {
		final String givenChecksum = request.getParameter("checksum");
		if (givenChecksum == null) {
			return false;
		}
		final String createdChecksum = utils.getChecksum(getChecksumInput(
			request));
		return givenChecksum.equals(createdChecksum);
	}
	
	public String createChecksum(Timestamp timestamp, String lastName, 
		String[] stations, String[] visns, Boolean national) 
	{
		StringBuilder result = new StringBuilder();
		result.append(timestamp);
		result.append(lastName);
		for(String s : stations) {
			result.append(s);
		}
		for(String s : visns) {
			result.append(s);
		}
		if (national != null) {
			result.append(national);
		}
		return utils.getChecksum(result.toString());
	}
	
	private static final String getChecksumInput(HttpServletRequest request) {
		Precondition.assertNotNull("request", request);
		StringBuilder result = new StringBuilder();
		result.append(request.getParameter("timestamp"));
		result.append(request.getParameter("lastName"));
		for(String s : getParameterValueSet(request, "station")) {
			result.append(s);
		}
		for(String s : getParameterValueSet(request, "visn")) {
			result.append(s);
		}
		String national = request.getParameter("national");
		if (national != null) {
			result.append(new Boolean(national));
		}
		return result.toString();
	}

	private static final SortedSet<String> getParameterValueSet(
		HttpServletRequest request, String paramName) 
	{
		assert request != null;
		SortedSet<String> result = new TreeSet<String>();
		String[] values = request.getParameterValues(paramName);
		if ( values != null ) {
			for(String val : values) {
				result.add(val);
			}
		}
		return result;
	}


}
