package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.sm.dto.SearchFormDTO;
import gov.va.med.mhv.sm.enumeration.MessagesOrderByEnum;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.enumeration.SortOrderEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.MailboxService;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class Sort extends AbstractInboxAction {
	
	private static final Log log = LogFactory.getLog(Sort.class);
	private HttpServletRequest request;
	private MailboxService mailboxService;

	private String STRUTS_RESULT;
	
	public Sort(){
		super();
	}
	
	public void setServletRequest(HttpServletRequest httpServletRequest){
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	public void prepare() throws Exception{
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(
				   ServletActionContext.getServletContext());
		mailboxService = (MailboxService)ctx.getBean("mailboxService");
		User u = (User)request.getSession().getAttribute(CURRENT_USER);
		STRUTS_RESULT = u.getUserType() == UserTypeEnum.PATIENT ? "PATIENT" : "CLINICIAN";
		
		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		messageFilterId = f.getFilter().getId();
		
	}

	public String execute(){
	  
	  MessagesOrderByEnum defaultColumn;
	  MessagesOrderByEnum column;
	  SortOrderEnum sort = SortOrderEnum.ASC;
	  
	  Folder currentFolder = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
	  boolean columnChange = false;
	  
	  if( currentFolder.getId() == SystemFolderEnum.DRAFTS.getId() ) {
		  defaultColumn = MessagesOrderByEnum.CREATED_DATE;
	  } else {
		  defaultColumn = MessagesOrderByEnum.DATE;
	  }
	  
      try {
    	  String y;
    	  y = request.getParameter("column");
    	  column = MessagesOrderByEnum.valueOf(Integer.parseInt(y));
      } catch (Exception e) {
    	  // there was an error default to something normal
    	  column = defaultColumn;
      }
      
      // If the field clicked is "Date" and is a draft folder then use CREATED_DATE
      if( column == MessagesOrderByEnum.DATE && currentFolder.getId() == SystemFolderEnum.DRAFTS.getId()) {
    	  column = MessagesOrderByEnum.CREATED_DATE;
      }
      
      
      // if nothing has changed then assume that they want to
      // reverse the sort       
      if(currentFolder.getOrderBy() == column){
    	  if(currentFolder.getSortOrder() == SortOrderEnum.ASC){
    		  sort = SortOrderEnum.DESC;
    	  }else{
    		  sort = SortOrderEnum.ASC;
    	  }
      }else{
    	columnChange = true;
    	// they have changed folders so we need to set the sort order
    	// to the default for that column.  ASC for everything but
    	// DATE which is DESC.
    	if(column == MessagesOrderByEnum.DATE || column == MessagesOrderByEnum.CREATED_DATE){
    		sort = SortOrderEnum.DESC;
  	  	}else{
  	  		sort = SortOrderEnum.ASC;
  	  	}    	
      }
      if(currentFolder.getName()==SystemFolderEnum.REASSIGN.getName()){
    	  if(request.getSession().getAttribute("SortOrder")!=null){
    		  if(request.getSession().getAttribute("SortOrder").equals("DESC")){
    			  sort = SortOrderEnum.DESC;
    		  }
    	  }
      }
      currentFolder.setSortOrder(sort);
      currentFolder.setOrderBy(column);
      log.debug("Fetching messages for folder: " + currentFolder.getName() + "  " + column + " " + sort);
      
      //If the user is currently in an active search we have to keep passing it to the service
      SearchFormDTO sf = (SearchFormDTO)request.getSession().getAttribute(SEARCH_FORM);
      
      // if the column changes then we need to go to the first page of the
      // pagination
      if(columnChange){
    	  mailboxService.getMessages(currentFolder, MessagesPageEnum.FIRST, sf);
      }else{
    	  mailboxService.getMessages(currentFolder, sf);
      }
      request.getSession().setAttribute("SortOrder",null);
      return STRUTS_RESULT;
	}
}
