package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dao.SignatureDao;
import gov.va.med.mhv.sm.dao.SurrogateDao;
import gov.va.med.mhv.sm.dao.TriageGroupDao;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.dao.properties.SMAttachmentProperties;
import gov.va.med.mhv.sm.dao.properties.SMWorkloadProperties;
import gov.va.med.mhv.sm.dto.CPRSMessageStatusDTO;
import gov.va.med.mhv.sm.enumeration.ClinicianStatusEnum;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Annotation;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Mailbox;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessageAttachment;
import gov.va.med.mhv.sm.model.NewMessage;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.Thread;
import gov.va.med.mhv.sm.model.TiuNotePreview;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.FacilityService;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.MessageService;
import gov.va.med.mhv.sm.service.PatientBlockedService;
import gov.va.med.mhv.sm.service.SendMessageService;
import gov.va.med.mhv.sm.service.TiuNoteService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.AttachmentUtils;
import gov.va.med.mhv.sm.util.UserUtils;
import gov.va.med.mhv.sm.web.form.CompleteReply;
import gov.va.med.mhv.sm.web.utils.PropertiesHelper;
import gov.va.med.mhv.sm.wsclient.IntegrationServiceDelegate;
import gov.va.med.mhv.sm.wsclient.queriessvc.UserLookupResponse;
import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.util.CPRSMessageUtils;


import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.hibernate.Hibernate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ReplyMsg extends AbstractInboxAction implements ServletResponseAware {


	private static final long serialVersionUID = 1534826588015302782L;

	private static final Log log = LogFactory.getLog(ReplyMsg.class);

	private static int EXPIRATION_PERIOD_IN_DAYS = -120;
	private static final String SM_WEB_PATIENT_REPLY_EXP_PARAM = "sm.web.patient.reply.expiration";

	private HttpServletRequest request;
	private SendMessageService sendMessageService;
	private MessageService messageService;
	private TiuNoteService tiuNoteService;
    private UserManagementService userService;
    private TriageGroupService triageGroupService;
    private MailboxService mailboxService;
    private PatientBlockedService patientBlockedService;
    private SignatureDao signatureDao;
    private SurrogateDao surrogateDao;
	private String DEFAULT_SM_CLINIC = "SECURE MESSAGING";
	private String DEFAULT_CPRS_NOTE_TITLE = "SECURE MESSAGING";


    private String STRUTS_RESULT;
    private String STRUTS_RESULT_SENT="_SENT";
    private String STRUTS_RESULT_DRAFT="_DRAFT";
    private String STRUTS_RESULT_CANCEL;
    private String STRUTS_RESULT_INPUT;
    private String STRUTS_RESULT_LOGOUT;
    private static final String PATIENT_READ_MESSAGE = "PATIENT_READ_MESSAGE";
    private static final String CLINICIAN_READ_MESSAGE = "CLINICIAN_READ_MESSAGE";
    private static final String CURRENT_READ_MESSAGE = "sessionMessage";
    

    // Struts properties filled from form
    // or instantiated upon start of reply
    private User user;
    private String recipient;
    private String sender;
    private String body;
    private NewMessage newMessage;
    private Message currentMessage;
    private String surrogate;
    private String surrogateArray;
    private String messageId;
    private String smSend;
    private String smCancel;
    private String smReplySaveDraft;
    private String smSaveDraftAndLogout;
    private String cancelButton;
    private TriageGroupDao triageGroupDao;
    private UserDao userDao;

    private CompleteReply completeReply;
    private HttpServletResponse httpResponse;
    private String autoSaveDraft;
    private String pwin;
    private String attachCancel;
    private File upload;
    private String uploadContentType;
    private String uploadFileName;
    private static final String SM_PATIENT_ATTACHMENT_ALLOWED_SWITCH = "sm.web.patient.attachment.allowed.switch";
    private static final String SM_WEB_PATIENT_ATTACHMENT_TESTING_STATUS ="sm.web.patient.attachment.testing.status";
    private static final String SM_WEB_PATIENT_ATTACHMENT_TESTING_USERS ="sm.web.patient.attachment.testing.users";
    private static final String SM_WEB_REPLY_AUTO_SAVE_SWITCH = "sm.web.reply.autosave.switch";

    private static String patientAttachmentSwichStatus=null;
    private static String replyAutoSaveSwitch="off";

	private String reminder;
	private Date reminderDate;
	private String removeReplyAttachment;
	private String surrogateEnabled;
	private SMWorkloadProperties workloadProperties;
	private static String patientAttchmentTestingStatus=null;
    private static String patientAllowedToAttachFile;
    private SMAttachmentProperties smAttachments;
	private Long totalAttachedSize;
    private String allowedCount;
    private Long removeId;
	private Collection<CPRSMessageStatusDTO> cprsMessageStatus;

	public static final String REPLY_ATTACHMENTS = "replyAttachments";
	public static final String REPLY_ATTACHMENTS_SIZE="replyAttachmentsSize";



	static {
    	//initialize with the sm-web.properties if it exists
    	if(PropertiesHelper.getProperties().containsKey(SM_WEB_PATIENT_REPLY_EXP_PARAM))
    	{
    		String expStr = PropertiesHelper.getProperties().getProperty(SM_WEB_PATIENT_REPLY_EXP_PARAM);
			try {
				int expInt = Integer.parseInt(expStr);
				if( expInt < 0 ) {
					EXPIRATION_PERIOD_IN_DAYS = expInt;
				}
			} catch (NumberFormatException e) {
				if(log.isWarnEnabled()){
					log.warn("Using default value; Unable to parse this property from sm-web.properties: " + SM_WEB_PATIENT_REPLY_EXP_PARAM );
				}
				//do nothing
			}

    	}

    	if(log.isInfoEnabled()){
    		log.info("Using the following value for reply message expiration: " + EXPIRATION_PERIOD_IN_DAYS + " days");
    	}

    	if(PropertiesHelper.getProperties().containsKey(SM_PATIENT_ATTACHMENT_ALLOWED_SWITCH)) {

    		patientAttachmentSwichStatus = PropertiesHelper.getProperties().getProperty(SM_PATIENT_ATTACHMENT_ALLOWED_SWITCH).toLowerCase();
    	}

    	if(PropertiesHelper.getProperties().containsKey(SM_WEB_REPLY_AUTO_SAVE_SWITCH)) {

    		replyAutoSaveSwitch = PropertiesHelper.getProperties().getProperty(SM_WEB_REPLY_AUTO_SAVE_SWITCH).toLowerCase();
    	}
    }


    public ReplyMsg(){
    	super();
    }

	public void setServletRequest(HttpServletRequest httpServletRequest) {
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	public void setServletResponse(HttpServletResponse httpServletResponse) {
		//Used only for the AJAX call for auto-save-draft
		this.httpResponse = httpServletResponse;
	}

	 public String getPatientAllowedToAttachFile() {
			return patientAllowedToAttachFile;
	 }

	 public void setPatientAllowedToAttachFile(String patientAllowedToAttachFile) {
			this.patientAllowedToAttachFile = patientAllowedToAttachFile;
	 }

	@SuppressWarnings("unchecked")
	public void prepare() throws Exception {
		super.prepare();



		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		sendMessageService = (SendMessageService) ctx.getBean("sendMessageService");
		messageService = (MessageService) ctx.getBean("messageService");
		tiuNoteService = (TiuNoteService) ctx.getBean("tiuNoteService");
		mailboxService = (MailboxService)ctx.getBean("mailboxService");
		userService = (UserManagementService) ctx.getBean("userManagementService");
		patientBlockedService = (PatientBlockedService) ctx.getBean("patientBlockedService");
		triageGroupService = (TriageGroupService) ctx.getBean("triageGroupService");
		triageGroupDao = (TriageGroupDao)ctx.getBean("triageGroupDao");
		userDao = (UserDao)ctx.getBean("userDao");
		signatureDao = (SignatureDao)ctx.getBean("signatureDao");
		surrogateDao = (SurrogateDao)ctx.getBean("surrogateDao");
		user = (User)request.getSession().getAttribute(CURRENT_USER);
		workloadProperties = ((SMWorkloadProperties)ctx.getBean("smWorkloadProperties"));
		smAttachments = ((SMAttachmentProperties)ctx.getBean("smAttachmentProperties"));
		allowedCount=smAttachments.getAttachmentAllowedCount();

		if(request.getParameter("messageId")!=null){

			ServiceResponse<Message> rsp = messageService.fetchMessage(new Long(request.getParameter("messageId")));
			Message currentMessage  = rsp.getPayload();
			request.getSession().setAttribute(CURRENT_MESSAGE,currentMessage);
		}

		currentMessage = (Message)request.getSession().getAttribute(CURRENT_MESSAGE);

		surrogate = "";
		if(currentMessage.getAssignedTo() != null){
			Surrogate currentSurrogate = surrogateDao.getCurrentSurrogateFor(currentMessage.getAssignedTo());
			if(currentSurrogate!=null){
				if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN))
				{
					Clinician clinician = (Clinician)userService.fetchClinician(currentSurrogate.getSurrogateId()).getPayload();
					surrogate = "Surrogate Enabled: " + clinician.getName();
				}else if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)){
					TriageGroup tg = triageGroupDao.findById(currentSurrogate.getSurrogateId());
					surrogate = "Surrogate Enabled: " + tg.getName();
				}
			}
		}

		// create the surrogate array
		if(currentMessage.getThread().getMailGroup() == null){
			surrogateArray = "[];";
		}else{

			surrogateArray = "var surrogateArray = [";

			Message m = currentMessage;

			Iterator<Clinician> ic = m.getThread().getMailGroup().getClinicians().iterator();
			while(ic.hasNext()){

				Clinician nc = ic.next();
				Surrogate currentSurrogate = surrogateDao.getCurrentSurrogateFor(nc);
				if(currentSurrogate!=null){
					if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN))
					{
						Clinician clinician = (Clinician)userService.fetchClinician(currentSurrogate.getSurrogateId()).getPayload();
						surrogateArray += "'Surrogate Enabled: " + clinician.getName()+ "'";
					}else if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)){
						TriageGroup tg = triageGroupDao.findById(currentSurrogate.getSurrogateId());
						surrogateArray += "'Surrogate Enabled: " + tg.getName()+ "'";
					}
				}
				else{
					surrogateArray +="''";
				}
				if(ic.hasNext()) surrogateArray += ",";
			}
			surrogateArray += ",''];";

		}

		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		messageFilterId = f.getFilter().getId();



		STRUTS_RESULT = user.getUserType() == UserTypeEnum.PATIENT ? "PATIENT" : "CLINICIAN";
		STRUTS_RESULT_CANCEL = STRUTS_RESULT + "_CANCEL";
		STRUTS_RESULT_INPUT = STRUTS_RESULT + "_INPUT";
		STRUTS_RESULT_LOGOUT = "LOGOUT";
		if(PropertiesHelper.getProperties().containsKey(SM_WEB_PATIENT_ATTACHMENT_TESTING_STATUS)) {
    		patientAttchmentTestingStatus = PropertiesHelper.getProperties().getProperty(SM_WEB_PATIENT_ATTACHMENT_TESTING_STATUS);
    		if(patientAttchmentTestingStatus!=null && patientAttchmentTestingStatus.equalsIgnoreCase("National")){
    			patientAllowedToAttachFile="YES";
    		}else if(patientAttchmentTestingStatus!=null && patientAttchmentTestingStatus.equalsIgnoreCase("Field")){
    				if(PropertiesHelper.getProperties().containsKey(SM_WEB_PATIENT_ATTACHMENT_TESTING_USERS)) {
    					setPatientAllowedToAttachFile(isFieldTestingUser(PropertiesHelper.getProperties().getProperty(SM_WEB_PATIENT_ATTACHMENT_TESTING_USERS)));
    				}
    		}
    	}

	}


	/**
	 * Called when the user click the "Reply" button.
	 * Used to initialize data for the form prior to
	 * submission
	 * @return
	 */
	@SkipValidation
	public String replyForm(){
		setupBean();
		signatureForReply();

		//ADD CR 6200
		if( user.getUserType() == UserTypeEnum.PATIENT && isMessageExpired(currentMessage) ) {
			//addFieldError("newMessage.body", "This message has expired.  Please create a new message to continue.");
			addActionError("This message has expired.  Please create a new message to continue.");
			return PATIENT_READ_MESSAGE;
		}

		if(user.getUserType()==UserTypeEnum.PATIENT){
			if(checkPatientBlockedFromFacility(currentMessage.getThread().getMailGroup().getId(), user.getId()) ||
			checkPatientBlockedFromTG(currentMessage.getThread().getMailGroup().getId(), user.getId())){
				addActionError("Your access to this Triage Group has been restricted.  You cannot send messages to this Triage Group.  If you think your access was restricted by mistake, contact your My Health<b><i>e</i></b>Vet Coordinator at your local VA Medical Center.");
				return PATIENT_READ_MESSAGE;
			}
		}
		if(user.getUserType()==UserTypeEnum.CLINICIAN){
			if(checkPatientBlockedFromFacility(currentMessage.getThread().getMailGroup().getId(),currentMessage.getSenderId()) ||
			checkPatientBlockedFromTG(currentMessage.getThread().getMailGroup().getId(),currentMessage.getSenderId())){
				String errorMsg="The patient is restricted from this Triage Group. Contact your My Health<b><i>e</i></b>Vet Coordinator if you have any questions.";
				addActionError(errorMsg);
				return CLINICIAN_READ_MESSAGE;
			}
			else{
				if(currentMessage.getSenderType()==(ParticipantTypeEnum.PATIENT)){
					Patient patient = userDao.findPatientById(currentMessage.getSenderId());
					if(patient.getStatus().equals(UserStatusEnum.BLOCKED)){
						addActionError("The patient is restricted from this Triage Group. Contact your My Health<b><i>e</i></b>Vet Coordinator if you have any questions.");
						return CLINICIAN_READ_MESSAGE;
					}
				}
			}
		}

		/*if(request.getSession().getAttribute(DRAFT_MSG_ID)==null){
			request.getSession().setAttribute(DRAFT_MSG_ID,0L);
		}*/

		return STRUTS_RESULT;
	}

	private void signatureForReply(){

		if(newMessage.getBody()==null){
			newMessage.setBody(UserUtils.getUserSignature(user.getId(),signatureDao));
		}else{
			newMessage.setBody(newMessage.getBody());
		}
	}

	public String replySubmit(){
		
		// if the "Attach File" window is up
		// do not send the message and don't validate. Just continue.
		if(pwin != null && pwin.trim().length() > 0){
			setupBean();
			return STRUTS_RESULT_INPUT;
		}

		// Was the cancel button pushed?
		if(smCancel != null){
			currentMessage.setCcRecipientId(null);
			currentMessage.setCcRecipientName(null);
			newMessage.setCc(null);
			if(null!=getSession().getAttribute(REPLY_ATTACHMENTS)){
				try
				{
					Map<Long,String> attachmentsMap = (Map)getSession().getAttribute(REPLY_ATTACHMENTS);
					for(Map.Entry<Long,String> mapEntry : attachmentsMap.entrySet()){
						if(mapEntry.getKey()!=null)messageService.removeAttachment(mapEntry.getKey());
					}
					attachmentsMap=null;
				}catch(Exception removeException){
				}
				getSession().removeAttribute(REPLY_ATTACHMENTS_SIZE);
				getSession().removeAttribute(REPLY_ATTACHMENTS);
			}
			setCprsMessageStatus(CPRSMessageUtils.getCPRSMessageStatus(tiuNoteService.getProgressNotesStatusByThreadId(currentMessage.getThread().getId())));
			return STRUTS_RESULT_CANCEL;
		}

		// Do we have a message to send
		if(StringUtils.isBlank(newMessage.getBody())){
			//addFieldError("newMessage.body", "The message cannot be blank.");
			if(!smSaveDraftAndLogout.equals("CANCEL")){
				addActionError("The message cannot be blank.");
				setupBean();
				return STRUTS_RESULT_INPUT;
			}
		}

		/*
		 * Save as Draft for reply message
		 */
		if(smReplySaveDraft !=null){
			return saveAsDraft();
		}
		if(smSaveDraftAndLogout!=null){
			if(smSaveDraftAndLogout.equals("DRAFT")){
				return saveDraftAndLogout();
			}else if(smSaveDraftAndLogout.equals("CANCEL")){
				return STRUTS_RESULT_LOGOUT;
			}
		}

		setupBean();

		String errorMsg = "You can no longer send messages to this Secure Messaging Triage Group.  Please contact the My Health<b><i>e</i></b>Vet Coordinator at your local VA Medical Center to see if this Triage Group is currently participating in Secure Messaging, and if you are enrolled in the Triage Group.";
		if(user.getUserType() == UserTypeEnum.PATIENT){
			if(!currentMessage.getThread().getMailGroup().isActive()){
				addActionError(errorMsg);
				return STRUTS_RESULT_INPUT;
			}
			else
			{	//The following block of code is implemented for Bug# 5330 (see notes).
				//If the Patient unassociate with the triage group, they cannot reply the messages related to the triagegroup.

				boolean userTriageGroupFlag = false;
				for(TriageGroup triageGroup : triageGroupDao.getTriageGroupsForPatient(userDao.findPatientById(user.getId()))){
					if(triageGroup.getId().equals(currentMessage.getThread().getMailGroup().getId())){
						userTriageGroupFlag = true;
						break;
					}
				}
				if(!userTriageGroupFlag){
					addActionError(errorMsg);
					return STRUTS_RESULT_INPUT;
				}
			}

			if(checkPatientBlockedFromFacility(currentMessage.getThread().getMailGroup().getId(),user.getId()) ||
				checkPatientBlockedFromTG(currentMessage.getThread().getMailGroup().getId(),user.getId())){
				addActionError(errorMsg);
				return STRUTS_RESULT_INPUT;
			}
		}

		if(user.getUserType() == UserTypeEnum.CLINICIAN){
			if(checkPatientBlockedFromFacility(currentMessage.getThread().getMailGroup().getId(),currentMessage.getSenderId()) ||
				checkPatientBlockedFromTG(currentMessage.getThread().getMailGroup().getId(),currentMessage.getSenderId())){
			//if(checkPatientBlockedFromTG(currentMessage.getThread().getMailGroup().getId(),currentMessage.getSenderId())){
				errorMsg="The patient is restricted from this Triage Group. Contact your My Health<b><i>e</i></b>Vet Coordinator if you have any questions.";
				addActionError(errorMsg);
				return STRUTS_RESULT_INPUT;
			}
		}


		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);


		if(!f.getId().equals(SystemFolderEnum.SENT.getId())){
			if(completeReply == null) completeReply = new CompleteReply();
			if(currentMessage.getAssignedTo() == null)
			{
				completeReply.setAssignedState(CompleteReply.UNASSIGNED);
			}else if(currentMessage.getAssignedTo().equals(user))
			{
				completeReply.setAssignedState(CompleteReply.ASSIGNED_SELF);
			}else
			{
				completeReply.setAssignedState(CompleteReply.ASSIGNED_OTHER);
			}
			if(log.isInfoEnabled()){
				log.info("completeReply.getReplyMessageId......."+completeReply.getReplyMessageId());
			}
		}


		ServiceResponse<Message> result = null;
		Long draftId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);

		if(f.getId().equals(SystemFolderEnum.SENT.getId())){


			if(getSession().getAttribute(REPLY_ATTACHMENTS)!=null){
    			newMessage.setAttachments((Map)getSession().getAttribute(REPLY_ATTACHMENTS));
    		}
			result = sendMessageService.replyFromSentFolder(currentMessage, newMessage);
			
			return STRUTS_RESULT+STRUTS_RESULT_SENT;
	    }
		if(f.getId().equals(SystemFolderEnum.DRAFTS.getId()) || draftId != 0L){
			Long ccRecipientId = ((Message)getSession().getAttribute(CURRENT_MESSAGE))!=null?((Message)getSession().getAttribute(CURRENT_MESSAGE)).getCcRecipientId():null;
			if(ccRecipientId!=null){
				User ccProvider = userService.findById(ccRecipientId);
				newMessage.setCc(ccProvider);
			}
			
			if(getSession().getAttribute(REPLY_ATTACHMENTS)!=null){
    			newMessage.setAttachments((Map)getSession().getAttribute(REPLY_ATTACHMENTS));
    		}
			
			result = sendMessageService.sendReplyDraft(currentMessage, newMessage);

			if(getCurrentUser().getUserType().equals(UserTypeEnum.PATIENT)){
				return STRUTS_RESULT+STRUTS_RESULT_DRAFT;
			}
			//Set the currentmessage from result because it is created in this service call
			currentMessage  = result.getPayload();
			
		
			if(user.getUserType() == UserTypeEnum.CLINICIAN){
				currentMessage.setAssignedTo((Clinician)user);
			}
			request.getSession().setAttribute(CURRENT_MESSAGE,currentMessage);
			if(completeReply!=null){
				completeReply.setReplyMessageId(result.getPayload().getId());
			}
            recipient = currentMessage.getRecipientName();
            sender = currentMessage.getSenderName();
		}
	    else
	    {
	    	if(!f.getId().equals(SystemFolderEnum.SENT.getId()))
	    	{
	    		if(getSession().getAttribute(REPLY_ATTACHMENTS)!=null){
	    			newMessage.setAttachments((Map)getSession().getAttribute(REPLY_ATTACHMENTS));
	    		}

	    		if(currentMessage.getCcRecipientId()!=null){
	    			User ccUser = userDao.findById(currentMessage.getCcRecipientId());
	    			newMessage.setCc(ccUser);
	    		}
	    		result = sendMessageService.reply(currentMessage, newMessage);
	    		completeReply.setReplyMessageId(result.getPayload().getId());
	    	}
	    }

		handleMessages(result);

		if ( user.getUserType() == UserTypeEnum.PATIENT ) {

			if(f.getId().equals(SystemFolderEnum.DRAFTS.getId())){
				// Decrease 1 to the draft message count
				Mailbox mailbox = user.getMailbox();
				Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
				drafts.setCount(drafts.getCount() - 1);
				mailboxService.getMessages(f);
			}
			return STRUTS_RESULT;
		}
		else{
			if(f.getId().equals(SystemFolderEnum.DRAFTS.getId())){
				// Decrease 1 to the draft message count
				Mailbox mailbox = user.getMailbox();
				Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
				drafts.setCount(drafts.getCount() - 1);
				mailboxService.getMessages(f);
				//if( completeReply != null && completeReply.getAssignedState() != CompleteReply.UNASSIGNED )
					//STRUTS_RESULT = "CLINICIAN_AFTER_REPLYDRAFT";
				//return STRUTS_RESULT;
			}

		}
		if(log.isInfoEnabled()){
			log.info("is Message Assigned before fetchMessage" + currentMessage.getAssignedTo());
		}

		currentMessage = messageService.fetchMessage(currentMessage.getId()).getPayload();
		if(log.isInfoEnabled()){
			log.info("message now assigned to: " + currentMessage.getAssignedTo());
		}
		if(!f.getId().equals(SystemFolderEnum.SENT.getId()))
		{
			if( currentMessage.getAssignedTo()!=null ) {
				completeReply.setClinicianId(currentMessage.getAssignedTo().getId());
				completeReply.setCompleteable(currentMessage.getAssignedTo().equals(user));
			}
			if(currentMessage.getThread().getMailGroup() != null)
			{
				completeReply.setClinicians(currentMessage.getThread().getMailGroup().getClinicians());

			}else
			{
				completeReply.setClinicians(new ArrayList<Clinician>());
			}
		}


		 // Implemented the following logic for Bug# 5990, when the clinician reply the message from SENT folder, it should not open the assign box.
		 if(f.getId().equals(SystemFolderEnum.SENT.getId())){
			 STRUTS_RESULT = "CLINICIAN_REPLY_ONLY";
		 }
        
		return STRUTS_RESULT;

	}

	private void setupBean(){

		if(newMessage == null) newMessage = new NewMessage();
		newMessage.setFrom(user);
		newMessage.setMessageCategoryTypeId(currentMessage.getThread().getMessageCategoryType().getId());
		newMessage.setSubject(currentMessage.getThread().getSubject());
		newMessage.setTriageGroup(currentMessage.getThread().getMailGroup());
		messageId = currentMessage.getThread().getId().toString();

		setupRecipientAndSender();

		//6598
		setMessageCategoryTypeId(currentMessage.getThread().getMessageCategoryType().getId());
		setCprsMessageStatus(CPRSMessageUtils.getCPRSMessageStatus(tiuNoteService.getProgressNotesStatusByThreadId(currentMessage.getThread().getId())));

	}

	private void setupRecipientAndSender() {
		Folder folder = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);

		if(user.getUserType() == UserTypeEnum.PATIENT){
			sender = user.getName();
			recipient = currentMessage.getSenderName() + " (" + currentMessage.getThread().getMailGroup().getName() + ")";

			if(folder.getId().equals(SystemFolderEnum.SENT.getId())){
				recipient = currentMessage.getThread().getMailGroup().getName();
			}else{
				if(request.getSession().getAttribute(DRAFT_MSG_ID)!=null){
					Long draftId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);
					if(draftId != 0L){
						recipient = currentMessage.getRecipientName();
					}
				}
			}
		}else{
			sender = user.getName();
			if(currentMessage.getThread().getMailGroup() != null){
				sender += " (" + currentMessage.getThread().getMailGroup().getName() + ")";
			}
			if(folder.getId().equals(SystemFolderEnum.SENT.getId()))
			{
				recipient = currentMessage.getRecipientName();
			}
			else
			{
				if(currentMessage.getSentDate()!=null)
					recipient = currentMessage.getSenderName();
				else
					recipient = currentMessage.getRecipientName();
			}
		}
	}

	public String editReplyDraft(){
		Long messageId = Long.valueOf(request.getParameter("messageId"));

		// Get the details of the message
		ServiceResponse<Message> response = messageService.fetchMessage(messageId);
		Message message = response.getPayload();
		List<Message> prevThreadMessages = getThreadMessages(message);
		request.getSession().setAttribute(CURRENT_MESSAGE, message);
		request.getSession().setAttribute(PREVIOUS_MESSAGES, prevThreadMessages);

		setupBean(message);

		return STRUTS_RESULT;
	}

	private void setupBean(Message message) {

		if(newMessage ==null) newMessage = new NewMessage();
        newMessage.setFrom(user);
        newMessage.setMessageCategoryTypeId(currentMessage.getThread().getMessageCategoryType().getId());
        newMessage.setSubject(currentMessage.getThread().getSubject());
        newMessage.setTriageGroup(currentMessage.getThread().getMailGroup());
        newMessage.setBody(currentMessage.getBody());
        messageId = ""+currentMessage.getId();
        //Folder folder = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);

        if(user.getUserType() == UserTypeEnum.PATIENT){
			sender = user.getName();
			recipient = currentMessage.getThread().getMailGroup().getName();
        }
        else
        {
        	sender = user.getName();
			recipient = currentMessage.getRecipientName();
			setCprsMessageStatus(CPRSMessageUtils.getCPRSMessageStatus(tiuNoteService.getProgressNotesStatusByThreadId(message.getThread().getId())));
        }
	}

	private boolean checkPatientBlockedFromTG(Long triageGroupId,Long patientId){
		PatientBlockedTriageGroup patBlockedTg = patientBlockedService.getPatientBlockedTriageGroupByTgIdAndPatientId(triageGroupId, patientId).getPayload();
		if(patBlockedTg!=null && patBlockedTg.isBlocked()){
			if(log.isInfoEnabled()){
				log.info("REPLY MESSAGE-> Patient " + patientId + " blocked from Triage Group "+patBlockedTg.getTriageGroupId());
			}
			return true;
		}
		return false;
	}

	private boolean checkPatientBlockedFromFacility(Long triageGroupId, Long patientId){
		ServiceResponse<TriageGroup> triageResp = triageGroupService.findTriageGroupById(triageGroupId);
		TriageGroup tGroup = triageResp.getPayload();
		if(tGroup!=null) {
			Long stationNumber = Long.valueOf(tGroup.getVistaDiv()).longValue();

			//Also check if the facility of the triage group is blocked -
			CollectionServiceResponse<PatientBlockedFacility> collectionResponse = patientBlockedService.getBlockedFacilityPatientsByPatientIdAndStation(patientId, stationNumber);
			Collection<PatientBlockedFacility> patBlockedFacilities = collectionResponse.getCollection();
			if(patBlockedFacilities!=null && patBlockedFacilities.size()>0){
				if(log.isInfoEnabled()){
					log.info("REPLY MESSAGE-> Patient " + patientId + " blocked from Facility "+ stationNumber);
				}
				return true;
			}
		}
		return false;
	}

	/*
	 * Private method to retrieve previous thread messages associated with the message
	 */
	private List<Message> getThreadMessages(Message message) {
		List<Message> result = new ArrayList<Message>();
		Thread thread = message.getThread();
		if (thread != null) {
			for (Message msg : thread.getMessages()) {
				if(msg.getSentDate() !=null)
						result.add(msg);
				}
			Collections.sort(result, new Comparator<Message>() {
				public int compare(Message msg1, Message msg2) {
					if (msg1 == null)
						return 1;
					else if (msg2 == null)
						return -1;
					else {
						Date date1 = msg1.getSentDate();
						Date date2 = msg2.getSentDate();
						if (date2.after(date1))
							return 1;
						else if (date2.before(date1))
							return -1;
						else
							return 0;
					}
				}
			});
		}
		return result;
	}

	private String saveDraftAndLogout(){
		try{
		currentMessage = (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
		ServiceResponse<Message> response = null;
		if(newMessage == null) newMessage = new NewMessage();
		newMessage.setFrom(user);
		newMessage.setMessageCategoryTypeId(currentMessage.getThread().getMessageCategoryType().getId());
        newMessage.setSubject(currentMessage.getThread().getSubject());
        newMessage.setTriageGroup(currentMessage.getThread().getMailGroup());
        response = sendMessageService.saveReplyDraft(currentMessage,newMessage);
		}catch(Exception e){
			if(log.isErrorEnabled()){
				log.error("Reply Save Draft and Logout - Error occured for user->"+user.getId()+"^Error:"+e);
			}
		}
		return STRUTS_RESULT_LOGOUT;
	}

	public void autoSaveDraft(){
		/**
		 * If(1st draft attempt)
		 * Auto save creates a new message and creates a replydraft.
		 * Switch current message to the newly created message.
		 * (In case they hit send, saveAsDraft)
		 *
		 * If(after first attempt)
		 * We already are editing a draft so just save it as a normal draft message.
		 * (As if someone opened a replyDraft message and hit saveasdraft)
		 *
		 */
		ServiceResponse<Message> response;

		if(newMessage == null) newMessage = new NewMessage();

		//If user opens a draft message the form sends the content as 'body'.
		if(newMessage.getBody() == null) newMessage.setBody(body);

		currentMessage = (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
		User u = (User)request.getSession().getAttribute(CURRENT_USER);
		newMessage.setFrom(u);
		newMessage.setMessageCategoryTypeId(currentMessage.getThread().getMessageCategoryType().getId());
        newMessage.setSubject(currentMessage.getThread().getSubject());
        newMessage.setTriageGroup(currentMessage.getThread().getMailGroup());
        
        if(getSession().getAttribute(REPLY_ATTACHMENTS)!=null){
			newMessage.setAttachments((Map)getSession().getAttribute(REPLY_ATTACHMENTS));
		}
        response = sendMessageService.saveReplyDraftForWeb(currentMessage, newMessage,getCurrentFolder());
        Message responseMessage = response.getPayload();

        ///Handle Errors?
		int count = 0;
		Long draftId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);

		if(draftId == null || draftId == 0L){
			//First time doing autosavedraft increment the folder count
			Mailbox mailbox = u.getMailbox();
			Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
			drafts.setCount(drafts.getCount() + 1);
			count = drafts.getCount();
		} else {
			Mailbox mailbox = u.getMailbox();
			Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
			count = drafts.getCount();
		}

		//force a response of just a simple JSON String with DRAFT_MSG_ID and Folder 'drafts' count.
		String responseTxt = "{draftFolderCnt:"+count+"}";
		try {
			httpResponse.getWriter().write(responseTxt);
		} catch (IOException e) {
			if(log.isWarnEnabled()){
				log.warn("Unable to write autosave result back to client");
			}
		}

		/**
		 * We make sure that the current message is the "new draft" with the same Id, etc.
		 */
		request.getSession().setAttribute(DRAFT_MSG_ID, currentMessage.getId());

		//Check if the currentmessage is not a draft already and a draft was created.
        if(responseMessage!=null && responseMessage.getId() != currentMessage.getId()){
        	//This forces the thread to get loaded since it is lazy load.
        	Iterator<Clinician> ic = responseMessage.getThread().getMailGroup().getClinicians().iterator();
			while(ic.hasNext()){
				ic.next();
			}

			if(currentMessage!=null && currentMessage.getCcRecipientId()!=null && responseMessage!=null){
				responseMessage.setCcRecipientId(currentMessage.getCcRecipientId());
				responseMessage.setCcRecipientName(currentMessage.getCcRecipientName());
			}
			request.getSession().setAttribute("oldMessage", currentMessage);
			request.getSession().setAttribute(CURRENT_MESSAGE,responseMessage);
        }
	}


	/*
	 * This method is called from replySubmit method and is called when the user
	 * clicks on SAVE AS DRAFT button in the reply window
	 */
	private String saveAsDraft(){
		currentMessage = (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
		ServiceResponse<Message> response = null;

		if(newMessage == null) newMessage = new NewMessage();
		newMessage.setFrom(user);
		newMessage.setMessageCategoryTypeId(currentMessage.getThread().getMessageCategoryType().getId());
        newMessage.setSubject(currentMessage.getThread().getSubject());
        newMessage.setTriageGroup(currentMessage.getThread().getMailGroup());

        //response = sendMessageService.saveReplyDraft(currentMessage,newMessage);
        response = sendMessageService.saveReplyDraftForWeb(currentMessage,newMessage,getCurrentFolder());


		if(handleMessages(response)){
			return STRUTS_RESULT_INPUT;
		}

		User u = (User)request.getSession().getAttribute(CURRENT_USER);

		if(((Message)response.getPayload()).getId() != currentMessage.getId()){
		// Adding 1 to the draft message count
		Mailbox mailbox = u.getMailbox();
		Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
		drafts.setCount(drafts.getCount() + 1);
		}
		// if we are currently in the drafts folder then we need to refresh it



		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		if(f.getId() == SystemFolderEnum.DRAFTS.getId()){
			mailboxService.getMessages(f);
		}


		if(u.getParticipantType() == ParticipantTypeEnum.CLINICIAN)
				STRUTS_RESULT = "CLINICIAN_AFTER_REPLYDRAFT";

		return STRUTS_RESULT;
	}

	public String completeReplySubmit(){
		//if user hits cancel on the finish options page for reply message return.
		if ( getCancelButton() != null ) {
			//Check if current folder is draft -
			//if draft folder - goto REFRESHINBOX
			//else - CLINICIAN_CANCEL
	        if(getCurrentFolder().getId().equals(SystemFolderEnum.DRAFTS.getId())){
				return "REFRESHINBOX";
			}

	        Message currentReadMessage = (Message)getSession().getAttribute(CURRENT_READ_MESSAGE);
	        if(currentReadMessage!=null){
	        	currentReadMessage= messageService.findMessageById(currentReadMessage.getId());
	        	getSession().setAttribute(AbstractInboxAction.CURRENT_MESSAGE, currentReadMessage);
	        	setMessageId(currentReadMessage.getId().toString());
	        	return CLINICIAN_READ_MESSAGE;
	        }else{
	        	return STRUTS_RESULT_CANCEL;
	        }
		}

		setupBean();
		if(log.isInfoEnabled()){
			log.info("new Reply message Id from request..."+request.getParameter("replyMessageId"));
		}
		Long newReplyMessageId = new Long(request.getParameter("replyMessageId"));
		if(completeReply.getClinicianId() != null &&
		   completeReply.getClinicianId() > 0){
			if(log.isDebugEnabled()){
				log.debug("Clinician id: " + completeReply.getClinicianId());
			}

			Clinician c = null;
			for(Clinician x : currentMessage.getThread().getMailGroup().getClinicians()){
				if(x.getId().equals(completeReply.getClinicianId()))
					c = x;
			}


			if(c != null){
				//messageService.assignMessage(currentMessage,c, (Clinician)user);
				//12.5 Changes
				messageService.assignMessageAndUpdateHistory(currentMessage, c, (Clinician)user,c.getName()+" "+getSurrogateEnabled());
				currentMessage.setAssignedTo(c);

				Folder f = getCurrentFolder();
				for(Addressee a : f.getMessages().getElements()){
					if(a.getMessage().getId().equals(currentMessage.getId())){
						a.getMessage().setAssignedTo(c);
						break;
					}
				}
			}

			// Block of code has been implemented for Bug# 5920.
			if(c==null)
			{
				Clinician currentClinician = (Clinician)request.getSession().getAttribute(CURRENT_USER);
				messageService.assignMessage(currentMessage,currentClinician,currentClinician);
				currentMessage.setAssignedTo(currentClinician);

				Folder f = getCurrentFolder();
				for(Addressee a : f.getMessages().getElements()){
					if(a.getMessage().getId().equals(currentMessage.getId())){
						a.getMessage().setAssignedTo(c);
						break;
					}
				}
			}

		}
		if(completeReply.getCompleteMsg().equals("Yes")){
			if(reminder.equalsIgnoreCase("No")){
				reminderDate = null;
			}
			//messageService.setMessageStatus(currentMessage, ClinicianStatusEnum.COMPLETE, (Clinician)user);
			messageService.setAllPreviousMessageStatus(currentMessage, ClinicianStatusEnum.COMPLETE, (Clinician)user,newReplyMessageId,reminderDate);

			// take care of some caching issues
			// mark the local copy as complete
			currentMessage.setStatus(ClinicianStatusEnum.COMPLETE);

			// The message will be moved to the completed folder
			// if we are in the inbox.  So we really should remove the
			// message from the local cache.
			Addressee a = (Addressee)request.getSession().getAttribute(CURRENT_ADDRESSEE);
			Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
			if(a != null && f != null){
				if(f.getId().equals(SystemFolderEnum.INBOX.getId()) ||
				   f.getId().equals(SystemFolderEnum.ESCALATED.getId())){
				   f.getMessages().getElements().remove(a);
				}
			}
		}

		if(!StringUtils.isBlank(completeReply.getComment())){
			Annotation a = new Annotation();
			a.setAnnotation(completeReply.getComment());
			a.setAuthor(user);
			a.setThread(currentMessage.getThread());
			messageService.annotateThread(a);
		}


		if(completeReply.getSaveAsTiu().equals("Yes")){
			request.getSession().setAttribute("notePreview", null);
			ServiceResponse<TiuNotePreview> response = tiuNoteService.getNotePreviewSMWeb(currentMessage.getThread(),(Clinician)user);
			Long triageGroupId = currentMessage.getThread().getMailGroup().getId();
			SMClinicsTriageMap clinicsTriageMap = triageGroupDao.getActiveSMClinicByTriageGroup(triageGroupId);

			if(handleMessages(response)){
				request.setAttribute("TIU_ERRORS", Boolean.TRUE);
			}
			TiuNotePreview preview = response.getPayload();
			preview.setCurrentMessageId(currentMessage.getId());
			if(preview!=null){
				preview.setClinicName(DEFAULT_SM_CLINIC);
				preview.setCprsTitle(DEFAULT_CPRS_NOTE_TITLE);

				if(clinicsTriageMap!=null && clinicsTriageMap.getSmClinicName()!=null){
					preview.setClinicName(clinicsTriageMap.getSmClinicName());
					preview.setClinicIen(clinicsTriageMap.getSmClinicIen());
				}

				if(clinicsTriageMap!=null && clinicsTriageMap.getSmClinicNameCPRSTitle()!=null)
					preview.setCprsTitle(clinicsTriageMap.getSmClinicNameCPRSTitle());

				preview.setVistAPatch11Status(workloadProperties.getVistAPatch11Status());
				preview.setVistAPatch11Fields(workloadProperties.getVistAPatch11Fields());
			}

			request.getSession().setAttribute("notePreview", preview);
			return "SAVE_AS_TIU";
		}

		//return SUCCESS;
		return "REFRESHINBOX";

	}

	public String getSurrogateEnabled() {
		return surrogateEnabled;
	}

	public void setSurrogateEnabled(String surrogateEnabled) {
		this.surrogateEnabled = surrogateEnabled;
	}

	public String getAssignedToSelect(){

		String select = "";
		String selected = "";
		String title = "";

		select = "<select id=\"assignee\" name=\"completeReply.clinicianId\" id=\"completeReply.clinicianId\" onchange=\"onchangeAssignTo()\">\r\n";

		Clinician assignedTo = currentMessage.getAssignedTo();

		//if(assignedTo == null){
		//	select += "<option selected value=\"\">Select Assignee</option>\r\n";
		//}

	    List<Clinician> triageMembers = currentMessage.getThread().getMailGroup().getClinicians();
	    boolean isCurrentUserPartofSelect = false;
	    for(Clinician c: triageMembers){
	    	user = (User)request.getSession().getAttribute(CURRENT_USER);
	    	if(c.getId().equals(user.getId())){
	    		isCurrentUserPartofSelect = true;
	    	}
	    	if(c.getStatus() == UserStatusEnum.OPT_OUT) continue;
	        if(c.equals(assignedTo)){
	          selected="selected";
	        }else{
	          selected="";
	        }

	        title = c.getName();

	        Surrogate currentSurrogate = surrogateDao.getCurrentSurrogateFor(c);
	        if(currentSurrogate!=null){
	        	if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN)){
	        		Clinician nc = userService.fetchClinician(currentSurrogate.getSurrogateId()).getPayload();
		        	title += " - surrogate enabled: " + nc.getName();
	        	}else if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)){
	        		TriageGroup tg = triageGroupDao.findById(currentSurrogate.getSurrogateId());
		        	title += " - surrogate enabled: " + tg.getName();
	        	}

	        }
	        select=select+"<option title=\"" + title + "\" " + selected + " value=\"" + c.getId() + "\">" + c.getName() + "</option>\r\n";
	    }
	    if(!isCurrentUserPartofSelect){
	    	title = "";
	    	select=select+"<option title=\"" + title + "\" value=\"" + user.getId() + "\">" +user.getName() + "</option>\r\n";
	    }

	    select +="</select>";
		return select;
	}

	/**
	 * Requirement: CR MHV00006200
	 *
	 * @param currentMessage
	 * @return
	 */
	private boolean isMessageExpired(Message currentMessage) {
		Date myDate = currentMessage.getCreatedDate();
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DAY_OF_MONTH, EXPIRATION_PERIOD_IN_DAYS);
		Date expiration = c.getTime();

		if (expiration.compareTo(myDate) < 0) {
			//Not expired
			return false;
		}
		else {
			//Expired
			return true;
		}
	}

		public String replyFileattached() throws IOException
		{
				setupBean();
				FileInputStream fileStream =  null;
				try
				{
					fileStream = new FileInputStream(getUpload());
					ServiceResponse<MessageAttachment> serviceResponse = null;
					Blob blob = Hibernate.createBlob(fileStream);

					try{
						serviceResponse = messageService.saveAttachment(blob, getUploadFileName(), getUploadContentType(),getCurrentUser().getId());
						if(log.isInfoEnabled()){
							log.info("<<<Reply File Attachment 502-User Id->"+getCurrentUser().getId()+" File Size->"+getUpload().length()+" contentType->"+getUploadContentType()+" fileName->"+getUploadFileName());
						}
						Long attachmentId = serviceResponse.getPayload().getId();
						if(log.isInfoEnabled()){
							log.info("Attachment Id..."+attachmentId);
						}
						String attachmentName = getUploadFileName()+" ("+AttachmentUtils.displayBytesSize(getUpload().length())+")^"+getUpload().length();


						if(getSession().getAttribute(REPLY_ATTACHMENTS)==null){
							Map<Long,String> attachmentsMap = new TreeMap<Long,String>();
							attachmentsMap.put(attachmentId, attachmentName);
							getSession().setAttribute(REPLY_ATTACHMENTS,attachmentsMap);
						}else{
							Map<Long,String> attachmentsMap = (Map)getSession().getAttribute(REPLY_ATTACHMENTS);
							attachmentsMap.put(attachmentId, attachmentName);
							getSession().setAttribute(REPLY_ATTACHMENTS,attachmentsMap);
						}

						Long totalSize = (getSession().getAttribute(REPLY_ATTACHMENTS_SIZE)!=null?(Long)getSession().getAttribute(REPLY_ATTACHMENTS_SIZE):0)+getUpload().length();
						getSession().setAttribute(REPLY_ATTACHMENTS_SIZE,totalSize);
						setTotalAttachedSize(totalSize);

						request.getSession().setAttribute("REPLY_MESSAGE_BODY",newMessage.getBody());
						fileStream.close();
					}catch(Exception e){
						if(log.isErrorEnabled()){
							log.error("Error while saving reply attachment..."+e);
						}
					}
				}catch(Exception e)
				{
					if(log.isErrorEnabled()){
						log.error("Error while saving reply attachment....."+e);
					}
				}
				finally{
					if(fileStream!=null){
						fileStream.close();	
					}
					
				}

			return STRUTS_RESULT;
		}


		/*
		 * removeAttachment, set the attachmentId, attachmentName in the NewMessage Object in the session.
		 *
		 */
		public String replyRemoveAttachment(){
			if(getRemoveReplyAttachment().equalsIgnoreCase("Yes")){
				setupBean();
				try
				{
					Map<Long,String> attachmentMap = (Map)getSession().getAttribute(REPLY_ATTACHMENTS);
					String removeAttachment = attachmentMap.get(getRemoveId());
					Long removeSize = new Long(AttachmentUtils.getSecondPartOfString(removeAttachment));
					Long totalSize = (Long)getSession().getAttribute(REPLY_ATTACHMENTS_SIZE) - removeSize;
					setTotalAttachedSize(totalSize);
					attachmentMap.remove(getRemoveId());
					messageService.removeAttachment(getRemoveId());
					getSession().setAttribute(REPLY_ATTACHMENTS, attachmentMap);
					getSession().setAttribute(REPLY_ATTACHMENTS_SIZE, totalSize);

				}catch(Exception e){
					if(log.isErrorEnabled()){
						log.error("Exception while remove reply attachment..."+getRemoveId()+e);
					}
				}
			}
			else{
				setupBean();
			}
			return STRUTS_RESULT;
		}

	public NewMessage getNewMessage() {
		return newMessage;
	}
	public void setNewMessage(NewMessage newMessage) {
		this.newMessage = newMessage;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Message getCurrentMessage() {
		return currentMessage;
	}

	public void setCurrentMessage(Message currentMessage) {
		this.currentMessage = currentMessage;
	}

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	public String getRecipient() {
		return recipient;
	}

	public String getSender() {
		return sender;
	}

	public String getSmSend() {
		return smSend;
	}

	public void setSmSend(String smSend) {
		this.smSend = smSend;
	}

	public String getSmCancel() {
		return smCancel;
	}

	public void setSmCancel(String smCancel) {
		this.smCancel = smCancel;
	}

	public CompleteReply getCompleteReply() {
		return completeReply;
	}

	public void setCompleteReply(CompleteReply completeReply) {
		this.completeReply = completeReply;
	}

	public String getSurrogate() {
		return surrogate;
	}

	public void setSurrogate(String surrogate) {
		this.surrogate = surrogate;
	}

	public String getSurrogateArray() {
		return surrogateArray;
	}

	public void setSurrogateArray(String surrogateArray) {
		this.surrogateArray = surrogateArray;
	}

	/**
	 * User reponse when decides to cancel the finish message screen.
	 * @return
	 */
	public String getCancelButton() {
		return cancelButton;
	}

	public void setCancelButton(String cancelButton) {
		this.cancelButton = cancelButton;
	}

	public String getSmReplySaveDraft() {
		return smReplySaveDraft;
	}

	public void setSmReplySaveDraft(String smReplySaveDraft) {
		this.smReplySaveDraft = smReplySaveDraft;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public void setAutoSaveDraft(String str) {
		autoSaveDraft = str;
	}

	public String getAutoSaveDraft() {
		return autoSaveDraft;
	}
	public String getPwin() {
		return pwin;
	}

	public void setPwin(String pwin) {
		this.pwin = pwin;
	}

	public String getUploadFileName() {
		return uploadFileName;
	}

	public void setUploadFileName(String uploadFileName) {
		this.uploadFileName = uploadFileName;
	}

	public String getUploadContentType() {
		return uploadContentType;
	}

	public void setUploadContentType(String uploadContentType) {
		this.uploadContentType = uploadContentType;
	}

	public File getUpload() {
		return upload;
	}

	public void setUpload(File upload) {
		this.upload = upload;
	}

	public String getAttachCancel() {
		return attachCancel;
	}

	public void setAttachCancel(String attachCancel) {
		this.attachCancel = attachCancel;
	}


	public String getReminder() {
		return reminder;
	}

	public void setReminder(String reminder) {
		this.reminder = reminder;
	}


	public Date getReminderDate() {
		return reminderDate;
	}

	public void setReminderDate(Date reminderDate) {
		this.reminderDate = reminderDate;
	}

	@SuppressWarnings("unchecked")
	public String addRecipientCc(){

		pwin = "";

		User user = (User)request.getSession().getAttribute(CURRENT_USER);
		String tab=request.getParameter("tab");
		setupBean();
		if("1".equals(tab))	{
			if(request.getParameter("search") != null){

				String lastName = (String)request.getParameter("lastName");
				// must provide a last name
				if(StringUtils.isBlank(lastName)) return "select";
				lastName=lastName.trim();

				String firstName = (String)request.getParameter("firstName");
				if (firstName != null)
					firstName=firstName.trim();

				request.getSession().setAttribute("firstName", firstName);
				request.getSession().setAttribute("lastName", lastName);

				try {
					CollectionServiceResponse<Clinician> response = userService
							.searchForClinicians(firstName, lastName,
									((Clinician) user).getStationNo(), true);
					Collection<Clinician> pts = response.getCollection();

					//Collection<Clinician> sortedClinicians = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER);
					//sortedClinicians.addAll(pts);
					request.getSession().setAttribute("clinicians", pts);
				} catch (Exception e) {
					addActionError("Search resulted in error.");
					return "select";
				}
				return "select";
			}
			else if(request.getParameter("select")!=null){
				Long id=null;
				try	{
					id = new Long((String)request.getParameter("recipient1"));
				}catch(Exception e){
					return "select";
				}
				Collection<Clinician> cns = (Collection<Clinician>)request.getSession().getAttribute("clinicians");
				User recipient = null;
				for(Clinician c : cns){
					if(c.getId().equals(id)){
						recipient = c;
						request.getSession().setAttribute("recipient1", recipient);
						WebApplicationContext ctx = WebApplicationContextUtils
						.getWebApplicationContext(ServletActionContext
								.getServletContext());
						FacilityService facilityService = (FacilityService)ctx.getBean("facilityService");
						IntegrationServiceDelegate delegate = (IntegrationServiceDelegate)ctx.getBean("integrationServiceDelegate");
						UserLookupResponse ulr = null;
						try
						{
							request.getSession().removeAttribute("recipient1Facility");
							request.getSession().removeAttribute("recipient1Demographics");

							Facility f = facilityService.getFacilityByStationNumber(c.getStationNo()).getPayload();
							if (f != null) {
								request.getSession().setAttribute("recipient1Facility", f.getName());
							} else {
								if(log.isErrorEnabled()){
									log.error("No facility for station " + c.getStationNo());
								}
							}
							if(log.isDebugEnabled()){
								log.debug("About to get user demographics for " + c.getFirstName() + " " + c.getLastName() + ", using DUZ=" + c.getDuz() + " on station " + c.getStationNo());
							}
							boolean userFound = false;
							ulr = delegate.getUserDemographics(null, null, c.getDuz(), c.getStationNo());
							if("Ok".equalsIgnoreCase(ulr.getStatus())) {
								if (ulr.getUsers()!= null && ulr.getUsers().length > 0) {
									// SUCCESS
									if(log.isDebugEnabled()){
										log.debug("Found clinician demographics for " + ulr.getUsers().length + " users");
									}
									gov.va.med.mhv.sm.wsclient.queriessvc.User[] users = ulr.getUsers();
									if (users.length != 1) {
										if(log.isDebugEnabled()){
											log.error("User demographics query retrieved " + users.length + " results when only 1 was expected: conversationID = " + ulr.getConversationID());
										}
									} else if (users[0] != null) {
										userFound = true;
										if(log.isDebugEnabled()){
											log.debug("User demographics found: " + users[0].getFirstName() + " " + users[0].getLastName() + ": department = " + users[0].getDepartment() + ", phone = " + users[0].getPhone());
										}
										request.getSession().setAttribute("recipient1Demographics", users[0]);
									}
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("User demographics query for " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo() + " returned " + ulr.getStatus() + ": conversationID = " + ulr.getConversationID());
								}
							}
							if (!userFound) {
								if(log.isErrorEnabled()){
									log.error("No users found matching " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo());
								}
							}
						} catch (Exception e) {
							if(log.isErrorEnabled()){
								log.error("Exception raised trying to retrieve user demographics for = " + c.getFirstName() + " " + c.getLastName() + ": DUZ/station = " + c.getDuz() + "/" + c.getStationNo());
							}
							if (ulr == null) {
								if(log.isErrorEnabled()){
									log.error("No conversation ID");
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("Conversation ID = " + ulr.getConversationID());
								}
							}
							e.printStackTrace();
						}
						break;
					}
				}
				return "select";
			}

			else if(request.getParameter("add")!=null || request.getParameter("cancel")!=null){
				if(request.getParameter("add")!=null){
					User recipient = (User)request.getSession().getAttribute("recipient1");

					Message currentMsg = (Message)request.getSession().getAttribute(AbstractInboxAction.CURRENT_MESSAGE);
					if(currentMsg != null || currentMsg.equals("")){
						currentMsg.setCcRecipientId(recipient.getId());
						currentMsg.setCcRecipientName(recipient.getName());
					}
					request.getSession().setAttribute(CURRENT_MESSAGE, currentMsg);
					
				}
				//cleanup
				request.getSession().removeAttribute("clinicians");
				request.getSession().removeAttribute("firstName");
				request.getSession().removeAttribute("lastName");
				request.getSession().removeAttribute("recipient1");
			}
		}

		request.setAttribute("doneAddReplyRecCcCln", "yes");
		return replyForm();//return STRUTS_RESULT;

	}
	
	private void getAttachments(Message message){
		if(message.isAttachment()){
			// Get Attachment Names.
			try{
				if(request.getSession().getAttribute(REPLY_ATTACHMENTS)==null){
					Map<Long,String> attachmentsMap = new TreeMap<Long,String>();
					ArrayList attachmentIds = new ArrayList();
					if(message.getAttachmentId()!=null) attachmentIds.add(message.getAttachmentId());
					if(message.getAttachmentId2()!=null) attachmentIds.add(message.getAttachmentId2());
					if(message.getAttachmentId3()!=null) attachmentIds.add(message.getAttachmentId3());
					if(message.getAttachmentId4()!=null) attachmentIds.add(message.getAttachmentId4());
					ServiceResponse<List<Object[]>> attachmentNames = messageService.getAttachmentNamesByAttachmentIds(attachmentIds);
					
					if(attachmentNames.getPayload()!=null && attachmentNames.getPayload().size()!=0){
						for(Object[] attachmentArr : attachmentNames.getPayload())
						{
							String attachmentName = (String)attachmentArr[1]+" ("+AttachmentUtils.displayBytesSize(((BigDecimal)attachmentArr[2]).longValue())+")";
							attachmentsMap.put(((BigDecimal)attachmentArr[0]).longValue(),attachmentName);
						}
						request.getSession().setAttribute(REPLY_ATTACHMENTS,attachmentsMap);
					}
				}
			}catch(Exception e1){
				if(log.isErrorEnabled()){
					log.error("An error occured while getting attachment names and size in Draft Messages"+e1);
				}
			}

		}
	}

	public static String getPatientAttachmentSwichStatus() {
		return patientAttachmentSwichStatus;
	}

	public static void setPatientAttachmentSwichStatus(
			String patientAttachmentSwichStatus) {
		ReplyMsg.patientAttachmentSwichStatus = patientAttachmentSwichStatus;
	}

	public String getRemoveReplyAttachment() {
		return removeReplyAttachment;
	}

	public void setRemoveReplyAttachment(String removeReplyAttachment) {
		this.removeReplyAttachment = removeReplyAttachment;
	}

    public SMAttachmentProperties getSmAttachments() {
		return smAttachments;
	}

	public void setSmAttachments(SMAttachmentProperties smAttachments) {
		this.smAttachments = smAttachments;
	}

    public Long getTotalAttachedSize() {
		return totalAttachedSize;
	}

	public void setTotalAttachedSize(Long totalAttachedSize) {
		this.totalAttachedSize = totalAttachedSize;
	}

	public String getAllowedCount() {
		return allowedCount;
	}

	public void setAllowedCount(String allowedCount) {
		this.allowedCount = allowedCount;
	}

	public Long getRemoveId() {
		return removeId;
	}

	public void setRemoveId(Long removeId) {
		this.removeId = removeId;
	}

	public static String getReplyAutoSaveSwitch() {
		return replyAutoSaveSwitch;
	}

	public static void setReplyAutoSaveSwitch(String replyAutoSaveSwitch) {
		ReplyMsg.replyAutoSaveSwitch = replyAutoSaveSwitch;
	}

	public String getSmSaveDraftAndLogout() {
		return smSaveDraftAndLogout;
	}

	public void setSmSaveDraftAndLogout(String smSaveDraftAndLogout) {
		this.smSaveDraftAndLogout = smSaveDraftAndLogout;
	}

	public Collection getCprsMessageStatus() {
		return cprsMessageStatus;
	}

	public void setCprsMessageStatus(Collection cprsMessageStatus) {
		this.cprsMessageStatus = cprsMessageStatus;
	}
	

}
