package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dao.MessageAttachmentDao;
import gov.va.med.mhv.sm.dao.SurrogateDao;
import gov.va.med.mhv.sm.dao.TiuNoteRecordDao;
import gov.va.med.mhv.sm.dao.TriageGroupDao;
import gov.va.med.mhv.sm.dao.FacilityDao;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.dao.ReAssignMessageDao;
import gov.va.med.mhv.sm.dao.properties.SMWorkloadProperties;
import gov.va.med.mhv.sm.dto.CPRSMessageStatusDTO;
import gov.va.med.mhv.sm.dto.UserSurrogateDTO;
import gov.va.med.mhv.sm.enumeration.AddresseeRoleEnum;
import gov.va.med.mhv.sm.enumeration.ClinicianStatusEnum;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.ReAssignMessageActionEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Annotation;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.DistGroupRecallMessage;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessageAttachment;
import gov.va.med.mhv.sm.model.MessagesPage;
import gov.va.med.mhv.sm.model.ReAssignMessageHistory;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.Thread;
import gov.va.med.mhv.sm.model.TiuNotePreview;
import gov.va.med.mhv.sm.model.TiuNoteRecord;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.AdminService;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.MessageService;
import gov.va.med.mhv.sm.service.TiuNoteService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.service.ReAssignMessageService;
import gov.va.med.mhv.sm.util.AttachmentUtils;
import gov.va.med.mhv.sm.util.CPRSMessageUtils;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMNoteTitle;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;


public class ReadMessage extends AbstractInboxAction
{

	private static final long serialVersionUID = 2915571014507343279L;

	private static final Log log = LogFactory.getLog(ReadMessage.class);

	private HttpServletRequest request;
	private MailboxService mailboxService;
	private MessageService messageService;
	private MessageAttachmentDao messageAttachmentDao;
	private TiuNoteService tiuNoteService;
	private TiuNoteRecordDao tiuNoteRecordDao;
	private UserManagementService userService;
	private AdminService adminService;
	private ReAssignMessageService reAssignMessageService;
	private SurrogateDao surrogateDao;
	private TriageGroupDao triageGroupDao;
	private FacilityDao facilityDao;
	private UserDao userDao;
	private String messageId;
	private String recipient;
	private String body;
	private String subject;
	private String sender;
	private String ccRecipient;
	private User user;
	private String sentDate;
	private String surrogate;
	private String surrogateArray;
	private String completeMessageSubmit;
	private String completeMessageCancel;
	private String providerCompleteMessageSubmit;
	private String STRUTS_RESULT_CANCEL = "CANCEL";
	private String CLINICIAN_NOT_ASSIGN = "CLINICIAN_NOTASSIGN";
	private String REFRESH_INBOX = "REFRESHINBOX";
	private String DEFAULT_SM_CLINIC = "SECURE MESSAGING";
	private String DEFAULT_CPRS_NOTE_TITLE = "SECURE MESSAGING";
	private String STRUTS_NOTES_PREVIEW="NotePreview";
	public static final String ATTACHMENT_NAMES = "attachmentNames";
	public static final String CPRS_MESSAGE_STATUS = "cprsMessageStatus";
	private String PROGRESS_NOTES_CLINIC_SUCCESSFUL="Your request to save the message in CPRS has been sent.</br> If this message fails to save, you will receive a notification in the CPRS Progress Notes Alerts folder.";
	//private String PROGRESS_NOTES_CLINIC_SUCCESSFUL="Your request to save the message in CPRS is queued. The message will be linked with SM Clinic: ";
	private static String PROGRESS_NOTES_ERR1="Previous attempt to save message as Progress Note failed: ";
	private static String PROGRESS_NOTES_ERR2="</br>Note: Please contact your SM Administrator and/or MHV Coordinator to assist in correcting the error.";
	private static String CC_MESSAGE="You have been carbon copied (CC) on this message.";
	private static String MESSAGE_ASSIGNED_OTHER="Message is already assigned to another user: ";
	private static String MESSAGE_REASSIGNED_FROM="This message has been reassigned from Triage Group: ";
	private static String MESSAGE_AUTO_ASSIGNED="This message has been automatically assigned to you.";
	private String[] selectedMessages;
	private boolean reassign;    // if true the select box for reassignment is shown
	private boolean assignable;  // if true the link for "Reassign?" is shown
	private boolean statusSelect;  // if true the select box for changing status is shown
	private boolean statusChangeable;  // if true the link for "Change Status?" is shown
	private boolean sentFolder; //if true ths current folder is sent folder
	private Message message;
	private List triageMembers;
	private String reAssignSubmit;
	private String reAssignCancel;
	private String STRUTS_RESULT;
	private String recallMessageSubmit;
	private String downloadFileName;
	private String reminder;
	private String reminderDate;
	private Date messageReminderDate;
	private Collection<UserSurrogateDTO> usersDTOList;
	private String surrogateEnabled;
	private SMWorkloadProperties workloadProperties;
	private String messageRecallStatus;
	private Collection<CPRSMessageStatusDTO> cprsMessageStatus;


	public ReadMessage(){
		super();
	}

	public void prepare() throws Exception {
		super.prepare();

		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		workloadProperties = ((SMWorkloadProperties)ctx.getBean("smWorkloadProperties"));
		tiuNoteService = (TiuNoteService) ctx.getBean("tiuNoteService");
		mailboxService = (MailboxService) ctx.getBean("mailboxService");
		messageService = (MessageService) ctx.getBean("messageService");
		adminService = (AdminService)ctx.getBean("adminService");
		triageGroupDao = (TriageGroupDao) ctx.getBean("triageGroupDao");
		reAssignMessageService = (ReAssignMessageService) ctx.getBean("reAssignMessageService");
		userService = (UserManagementService) ctx.getBean("userManagementService");
		messageAttachmentDao = (MessageAttachmentDao) ctx.getBean("messageAttachmentDao");
		surrogateDao = (SurrogateDao) ctx.getBean("surrogateDao");
		user = (User) request.getSession().getAttribute(CURRENT_USER);
		STRUTS_RESULT = user.getUserType() == UserTypeEnum.PATIENT ? "PATIENT"
				: "CLINICIAN";

		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		messageFilterId = f.getFilter().getId();
		request.getSession().setAttribute("MessageAnnotation","");
		//assign if the current folder is sent folder.
		sentFolder = f.getId().equals(SystemFolderEnum.SENT.getId());
		request.getSession().removeAttribute(ReplyMsg.REPLY_ATTACHMENTS);;
		request.getSession().setAttribute("updatedBody",null);
		request.getSession().removeAttribute(ATTACHMENT_NAMES);
	}



	private int getMessageIndex(MessagesPage mp, String messageId) {
		int notFoundResult = -1;
		for (int i = 0; i < mp.getPageSize(); i++) {
			Addressee a = mp.getElements().get(i);
			if (a.getMessage().getId().toString().equals(messageId)) {
				// found correct message
				return i;
			}
		}
		return notFoundResult;
	}

	private List<Message> getThreadMessages(Message message) {
		List<Message> result = new ArrayList<Message>();
		Thread thread = message.getThread();
		if (thread != null) {

			Folder folder = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);

		    // if block(folder.getName().equals("Completed") implemented for Bug#5342.  Completed folder required to disply the message thread.
			if(folder.getName().equals("Completed")){
				for (Message msg : thread.getMessages()) {
					if(msg.getId()!= message.getId() && msg.getSentDate()!=null){
						result.add(msg);
					}
				}
			}
			else
			{
				for (Message msg : thread.getMessages()) {
					if (msg.getCreatedDate().before(message.getCreatedDate()) && msg.getSentDate() != null){
						result.add(msg);
					}
				}
				result.add(message);
			}
			Collections.sort(result, new Comparator<Message>() {
				public int compare(Message msg1, Message msg2) {
					if (msg1 == null)
						return 1;
					else if (msg2 == null)
						return -1;
					else {
						Date date1 = msg1.getSentDate();
						Date date2 = msg2.getSentDate();
						if (date2.after(date1))
							return 1;
						else if (date2.before(date1))
							return -1;
						else
							return 0;
					}
				}
			});
		}
		return result;
	}

	private Message updateReadStatus(Addressee a) {
		User u = (User) request.getSession().getAttribute(CURRENT_USER);
		Message toReturn;

		if (a.getReadDate() == null) {
			// reduce the read count in the folder object
			// at least until it is refreshed from the DB
			Folder currentFolder = (Folder) request.getSession().getAttribute(
					CURRENT_FOLDER);
			currentFolder.setUnreadCount(currentFolder.getUnreadCount() - 1);
		}

		// regardless of whether the message has been read before we have to
		// obtain the rest of the messages in the thread
		ServiceResponse<Message> response = messageService.readMessage(a.getMessage(), u);
		toReturn = response.getPayload();

		// set the read date in our local copy of the message so that
		// it will be displayed properly on the folder view until it
		// can be refreshed from the database
		a.setReadDate(new Date());

		return toReturn;
	}


	private Message updateReadReceipt(Long messageId){
		Message responseMsg = null;
		Folder activeFolder = (Folder) request.getSession().getAttribute(CURRENT_FOLDER);
		//if the active folder is "sent" then do not update the read receipt.
		// (basically this prevents the sender from setting the READ receipt on their own message)
		if(!activeFolder.getName().equals(SystemFolderEnum.SENT.getName())) {
			ServiceResponse<Message> response = messageService.updateReadReceipt(messageId);
			responseMsg = response.getPayload();
		}
		return responseMsg;
	}

	private Message updateAssignmentStatus(Long messageId, Clinician clinician) {
		ServiceResponse<Message> response = messageService.updateAssignmentStatus(messageId, clinician);
		Message msg = response.getPayload();
		if(msg.getSenderType().equals(ParticipantTypeEnum.PATIENT)){
			if(!reAssignMessageService.findMsgReceivedHistoryByMessageId(msg.getId())){
				reAssignMessageService.createMessageReceivedHistory(msg.getId(),msg.getRecipientId(),msg.getSentDate(),user.getId());
			}

			String userSurrogateName="";
	     	String surrogateEnabled = userService.getActiveSurrogateByUser(clinician);
			if(surrogateEnabled!=null)	userSurrogateName = "Surrogate Enabled: "+surrogateEnabled;

			reAssignMessageService.createMessageAutoAssignedHistory(msg.getId(),msg.getRecipientId(),user.getId(),user.getName()+" "+userSurrogateName);
			messageService.updateAddresseeReAssignedActive(msg);
		}

		if(response.getPayload()!=null){
			addActionError(MESSAGE_AUTO_ASSIGNED);

			ReAssignMessageHistory history1= reAssignMessageService.getMsgHistoryByMsgAndAction(msg.getId(), ReAssignMessageActionEnum.MESSAGE_TRANSFERRED_TG_OUTSIDE_FACILITY).getPayload();
			if(history1!=null){
				String reAssignedTG = history1.getTriageGroupName().substring(history1.getTriageGroupName().lastIndexOf("/")+1, history1.getTriageGroupName().length());;
				addActionError(MESSAGE_REASSIGNED_FROM+reAssignedTG+" in "+history1.getTriageGroupName().substring(0,history1.getTriageGroupName().lastIndexOf("/")));
			}else{
			ReAssignMessageHistory history = reAssignMessageService.getMsgHistoryByMsgAndAction(msg.getId(), ReAssignMessageActionEnum.REASSIGN_ANOTHER_TG_WITH_IN_FACILITY).getPayload();
			if(history!=null){
				String reAssignedTG = history.getTriageGroupName().substring(history.getTriageGroupName().lastIndexOf("/")+1, history.getTriageGroupName().length());;
				addActionError(MESSAGE_REASSIGNED_FROM+reAssignedTG);
			}
	   	   }
		}
		return response.getPayload();
	}

	public String read() {

		Folder activeFolder = (Folder) request.getSession().getAttribute(CURRENT_FOLDER);
		MessagesPage mp = activeFolder.getMessages();
		int index = getMessageIndex(mp, messageId);
		Addressee addsee = mp.getElements().get(index);
		Message mesg = messageService.findMessageById(new Long(messageId));
		request.getSession().setAttribute(DRAFT_MSG_ID,0L);
		request.getSession().setAttribute("oldMessage",null);
		//request.getSession().setAttribute("sessionMessage",mesg);

		if(user.getUserType().equals(UserTypeEnum.CLINICIAN) &&
				activeFolder.getName().equals(SystemFolderEnum.INBOX.getName()) ) {
			if(mesg.getAssignedTo() == null) {
				updateAssignmentStatus( Long.parseLong(messageId), (Clinician)user);
			}
			else if(!mesg.getAssignedTo().getId().equals(user.getId())) {
			Clinician mesgAssignedUser = userService.fetchClinician(mesg.getAssignedTo().getId()).getPayload();
			addActionError(MESSAGE_ASSIGNED_OTHER+mesgAssignedUser.getFirstName() +" " + mesgAssignedUser.getLastName());
			}
			
			// If the Message is reassigned to another Triage Group/Staff, the following display message should appear when the Provider opens the message.
			ReAssignMessageHistory history = reAssignMessageService.getMsgHistoryByMsgAndAction(mesg.getId(), ReAssignMessageActionEnum.REASSIGN_ANOTHER_STAFF_WITH_IN_FACILITY).getPayload();
			if(history!=null){
				String reAssignedTG = history.getTriageGroupName().substring(history.getTriageGroupName().lastIndexOf("/")+1, history.getTriageGroupName().length());;
				addActionError(MESSAGE_REASSIGNED_FROM+reAssignedTG);
			}else{
				ReAssignMessageHistory history1= reAssignMessageService.getMsgHistoryByMsgAndAction(mesg.getId(), ReAssignMessageActionEnum.MESSAGE_TRANSFERRED_STAFF_OUTSIDE_FACILITY).getPayload();
				if(history1!=null){
					String reAssignedTG = history1.getTriageGroupName().substring(history1.getTriageGroupName().lastIndexOf("/")+1, history1.getTriageGroupName().length());;
					addActionError(MESSAGE_REASSIGNED_FROM+reAssignedTG+" in "+history1.getTriageGroupName().substring(0,history1.getTriageGroupName().lastIndexOf("/")));
				}
			}
			
				
			ReAssignMessageHistory autoAssociatedHistory = reAssignMessageService.getAutoAssociatedTGHistoryByMessage(mesg.getId()).getPayload();
			if(autoAssociatedHistory!=null){
				String reAssignedTG = autoAssociatedHistory.getReAssignedTriageGroupName().substring(autoAssociatedHistory.getReAssignedTriageGroupName().lastIndexOf("/")+1, autoAssociatedHistory.getReAssignedTriageGroupName().length());;
				String displayMessage="NOTE: Patient "+mesg.getSenderName()+" is now associated with your Triage Group.  If you do not want to maintain the association with the patient, contact your SM Administrator to remove the association.";
				addActionError(displayMessage);
			}
		}
		
		if(mesg.getSenderType().equals(ParticipantTypeEnum.CLINICIAN)){
			List<Addressee> addseeList = mesg.getAddressees();
			if(user.getUserType().equals(UserTypeEnum.CLINICIAN) && activeFolder.getName().equals(SystemFolderEnum.SENT.getName())){
				for(Addressee addressee:addseeList){
					if(addressee.getRole().equals(AddresseeRoleEnum.CC)){
							setCcRecipient(addressee.getOwner().getName());
							break;
					}
				}
			}else if(user.getUserType().equals(UserTypeEnum.CLINICIAN) && !activeFolder.getName().equals(SystemFolderEnum.SENT.getName())){
				for(Addressee addressee:addseeList){
					if(addressee.getRole().equals(AddresseeRoleEnum.CC)){
						setCcRecipient(addressee.getOwner().getName());
						if(user.getId().equals(addressee.getOwner().getId())){
							addActionError(CC_MESSAGE);
						}
						break;
					}
				}
			}
		}

		// Due to unavailability of automatic assignment function for Escalated Folder and System Folders, System should capture the Message received history.
		if(user.getUserType().equals(UserTypeEnum.CLINICIAN) && (!activeFolder.isSystemFolder() || activeFolder.getName().equals(SystemFolderEnum.ESCALATED.getName())))
		{
			if(mesg.getAssignedTo()==null && mesg.getSenderType().equals(ParticipantTypeEnum.PATIENT)){
				if(!reAssignMessageService.findMsgReceivedHistoryByMessageId(mesg.getId())){
					try{
					reAssignMessageService.createMessageReceivedHistory(mesg.getId(),mesg.getRecipientId(),mesg.getSentDate(),user.getId());

					messageService.updateAddresseeReAssignedActive(mesg);
					}catch(Exception e2){
						if(log.isErrorEnabled()){
							log.error("Error while updateAddresseReassigned Status..."+e2);
						}
					}
				}
			}
		}

		if(user.getUserType().equals(UserTypeEnum.CLINICIAN) &&
				activeFolder.getName().equals(SystemFolderEnum.REMINDER.getName()) ){
			if(addsee.getReminderDate()!=null){
				addActionError("The Reminder Date for this Message is "+DateUtils.formatDate(addsee.getReminderDate(),DateUtils.ENGLISH_DATE_FORMAT));
			}
		}

		if(user.getUserType().equals(UserTypeEnum.CLINICIAN) && activeFolder.getName().equals(SystemFolderEnum.SENT.getName())){
				if(mesg.getRecipientType().equals(ParticipantTypeEnum.PATIENT) || mesg.getRecipientType().equals(ParticipantTypeEnum.DISTRIBUTION_GROUP)){
					DistGroupRecallMessage dgRecallMessage = messageService.getDistGroupRecallMessageById(mesg.getId());
					if(dgRecallMessage!=null){
						setMessageRecallStatus("Recalled");
						addActionError("This message was recalled on "+DateUtils.getEnglishDateTime(dgRecallMessage.getCreatedDate())+".");
					}
				}
		}

		request.getSession().setAttribute("sessionMessage",mesg);

		Message messageToRead = updateReadStatus(addsee);
		Message updateReadReceipt = updateReadReceipt(new Long(messageId));
		List<Message> prevThreadMessages = getThreadMessages(messageToRead);
		request.getSession().setAttribute(CURRENT_ADDRESSEE, addsee);
		request.getSession().setAttribute(CURRENT_MESSAGE, messageToRead);
		request.getSession().setAttribute(PREVIOUS_MESSAGES, prevThreadMessages);

		//List<Object[]> attachmentList = messageAttachmentDao.getAttachmentNameByMessageId(messageToRead.getId());
		if(messageToRead.getAttachmentId()!=null){
			MessageAttachment messageAttachment = messageAttachmentDao.findById(messageToRead.getAttachmentId());
			if(messageAttachment!=null){
				setDownloadFileName(messageAttachment.getAttachmentName());
			}
		}

		setupBean(messageToRead);
		return STRUTS_RESULT;
	}

	/**
	 * This method will forward to the print page.
	 * Since  CURRENT_ADDRESSEE, CURRENT_MESSAGE, PREVIOUS_MESSAGES stored in session,
	 * jsp page will perform all the task to retrieve these information and make
	 * them display.
	 *
	 * @return
	 */
	public String printMessage() {
		return STRUTS_RESULT;
	}

	public String completeIndividualMessage() {

		Message currentMessage = (Message) request.getSession().getAttribute(
				CURRENT_MESSAGE);

		if (completeMessageSubmit != null) {

			String completeOption = getRequest().getParameter("optionGroup");
			ServiceResponse<Boolean> completeResponse = null;
			ServiceResponse<Boolean> tiuNoteResponse = null;

			if (completeOption.equals("1")) {
				completeResponse = messageService.completeIndividualMessage(currentMessage,(Clinician) user);
				return notePreview(currentMessage, (Clinician)user);

			}
			if (completeOption.equals("2")) {
				completeResponse = messageService
						.completeIndividualMessage(currentMessage,
								(Clinician) user);
			}
			return REFRESH_INBOX;
		}

		if (providerCompleteMessageSubmit != null) {
			ServiceResponse<Boolean> completeResponse = null;
			completeResponse = messageService
						.completeIndividualMessage(currentMessage,
								(Clinician) user);
			return REFRESH_INBOX;
		}

		if (completeMessageCancel != null) {

			return STRUTS_RESULT_CANCEL;
		}

		return STRUTS_RESULT;
	}



	public String completedReAssignment() {
		Message currentMessage = (Message) request.getSession().getAttribute(
				CURRENT_MESSAGE);

		if(reAssignCancel!=null){
			return STRUTS_RESULT_CANCEL;
		}

		Long reAssigneeId = null;
		if(request.getParameter("clinicianId")!=null){
			reAssigneeId = new Long(request.getParameter("clinicianId"));
		}

		if (reAssigneeId!=null) {
			String reAssignComment = request.getParameter("reAssignComment");
			ServiceResponse<Boolean> response = messageService.completedMessageReassignment(currentMessage,(Clinician)user,reAssigneeId,reAssignComment,getSurrogateEnabled());
			if(response==null){
				if(log.isErrorEnabled()){
					log.error("Error while ReAssigning Message from Completed Folder...");
				}
			}
			return REFRESH_INBOX;

		}
		else{
			//12.5 Changes
			getUsersSurrogateList(currentMessage.getThread().getMailGroup().getId());

			/*List<Clinician> reAssignMembers = currentMessage.getThread().getMailGroup().getClinicians();
			setTriageMembers(reAssignMembers);
			reAssignMembers=null;
			*/
			return STRUTS_RESULT;

		}

	}

	public String readNext() {
		Folder currentFolder = (Folder) request.getSession().getAttribute(
				CURRENT_FOLDER);
		MessagesPage mp = currentFolder.getMessages();
		int index = getMessageIndex(mp, messageId);
		if (index == mp.getElements().size() - 1 && mp.hasNextPage()) {
			currentFolder = mailboxService.getMessages(currentFolder,
					MessagesPageEnum.NEXT).getPayload();
			mp = currentFolder.getMessages();
			request.getSession().setAttribute(CURRENT_FOLDER, currentFolder);
			index = 0;
		} else if (index < mp.getElements().size() - 1) {
			index = index + 1;
		}
		Addressee a = mp.getElements().get(index);
		Message messageToRead = updateReadStatus(a);
		List<Message> prevThreadMessages = getThreadMessages(messageToRead);
		request.getSession().setAttribute(CURRENT_ADDRESSEE, a);
		request.getSession().setAttribute(CURRENT_MESSAGE, messageToRead);
		request.getSession().setAttribute(PREVIOUS_MESSAGES, prevThreadMessages);
		request.getSession().removeAttribute(ATTACHMENT_NAMES);
		setupBean(messageToRead);

		return STRUTS_RESULT;
	}

	public String readPrev() {
		Folder currentFolder = (Folder) request.getSession().getAttribute(
				CURRENT_FOLDER);
		MessagesPage mp = currentFolder.getMessages();
		int index = getMessageIndex(mp, messageId);
		if (index == 0 && mp.hasPreviousPage()) {
			currentFolder = mailboxService.getMessages(currentFolder,
					MessagesPageEnum.PREV).getPayload();
			mp = currentFolder.getMessages();
			request.getSession().setAttribute(CURRENT_FOLDER, currentFolder);
			index = mp.getPageSize() - 1;
		} else if (index > 0) {
			index = index - 1;
		}
		Addressee a = mp.getElements().get(index);
		Message messageToRead = updateReadStatus(a);
		List<Message> prevThreadMessages = getThreadMessages(messageToRead);
		request.getSession().setAttribute(CURRENT_ADDRESSEE, a);
		request.getSession().setAttribute(CURRENT_MESSAGE, messageToRead);
		request.getSession().setAttribute(PREVIOUS_MESSAGES, prevThreadMessages);
		request.getSession().removeAttribute(ATTACHMENT_NAMES);
		setupBean(messageToRead);

		return STRUTS_RESULT;
	}

    public String saveMessageAsTIU() {

        User u = (User) request.getSession().getAttribute(CURRENT_USER);
        if (u == null || !u.getUserType().equals(UserTypeEnum.CLINICIAN)) {
                        return ERROR;
        }




        Message message = (Message) request.getSession().getAttribute(
                                        CURRENT_MESSAGE);
        if (request.getParameterMap().containsKey("save") ||
        		request.getParameterMap().containsKey("append")) {

        		if(getSelectedMessages()==null){

					request.getSession().setAttribute("CHECKBOX_ERROR","CheckBoxNotSelected");

					return "CLINICIAN_INPUT";
				}

        				ServiceResponse<Boolean> response = null;
						 if(message.getAssignedTo()== null){
						    message.setAssignedTo((Clinician)u);
						    response = messageService.assignMessage(message,(Clinician)u,(Clinician)u);
						    if(handleMessages(response)){
						    	if(log.isErrorEnabled()){
						    		log.error("Error while trying to assign a message to a Clinician in saveMessageAsTIU()");
						    	}
						    }
						 }

						 TiuNotePreview notePreview = (TiuNotePreview) request.getSession().getAttribute("notePreview");

						 response = tiuNoteService.createProgressNoteSMWeb(message.getThread(),(Clinician) u, getSelectedMessages(),notePreview);

                         setupBean(message);

                        if (handleMessages(response)){
                                        request.setAttribute("TIU_ERRORS", Boolean.TRUE);
                                        return notePreview(message, (Clinician)u);
                        } else{
                                        addActionError(PROGRESS_NOTES_CLINIC_SUCCESSFUL);
                        				//addActionError(PROGRESS_NOTES_CLINIC_SUCCESSFUL+notePreview.getClinicName()+", CPRS Title: "+notePreview.getCprsTitle()+".");
                                        return SUCCESS;
                        }
        } else if (request.getParameterMap().containsKey("cancel")) {
        				setupBean(message);
                        return SUCCESS;
        } else {
                        return notePreview(message, (Clinician)u);
        }
     }




	private String notePreview(Message message, Clinician c){

			request.getSession().setAttribute("notePreview", null);
			ServiceResponse<TiuNotePreview> response = tiuNoteService.getNotePreviewSMWeb(message.getThread(), c);
			Long triageGroupId = message.getThread().getMailGroup().getId();
			SMClinicsTriageMap clinicsTriageMap = triageGroupDao.getActiveSMClinicByTriageGroup(triageGroupId);

			if(handleMessages(response)){
				request.setAttribute("TIU_ERRORS", Boolean.TRUE);
				}
			TiuNotePreview preview = response.getPayload();
			preview.setCurrentMessageId(message.getId());
			if(preview!=null){
				preview.setClinicName(DEFAULT_SM_CLINIC);
				preview.setCprsTitle(DEFAULT_CPRS_NOTE_TITLE);

				if(clinicsTriageMap!=null && clinicsTriageMap.getSmClinicName()!=null){
					preview.setClinicName(clinicsTriageMap.getSmClinicName());
					preview.setClinicIen(clinicsTriageMap.getSmClinicIen());
				}

				if(clinicsTriageMap!=null && clinicsTriageMap.getSmClinicNameCPRSTitle()!=null)
					preview.setCprsTitle(clinicsTriageMap.getSmClinicNameCPRSTitle());
				preview.setVistAPatch11Status(workloadProperties.getVistAPatch11Status());
				preview.setVistAPatch11Fields(workloadProperties.getVistAPatch11Fields());
			}

			request.getSession().setAttribute("notePreview", preview);

			return "save";
	}

	private String getTiuNoteTitle(){
		TiuNotePreview preview = (TiuNotePreview)request.getSession().getAttribute("notePreview");
		return preview.getCprsTitle();
	}

	public String closeMessage() {
		if(getCurrentFolder().getId().equals(SystemFolderEnum.DRAFTS.getId())){
			return "REFRESHINBOX";
		}
		return STRUTS_RESULT;
	}

	public String moveMessage() {
		return SUCCESS;
	}

	public String replyToMessage() {
		return SUCCESS;
	}

	public String deleteMessage() {
		User u = (User) request.getSession().getAttribute(CURRENT_USER);
		if (u == null) {
			// if user is null then we have to abort
			return ERROR;
		}

		Message messageToDelete = (Message) request.getSession().getAttribute(
				CURRENT_MESSAGE);

		if (messageService.deleteMessage(messageToDelete, u).getPayload()) {
			Folder currentFolder = u.getMailbox().getFolders().get(
					SystemFolderEnum.INBOX.getId());
			request.getSession().setAttribute(CURRENT_FOLDER, currentFolder);
		}
		return SUCCESS;
	}

	public String getMessageId() {
		return messageId;
	}

	//public User getMessageSender() {
	//	Message message = (Message) request.getSession().getAttribute(CURRENT_MESSAGE);
	//	User messageSender=messageService.getSender(message.getSenderId());
	//	request.getSession().setAttribute("CURRENT_SENDER", messageSender);
	//	return messageSender;
	//}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	public String AssignStatusAnnot() {
		Long assignToId = null;
		Long statusId = null;
		String MessageAnnotation = null;
		Message currentMessage = null;
		Clinician currentClinician = null;
		request.getSession().setAttribute("MessageAnnotation","");
		boolean isAssignTo = false;
		boolean isStatus = false;
		boolean isAnnot = false;
		boolean isCurrentUserPartOfTriage = false;

		try {
			currentMessage = (Message) request.getSession().getAttribute(
					CURRENT_MESSAGE);
		} catch (Exception e) {
		}
		if (currentMessage == null) {
			return ERROR;
		}
		try {
			currentClinician = (Clinician)request.getSession().getAttribute(CURRENT_USER);
		} catch (Exception e) {
		}
		if (currentClinician != null) {
			if(log.isInfoEnabled()){
				log.info("currentClinician ID="	+ currentClinician.getId());
			}
		} else {
			if(log.isInfoEnabled()){
				log.info("currentClinician is null");
			}
		}
		try {
			assignToId = Long.valueOf(request.getParameter("Assignee"));
		} catch (Exception e) {
		}
		if (assignToId != null && assignToId > 0) {
			isAssignTo = true;
		}
		try {
			statusId = Long.valueOf(request.getParameter("MessageStatusID"));
		} catch (Exception e) {
		}
		if (statusId != null && statusId > 0) {
			isStatus = true;
			// Validattion for message Reminder Date.
			if(statusId.equals(ClinicianStatusEnum.COMPLETE.getId()) && reminder.equalsIgnoreCase("Yes")){

				if(getReminderDate().length()==0){
					setupBean(currentMessage);
					addActionError("Please enter a valid Reminder Date");
					return "CLINICIAN_INPUT";
				}
				try {
					if( getReminderDate() != null) {
						messageReminderDate = (DateUtils.parseDateNoLeniency(getReminderDate(), DateUtils.ENGLISH_DATE_FORMAT));

						Calendar cal = Calendar.getInstance();
						Date currentDate = DateUtils.dateOnly(cal.getTime());
						if(messageReminderDate.before(currentDate)){
							setupBean(currentMessage);
							addActionError("Please verify that the Reminder date is before the current date");
							return "CLINICIAN_INPUT";
						}

					}

				} catch (ParseException e) {
					setupBean(currentMessage);
					addActionError("Please enter a valid Reminder Date");
					return "CLINICIAN_INPUT";
				}



			}
		}

		try {
			MessageAnnotation = request.getParameter("MessageAnnotation");
		} catch (Exception e) {
		}
		if (MessageAnnotation != null) {
			isAnnot = true;
		}
		if (MessageAnnotation.equals("")) {
			isAnnot = false;
		}
		if (isAssignTo) {
			List<Clinician> TriageMembers = currentMessage.getThread()
					.getMailGroup().getClinicians();

			for (Clinician c : TriageMembers) {
				if (c.getId().equals(assignToId))
				{
					isCurrentUserPartOfTriage = true;
					//ServiceResponse<Boolean> result = messageService.assignMessage(currentMessage, c, currentClinician);
					// 12.5 Changes
					ServiceResponse<Boolean> result = messageService.assignMessageAndUpdateHistory(currentMessage, c, currentClinician,c.getName()+" "+getSurrogateEnabled());

					if(result.getPayload())
					{
						currentMessage.setAssignedTo(c);
						currentMessage.setStatus(ClinicianStatusEnum.INPROCESS);
					}
					else
					{
						handleMessages(result);
					}
					break;
				}
			}
			// The following implementation for the Bug#5920(If the surrogate belongs to other triage group, they can assign the current message
			// to themself and complete the message.
			 if(!isCurrentUserPartOfTriage){
				 //ServiceResponse<Boolean> result = messageService.assignMessage(currentMessage,currentClinician,currentClinician);
				 // 12.5 Changes
				 ServiceResponse<Boolean> result = messageService.assignMessageAndUpdateHistory(currentMessage, currentClinician, currentClinician,currentClinician.getName()+" "+getSurrogateEnabled());

				if(result.getPayload()){
					currentMessage.setAssignedTo(currentClinician);
					currentMessage.setStatus(ClinicianStatusEnum.INPROCESS);
				}
			}

			message = currentMessage;
		} else {
			if(log.isInfoEnabled()){
				log.info("isAssignTo=false");
			}
		}
		if (isStatus) {
			for (ClinicianStatusEnum s : ClinicianStatusEnum.values()) {
				if (s.getId().equals(statusId)) {
					currentMessage.setStatus(s);
					ServiceResponse<Boolean> result = messageService.setMessageStatus(currentMessage, s, currentClinician,messageReminderDate);
					if(handleMessages(result)){
						if(log.isInfoEnabled()){
							log.info("setting message status failed");
						}
						break;
					}

					// The message will be moved to the completed folder
					// if we are in the inbox.  So we really should remove the
					// message from the local cache.
					Addressee a = (Addressee)request.getSession().getAttribute(CURRENT_ADDRESSEE);
					Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
					if(a != null && f != null){
						if(f.getId().equals(SystemFolderEnum.INBOX.getId()) ||
						   f.getId().equals(SystemFolderEnum.ESCALATED.getId())){
							f.getMessages().getElements().remove(a);
						}
						// reduce the count of messages in the folder
						f.setCount(f.getCount() - 1);
						f.getMessages().setElementCount(f.getMessages().getElementCount()-1);
					}

					break;
				}
			}
		} else {
			if(log.isInfoEnabled()){
				log.info("isStatus=false");
			}
		}
		if (isAnnot) {
			Annotation a = new Annotation();
			a.setAnnotation(MessageAnnotation);
			a.setAuthor(currentClinician);
			a.setThread(currentMessage.getThread());
			messageService.annotateThread(a);
			currentMessage.getThread().getAnnotations().add(a);
		} else {
			if(log.isInfoEnabled()){
				log.info("isAnnot=false");
			}
		}
		if (isAssignTo || isStatus || isAnnot) {
			request.getSession().setAttribute(CURRENT_MESSAGE, currentMessage);
		}
		setupBean(currentMessage);
		return SUCCESS;
	}


	/**
	 * MHV00004683
	 *
	 * @return
	 */
	public String recallMessage() {
		//check params
		if( "yes".equalsIgnoreCase(recallMessageSubmit) ) {
			Message messageToRead = (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
			ServiceResponse result = messageService.recall(messageToRead.getId(),(Clinician)user);
			if(handleMessages(result)){
				if(log.isInfoEnabled()){
					log.info("recalling message status failed");
				}
				return STRUTS_RESULT_CANCEL;
			} else {
				if( null == messageToRead.getReadReceipt() || messageToRead.getReadReceipt().length() == 0) {
//					Message was not read so successful
					addActionError("Your message has been successfully recalled");
				} else {
//					Message was read so unsuccessful (Could be a breech)
					addActionError("Your message was recalled but has already been read by the recipient.<br>" +
							       "Please notify your administrator with Message Id " + messageToRead.getId());
				}
				Message msg = (Message)result.getPayload();
				if( msg != null ) {
					request.getSession().setAttribute(CURRENT_MESSAGE, msg);
				}
			}
			return STRUTS_RESULT_CANCEL;
		} else {
			//no
			return STRUTS_RESULT_CANCEL;
		}
		//blah
	}

	public String reassign(){
		Message messageToRead = (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
		String messageAnnotation = request.getParameter("MessageAnnotation");
		request.getSession().setAttribute("MessageAnnotation",messageAnnotation);
		setupBean(messageToRead);
		if(messageToRead.getStatus() != ClinicianStatusEnum.COMPLETE )
			reassign = true;
		return SUCCESS;
	}

	public String changeStatus(){
		Message messageToRead = (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
		setupBean(messageToRead);
		if(messageToRead.getStatus() != ClinicianStatusEnum.COMPLETE &&
		   messageToRead.getAssignedTo() != null &&
		   messageToRead.getAssignedTo().equals(user))
			statusSelect = true;
		return SUCCESS;
	}

	public void setupBean(Message m){

		message = m;

		if(user.getUserType() == UserTypeEnum.PATIENT){
			sender = m.getSenderName() + " (" +
				m.getThread().getMailGroup().getName() + ")";
			recipient = m.getRecipientName();
		}else{
			sender = m.getSenderName();
			if(m.getThread().getMailGroup() != null){
				recipient = m.getRecipientName() + " (" +
					m.getThread().getMailGroup().getName() + ")";
			}else{
				recipient = m.getRecipientName();
			}
			Long id= new Long(m.getSenderId());
			ServiceResponse<User> response = messageService.getSender(id);
			User messageSender = response.getPayload();
			request.getSession().setAttribute("MESSAGE_SENDER", messageSender);
		}

		body = m.getBody();
		subject = m.getThread().getSubject();
		sentDate = DateUtils.getEnglishDateTime(m.getSentDate());

		surrogate = "";

		if(m.getAssignedTo() != null){
			Surrogate currentSurrogate = surrogateDao.getCurrentSurrogateFor(m.getAssignedTo());
			if(currentSurrogate!=null){
				if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN)){
					Clinician nc = userService.fetchClinician(currentSurrogate.getSurrogateId()).getPayload();
					surrogate = "Surrogate Enabled: " + nc.getName();
				}
				else if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)){
					TriageGroup tg = triageGroupDao.findById(currentSurrogate.getSurrogateId());
					surrogate = "Surrogate Enabled: " + tg.getName();
				}

			}
		}

		if(user.getUserType().equals(UserTypeEnum.CLINICIAN)){
			setCprsMessageStatus(CPRSMessageUtils.getCPRSMessageStatus(tiuNoteService.getProgressNotesStatusByThreadId(m.getThread().getId())));
			request.getSession().setAttribute(CPRS_MESSAGE_STATUS,CPRSMessageUtils.getCPRSMessageStatus(tiuNoteService.getProgressNotesStatusByThreadId(m.getThread().getId())));
		}
		Folder activeFolder = (Folder) request.getSession().getAttribute(CURRENT_FOLDER);
		if(user.getUserType().equals(UserTypeEnum.CLINICIAN) && activeFolder.getName().equals(SystemFolderEnum.CPRSPROGRESSALERTS.getName())){

			ServiceResponse<TiuNoteRecord> response = tiuNoteService.getTiuNoteRecordByThreadAndMessageId(m.getThread().getId(), m.getId());

			TiuNoteRecord tiuNoteRecord = response.getPayload();

			if(tiuNoteRecord!=null && tiuNoteRecord.getComments()!=null){
				addActionError(PROGRESS_NOTES_ERR1+CPRSMessageUtils.getErrorMessage(tiuNoteRecord.getComments())+PROGRESS_NOTES_ERR2);
			}
		}


		// create the surrogate array

		if(m.getThread().getMailGroup() == null){
			surrogateArray = "[];";
		}else{

			surrogateArray = "var surrogateArray = [";

			if(m.getAssignedTo() == null) surrogateArray += "'',";

			Iterator<Clinician> ic = m.getThread().getMailGroup().getClinicians().iterator();
			while(ic.hasNext()){

				Clinician nc = ic.next();
				Surrogate currentSurrogate = surrogateDao.getCurrentSurrogateFor(nc);
				if(currentSurrogate!=null)
				{
					if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN))
					{
						Clinician clinician = (Clinician)userService.fetchClinician(currentSurrogate.getSurrogateId()).getPayload();
						surrogateArray += "'Surrogate Enabled: " + clinician.getName()+ "'";
					}else if(currentSurrogate.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)){
						TriageGroup tg = triageGroupDao.findById(currentSurrogate.getSurrogateId());
						surrogateArray += "'Surrogate Enabled: " + tg.getName()+ "'";
					}
				}
				else
				{
					surrogateArray +="''";
				}
				if(ic.hasNext()) surrogateArray += ",";

			}

			surrogateArray +=",''];";

		}

		// show the select box for assignment?
		if (m.getAssignedTo() == null)
			reassign = true;
		if(m.getStatus() == ClinicianStatusEnum.COMPLETE){
			assignable = false;
		}else{
			assignable = true;
		}

		if(m.getStatus() != ClinicianStatusEnum.COMPLETE &&
		   m.getAssignedTo() != null && m.getAssignedTo().equals(user))
			statusChangeable = true;
		else
			statusChangeable = false;

		//6598
		setMessageCategoryTypeId(m.getThread().getMessageCategoryType().getId());

		// Set attachment names in message header
		if(m.isAttachment()){
			// Get Attachment Names.

			try{
				if(request.getSession().getAttribute(ATTACHMENT_NAMES)==null){
					Map<Long,String> attachmentsMap = new TreeMap<Long,String>();
					ArrayList attachmentIds = new ArrayList();
					if(m.getAttachmentId()!=null) attachmentIds.add(m.getAttachmentId());
					if(m.getAttachmentId2()!=null) attachmentIds.add(m.getAttachmentId2());
					if(m.getAttachmentId3()!=null) attachmentIds.add(m.getAttachmentId3());
					if(m.getAttachmentId4()!=null) attachmentIds.add(m.getAttachmentId4());
					List<Object[]> attachmentNames = messageAttachmentDao.getAttachmentNamesByAttachmentIds(attachmentIds);
					if(attachmentNames!=null && attachmentNames.size()!=0){
						for(Object[] attachmentArr : attachmentNames)
						{
							String attachmentName = (String)attachmentArr[1]+" ("+AttachmentUtils.displayBytesSize(((BigDecimal)attachmentArr[2]).longValue())+")";
							attachmentsMap.put(((BigDecimal)attachmentArr[0]).longValue(),attachmentName);
						}
						request.getSession().setAttribute(ATTACHMENT_NAMES,attachmentsMap);
					}
				}
			}catch(Exception e1){
				if(log.isErrorEnabled()){
					log.error("An error occured while getting attachment names and size"+e1);
				}
			}

		}
	}


	public void getUsersSurrogateList(Long triageGroupId){
		Clinician loggedInUser = ((Clinician) getRequest().getSession().getAttribute(CURRENT_USER));
		CollectionServiceResponse<UserSurrogateDTO> response = getUserService().getTriageMembersWithCurrentSurrogate(triageGroupId);
		Collection<UserSurrogateDTO> userSurrogateList = response.getCollection();
		boolean userExists=false;
		for(UserSurrogateDTO userSurrogate:userSurrogateList){
			if(userSurrogate.getUserId().equals(loggedInUser.getId())){
				userExists=true;
				break;
			}
		}
		if(!userExists){
			UserSurrogateDTO userSurrogateDTO= new UserSurrogateDTO();
			userSurrogateDTO.setName(loggedInUser.getName());
			userSurrogateDTO.setSurrogateName("");
			userSurrogateDTO.setUserId(loggedInUser.getId());
			userSurrogateList.add(userSurrogateDTO);
		}
		setUsersDTOList(response.getCollection());
	}

	public String getSurrogateEnabled() {
		return surrogateEnabled;
	}

	public void setSurrogateEnabled(String surrogateEnabled) {
		this.surrogateEnabled = surrogateEnabled;
	}

	public static final Comparator<Annotation> ANNOTATION_SORTER = new Comparator<Annotation>() {
		public int compare(Annotation a, Annotation b) {
			if (a == null)
				return 1;
			else if (b == null)
				return -1;
			else {
				Date date1 = a.getCreatedDate();
				Date date2 = b.getCreatedDate();
				if (date2.after(date1))
					return 1;
				else if (date2.before(date1))
					return -1;
				else
					return 0;
			}
		}
	};

	public String getRecipient() {
		return recipient;
	}
	public String getSender() {
		return sender;
	}
	public String getBody() {
		return body;
	}
	public String getSubject() {
		return subject;
	}

	public String getSentDate() {
		return sentDate;
	}

	public String getSurrogate() {
		return surrogate;
	}

	public void setSurrogate(String surrogate) {
		this.surrogate = surrogate;
	}

	public String getSurrogateArray() {
		return surrogateArray;
	}

	public void setSurrogateArray(String surrogateArray) {
		this.surrogateArray = surrogateArray;
	}

	public boolean isReassign() {
		return reassign;
	}

	public Message getMessage() {
		return message;
	}

	public void setMessage(Message message) {
		this.message = message;
	}

	public boolean isAssignable() {
		return assignable;
	}

	public boolean isStatusSelect() {
		return statusSelect;
	}

	public boolean isStatusChangeable() {
		return statusChangeable;
	}

	public boolean isSentFolder() {
		return sentFolder;
	}

	public void setSentFolder(boolean sentFolder) {
		this.sentFolder = sentFolder;
	}

	public String getCompleteMessageSubmit() {
		return completeMessageSubmit;
	}

	public void setCompleteMessageSubmit(String completeMessageSubmit) {
		this.completeMessageSubmit = completeMessageSubmit;
	}

	public String getCompleteMessageCancel() {
		return completeMessageCancel;
	}

	public void setCompleteMessageCancel(String completeMessageCancel) {
		this.completeMessageCancel = completeMessageCancel;
	}

	public List getTriageMembers() {
		return triageMembers;
	}

	public void setTriageMembers(List triageMembers) {
		this.triageMembers = triageMembers;
	}

	public String getReAssignSubmit() {
		return reAssignSubmit;
	}

	public void setReAssignSubmit(String reAssignSubmit) {
		this.reAssignSubmit = reAssignSubmit;
	}

	public String[] getSelectedMessages() {
		return selectedMessages;
	}

	public void setSelectedMessages(String[] selectedMessages) {
		this.selectedMessages = selectedMessages;
	}

	public String getReAssignCancel() {
		return reAssignCancel;
	}

	public void setReAssignCancel(String reAssignCancel) {
		this.reAssignCancel = reAssignCancel;
	}

	public void setrecallMessageSubmit(String recallMessage_submit) {
		this.recallMessageSubmit = recallMessage_submit;
	}

	public String getRecallMessageSubmit(){
		return this.recallMessageSubmit;
	}

	public String getDownloadFileName() {
		return downloadFileName;
	}

	public void setDownloadFileName(String downloadFileName) {
		this.downloadFileName = downloadFileName;
	}

	public String getReminder() {
		return reminder;
	}

	public void setReminder(String reminder) {
		this.reminder = reminder;
	}

	public String getReminderDate() {
		return reminderDate;
	}

	public void setReminderDate(String reminderDate) {
		this.reminderDate = reminderDate;
	}

	public Date getMessageReminderDate() {
		return messageReminderDate;
	}

	public void setMessageReminderDate(Date messageReminderDate) {
		this.messageReminderDate = messageReminderDate;
	}

	public String getProviderCompleteMessageSubmit() {
		return providerCompleteMessageSubmit;
	}

	public void setProviderCompleteMessageSubmit(
			String providerCompleteMessageSubmit) {
		this.providerCompleteMessageSubmit = providerCompleteMessageSubmit;
	}


	public TriageGroupDao getTriageGroupDao() {
		return triageGroupDao;
	}

	public void setTriageGroupDao(TriageGroupDao triageGroupDao) {
		this.triageGroupDao = triageGroupDao;
	}

	public UserDao getUserDao() {
		return userDao;
	}

	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

	public UserManagementService getUserService() {
		return userService;
	}

	public void setUserService(UserManagementService userService) {
		this.userService = userService;
	}

	public MessageService getMessageService() {
		return messageService;
	}

	public void setMessageService(MessageService messageService) {
		this.messageService = messageService;
	}

	public ReAssignMessageService getReAssignMessageService() {
		return reAssignMessageService;
	}

	public void setReAssignMessageService(
			ReAssignMessageService reAssignMessageService) {
		this.reAssignMessageService = reAssignMessageService;
	}

	public Collection<UserSurrogateDTO> getUsersDTOList() {
		return usersDTOList;
	}

	public void setUsersDTOList(Collection<UserSurrogateDTO> usersDTOList) {
		this.usersDTOList = usersDTOList;
	}


	public void setServletRequest(HttpServletRequest httpServletRequest) {
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	public TiuNoteService getTiuNoteService() {
		return tiuNoteService;
	}

	public void setTiuNoteService(TiuNoteService tiuNoteService) {
		this.tiuNoteService = tiuNoteService;
	}

	public SMWorkloadProperties getWorkloadProperties() {
		return workloadProperties;
	}

	public void setWorkloadProperties(SMWorkloadProperties workloadProperties) {
		this.workloadProperties = workloadProperties;
	}

	public FacilityDao getFacilityDao() {
		return facilityDao;
	}
	public void setFacilityDao(FacilityDao facilityDao) {
		this.facilityDao = facilityDao;
	}


	public String getMessageRecallStatus() {
		return messageRecallStatus;
	}

	public void setMessageRecallStatus(String messageRecallStatus) {
		this.messageRecallStatus = messageRecallStatus;
	}

	public Collection getCprsMessageStatus() {
		return cprsMessageStatus;
	}

	public void setCprsMessageStatus(Collection cprsMessageStatus) {
		this.cprsMessageStatus = cprsMessageStatus;
	}
	
	public String getCcRecipient() {
		return ccRecipient;
	}

	public void setCcRecipient(String ccRecipient) {
		this.ccRecipient = ccRecipient;
	}
}