package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dto.SearchFormDTO;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.MailboxService;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;



public class Pagination extends AbstractInboxAction {
	private HttpServletRequest request;
	
	private Folder activeFolder;
	private MailboxService mailboxService;
	
	private String STRUTS_RESULT;

	public Pagination(){
		super();
	}
	
	public void setServletRequest(HttpServletRequest httpServletRequest){
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	public void prepare() throws Exception{
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(
				   ServletActionContext.getServletContext());
		mailboxService = (MailboxService)ctx.getBean("mailboxService");
		User u = (User)request.getSession().getAttribute(CURRENT_USER);
		STRUTS_RESULT = u.getUserType() == UserTypeEnum.PATIENT ? "PATIENT" : "CLINICIAN";
		
		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		messageFilterId = f.getFilter().getId();
		
	}

	private void fetchPage(MessagesPageEnum direction){
		SearchFormDTO sf = (SearchFormDTO)request.getSession().getAttribute(SEARCH_FORM);
		ServiceResponse<Folder> response = null;
		if( sf != null ) {
			response = mailboxService.getMessages(activeFolder, direction,sf);
		} else {
			response = mailboxService.getMessages(activeFolder, direction);
		}
		if( response != null ) {
			Folder f = response.getPayload();
			request.getSession().setAttribute(CURRENT_FOLDER, f);
			messageFilterId = f.getFilter().getId();
		}
	}
	
	private void getActiveFolder(){
		activeFolder = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
	}
	
	public String first(){
		getActiveFolder();
		if(activeFolder.getMessages().getPageNumber() == 0){
			 
			// don't do anything; we are already on the first page
			return STRUTS_RESULT;
		}
		fetchPage(MessagesPageEnum.FIRST);
		return STRUTS_RESULT;
	}
	
	
	public String last(){
		getActiveFolder();
		if(activeFolder.getMessages().isLastPage()){
			// don't do anything; we are already on the last page
			return STRUTS_RESULT;
		}
		fetchPage(MessagesPageEnum.LAST);
		return STRUTS_RESULT;
	}
	
	public String loadCurrentPage(){
		getActiveFolder();
		fetchPage(MessagesPageEnum.CURRENT);
		return STRUTS_RESULT;
	}
	
	public String next(){
		getActiveFolder();
		if(!activeFolder.getMessages().hasNextPage()){
			// don't do anything; there is not a next page
			return STRUTS_RESULT;
		}
		fetchPage(MessagesPageEnum.NEXT);
		return STRUTS_RESULT;
	}
	
	public String prev(){
		getActiveFolder();
		if(!activeFolder.getMessages().hasPreviousPage()){
			// don't do anything; there is not a previous
			return STRUTS_RESULT;
		}
		fetchPage(MessagesPageEnum.PREV);
		return STRUTS_RESULT;
	}
	
}
