package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dao.SignatureDao;
import gov.va.med.mhv.sm.dao.properties.SMAttachmentProperties;
import gov.va.med.mhv.sm.dao.properties.SMWorkloadProperties;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.DistributionGroup;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Mailbox;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessagesPage;
import gov.va.med.mhv.sm.model.NewMessage;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.PatientBlockedTriageGroup;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.TiuNotePreview;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.FacilityService;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.MessageService;
import gov.va.med.mhv.sm.service.PatientBlockedService;
import gov.va.med.mhv.sm.service.SendMessageService;
import gov.va.med.mhv.sm.service.ThreadService;
import gov.va.med.mhv.sm.service.TiuNoteService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.util.UserUtils;
import gov.va.med.mhv.sm.web.utils.PropertiesHelper;
import gov.va.med.mhv.sm.wsclient.IntegrationServiceDelegate;
import gov.va.med.mhv.sm.wsclient.queriessvc.PatientDemographicsResponse;
import gov.va.med.mhv.sm.wsclient.queriessvc.UserLookupResponse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class NewMsg extends AbstractInboxAction implements ServletResponseAware {

	private static final long serialVersionUID = 8235991666751058875L;
	private static final Log log = LogFactory.getLog(NewMsg.class);
	private HttpServletRequest request;
    private SendMessageService sendMessageService;
    private UserManagementService userService;
    private MailboxService mailboxService;
    private PatientBlockedService patientBlockedService;
	private FacilityService facilityService;
	public MessageService messageService;
	private SignatureDao signatureDao;
	private TiuNoteService tiuNoteService;
	private ThreadService threadService;
	private SMWorkloadProperties workloadProperties;

    private String STRUTS_RESULT;
    private String STRUTS_RESULT_CANCEL;
    private String STRUTS_RESULT_INPUT;
    private String STRUTS_RESULT_LOGOUT;

    // Struts properties filled from form
    // or instantiated upon start of message

    private File upload;
    private String uploadContentType;
    private String uploadFileName;

    public User user;
    private String body;
    private String subject;
    private Long triageGroupId;
    private Long messageCategoryId;
    private String smSend;
    private String smCancel;
    private String smSaveDraft;
    private String smSaveDraftAndLogout;
	private String smAttachFile;
    private String pwin;
    private String tab;
    private String addCancel;
    private Long removeId;
    private boolean dgWarning;
    private boolean saveToCPRSPopup;
	private String saveToCPRSSubmit;
    private String dgMessageSubmit;
    
	private List<TriageGroup> triageGroups;
	private HttpServletResponse httpResponse;
    private String attachCancel;
    private static String patientAttachmentSwichStatus=null;
    private String removeAttachment;
    private static String patientAttchmentTestingStatus=null;
    private static String patientAttchmentTestingUsers;
    private static String patientAllowedToAttachFile;
    public static final String SESSION_TRIAGE_GROUP_ID="messageTriageGroupId";
    public static final String SESSION_MESSAGE_BODY="messageBody";
    public static final String SESSION_MESSAGE_SUBJECT="messageSubject";
    public static final String SESSION_MESSAGE_CATEGORY="messageCategory";
    private static final String SAVE_AS_CPRS = "SAVE_AS_TIU";
    private String DEFAULT_SM_CLINIC = "SECURE MESSAGING";
	private String DEFAULT_CPRS_NOTE_TITLE = "SECURE MESSAGING";
    private SMAttachmentProperties smAttachments;
    private TriageGroupService triageGroupService;
    private static final String SM_WEB_NEW_AUTO_SAVE_SWITCH = "sm.web.new.autosave.switch";
    private static String newMessageAutoSaveSwitch="off";
    

    
	private Long totalAttachedSize;
    private String allowedCount;


    public NewMsg(){
    	super();
    }

	public void setServletRequest(HttpServletRequest httpServletRequest) {
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	public void setServletResponse(HttpServletResponse httpServletResponse) {
		//Used only for the AJAX call for auto-save-draft
		this.httpResponse = httpServletResponse;
	}

	 public String getPatientAllowedToAttachFile() {
			return patientAllowedToAttachFile;
	 }

	 public void setPatientAllowedToAttachFile(String patientAllowedToAttachFile) {
			this.patientAllowedToAttachFile = patientAllowedToAttachFile;
	 }

	@SuppressWarnings("unchecked")
	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		sendMessageService = (SendMessageService) ctx.getBean("sendMessageService");
		userService = (UserManagementService)ctx.getBean("userManagementService");
		messageService = (MessageService)ctx.getBean("messageService");
		mailboxService = (MailboxService)ctx.getBean("mailboxService");
		facilityService = (FacilityService)ctx.getBean("facilityService");
		triageGroupService = (TriageGroupService) ctx.getBean("triageGroupService");
		signatureDao = (SignatureDao)ctx.getBean("signatureDao");
		patientBlockedService  = (PatientBlockedService) ctx.getBean("patientBlockedService");
		workloadProperties = ((SMWorkloadProperties)ctx.getBean("smWorkloadProperties"));
		tiuNoteService = (TiuNoteService) ctx.getBean("tiuNoteService");
		threadService = (ThreadService) ctx.getBean("threadService");

		user = (User)request.getSession().getAttribute(CURRENT_USER);
		triageGroups = user.getGroups();
		smAttachments = ((SMAttachmentProperties)ctx.getBean("smAttachmentProperties"));
		if(log.isInfoEnabled()){
			log.info("**************SMAttachments..."+smAttachments.getAttachmentAllowedTypes());
		}
		allowedCount=smAttachments.getAttachmentAllowedCount();
		if(log.isInfoEnabled()){
			log.info("**************Allowed count..."+smAttachments.getAttachmentAllowedCount());
		}
		patientAttachmentSwichStatus = smAttachments.getPatientAttachmentSwitch();
		patientAttchmentTestingStatus = smAttachments.getPatientAttachmentTestingStatus();

		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		messageFilterId = f.getFilter().getId();

		STRUTS_RESULT = user.getUserType() == UserTypeEnum.PATIENT ? "PATIENT" : "CLINICIAN";
		STRUTS_RESULT_CANCEL = STRUTS_RESULT + "_CANCEL";
		STRUTS_RESULT_INPUT = STRUTS_RESULT + "_INPUT";
		STRUTS_RESULT_LOGOUT = "LOGOUT";

    	if(patientAttchmentTestingStatus!=null && patientAttchmentTestingStatus.equalsIgnoreCase("National")){
    			patientAllowedToAttachFile="YES";
    	}else if(patientAttchmentTestingStatus!=null && patientAttchmentTestingStatus.equalsIgnoreCase("Field")){
    				if(smAttachments.getPatientAttachmentTesters()!=null) {
    					setPatientAllowedToAttachFile(isFieldTestingUser(smAttachments.getPatientAttachmentTesters()));
    		}
    	}
    	
    	if(PropertiesHelper.getProperties().containsKey(SM_WEB_NEW_AUTO_SAVE_SWITCH)) {

    		newMessageAutoSaveSwitch = PropertiesHelper.getProperties().getProperty(SM_WEB_NEW_AUTO_SAVE_SWITCH).toLowerCase();
    	}
	}

	private int getMessageIndex(MessagesPage mp, String messageId) {
		int notFoundResult = -1;
		try{
		for (int i = 0; i < mp.getPageSize(); i++) {
			Addressee a = mp.getElements().get(i);
			if (a.getMessage().getId().toString().equals(messageId)) {
				// found correct message
				return i;
			}
		}
		}catch(IndexOutOfBoundsException exp1){
		}
		return notFoundResult;
	}


	public String editDraft(){

		Long messageId = Long.valueOf(request.getParameter("messageId"));
		NewMessage nm;

		Folder activeFolder = (Folder) request.getSession().getAttribute(CURRENT_FOLDER);
		MessagesPage mp = activeFolder.getMessages();
		int index = getMessageIndex(mp, messageId.toString());
		Addressee a = mp.getElements().get(index);

		ServiceResponse<Message> messageServiceResponse = messageService.readMessage(a.getMessage(), user);

		// set the read date in our local copy of the message so that
		// it will be displayed properly on the folder view until it
		// can be refreshed from the database
		a.setReadDate(new Date());

		ServiceResponse<NewMessage> response = sendMessageService.draftToNewMessage(user, messageId);
		nm = response.getPayload();
		
		request.getSession().setAttribute(NEW_MESSAGE, nm);
		request.getSession().setAttribute(DRAFT_MSG_ID, messageId);

		this.subject = nm.getSubject();
		this.messageCategoryTypeId = nm.getMessageCategoryTypeId();
		this.body = nm.getBody();
		if(nm.getTriageGroup() != null)
			this.triageGroupId = nm.getTriageGroup().getId();

		return STRUTS_RESULT;
	}

	public String compose(){
		NewMessage nm = new NewMessage();
		this.setBody(UserUtils.getUserSignature(user.getId(),signatureDao));
		if(subject==null || subject.equals(""))subject = "General Inquiry";
		request.getSession().setAttribute(NEW_MESSAGE, nm);
		request.getSession().setAttribute(DRAFT_MSG_ID, 0L);
		if ( user.getGroups() == null || user.getGroups().isEmpty() ) {
			request.setAttribute("NO_TG_ERROR", STRUTS_RESULT);
		}
		return STRUTS_RESULT;
	}
	
	@SkipValidation
	public String send(){
		String saveToCPRSStatus=request.getParameter("saveToCPRS");
		user = (User)request.getSession().getAttribute(CURRENT_USER);
		//Restore the subject and body values while using search recipients tabs
		if(user.getUserType() == UserTypeEnum.CLINICIAN){
			NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
			//nm.setMessageCategoryTypeId(messageCategoryTypeId);
			if(subject != null){
				nm.setSubject(subject.trim());
			}else{
				subject=nm.getSubject();
			}
			if(body != null){
				nm.setBody(body.trim());
			}else{
				body=nm.getBody();
			}

			if(triageGroupId!=null){
				nm.setTriageGroupId(triageGroupId);
			}else{
				triageGroupId = nm.getTriageGroupId();
			}

			if(messageCategoryTypeId!=null){
				nm.setMessageCategoryTypeId(messageCategoryTypeId);
			}else{
				messageCategoryTypeId = nm.getMessageCategoryTypeId();
			}
			request.getSession().setAttribute(NEW_MESSAGE, nm);
		}
		//End- Restore values


		boolean error = false;

		// if the "Add Recipient" window is up or just closing the
		// do not send the message and don't validate. Just continue.
		if(pwin != null && pwin.trim().length() > 0){
			getSession().setAttribute(SESSION_MESSAGE_BODY, body);
			getSession().setAttribute(SESSION_MESSAGE_SUBJECT, subject);
			getSession().setAttribute(SESSION_MESSAGE_CATEGORY, getMessageCategoryTypeId());
			getSession().setAttribute(SESSION_TRIAGE_GROUP_ID, getTriageGroupId());
			return STRUTS_RESULT_INPUT;
		}

		if(smCancel !=null && smCancel.equals("CANCEL")){
			return STRUTS_RESULT_CANCEL;
		}

		// Do some error checking
		if(StringUtils.isBlank(subject)){
			//addFieldError("subject", "The subject cannot be blank.");
			//6598
			//Prepopulate with the category
			subject=MessageCategoryTypeEnum.valueOf(messageCategoryTypeId).getName() + " Inquiry";
			error = false;
		} else {
			//Double check if JS is off then we have to reset the field to current category
			List<MessageCategoryTypeEnum> list = MessageCategoryTypeEnum.toList();
			for(Iterator i = list.iterator(); i.hasNext();) {
				MessageCategoryTypeEnum cat = (MessageCategoryTypeEnum)i.next();
				if( cat.getId() != MessageCategoryTypeEnum.OTHER.getId() && subject.equals(cat.getName() + " Inquiry")) {
					subject = MessageCategoryTypeEnum.valueOf(messageCategoryTypeId).getName() + " Inquiry";
					break;
				}
			}
		}
		
		
		if(StringUtils.isBlank(body)){
			if(!smSaveDraftAndLogout.equals("CANCEL")){
				addFieldError("body", "The message cannot be blank.");
				error = true;
				return STRUTS_RESULT_INPUT;
			}
		}

		
		if(user.getUserType() == UserTypeEnum.CLINICIAN){
			NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
			if(nm.getTo() == null){
				if(!smSaveDraftAndLogout.equals("CANCEL")){
					addFieldError("recipient", "The recipient has not been identified.");
					return STRUTS_RESULT_INPUT;
				}
			}
		}

		if(!this.hasErrors() && smSaveDraft != null && smSaveDraft.equals("DRAFT")){
			if(error){
				return STRUTS_RESULT_INPUT;
			}else{
				return saveDraft();
			}
		}
		
		if(smSaveDraftAndLogout!=null){
			if(smSaveDraftAndLogout.equals("DRAFT")){
					return saveDraftAndLogout();	
			}else if(smSaveDraftAndLogout.equals("CANCEL")){
				return STRUTS_RESULT_LOGOUT;	
			}
		}

		if(user.getUserType() == UserTypeEnum.CLINICIAN){
			// Patients will always have some recipient (determined later in sendPatient())
			// because there is no blank option in the triage group drop down list
			NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
			if(nm.getTo() == null){
				addFieldError("recipient", "The recipient has not been identified.");
				error = true;
			}


			if(nm.getTo()!=null && nm.getTo().getParticipantType().equals(ParticipantTypeEnum.PATIENT)){
				if(log.isInfoEnabled()){
					log.info("<<<<<<<<<<500-->Prvider selected recipient type is PATIENT..."+nm.getTo().getId());
				}
				PatientBlockedTriageGroup patientBlockedTg = patientBlockedService.getPatientBlockedTriageGroupByTgIdAndPatientId(nm.getTriageGroupId(),nm.getTo().getId()).getPayload();
				if(patientBlockedTg!=null && patientBlockedTg.isBlocked()){
					String  errorMsg = "The patient is restricted from this Triage Group. Contact your My Health<b><i>e</i></b>Vet Coordinator if you have any questions.";
					if(log.isInfoEnabled()){
						log.info("<<<<<<<<500->Provider's New Message restricted error for TgId.."+nm.getTriageGroup()+"^patientId"+nm.getTo().getId());
					}
					addFieldError("recipient",errorMsg);
					error=true;
				}
				// Now check if the facility is blocked.
				ServiceResponse<TriageGroup> triageResp = triageGroupService.findTriageGroupById(nm.getTriageGroupId());
				TriageGroup tGroup = triageResp.getPayload();
				Long stationNumber = Long.valueOf(tGroup.getVistaDiv()).longValue();

				CollectionServiceResponse<PatientBlockedFacility> collectionResponse = patientBlockedService.getBlockedFacilityPatientsByPatientIdAndStation(nm.getTo().getId(), stationNumber);
				Collection<PatientBlockedFacility> patBlockedFacilities = collectionResponse.getCollection();
				if(patBlockedFacilities!=null && patBlockedFacilities.size()>0){
					String  errorMsg = "The patient is restricted from this Triage Group. Contact your My Health<b><i>e</i></b>Vet Coordinator if you have any questions.";
					if(log.isInfoEnabled()){
						log.info("<<<<<<<<500->Provider's New Message restricted error for blocked from Facility.."+stationNumber+"^patientId"+nm.getTo().getId());
					}
					addFieldError("recipient",errorMsg);
					error=true;
				}
			}
			if(nm.getTo()!=null && nm.getTo().getParticipantType().equals(ParticipantTypeEnum.PATIENT)){
				if(saveToCPRSStatus==null || saveToCPRSStatus.equals("")){
					setSaveToCPRSPopup(true);
					return STRUTS_RESULT_INPUT;
				}
				else if(saveToCPRSStatus!=null){
					setSaveToCPRSPopup(false);
				}
			}
			
			// To DO.. check if the message is to dg, then display popup...
			if(nm.getTo()!=null && nm.getTo().getParticipantType().equals(ParticipantTypeEnum.DISTRIBUTION_GROUP)){
					String dgWarningAcceptStatus=request.getParameter("dgMessageAccept");
					if(dgWarningAcceptStatus==null || dgWarningAcceptStatus.equals("")){
						setDgWarning(true);
						return STRUTS_RESULT_INPUT;
					}
					else if(dgWarningAcceptStatus!=null && dgWarningAcceptStatus.equalsIgnoreCase("No")){
						setDgWarning(false);
						return STRUTS_RESULT_INPUT;
					}
				}
		}



		if(error)
			return STRUTS_RESULT_INPUT;

		if(user.getUserType() == UserTypeEnum.PATIENT){
			return sendPatient();
		}else{
			if(saveToCPRSStatus!=null&&saveToCPRSStatus.equalsIgnoreCase("Yes")) return sendClinician(true); 
			return sendClinician(false);
		}

	}

	private String sendClinician(boolean saveToCPRS){
		NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
		if(nm.getTo() == null){
			addActionError("Recipient has not been identified");
			return STRUTS_RESULT_INPUT;
		}
		nm.setMessageCategoryTypeId(messageCategoryTypeId);
		nm.setSubject(subject);
		nm.setBody(body);

		// the triage group is really only necessary
		// for sending message to patients but set
		// it for all messages just in case
		for(TriageGroup tg : user.getGroups()){
			if(tg.getId().equals(triageGroupId)){
				nm.setTriageGroup(tg);
				break;
			}
		}
		nm.setFrom(user);


		if(nm.isDraft()){
			ServiceResponse<Message> response = sendDraft(nm);
			if(handleMessages(response)){
				return STRUTS_RESULT_INPUT;
			}else{
				addActionError("Your message has been successfully sent.");
				if(saveToCPRS){
					return previewProgressNotes(response);
				}
			}
			/*if(!sendDraft(nm)){
				return STRUTS_RESULT_INPUT;
			}*/
		}else{
			ServiceResponse<Message> response = sendMessageService.send(nm);
			if(handleMessages(response)){
				return STRUTS_RESULT_INPUT;
			}else{
				addActionError("Your message has been successfully sent.");
				if(saveToCPRS){
					return previewProgressNotes(response);
				}
				
			}
		}

		return STRUTS_RESULT;
	}

	private String previewProgressNotes(ServiceResponse<Message> messageResponse){
		Long messageId =  messageResponse.getPayload().getId();
		ServiceResponse<Message> serviceResponse = messageService.fetchMessage(messageId);
		Message message = serviceResponse.getPayload(); 	
		if(log.isInfoEnabled()){
			log.info("New Message ID Created in PreviewProgressNotes"+messageId);
		}
		ServiceResponse<TiuNotePreview> response = tiuNoteService.getNotePreviewForNewMessage(message,(Clinician)user,message.getRecipientId());
		Long triageGroupId = message.getThread().getMailGroup().getId();
		SMClinicsTriageMap clinicsTriageMap = triageGroupService.getActiveSMClinicByTriageGroup(triageGroupId);
		if(handleMessages(response)){
			request.setAttribute("TIU_ERRORS", Boolean.TRUE);
		}
		TiuNotePreview preview = response.getPayload();
		preview.setCurrentMessageId(message.getId());
		preview.setNewMessage(true);
		if(preview!=null){
			preview.setClinicName(DEFAULT_SM_CLINIC);
			preview.setCprsTitle(DEFAULT_CPRS_NOTE_TITLE);
			if(clinicsTriageMap!=null && clinicsTriageMap.getSmClinicName()!=null){
				preview.setClinicName(clinicsTriageMap.getSmClinicName());
				preview.setClinicIen(clinicsTriageMap.getSmClinicIen());
			}
			if(clinicsTriageMap!=null && clinicsTriageMap.getSmClinicNameCPRSTitle()!=null)
				preview.setCprsTitle(clinicsTriageMap.getSmClinicNameCPRSTitle());
			preview.setVistAPatch11Status(workloadProperties.getVistAPatch11Status());
			preview.setVistAPatch11Fields(workloadProperties.getVistAPatch11Fields());
		}
		request.getSession().setAttribute("notePreview", preview);
		request.getSession().setAttribute(CURRENT_MESSAGE,message);
		return SAVE_AS_CPRS;
	}
	
	
	private String sendPatient(){

		NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);

		if(triageGroupId == null){
			addFieldError("recipient", "The recipient has not been identified.");
			return STRUTS_RESULT_INPUT;
		}

		for(TriageGroup tg : user.getGroups()){
			if(tg.getId().equals(triageGroupId)){
				nm.setTo(tg);
				nm.setTriageGroup(tg);
				break;
			}
		}

		nm.setMessageCategoryTypeId(messageCategoryTypeId);

		nm.setSubject(subject);
		nm.setBody(body);
		nm.setFrom(user);


		if(nm.isDraft()){
			ServiceResponse<Message> response = sendDraft(nm);
			if(handleMessages(response)){
				return STRUTS_RESULT_INPUT;
			}else{
				addActionError("Your message has been successfully sent.");
				return STRUTS_RESULT;
			}
			/*if(!sendDraft(nm)){
				return STRUTS_RESULT_INPUT;
			}*/
		}else{
			ServiceResponse<Message> response = sendMessageService.send(nm);
			addActionError("Your message has been successfully sent.");
			if(handleMessages(response)){
				return STRUTS_RESULT_INPUT;
			}
		}


		return STRUTS_RESULT;
	}

	public void autoSaveDraft(){
		NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
		nm.setMessageCategoryTypeId(messageCategoryTypeId);
		nm.setSubject(subject);
		nm.setBody(body);
		for(TriageGroup tg : user.getGroups()){
			if(tg.getId().equals(triageGroupId)){
				nm.setTriageGroup(tg);
				break;
			}
		}
		nm.setFrom(user);
		nm.setDraft(true);

		/**
		 * If the messageId in the Session is '0' then it is a new compose message.
		 */
		Long messageId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);
		ServiceResponse<Message> svcResponse = sendMessageService.saveDraft(nm, messageId);

		/**
		 * If the messageId was '0' then we just overwrite it so that any subsequent autosave
		 * calls use the same messageId for the draft and don't create a new message.
		 */
		Message m = svcResponse.getPayload();
		request.getSession().setAttribute(DRAFT_MSG_ID, m.getId());

		///Handle Errors?
		int count = 0;
		if(messageId == null || messageId.equals(0L)){
			User u = (User)request.getSession().getAttribute(CURRENT_USER);
			Mailbox mailbox = u.getMailbox();
			Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
			drafts.setCount(drafts.getCount() + 1);
			count = drafts.getCount();
		} else {
			User u = (User)request.getSession().getAttribute(CURRENT_USER);
			Mailbox mailbox = u.getMailbox();
			Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
			count = drafts.getCount();
		}

		Long id = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);

		//force a response of just a simple JSON String with DRAFT_MSG_ID and Folder 'drafts' count.
		String responseTxt = "{draftFolderCnt:"+count+"}"; //future may need this:  draftMsgId:"+id+",

		try {
			httpResponse.getWriter().write(responseTxt);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	private String saveDraft(){


		NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
		nm.setMessageCategoryTypeId(messageCategoryTypeId);
		nm.setSubject(subject);
		nm.setBody(body);
		for(TriageGroup tg : user.getGroups()){
			if(tg.getId().equals(triageGroupId)){
				nm.setTriageGroup(tg);
				break;
			}
		}
		nm.setFrom(user);

		
		
		Long messageId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);
		ServiceResponse<Message> response = sendMessageService.saveDraft(nm, messageId);

		if(handleMessages(response)){
			return STRUTS_RESULT_INPUT;
		}


		if(messageId == null || messageId.equals(0L)){
			User u = (User)request.getSession().getAttribute(CURRENT_USER);
			Mailbox mailbox = u.getMailbox();
			Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
			drafts.setCount(drafts.getCount() + 1);
		}
		// if we are currently in the drafts folder then we need to refresh it
		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		if(f.getId() == SystemFolderEnum.DRAFTS.getId()){
			mailboxService.getMessages(f);
		}
		return "SAVE_DRAFT";
	}
	
	
	private String saveDraftAndLogout(){
		try{
			NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
			nm.setMessageCategoryTypeId(messageCategoryTypeId);
			nm.setSubject(subject);
			nm.setBody(body);
			for(TriageGroup tg : user.getGroups()){
				if(tg.getId().equals(triageGroupId)){
					nm.setTriageGroup(tg);
					break;
				}
			}
			nm.setFrom(user);
	
			Long messageId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);
			ServiceResponse<Message> response = sendMessageService.saveDraft(nm, messageId);
	
		}catch(Exception e){
			if(log.isErrorEnabled()){
				log.error("New Save Draft and Logout - Error occured for user->"+user.getId()+"^Error:"+e);
			}
		}
		return STRUTS_RESULT_LOGOUT;
	}

	@SuppressWarnings("unchecked")
	public String addRecipient(){

		// reset the pwin parameter
		pwin = "";

		User user = (User)request.getSession().getAttribute(CURRENT_USER);
		String tab=request.getParameter("tab");

		/*setBody((String)getSession().getAttribute(SESSION_MESSAGE_BODY));
		setSubject((String)getSession().getAttribute(SESSION_MESSAGE_SUBJECT));
		setMessageCategoryTypeId((Long)getSession().getAttribute(SESSION_MESSAGE_CATEGORY));
		setTriageGroupId((Long)getSession().getAttribute(SESSION_TRIAGE_GROUP_ID));
	    */

		if("1".equals(tab))	{
			if(request.getParameter("search") != null){
				String firstName = (String)request.getParameter("firstName");
				if (firstName != null)
					firstName=firstName.trim();
				String lastName = (String)request.getParameter("lastName");
				if (lastName != null)
					lastName=lastName.trim();
				String nssn = (String)request.getParameter("nssn");
				if (nssn != null)
					nssn=nssn.trim();
				request.getSession().setAttribute("firstName", firstName);
				request.getSession().setAttribute("lastName", lastName);
				request.getSession().setAttribute("nssn", nssn);

				Clinician c = (Clinician)user;

				try{

					CollectionServiceResponse<Patient> response = userService.searchForPatients(firstName, lastName, nssn, c.getStationNo());
					Collection<Patient> responsePatients = response.getCollection();

					//Collection<Patient> sortedPts = new TreeSet<Patient>(User.USER_BY_NAME_SORTER);
					List<Patient> sortedPts = new ArrayList<Patient>();
						for(Patient patient:responsePatients){
							if(patient.getStatus().getId().equals(UserStatusEnum.OPT_IN.getId()))
							{
								sortedPts.add(patient);
							}
						}
					Collections.sort(sortedPts,User.USER_BY_NAME_SORTER);
					request.getSession().setAttribute("patients", sortedPts);
				}catch(Exception e){
					/* no op */
				}

				return "select";
			}
			else if(request.getParameter("select")!=null){
				Long id=null;
				try	{
					id = new Long((String)request.getParameter("recipient"));
				}catch(Exception e){
					return "select";
				}
				Collection<Patient> pts = (Collection<Patient>)request.getSession().getAttribute("patients");
				User recipient = null;
				for(Patient p : pts){
					if(p.getId().equals(id)){
						recipient = p;
						request.getSession().setAttribute("recipient", recipient);
						WebApplicationContext ctx = WebApplicationContextUtils
						.getWebApplicationContext(ServletActionContext
								.getServletContext());
						IntegrationServiceDelegate delegate = (IntegrationServiceDelegate)ctx.getBean("integrationServiceDelegate");
						PatientDemographicsResponse pdr = null;
						try
						{
							request.getSession().removeAttribute("recipientDemographics");
							/* FORTIFY SCAN REMOVE:
							 * log.debug("About to get patient demographics for " + p.getSsn() + " on station " + ((Clinician)user).getStationNo());
							 */
							pdr = delegate.getPatientDemographics(p.getSsn(), ((Clinician)user).getStationNo());

							if("Ok".equalsIgnoreCase(pdr.getStatus())) {
								if (pdr.getPatient()!= null) {
									// SUCCESS
									/* FORTIFY SCAN REMOVE:
									log.debug("Found patient demographics for " + pdr.getPatient().getFirstName() + " " + pdr.getPatient().getLastName());
									*/
									request.getSession().setAttribute("recipientDemographics", pdr.getPatient());
								}
								 else {
										/* FORTIFY SCAN CHANGE */
									 if(log.isErrorEnabled()){
										 log.error("No patients found matching  for " + p.getId() + "  and station " + ((Clinician)user).getStationNo());
									 }
								 }
							} else {
								if(log.isErrorEnabled()){
									log.error("Patient demographics query for " + p.getId() + " returned " + pdr.getStatus() + ": conversationID = " + pdr.getConversationID());
								}
							}
						} catch (Exception e) {
							if(log.isErrorEnabled()){
								log.error("Exception raised trying to retrieve patient demographics for " + p.getId());
							}
							if (pdr == null) {
								if(log.isErrorEnabled()){
									log.error("No conversation ID");
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("Conversation ID = " + pdr.getConversationID());
								}
							}
							e.printStackTrace();
						}
						break;
					}
				}
				return "select";
			}
			else if(request.getParameter("add")!=null || request.getParameter("cancel")!=null)
			{
				if(request.getParameter("add")!=null)
				{
					NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
					User recipient = (User)request.getSession().getAttribute("recipient");
					nm.setTo(recipient);
					request.getSession().setAttribute(NEW_MESSAGE, nm);
				}
				//cleanup
				request.getSession().removeAttribute("patients");
				request.getSession().removeAttribute("firstName");
				request.getSession().removeAttribute("lastName");
				request.getSession().removeAttribute("nssn");
				request.getSession().removeAttribute("recipient");
				request.getSession().removeAttribute("recipientDemographics");
			}
		}
		if("2".equals(tab))	{
			if(request.getParameter("search") != null){

				String lastName = (String)request.getParameter("lastName");
				// must provide a last name
				if(StringUtils.isBlank(lastName)) return "select";
				lastName=lastName.trim();

				String firstName = (String)request.getParameter("firstName");
				if (firstName != null)
					firstName=firstName.trim();

				request.getSession().setAttribute("firstName", firstName);
				request.getSession().setAttribute("lastName", lastName);

				try {
					CollectionServiceResponse<Clinician> response = userService
							.searchForClinicians(firstName, lastName,
									((Clinician) user).getStationNo(), true);
					Collection<Clinician> pts = response.getCollection();

					//Collection<Clinician> sortedClinicians = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER);
					//sortedClinicians.addAll(pts);
					//request.getSession().setAttribute("clinicians", sortedClinicians);
					request.getSession().setAttribute("clinicians", pts);
				} catch (Exception e) {
					addActionError("Search resulted in error.");
					return "select";
				}
				return "select";
			}
			else if(request.getParameter("select")!=null){
				Long id=null;
				try	{
					id = new Long((String)request.getParameter("recipient1"));
				}catch(Exception e){
					return "select";
				}
				Collection<Clinician> cns = (Collection<Clinician>)request.getSession().getAttribute("clinicians");
				User recipient = null;
				for(Clinician c : cns){
					if(c.getId().equals(id)){
						recipient = c;
						request.getSession().setAttribute("recipient1", recipient);
						WebApplicationContext ctx = WebApplicationContextUtils
						.getWebApplicationContext(ServletActionContext
								.getServletContext());
						IntegrationServiceDelegate delegate = (IntegrationServiceDelegate)ctx.getBean("integrationServiceDelegate");
						UserLookupResponse ulr = null;
						try
						{
							request.getSession().removeAttribute("recipient1Facility");
							request.getSession().removeAttribute("recipient1Demographics");

							Facility f = facilityService.getFacilityByStationNumber(c.getStationNo()).getPayload();
							if (f != null) {
								request.getSession().setAttribute("recipient1Facility", f.getName());
							} else {
								if(log.isErrorEnabled()){
									log.error("No facility for station " + c.getStationNo());
								}
							}
							if(log.isDebugEnabled()){
								log.debug("About to get user demographics for " + c.getFirstName() + " " + c.getLastName() + ", using DUZ=" + c.getDuz() + " on station " + c.getStationNo());
							}
							boolean userFound = false;
							ulr = delegate.getUserDemographics(null, null, c.getDuz(), c.getStationNo());
							if("Ok".equalsIgnoreCase(ulr.getStatus())) {
								if (ulr.getUsers()!= null && ulr.getUsers().length > 0) {
									// SUCCESS
									if(log.isDebugEnabled()){
										log.debug("Found clinician demographics for " + ulr.getUsers().length + " users");
									}
									gov.va.med.mhv.sm.wsclient.queriessvc.User[] users = ulr.getUsers();
									if (users.length != 1) {
										if(log.isErrorEnabled()){
											log.error("User demographics query retrieved " + users.length + " results when only 1 was expected: conversationID = " + ulr.getConversationID());
										}
									} else if (users[0] != null) {
										userFound = true;
										if(log.isDebugEnabled()){
											log.debug("User demographics found: " + users[0].getFirstName() + " " + users[0].getLastName() + ": department = " + users[0].getDepartment() + ", phone = " + users[0].getPhone());
										}
										request.getSession().setAttribute("recipient1Demographics", users[0]);
									}
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("User demographics query for " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo() + " returned " + ulr.getStatus() + ": conversationID = " + ulr.getConversationID());
								}
							}
							if (!userFound) {
								if(log.isErrorEnabled()){
									log.error("No users found matching " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo());
								}
							}
						} catch (Exception e) {
							if(log.isErrorEnabled()){
								log.error("Exception raised trying to retrieve user demographics for = " + c.getFirstName() + " " + c.getLastName() + ": DUZ/station = " + c.getDuz() + "/" + c.getStationNo());
							}
							if (ulr == null) {
								if(log.isErrorEnabled()){
									log.error("No conversation ID");
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("Conversation ID = " + ulr.getConversationID());
								}
							}
							e.printStackTrace();
						}
						break;
					}
				}
				return "select";
			}
			else if(request.getParameter("add")!=null || request.getParameter("cancel")!=null)
			{
				if(request.getParameter("add")!=null)
				{
					NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
					User recipient = (User)request.getSession().getAttribute("recipient1");
					nm.setTo(recipient);
					request.getSession().setAttribute(NEW_MESSAGE, nm);
				}
				//cleanup
				request.getSession().removeAttribute("clinicians");
				request.getSession().removeAttribute("firstName");
				request.getSession().removeAttribute("lastName");
				request.getSession().removeAttribute("recipient1");
			}
		}
		else if("3".equals(tab))
		{
			if(request.getParameter("add")!=null)
			{
				NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
				String id = request.getParameter("TriageGroup");
				for(TriageGroup tg : triageGroups)
				{
					if(tg.getId().toString().equals(id))
					{
						nm.setTo(tg);
						request.getSession().setAttribute(NEW_MESSAGE, nm);
					}
				}
			}
		}
		else if("4".equals(tab));
		{
			if(request.getParameter("add")!=null)
			{
				NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
				String id = request.getParameter("DistributionGroup");
				for(DistributionGroup dg : ((Clinician)user).getDistGroups())
				{
					if(dg.getId().toString().equals(id))
					{
						nm.setTo(dg);
						request.getSession().setAttribute(NEW_MESSAGE, nm);
					}
				}
			}
		}
		request.setAttribute("doneAddRec", "yes");
		return STRUTS_RESULT;
	}


	private ServiceResponse<Message> sendDraft(NewMessage nm){

		Long messageId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);
		ServiceResponse<Message> response = sendMessageService.sendDraft(nm, messageId);

		if(handleMessages(response)){
			return response;
		}

		request.getSession().setAttribute(DRAFT_MSG_ID, 0L);

		// remove the draft from the mailbox
		User u = (User)request.getSession().getAttribute(CURRENT_USER);
		Mailbox mailbox = u.getMailbox();
		Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
		drafts.setCount(drafts.getCount() - 1);

		// if we are currently in the drafts folder then we need to refresh it
		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		if(f.getId() == SystemFolderEnum.DRAFTS.getId()){
			mailboxService.getMessages(f);
		}

		return response;
	}


	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public Long getTriageGroupId() {
		return triageGroupId;
	}

	public void setTriageGroupId(Long triageGroupId) {
		this.triageGroupId = triageGroupId;
	}

	public void setSmSend(String smSend) {
		this.smSend = smSend;
	}

	public void setSmCancel(String smCancel) {
		this.smCancel = smCancel;
	}

	public List<TriageGroup> getTriageGroups() {
		return triageGroups;
	}

	public void setTriageGroups(List<TriageGroup> triageGroups) {
		this.triageGroups = triageGroups;
	}

	public String getPwin() {
		return pwin;
	}

	public void setPwin(String pwin) {
		this.pwin = pwin;
	}

	public String getTab() {
		return tab;
	}

	public void setTab(String tab) {
		this.tab = tab;
	}

	public String getAddCancel() {
		return addCancel;
	}

	public void setAddCancel(String addCancel) {
		this.addCancel = addCancel;
	}

	public String getSmSend() {
		return smSend;
	}

	public String getSmCancel() {
		return smCancel;
	}

	public String getSmSaveDraft() {
		return smSaveDraft;
	}
	public void setSmSaveDraft(String smSaveDraft) {
		this.smSaveDraft = smSaveDraft;
	}

	public MessageService getMessageService() {
		return messageService;
	}

	public void setMessageService(MessageService messageService) {
		this.messageService = messageService;
	}


	public String getSmAttachFile() {
		return smAttachFile;
	}

	public void setSmAttachFile(String smAttachFile) {
		this.smAttachFile = smAttachFile;
	}

	public File getUpload() {
		return upload;
	}

	public void setUpload(File upload) {
		this.upload = upload;
	}

	public String getUploadContentType() {
		return uploadContentType;
	}

	public void setUploadContentType(String uploadContentType) {
		this.uploadContentType = uploadContentType;
	}

	public String getUploadFileName() {
		return uploadFileName;
	}

	public void setUploadFileName(String uploadFileName) {
		this.uploadFileName = uploadFileName;
	}


	public String getAttachCancel() {
		return attachCancel;
	}

	public void setAttachCancel(String attachCancel) {
		this.attachCancel = attachCancel;
	}


	public static String getPatientAttachmentSwichStatus() {
		return patientAttachmentSwichStatus;
	}

	public static void setPatientAttachmentSwichStatus(
			String patientAttachmentSwichStatus) {
		NewMsg.patientAttachmentSwichStatus = patientAttachmentSwichStatus;
	}

	public String getRemoveAttachment() {
		return removeAttachment;
	}

	public void setRemoveAttachment(String removeAttachment) {
		this.removeAttachment = removeAttachment;
	}


	/*public String getAllowedSize() {
		return allowedSize;
	}

	public void setAllowedSize(String allowedSize) {
		this.allowedSize = allowedSize;
	}*/

	/*public String getAllowedTypes() {
		return allowedTypes;
	}

	public void setAllowedTypes(String allowedTypes) {
		this.allowedTypes = allowedTypes;
	}*/

    public Long getRemoveId() {
		return removeId;
	}

	public void setRemoveId(Long removeId) {
		this.removeId = removeId;
	}

	public Long getTotalAttachedSize() {
			return totalAttachedSize;
	}

	public void setTotalAttachedSize(Long totalAttachedSize) {
			this.totalAttachedSize = totalAttachedSize;
	}

	public String getAllowedCount() {
		return allowedCount;
	}

	public void setAllowedCount(String allowedCount) {
		this.allowedCount = allowedCount;
	}

	public SMAttachmentProperties getSmAttachments() {
			return smAttachments;
	}

	public void setSmAttachmentProperties(
				SMAttachmentProperties smAttachments) {
			this.smAttachments = smAttachments;
	}

	public Long getMessageCategoryId() {
		return messageCategoryId;
	}

	public void setMessageCategoryId(Long messageCategoryId) {
		this.messageCategoryId = messageCategoryId;
	}

	public boolean getDgWarning() {
		return dgWarning;
	}

	public void setDgWarning(boolean dgWarning) {
		this.dgWarning = dgWarning;
	}

	public String getDgMessageSubmit() {
		return dgMessageSubmit;
	}

	public void setDgMessageSubmit(String dgMessageSubmit) {
		this.dgMessageSubmit = dgMessageSubmit;
	}
	
	public static String getNewMessageAutoSaveSwitch() {
		return newMessageAutoSaveSwitch;
	}

	public static void setNewMessageAutoSaveSwitch(String newMessageAutoSaveSwitch) {
		NewMsg.newMessageAutoSaveSwitch = newMessageAutoSaveSwitch;
	}
	
	public String getSmSaveDraftAndLogout() {
		return smSaveDraftAndLogout;
	}

	public void setSmSaveDraftAndLogout(String smSaveDraftAndLogout) {
		this.smSaveDraftAndLogout = smSaveDraftAndLogout;
	}
	
	public boolean isSaveToCPRSPopup() {
			return saveToCPRSPopup;
	}

	public void setSaveToCPRSPopup(boolean saveToCPRSPopup) {
			this.saveToCPRSPopup = saveToCPRSPopup;
	}
	
}