package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.enumeration.MessageFilterEnum;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Mailbox;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.SubFolder;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.web.utils.ut;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MBLeftNav extends AbstractInboxAction {

	private static final long serialVersionUID = 1724844057199102033L;

	private static final Log LOG = LogFactory.getLog(MBLeftNav.class);

	private HttpServletRequest request;
	private MailboxService mailboxService;

	private String STRUTS_RESULT;

	private String mbLeftNavSubmit = null;
	private String addFolder_submit = null;
	private String renameFolder_submit = null;
	private String deleteFolder_submit = null;
	private String myFolderName = null;
	private String folderName = null;

	
	
	public MBLeftNav(){
		super();
	}

	public void setServletRequest(HttpServletRequest httpServletRequest) {
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	public void prepare() throws Exception {
		super.prepare();
		mailboxService = (MailboxService) getBean("mailboxService");
		STRUTS_RESULT = (isPatient(getCurrentUser())) ? "PATIENT" : "CLINICIAN";
	}

	public String execute() {
		final User user = getCurrentUser();

		String proposedFolder = getMBLeftNavSubmit();
		Folder currentFolder = getCurrentFolder();
		
		request.getSession().setAttribute("proposedFolder",proposedFolder);
		//Reset the search form
		request.getSession().removeAttribute(SEARCH_FORM);
		//Reset the subfolder
		currentFolder.setCurrentSubFolderId(null);

		MessageFilterEnum f = user.getMessageFilter();
		if (proposedFolder == null) {
			// this should be the case on first display of the inbox
			// otherwise it is an error so assume it should be the inbox
			if (LOG.isDebugEnabled()) {
				LOG.debug("No current or proposed folder for user '" +
					getCurrentUserName() + "'. Opening 'Inbox'.");
			}
			currentFolder = getCurrentUserInbox();
			currentFolder.setFilter(f);
		} else {
			currentFolder = ut.getActiveFolder(request);
			if( currentFolder == null ) {
				//Probably a subfolder type
				//Right now only Inbox has sub type.  But in the future we can search for the name
				currentFolder = ut.getActiveFolder(request, SystemFolderEnum.INBOX.getName());
				SubFolder sf = ut.getActiveSubFolder(request, currentFolder);
				currentFolder.setCurrentSubFolderId(sf.getId());
			}
			currentFolder.setFilter(f);
		}

		if (LOG.isDebugEnabled()) {
			LOG.debug("Fetch messages in folder '" + proposedFolder +
				"' for user '" + getCurrentUserName() + "'");
		}
		//handleMessages(mailboxService.getMessages(currentFolder, currentSubFolder));

		addCurrentUserFolder(currentFolder, true);

		if (isClinician(user)) {
			mailboxService.updateCounts((Clinician)user);
		} else {
			mailboxService.updateCounts((Patient)user);
		}

		messageFilterId = currentFolder.getFilter().getId();
		setCurrentFolder(currentFolder);
		filterMessages();

		return STRUTS_RESULT;
	}

	public String filterMessages() {

		Folder currentFolder = getCurrentFolder();
		MessageFilterEnum messageFilter = MessageFilterEnum.valueOf(
			messageFilterId);
		if (messageFilter == null) {
			messageFilter = MessageFilterEnum.ALL;
		}

		// only fetch messages if the filter has changed.
		// and if changed reset to the FIRST page
		//if(currentFolder.getFilter() != messageFilter){
		if(currentFolder.getId() != SystemFolderEnum.DELETED.getId()){
			currentFolder.setFilter(messageFilter);
		}

		//Call mailboxService and update the currentFolder counts with filter.
		mailboxService.getMessages(currentFolder, MessagesPageEnum.FIRST);

		//Make sure to refresh the Session instance of the Folder
		// (The counts may have been updated because of the current filter)
		setCurrentFolder(currentFolder);

		return STRUTS_RESULT;
	}

	public String saveNewFolder() {
		final String submitValue = getAddFolder_submit();


		if (submitValue !=null && submitValue.equalsIgnoreCase("Cancel")){
			return STRUTS_RESULT;
		}

		String errorText = validateFolderName(getFolderName());
		if (errorText != null) {
			addActionError(errorText);
			return "WITHOUTSUCCESS";
		}

		Folder newFolder = new Folder();
		newFolder.setName(getFolderName());
		newFolder.setOwner(getCurrentUser());
		mailboxService.addUserFolder(newFolder);

		getMailBoxAndSetInBoxAsCurrentFolder();
		return STRUTS_RESULT;
	}

	public String renameFolder() {
		String newFolderName = getMyFolderNameFromSession();

		final String submitVal = StringUtils.defaultString(
			getRenameFolder_submit());
		if (submitVal.equalsIgnoreCase("Submit")){
			String errorText = validateFolderName(getFolderName());
			if (errorText != null) {
				addActionError(errorText);
				return SUCCESS;
			}

			for (Folder folder: getUserFolders()) {
				if (isNamedFolder(folder, newFolderName)) {
					folder.setName(folderName);
					mailboxService.renameUserFolder(folder);
					break;
				}
			}
		}
		getMailBoxAndSetInBoxAsCurrentFolder();
		return STRUTS_RESULT;
	}

	public String deleteFolder() {
		String toDeleteFolderName = getMyFolderNameFromSession();

		String submitVal = getDeleteFolder_submit();
		if (submitVal.equalsIgnoreCase("Yes")) {
			for (Folder folder: getUserFolders()) {
				if (isNamedFolder(folder, toDeleteFolderName)) {
					if (folder.getCount() < 1){
						mailboxService.deleteUserFolder(folder.getId());
					} else{
						addActionError("This folder still contains messages. " +
							"Before this folder can be deleted, all of the " +
							"messages it contains must be removed.");
					}
					break;
				}
			}
		}
		getMailBoxAndSetInBoxAsCurrentFolder();
		return STRUTS_RESULT;
	}


	public String addNewFolder() {
		getMailBoxAndSetInBoxAsCurrentFolder();
		return STRUTS_RESULT;
	}

	public String renameFolders() {
		setMyFolderNameInSession(getMyFolderName());
		return SUCCESS;
	}

	public String deleteFolders() {
		String folderName = getMyFolderName();
		setMyFolderNameInSession(folderName);
		for (Folder folder: getUserFolders()){
			if (isNamedFolder(folder, folderName)) {
				request.setAttribute("DEL_FOLDER", folder);
			}
		}
		return SUCCESS;
	}

	public String manageFolders() {
		getMailBoxAndSetInBoxAsCurrentFolder();
		return SUCCESS;
	}

	public String getFolderName() {
		return folderName;
	}
	public void setFolderName(String folderName) {
		this.folderName = StringUtils.trim(folderName);
	}

	public void setMBLeftNavSubmit(String mbLeftNavSubmit) {
		this.mbLeftNavSubmit = mbLeftNavSubmit;
	}
	public String getMBLeftNavSubmit() {
		return mbLeftNavSubmit;
	}

	public String getAddFolder_submit() {
		return addFolder_submit;
	}
	public void setAddFolder_submit(String addFolder_submit) {
		this.addFolder_submit = StringUtils.defaultString(addFolder_submit);
	}

	public String getRenameFolder_submit() {
		return renameFolder_submit;
	}
	public void setRenameFolder_submit(String renameFolder_submit) {
		this.renameFolder_submit = StringUtils.defaultString(
			renameFolder_submit);
	}


	public String getDeleteFolder_submit() {
		return deleteFolder_submit;
	}

	public void setDeleteFolder_submit(String deleteFolder_submit) {
		this.deleteFolder_submit = StringUtils.defaultString(
			deleteFolder_submit);
	}

	public String getMyFolderName() {
		return myFolderName;
	}
	public void setMyFolderName(String myFolderName) {
		this.myFolderName = myFolderName;
	}

	protected User getCurrentUser() {
		User user = super.getCurrentUser();
		Precondition.assertTrue(isPatient(user) || isClinician(user),
			"'user' must be a patient or a clinician");
		return user;
	}

	private void setMyFolderNameInSession(String folderName) {
		getSession().setAttribute("MY_FOLDER_NAME", folderName);
	}
	private String getMyFolderNameFromSession() {
		return (String) getSession().getAttribute("MY_FOLDER_NAME");
	}

	protected void getMailBoxAndSetInBoxAsCurrentFolder() {
		final User user = getCurrentUser();
		if (isPatient(user)){
			mailboxService.getMailbox((Patient) user);
		} else {
			mailboxService.getMailbox((Clinician) user);
		}
		setCurrentFolder(getCurrentUserInbox());
	}

	/**
	 * Check if the current user has a folder with a given name.
	 * @param folderName The name of the folder to check
	 * @return true when the user has a folder with the given name;
	 *    false otherwise.
	 */
	private boolean hasFolderAlready(String folderName) {
		final User user = getCurrentUser();
		assert (user != null) : "user is null";
		assert (!StringUtils.isBlank(folderName)) : "folderName is blank";
		Mailbox mailbox = user.getMailbox();
		if (mailbox == null) {
			return false;
		}
		Map<Long, Folder> folders = getCurrentUserFolders();
		if (folders != null) {
			for (Folder folder: folders.values()){
				if (isNamedFolder(folder, folderName)) {
					return true;
				}
			}
		}
		return false;
	}

	@SuppressWarnings("unchecked")
	private List<Folder> getUserFolders() {
		Mailbox mailbox = getCurrentUserMailbox();
		if (mailbox == null) {
			return Collections.EMPTY_LIST;
		}
		return mailbox.getUserFolders();
	}

	private String validateFolderName(String folderName) {
		if(StringUtils.isBlank(folderName)){
			return "Folder name should not be blank.";
		}
		if(!StringUtils.isAlphanumericSpace(folderName)){
			return "Folder name should only contain letters, numbers, and " +
				"spaces.";
		}
		if (hasFolderAlready(folderName)) {
			// Folder names must be unique for the current user
			return "You already have the same folder name. Please enter " +
				"different folder name.";

		}
		return null;
	}

	private boolean isNamedFolder(Folder folder, String folderName) {
		return (folder != null) && (folder.getName() != null) &&
			folder.getName().trim().equalsIgnoreCase(StringUtils.trim(
			folderName));
	}
	
}
