package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dao.SignatureDao;
import gov.va.med.mhv.sm.dao.properties.SMAttachmentProperties;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Mailbox;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessagesPage;
import gov.va.med.mhv.sm.model.NewMessage;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.FacilityService;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.MessageService;
import gov.va.med.mhv.sm.service.SendMessageService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.web.utils.HtmlHelper;
import gov.va.med.mhv.sm.wsclient.IntegrationServiceDelegate;
import gov.va.med.mhv.sm.wsclient.queriessvc.UserLookupResponse;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ForwardMsg extends AbstractInboxAction {

	/**
	 *
	 */
	private static final long serialVersionUID = 4178751987423838772L;

	private static final Log log = LogFactory.getLog(ForwardMsg.class);
	public static final String SESSION_MESSAGE_CATEGORY="messageCategory";
	public static final String SESSION_TRIAGE_GROUP_ID="messageTriageGroupId";

	private HttpServletRequest request;
    private SendMessageService sendMessageService;
    private UserManagementService userService;
    private MailboxService mailboxService;
	private FacilityService facilityService;
	private MessageService messageService;
	private SignatureDao signatureDao;

    private String STRUTS_RESULT;
    private String STRUTS_RESULT_CANCEL;
    private String STRUTS_RESULT_INPUT;


    // Struts properties filled from form
    // or instantiated upon start of message
    private User user;
    private String body;
    private String subject;
    private Long triageGroupId;
    private String smSend;
    private String smCancel;
    private String smSaveDraft;
    private String pwin;
    private String addCancel;
    private List<TriageGroup> triageGroups;
    private Message currentMessage;
	private SMAttachmentProperties smAttachments;
    private Long totalAttachedSize;
    private String allowedCount;
    
    public ForwardMsg(){
    	super();
    }

	public void setServletRequest(HttpServletRequest httpServletRequest) {
		super.setServletRequest(httpServletRequest);
		this.request = httpServletRequest;
	}

	@SuppressWarnings("unchecked")
	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		sendMessageService = (SendMessageService) ctx.getBean("sendMessageService");
		userService = (UserManagementService)ctx.getBean("userManagementService");
		messageService = (MessageService)ctx.getBean("messageService");
		mailboxService = (MailboxService)ctx.getBean("mailboxService");
		facilityService = (FacilityService)ctx.getBean("facilityService");
		signatureDao = (SignatureDao)ctx.getBean("signatureDao");
		user = (User)request.getSession().getAttribute(CURRENT_USER);
		triageGroups = user.getGroups();
		currentMessage = (Message)request.getSession().getAttribute(CURRENT_MESSAGE);
		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		messageFilterId = f.getFilter().getId();
		smAttachments = ((SMAttachmentProperties)ctx.getBean("smAttachmentProperties"));
		if(log.isInfoEnabled()){
			log.info("ForwardMsg.java-> SMAttachments properties....."+smAttachments);
		}
		allowedCount=smAttachments.getAttachmentAllowedCount();
		if(log.isInfoEnabled()){
			log.info("ForwardMsg.java-> SMAttachments allowedCount....."+allowedCount);
		}
		STRUTS_RESULT = user.getUserType() == UserTypeEnum.PATIENT ? "PATIENT" : "CLINICIAN";
		STRUTS_RESULT_CANCEL = STRUTS_RESULT + "_CANCEL";
		STRUTS_RESULT_INPUT = STRUTS_RESULT + "_INPUT";
	}

	private int getMessageIndex(MessagesPage mp, String messageId) {
		int notFoundResult = -1;
		for (int i = 0; i < mp.getPageSize(); i++) {
			Addressee a = mp.getElements().get(i);
			if (a.getMessage().getId().toString().equals(messageId)) {
				// found correct message
				return i;
			}
		}
		return notFoundResult;
	}


	public String editDraft(){

		Long messageId = Long.valueOf(request.getParameter("messageId"));
		NewMessage nm;

		Folder activeFolder = (Folder) request.getSession().getAttribute(CURRENT_FOLDER);
		MessagesPage mp = activeFolder.getMessages();
		int index = getMessageIndex(mp, messageId.toString());
		Addressee a = mp.getElements().get(index);

		ServiceResponse<Message> messageServiceResponse = messageService.readMessage(a.getMessage(), user);

		// set the read date in our local copy of the message so that
		// it will be displayed properly on the folder view until it
		// can be refreshed from the database
		a.setReadDate(new Date());



		ServiceResponse<NewMessage> response = sendMessageService.draftToNewMessage(user, messageId);
		nm = response.getPayload();

		request.getSession().setAttribute(NEW_MESSAGE, nm);
		request.getSession().setAttribute(DRAFT_MSG_ID, messageId);

		this.subject = nm.getSubject();
		this.body = nm.getBody();
		if(nm.getTriageGroup() != null)
			this.triageGroupId = nm.getTriageGroup().getId();

		return STRUTS_RESULT;
	}

	public String forwardForm(){

		 if(request.getSession().getAttribute("updatedBody")==null){
			 request.getSession().setAttribute("updatedBody",request.getParameter("body"));
		 }

		 if(smCancel!=null){
			 return "CLINICIAN_INBOX";
		 }
		if(smSend!=null){
			NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
			if(nm.getTo()==null){
				addActionError("Recipient not been assigned");
				return STRUTS_RESULT_INPUT;
			}
			send();
			return "CLINICIAN_INBOX";
		}

		NewMessage nm = new NewMessage();
		nm.setAttachmentId(currentMessage.getAttachmentId());
		this.setSubject("FW: " + currentMessage.getThread().getSubject());
		this.setTriageGroupId(currentMessage.getThread().getMailGroup().getId());
		//Long messageId = currentMessage.getId();

		// Get the details of the message
		ServiceResponse<Message> response = messageService.fetchMessage(currentMessage.getId());
		Message message = response.getPayload();

		//List<Message> prevThreadMessages = getThreadMessages(message);
		List<Message> prevThreadMessages = (List<Message>)request.getSession().getAttribute(PREVIOUS_MESSAGES);
		StringBuffer strBuf = new StringBuffer("\n"+"\n"+"\n");


		for(Message msg: prevThreadMessages) {
			strBuf.append("\n" +"Sent: " + DateUtils.getEnglishDateTime(msg.getSentDate()) + "\n");
			strBuf.append("From: " + msg.getSenderName() + "\n");
			strBuf.append("To: " + msg.getRecipientName() + "\n");
			strBuf.append("Subject: " + msg.getThread().getSubject() + "\n");
			strBuf.append(HtmlHelper.untabify(msg.getBody(),8) +"\n");
			strBuf.append("_________________________________________________________________");
			strBuf.append("\n" +"\n");
		}
		this.setBody(strBuf.toString());

		if(request.getSession().getAttribute("updatedBody")!=null){
			this.setBody((String)request.getSession().getAttribute("updatedBody"));
		}

		request.getSession().setAttribute(NEW_MESSAGE, nm);
		request.getSession().setAttribute(DRAFT_MSG_ID, 0L);
		if ( user.getGroups() == null || user.getGroups().isEmpty() ) {
			request.setAttribute("NO_TG_ERROR", STRUTS_RESULT);
		}
		return STRUTS_RESULT;
	}

	@SkipValidation
	public String send(){

		//Restore the subject and body values while using search recipients tabs
		if(user.getUserType() == UserTypeEnum.CLINICIAN){
			NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
			nm.setMessageCategoryTypeId(messageCategoryTypeId);
			if(subject != null){
				nm.setSubject(subject.trim());
			}else{
				subject=nm.getSubject();
			}
			if(body != null){
				nm.setBody(body.trim());
			}else{
				body=nm.getBody();
			}
			request.getSession().setAttribute(NEW_MESSAGE, nm);
		}
		//End- Restore values


		boolean error = false;

		// if the "Add Recipient" window is up or just closing the
		// do not send the message and don't validate. Just continue.
		if(pwin != null && pwin.trim().length() > 0){
			return STRUTS_RESULT_INPUT;
		}

		if(smCancel != null){
			return STRUTS_RESULT_CANCEL;
		}

		// Do some error checking
		if(StringUtils.isBlank(subject)){
			//addFieldError("subject", "The subject cannot be blank.");
			//6598
			//Prepopulate with the category
			subject=MessageCategoryTypeEnum.valueOf(messageCategoryTypeId).getName() + " Inquiry";
			error = false;
		} else {
			//Double check if JS is off then we have to reset the field to current category
			List<MessageCategoryTypeEnum> list = MessageCategoryTypeEnum.toList();
			for(Iterator i = list.iterator(); i.hasNext();) {
				MessageCategoryTypeEnum cat = (MessageCategoryTypeEnum)i.next();
				if( cat.getId() != MessageCategoryTypeEnum.OTHER.getId() && subject.equals(cat.getName() + " Inquiry")) {
					subject = MessageCategoryTypeEnum.valueOf(messageCategoryTypeId).getName() + " Inquiry";
					break;
				}
			}
		}

		if(StringUtils.isBlank(body)){
			addFieldError("body", "The message cannot be blank.");
			error = true;
		}

		/*if(user.getUserType() == UserTypeEnum.CLINICIAN){
			System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
			// Patients will always have some recipient (determined later in sendPatient())
			// because there is no blank option in the triage group drop down list
			NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
			if(nm.getTo() == null){
				System.out.println("&&&&&&&&&&&&&&&&************************************************");
				addActionError("Recipient has not been identified");
				error = true;
				return STRUTS_RESULT_INPUT;

			}
		}

		if(!this.hasErrors() && smSaveDraft != null){
			return saveDraft();
		}

		if(error)
			return STRUTS_RESULT_INPUT;

	    */
		return sendClinician();
	}

	private String sendClinician(){

		NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);

		if(nm.getTo() == null){
			addActionError("Recipient has not been identified");
			return STRUTS_RESULT_INPUT;
		}

		nm.setMessageCategoryTypeId(messageCategoryTypeId);
		nm.setSubject(subject);
		nm.setBody(body);

		// the triage group is really only necessary
		// for sending message to patients but set
		// it for all messages just in case
		for(TriageGroup tg : user.getGroups()){
			if(tg.getId().equals(triageGroupId)){
				nm.setTriageGroup(tg);
				break;
			}
		}
		nm.setFrom(user);


		if(nm.isDraft()){
			if(!sendDraft(nm)){
				return STRUTS_RESULT_INPUT;
			}
		}else{
			ServiceResponse<Message> response = sendMessageService.send(nm);
			addActionError("Your message has been successfully sent.");
			if(handleMessages(response)){
				return STRUTS_RESULT_INPUT;
			}
		}

		return STRUTS_RESULT;
	}


	private String saveDraft(){

		NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);

		nm.setMessageCategoryTypeId(messageCategoryTypeId);
		nm.setSubject(subject);
		nm.setBody(body);
		for(TriageGroup tg : user.getGroups()){
			if(tg.getId().equals(triageGroupId)){
				nm.setTriageGroup(tg);
				break;
			}
		}
		nm.setFrom(user);

		Long messageId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);
		ServiceResponse<Message> response = sendMessageService.saveDraft(nm, messageId);

		if(handleMessages(response)){
			return STRUTS_RESULT_INPUT;
		}


		if(messageId == null || messageId.equals(0L)){
			User u = (User)request.getSession().getAttribute(CURRENT_USER);
			Mailbox mailbox = u.getMailbox();
			Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
			drafts.setCount(drafts.getCount() + 1);
		}
		// if we are currently in the drafts folder then we need to refresh it
		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		if(f.getId() == SystemFolderEnum.DRAFTS.getId()){
			mailboxService.getMessages(f);
		}
		return STRUTS_RESULT;
	}

	@SuppressWarnings("unchecked")
	public String addForwardRecipient(){

		pwin = "";
		User user = (User)request.getSession().getAttribute(CURRENT_USER);
		String tab=request.getParameter("tab");
		if("1".equals(tab))
		{

			if(request.getParameter("search") != null)
			{
				String lastName = (String)request.getParameter("lastName");
				// must provide a last name
				if(StringUtils.isBlank(lastName)) return "select";
				lastName=lastName.trim();

				String firstName = (String)request.getParameter("firstName");
				if (firstName != null)
					firstName=firstName.trim();

				request.getSession().setAttribute("firstName", firstName);
				request.getSession().setAttribute("lastName", lastName);

				try {
					CollectionServiceResponse<Clinician> response = userService
							.searchForClinicians(firstName, lastName,
									((Clinician) user).getStationNo(), true);
					Collection<Clinician> pts = response.getCollection();
					//Collection<Clinician> sortedClinicians = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER);
					//sortedClinicians.addAll(pts);
					request.getSession().setAttribute("clinicians", pts);
				} catch (Exception e) {
					addActionError("Search resulted in error.");
					return "select";
				}
				return "select";
			}
			else if(request.getParameter("select")!=null){
				Long id=null;
				try	{
					id = new Long((String)request.getParameter("recipient1"));
				}catch(Exception e){
					return "select";
				}
				Collection<Clinician> cns = (Collection<Clinician>)request.getSession().getAttribute("clinicians");
				User recipient = null;
				for(Clinician c : cns){
					if(c.getId().equals(id)){
						recipient = c;
						request.getSession().setAttribute("recipient1", recipient);
						WebApplicationContext ctx = WebApplicationContextUtils
						.getWebApplicationContext(ServletActionContext
								.getServletContext());
						IntegrationServiceDelegate delegate = (IntegrationServiceDelegate)ctx.getBean("integrationServiceDelegate");
						UserLookupResponse ulr = null;
						try
						{
							request.getSession().removeAttribute("recipient1Facility");
							request.getSession().removeAttribute("recipient1Demographics");

							Facility f = facilityService.getFacilityByStationNumber(c.getStationNo()).getPayload();
							if (f != null) {
								request.getSession().setAttribute("recipient1Facility", f.getName());
							} else {
								if(log.isErrorEnabled()){
									log.error("No facility for station " + c.getStationNo());
								}
							}

							log.debug("About to get user demographics for " + c.getFirstName() + " " + c.getLastName() + ", using DUZ=" + c.getDuz() + " on station " + c.getStationNo());
							boolean userFound = false;
							ulr = delegate.getUserDemographics(null, null, c.getDuz(), c.getStationNo());
							if("Ok".equalsIgnoreCase(ulr.getStatus())) {
								if (ulr.getUsers()!= null && ulr.getUsers().length > 0) {
									// SUCCESS
									if(log.isDebugEnabled()){
										log.debug("Found clinician demographics for " + ulr.getUsers().length + " users");
									}
									gov.va.med.mhv.sm.wsclient.queriessvc.User[] users = ulr.getUsers();
									if (users.length != 1) {
										if(log.isErrorEnabled()){
											log.error("User demographics query retrieved " + users.length + " results when only 1 was expected: conversationID = " + ulr.getConversationID());
										}
									} else if (users[0] != null) {
										userFound = true;
										if(log.isDebugEnabled()){
											log.debug("User demographics found: " + users[0].getFirstName() + " " + users[0].getLastName() + ": department = " + users[0].getDepartment() + ", phone = " + users[0].getPhone());
										}
										request.getSession().setAttribute("recipient1Demographics", users[0]);
									}
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("User demographics query for " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo() + " returned " + ulr.getStatus() + ": conversationID = " + ulr.getConversationID());
								}
							}
							if (!userFound) {
								if(log.isErrorEnabled()){
									log.error("No users found matching " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo());
								}
							}
						} catch (Exception e) {
							if(log.isErrorEnabled()){
								log.error("Exception raised trying to retrieve user demographics for = " + c.getFirstName() + " " + c.getLastName() + ": DUZ/station = " + c.getDuz() + "/" + c.getStationNo());
							}
							if (ulr == null) {
								if(log.isErrorEnabled()){
									log.error("No conversation ID");
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("Conversation ID = " + ulr.getConversationID());
								}
							}
							e.printStackTrace();
						}
						break;
					}
				}
				return "select";
			}

			else if(request.getParameter("add")!=null || request.getParameter("cancel")!=null){
				if(request.getParameter("add")!=null)
				{
					NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
					User recipient = (User)request.getSession().getAttribute("recipient1");
					nm.setTo(recipient);
					request.getSession().setAttribute(NEW_MESSAGE, nm);

				}
				//cleanup
				request.getSession().removeAttribute("clinicians");
				request.getSession().removeAttribute("firstName");
				request.getSession().removeAttribute("lastName");
				request.getSession().removeAttribute("recipient1");
			}
		}
		request.setAttribute("doneAddForwardRecCln", "yes");
		return STRUTS_RESULT;

	}


	@SuppressWarnings("unchecked")
	public String addRecipient(){

		pwin = "";

		User user = (User)request.getSession().getAttribute(CURRENT_USER);
		String tab=request.getParameter("tab");

		if("1".equals(tab))
		{
			if(request.getParameter("search") != null)
			{

				String lastName = (String)request.getParameter("lastName");
				// must provide a last name
				if(StringUtils.isBlank(lastName)) return "select";
				lastName=lastName.trim();

				String firstName = (String)request.getParameter("firstName");
				if (firstName != null)
					firstName=firstName.trim();

				request.getSession().setAttribute("firstName", firstName);
				request.getSession().setAttribute("lastName", lastName);

				try {
					CollectionServiceResponse<Clinician> response = userService
							.searchForClinicians(firstName, lastName,
									((Clinician) user).getStationNo(), true);
					Collection<Clinician> pts = response.getCollection();
					//Collection<Clinician> sortedClinicians = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER);
					//sortedClinicians.addAll(pts);
					request.getSession().setAttribute("clinicians", pts);
				} catch (Exception e) {
					addActionError("Search resulted in error.");
					return "select";
				}
				return "select";
			}
			else if(request.getParameter("select")!=null){
				Long id=null;
				try	{
					id = new Long((String)request.getParameter("recipient1"));
				}catch(Exception e){
					return "select";
				}
				Collection<Clinician> cns = (Collection<Clinician>)request.getSession().getAttribute("clinicians");
				User recipient = null;
				for(Clinician c : cns){
					if(c.getId().equals(id)){
						recipient = c;
						request.getSession().setAttribute("recipient1", recipient);
						WebApplicationContext ctx = WebApplicationContextUtils
						.getWebApplicationContext(ServletActionContext
								.getServletContext());
						IntegrationServiceDelegate delegate = (IntegrationServiceDelegate)ctx.getBean("integrationServiceDelegate");
						UserLookupResponse ulr = null;
						try
						{
							request.getSession().removeAttribute("recipient1Facility");
							request.getSession().removeAttribute("recipient1Demographics");

							Facility f = facilityService.getFacilityByStationNumber(c.getStationNo()).getPayload();
							if (f != null) {
								request.getSession().setAttribute("recipient1Facility", f.getName());
							} else {
								if(log.isErrorEnabled()){
									log.error("No facility for station " + c.getStationNo());
								}
							}
							if(log.isDebugEnabled()){
								log.debug("About to get user demographics for " + c.getFirstName() + " " + c.getLastName() + ", using DUZ=" + c.getDuz() + " on station " + c.getStationNo());
							}
							boolean userFound = false;
							ulr = delegate.getUserDemographics(null, null, c.getDuz(), c.getStationNo());
							if("Ok".equalsIgnoreCase(ulr.getStatus())) {
								if (ulr.getUsers()!= null && ulr.getUsers().length > 0) {
									// SUCCESS
									if(log.isDebugEnabled()){
										log.debug("Found clinician demographics for " + ulr.getUsers().length + " users");
									}
									gov.va.med.mhv.sm.wsclient.queriessvc.User[] users = ulr.getUsers();
									if (users.length != 1) {
										if(log.isErrorEnabled()){
											log.error("User demographics query retrieved " + users.length + " results when only 1 was expected: conversationID = " + ulr.getConversationID());
										}
									} else if (users[0] != null) {
										userFound = true;
										if(log.isDebugEnabled()){
											log.debug("User demographics found: " + users[0].getFirstName() + " " + users[0].getLastName() + ": department = " + users[0].getDepartment() + ", phone = " + users[0].getPhone());
										}
										request.getSession().setAttribute("recipient1Demographics", users[0]);
									}
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("User demographics query for " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo() + " returned " + ulr.getStatus() + ": conversationID = " + ulr.getConversationID());
								}
							}
							if (!userFound) {
								if(log.isErrorEnabled()){
									log.error("No users found matching " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo());
								}
							}
						} catch (Exception e) {
							if(log.isErrorEnabled()){
								log.error("Exception raised trying to retrieve user demographics for = " + c.getFirstName() + " " + c.getLastName() + ": DUZ/station = " + c.getDuz() + "/" + c.getStationNo());
							}
							if (ulr == null) {
								if(log.isErrorEnabled()){
									log.error("No conversation ID");
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("Conversation ID = " + ulr.getConversationID());
								}
							}
							e.printStackTrace();
						}
						break;
					}
				}
				return "select";
			}

			else if(request.getParameter("add")!=null || request.getParameter("cancel")!=null){
				if(request.getParameter("add")!=null)
				{
					NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
					User recipient = (User)request.getSession().getAttribute("recipient1");
					nm.setTo(recipient);
					request.getSession().setAttribute(NEW_MESSAGE, nm);
				}
				//cleanup
				request.getSession().removeAttribute("clinicians");
				request.getSession().removeAttribute("firstName");
				request.getSession().removeAttribute("lastName");
				request.getSession().removeAttribute("recipient1");
			}
		}

		else if("2".equals(tab)){
			if(request.getParameter("add")!=null){
				NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
				String id = request.getParameter("TriageGroup");
				for(TriageGroup tg : triageGroups){
					if(tg.getId().toString().equals(id)){
						nm.setTo(tg);
						request.getSession().setAttribute(NEW_MESSAGE, nm);
					}
				}
			}
		}

		request.setAttribute("doneAddRecCln", "yes");
		return STRUTS_RESULT;

	}


	@SuppressWarnings("unchecked")
	public String addRecipientCc(){

		pwin = "";

		User user = (User)request.getSession().getAttribute(CURRENT_USER);
		String tab=request.getParameter("tab");

		setMessageCategoryTypeId((Long)getSession().getAttribute(SESSION_MESSAGE_CATEGORY));
		setTriageGroupId((Long)getSession().getAttribute(SESSION_TRIAGE_GROUP_ID));

		if("1".equals(tab))	{
			if(request.getParameter("search") != null){

				String lastName = (String)request.getParameter("lastName");
				// must provide a last name
				if(StringUtils.isBlank(lastName)) return "select";
				lastName=lastName.trim();

				String firstName = (String)request.getParameter("firstName");
				if (firstName != null)
					firstName=firstName.trim();

				request.getSession().setAttribute("firstName", firstName);
				request.getSession().setAttribute("lastName", lastName);

				try {
					CollectionServiceResponse<Clinician> response = userService
							.searchForClinicians(firstName, lastName,
									((Clinician) user).getStationNo(), true);
					Collection<Clinician> pts = response.getCollection();
					Collection<Clinician> sortedClinicians = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER);
					sortedClinicians.addAll(pts);
					request.getSession().setAttribute("clinicians", sortedClinicians);
				} catch (Exception e) {
					addActionError("Search resulted in error.");
					return "select";
				}
				return "select";
			}
			else if(request.getParameter("select")!=null){
				Long id=null;
				try	{
					id = new Long((String)request.getParameter("recipient1"));
				}catch(Exception e){
					return "select";
				}
				Collection<Clinician> cns = (Collection<Clinician>)request.getSession().getAttribute("clinicians");
				User recipient = null;
				for(Clinician c : cns){
					if(c.getId().equals(id)){
						recipient = c;
						request.getSession().setAttribute("recipient1", recipient);
						WebApplicationContext ctx = WebApplicationContextUtils
						.getWebApplicationContext(ServletActionContext
								.getServletContext());
						IntegrationServiceDelegate delegate = (IntegrationServiceDelegate)ctx.getBean("integrationServiceDelegate");
						UserLookupResponse ulr = null;
						try
						{
							request.getSession().removeAttribute("recipient1Facility");
							request.getSession().removeAttribute("recipient1Demographics");

							Facility f = facilityService.getFacilityByStationNumber(c.getStationNo()).getPayload();
							if (f != null) {
								request.getSession().setAttribute("recipient1Facility", f.getName());
							} else {
								if(log.isErrorEnabled()){
									log.error("No facility for station " + c.getStationNo());
								}
							}
							if(log.isDebugEnabled()){
								log.debug("About to get user demographics for " + c.getFirstName() + " " + c.getLastName() + ", using DUZ=" + c.getDuz() + " on station " + c.getStationNo());
							}
							boolean userFound = false;
							ulr = delegate.getUserDemographics(null, null, c.getDuz(), c.getStationNo());
							if("Ok".equalsIgnoreCase(ulr.getStatus())) {
								if (ulr.getUsers()!= null && ulr.getUsers().length > 0) {
									// SUCCESS
									if(log.isDebugEnabled()){
										log.debug("Found clinician demographics for " + ulr.getUsers().length + " users");
									}
									gov.va.med.mhv.sm.wsclient.queriessvc.User[] users = ulr.getUsers();
									if (users.length != 1) {
										if(log.isErrorEnabled()){
											log.error("User demographics query retrieved " + users.length + " results when only 1 was expected: conversationID = " + ulr.getConversationID());
										}
									} else if (users[0] != null) {
										userFound = true;
										if(log.isDebugEnabled()){
											log.debug("User demographics found: " + users[0].getFirstName() + " " + users[0].getLastName() + ": department = " + users[0].getDepartment() + ", phone = " + users[0].getPhone());
										}
										request.getSession().setAttribute("recipient1Demographics", users[0]);
									}
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("User demographics query for " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo() + " returned " + ulr.getStatus() + ": conversationID = " + ulr.getConversationID());
								}
							}
							if (!userFound) {
								if(log.isErrorEnabled()){
									log.error("No users found matching " + c.getFirstName() + " " + c.getLastName() + ", DUZ=" + c.getDuz() + " on station " + c.getStationNo());
								}
							}
						} catch (Exception e) {
							if(log.isErrorEnabled()){
								log.error("Exception raised trying to retrieve user demographics for = " + c.getFirstName() + " " + c.getLastName() + ": DUZ/station = " + c.getDuz() + "/" + c.getStationNo());
							}
							if (ulr == null) {
								if(log.isErrorEnabled()){
									log.error("No conversation ID");
								}
							} else {
								if(log.isErrorEnabled()){
									log.error("Conversation ID = " + ulr.getConversationID());
								}
							}
							e.printStackTrace();
						}
						break;
					}
				}
				return "select";
			}

			else if(request.getParameter("add")!=null || request.getParameter("cancel")!=null){
				if(request.getParameter("add")!=null)
				{
					NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
					User recipient = (User)request.getSession().getAttribute("recipient1");
					if(nm != null || nm.equals(""))
						nm.setCc(recipient);

					Message currentMsg = (Message)request.getSession().getAttribute(AbstractInboxAction.CURRENT_MESSAGE);
					if(currentMsg != null){
						currentMsg.setCcRecipientId(recipient.getId());
						currentMsg.setCcRecipientName(recipient.getName());
						request.getSession().setAttribute(CURRENT_MESSAGE, currentMsg);
						request.setAttribute("doneAddReplyRecCcCln", "yes");
					}

					request.getSession().setAttribute(NEW_MESSAGE, nm);
				}
				//cleanup
				request.getSession().removeAttribute("clinicians");
				request.getSession().removeAttribute("firstName");
				request.getSession().removeAttribute("lastName");
				request.getSession().removeAttribute("recipient1");
			}
		}

		else if("2".equals(tab)){
			if(request.getParameter("add")!=null){
				NewMessage nm = (NewMessage)request.getSession().getAttribute(NEW_MESSAGE);
				String id = request.getParameter("TriageGroup");
				for(TriageGroup tg : triageGroups){
					if(tg.getId().toString().equals(id)){
						nm.setTo(tg);
						request.getSession().setAttribute(NEW_MESSAGE, nm);
					}
				}
			}
		}

		request.setAttribute("doneAddRecCcCln", "yes");
		return STRUTS_RESULT;

	}

	private boolean sendDraft(NewMessage nm){

		Long messageId = (Long)request.getSession().getAttribute(DRAFT_MSG_ID);
		ServiceResponse<Message> response = sendMessageService.sendDraft(nm, messageId);

		if(handleMessages(response)){
			return false;
		}

		request.getSession().setAttribute(DRAFT_MSG_ID, 0L);

		// remove the draft from the mailbox
		User u = (User)request.getSession().getAttribute(CURRENT_USER);
		Mailbox mailbox = u.getMailbox();
		Folder drafts = mailbox.getFolders().get(SystemFolderEnum.DRAFTS.getId());
		drafts.setCount(drafts.getCount() - 1);

		// if we are currently in the drafts folder then we need to refresh it
		Folder f = (Folder)request.getSession().getAttribute(CURRENT_FOLDER);
		if(f.getId() == SystemFolderEnum.DRAFTS.getId()){
			mailboxService.getMessages(f);
		}

		return true;
	}


	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public Long getTriageGroupId() {
		return triageGroupId;
	}

	public void setTriageGroupId(Long triageGroupId) {
		this.triageGroupId = triageGroupId;
	}

	public void setSmSend(String smSend) {
		this.smSend = smSend;
	}

	public void setSmCancel(String smCancel) {
		this.smCancel = smCancel;
	}

	public List<TriageGroup> getTriageGroups() {
		return triageGroups;
	}

	public void setTriageGroups(List<TriageGroup> triageGroups) {
		this.triageGroups = triageGroups;
	}

	public String getPwin() {
		return pwin;
	}

	public void setPwin(String pwin) {
		this.pwin = pwin;
	}

	public String getAddCancel() {
		return addCancel;
	}

	public void setAddCancel(String addCancel) {
		this.addCancel = addCancel;
	}

	public String getSmSend() {
		return smSend;
	}

	public String getSmCancel() {
		return smCancel;
	}

	public String getSmSaveDraft() {
		return smSaveDraft;
	}

	public void setSmSaveDraft(String smSaveDraft) {
		this.smSaveDraft = smSaveDraft;
	}

	public MessageService getMessageService() {
		return messageService;
	}

	public void setMessageService(MessageService messageService) {
		this.messageService = messageService;
	}
	
    public SMAttachmentProperties getSmAttachments() {
		return smAttachments;
	}

	public void setSmAttachments(SMAttachmentProperties smAttachments) {
		this.smAttachments = smAttachments;
	}

	public Long getTotalAttachedSize() {
		return totalAttachedSize;
	}

	public void setTotalAttachedSize(Long totalAttachedSize) {
		this.totalAttachedSize = totalAttachedSize;
	}

	public String getAllowedCount() {
		return allowedCount;
	}

	public void setAllowedCount(String allowedCount) {
		this.allowedCount = allowedCount;
	}

}