package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.MessageAttachment;
import gov.va.med.mhv.sm.model.NewMessage;
import gov.va.med.mhv.sm.util.AttachmentUtils;
import gov.va.med.mhv.sm.web.utils.TimerUtils;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Blob;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.hibernate.Hibernate;

public class FileAttachment extends NewMsg implements ServletResponseAware {
	 	
	private String STRUTS_RESULT;
    private String STRUTS_RESULT_CANCEL;
    private String STRUTS_RESULT_INPUT;
    
    
    /*
     * NSOC - File Upload Vulnerability.
     * DO NOT USE SMAttachmentProperties. 
     * Some of properties such as allowedFileTypes can be dynamically overwritten or substituted externally.
     */
    private static String[] allowedFileTypes = {"doc", "pdf", "xls", "txt", "rtf", "jpg", "gif", "png", "docx", "xlsx"};
    private static final long totalAllowedSize = 6291456;
    private static final Log log = LogFactory.getLog(NewMsg.class);
    
    public void prepare() throws Exception{
    	super.prepare();
    	STRUTS_RESULT = getCurrentUser().getUserType() == UserTypeEnum.PATIENT ? "PATIENT" : "CLINICIAN";
		STRUTS_RESULT_CANCEL = STRUTS_RESULT + "_CANCEL";
		STRUTS_RESULT_INPUT = STRUTS_RESULT + "_INPUT";
   }
    
	public String saveFileAttachment() throws IOException{
	 	TimerUtils timer = new TimerUtils();
	 	timer.start();
	 	NewMessage newMessage = (NewMessage)getRequest().getSession().getAttribute(NEW_MESSAGE);
	 	FileInputStream fileStream = null;
		try
		{
			//server-side validation - To remediate "File upload" vulnerability.
			if(!isFileTypeAllowed()){
				addActionError("The file(s) type you are trying to upload is not allowed.");
				return STRUTS_RESULT;				
			}
			// Saving the file into Database.
			fileStream = new FileInputStream(getUpload());
            Blob blob = Hibernate.createBlob(fileStream);
            ServiceResponse<MessageAttachment> serviceResponse = messageService.saveAttachment(blob, getUploadFileName(),getUploadContentType(),getCurrentUser().getId());
        	newMessage.setBody(this.getBody());
	
        	if(log.isInfoEnabled()){
        		log.info("<<<File Attachment 501-User Id->"+getCurrentUser().getId()+" File Size->"+getUpload().length()+" contentType->"+getUploadContentType()+" fileName->"+getUploadFileName());
        	}
			Long attachmentId = serviceResponse.getPayload().getId();
			String attachmentName = getUploadFileName()+" ("+AttachmentUtils.displayBytesSize(getUpload().length())+")^"+getUpload().length();
			
			if(newMessage.getAttachments()==null){
				Map<Long,String> attachmentsMap = new TreeMap<Long,String>();
				attachmentsMap.put(attachmentId, attachmentName);
				newMessage.setAttachments(attachmentsMap);
			}else{
				Map<Long,String> attachmentsMap = newMessage.getAttachments();
				attachmentsMap.put(attachmentId, attachmentName);
				newMessage.setAttachments(attachmentsMap);
			}

			Long totalSize = (newMessage.getAttachmentSize()!=null?newMessage.getAttachmentSize():0)+getUpload().length();

			if(totalSize>totalAllowedSize){
				addActionError("The sum of the file(s) you are trying to upload exceeds the 6 MB limit. Please reduce the file(s) size and try again.");
				return STRUTS_RESULT;								
			}
			
			newMessage.setAttachmentSize(totalSize);
			setTotalAttachedSize(totalSize);

			getRequest().getSession().setAttribute(NEW_MESSAGE,newMessage);
			fileStream.close();
			setMessageHeaders();
		}catch(Exception e)
		{
			if(log.isErrorEnabled()){
				log.error("Error while uploading attachment for the user..."+getCurrentUser().getName()+e);
			}
			if(fileStream!=null){
				fileStream.close();
			}
			addActionError("An Error occured while saving attachment");
			return STRUTS_RESULT;
		}

		finally{
			if(fileStream!=null){
				fileStream.close();
			}
		}
		
		return STRUTS_RESULT;
		
	}
	
	/*
	 * removeAttachment, set the attachmentId, attachmentName in the NewMessage Object in the session.
	 * 
	 */
	public String removeAttachment(){
		if(getRemoveAttachment().equalsIgnoreCase("Yes")){
			NewMessage newMessage = (NewMessage)getRequest().getSession().getAttribute(NEW_MESSAGE);
			try
			{
				Map<Long,String> attachmentMap = newMessage.getAttachments();
				String removeAttachment = attachmentMap.get(getRemoveId());
				Long removeSize = new Long(AttachmentUtils.getSecondPartOfString(removeAttachment));
				Long totalSize = newMessage.getAttachmentSize() - removeSize;
				setTotalAttachedSize(totalSize);
				attachmentMap.remove(getRemoveId());
				newMessage.setAttachments(attachmentMap);
				newMessage.setAttachmentSize(totalSize);
				getRequest().getSession().setAttribute(NEW_MESSAGE,newMessage);
				messageService.removeAttachment(getRemoveId());
			}catch(Exception e){
				
			}
			newMessage.setAttachmentId(null);
			newMessage.setAttachmentName(null);
		}
		return STRUTS_RESULT;
	}
	
	public void setMessageHeaders(){
		if(null!=getSession().getAttribute(SESSION_MESSAGE_BODY))
			setBody((String)getSession().getAttribute(SESSION_MESSAGE_BODY));
		if(null!=getSession().getAttribute(SESSION_MESSAGE_SUBJECT))
			setSubject((String)getSession().getAttribute(SESSION_MESSAGE_SUBJECT));
		if(null!=getSession().getAttribute(SESSION_MESSAGE_CATEGORY))
			setMessageCategoryTypeId((Long)getSession().getAttribute(SESSION_MESSAGE_CATEGORY));
		if(null!=getSession().getAttribute(SESSION_TRIAGE_GROUP_ID))
			setTriageGroupId((Long)getSession().getAttribute(SESSION_TRIAGE_GROUP_ID));
		getSession().removeAttribute(SESSION_MESSAGE_BODY);
		getSession().removeAttribute(SESSION_MESSAGE_SUBJECT);
		getSession().removeAttribute(SESSION_MESSAGE_CATEGORY);
		getSession().removeAttribute(SESSION_TRIAGE_GROUP_ID);
	}
	
	public void setSessionAttribute(String sessionKey, String value){
		getRequest().getSession().setAttribute(sessionKey,value);
	}
	
	public String getSessionAttribute(String sessionKey){
		if(getRequest().getSession().getAttribute(sessionKey)!=null) return (String)getRequest().getSession().getAttribute(sessionKey);
		else return null;
	}
	
	public void removeSessionAttribute(String sessionKey){
		getRequest().getSession().removeAttribute(sessionKey);
	}

	// check content/file type
	private boolean isFileTypeAllowed(){
		String fileName = getUploadFileName();
		String fileType = fileName.substring(fileName.lastIndexOf('.')+1);
		for(String type: allowedFileTypes){		
			if(type.equals(fileType)){
				return true;
			}
		}
		return false;
	}
	
}

