package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.DistributionGroup;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.DistributionGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.service.FacilityService;
import gov.va.med.mhv.sm.dao.DistributionGroupDao;
import gov.va.med.mhv.sm.dao.FacilityDao;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.model.Facility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.Preparable;




public class DistGroup extends AbstractInboxAction  {
	private static final Log log = LogFactory.getLog(DistGroup.class);
	private HttpServletRequest request;
	private String STRUTS_RESULT;
	private User user;
	private UserManagementService userManagementService;
	private DistributionGroupService distributionGroupService;
	private FacilityService facilityService;
	private UserManagementService userService;
	private DistributionGroupDao distributionGroupDao;
	private UserDao userDao;
	private FacilityDao facilityDao;
	private String tab;
	private String firstName;
	private String lastName;
	private String nssn;
	private String selectAction;
	private List<String> availableMembers;
	private List<String> selectedMembers;
	private List<Clinician> clinicians;
	private List<Clinician> cliniciansOSF;
	private Collection<Patient> patients;
	private Collection<Facility> visns;
	private Collection<Facility> facilities;
	private String distGroupName;
	private String distGroup;
	private List<User> selectedUsers = new ArrayList<User>();
	private String sharedGroup;
	private Long visnId;
	private Long otherFacilityVISNId;
	private Long otherFacilityFacilityId;
	private String otherFacilityVISNSelect;
	private String otherFacilityFacilitySelect;
	private String otherFacilityVISNCancel;
	private String otherFacilityFacilityCancel;
	
	

	private static final int SM_DISTRIBUTION_LIST_ALLOWED_COUNT=250;

	public DistGroup()
	{
		super();
		Locale.setDefault(Locale.ENGLISH);
	}

	public void setServletRequest(HttpServletRequest httpServletRequest)
	{
		this.request = httpServletRequest;
	}

	public void prepare() throws Exception
	{
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
									.getWebApplicationContext(ServletActionContext
									.getServletContext());
		userManagementService = (UserManagementService) ctx.getBean("userManagementService");
		distributionGroupService = (DistributionGroupService)ctx.getBean("distributionGroupService");
		facilityService = (FacilityService)ctx.getBean("facilityService");
		userService = (UserManagementService)ctx.getBean("userManagementService");
		facilityDao = (FacilityDao)ctx.getBean("facilityDao");
		userDao = (UserDao) ctx.getBean("userDao");
		distributionGroupDao = (DistributionGroupDao) ctx.getBean("distributionGroupDao");
		user=(User)request.getSession().getAttribute(CURRENT_USER);
		Clinician clinician = (Clinician)user;
		STRUTS_RESULT = user.getUserType() == UserTypeEnum.PATIENT ? "PATIENT":"CLINICIAN";
		Facility facility = facilityDao.getFacilityByStationNumber(clinician.getStationNo());
		setVisnId(facility.getVisnId());
	}


	public String createDistGroup(){
		clearDistSessionAttr();
		selectedUsers.add(user);
		request.getSession().setAttribute("selectedUsers", selectedUsers);
		/* Get All VISNs here before loading the DistGroup page */
		setVisns(getAllVisns());

		if(!((distGroupName == null) || distGroupName.equals("") || (distGroupName.equalsIgnoreCase("Enter Group Name")))){
			request.getSession().setAttribute("distGroupName", distGroupName);
		}
		request.getSession().setAttribute("sharedGroup", sharedGroup);

		request.getSession().removeAttribute("facilities");
		request.getSession().removeAttribute("disableAddButton");
		request.getSession().removeAttribute("displayVISNSelection");
		request.getSession().removeAttribute("otherFacilityVISNName");
		request.getSession().removeAttribute("otherFacilityVISNId");
		request.getSession().removeAttribute("otherFacilityVISNSelected");
		request.getSession().removeAttribute("otherFacilityFacilityName");
		request.getSession().removeAttribute("otherFacilityFacilityId");
		request.getSession().removeAttribute("otherFacilityFacilitySelected");
		return STRUTS_RESULT;
	}

	public Collection<Facility> getAllVisns(){
		Collection<Facility> visnList = getFacilityDao().getVisns();
		return visnList;
	}

	public Collection<Facility> getFacilitiesByVisn(String visnName){

		String  stationNumber = ((Clinician)user).getStationNo();

		//Get facility of the current user - Healthcare team member
		Facility f = facilityService.getFacilityByStationNumber(stationNumber).getPayload();
		Collection<Facility> facilityList = getFacilityDao().getFacilityByVisn(visnName);

		if (f != null){
			//The current facility of the Healthcare team member is not listed in the drop down
			for(Facility fl:facilityList){
				if(fl.getId().equals(f.getId())){
					facilityList.remove(fl);
					break;
				}
			}
		}
		else
		{
			if(log.isInfoEnabled()){
				log.info("There is no facility setup for the current user.");
			}
		}
		return facilityList;
	}

	public String addDistGroups(){

		setVisns(getAllVisns());

		if(!((distGroupName == null) || distGroupName.equals("") || (distGroupName.equalsIgnoreCase("Enter Group Name")))){
			request.getSession().setAttribute("distGroupName", distGroupName);
		}
		request.getSession().setAttribute("sharedGroup", sharedGroup);

		String crudVal = "addDistGroup";
		if((tab != null) && (tab.equals("1"))){
			String returnVal =  addPatientDistGroups(crudVal);
			return returnVal;

		}else if((tab != null) && (tab.equals("2"))){
			String returnVal =  addClinicianDistGroups(crudVal);
			return returnVal;

		}else if((tab != null) && (tab.equals("3"))){
			String returnVal =  addClinicianOSFDistGroups(crudVal);
			return returnVal;
		}
		return STRUTS_RESULT;

	}


	public String addPatientDistGroups(String crudVal){

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("search"))){
			if((lastName.length()<2) && (nssn.equals(""))){
				addActionError("Please enter full last name or the first 2 characters of the last name or full NSSN.");
				return "addDistGroup";
			}

			Clinician c = (Clinician)user;
			CollectionServiceResponse<Patient> response = userManagementService.searchForPatients(firstName, lastName, nssn, ((Clinician)user).getStationNo());

			List<Patient> optedInPatientsList = new ArrayList<Patient>();
			for(Patient patient:response.getCollection()){
				if(patient.getStatus().getId().equals(UserStatusEnum.OPT_IN.getId())){
					optedInPatientsList.add(patient);
					}
				}
			request.getSession().setAttribute("patients", optedInPatientsList);
			optedInPatientsList=null;

			return "addDistGroup";
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Add ->"))){
			patients = (Collection<Patient>)request.getSession().getAttribute("patients");

			if(((List<User>)request.getSession().getAttribute("selectedUsers")) != null){
				selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
				if( availableMembers != null){
				if (selectedUsers.size()+availableMembers.size() > SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
				{
					addActionError("Only up to 250 Group Members can be added to the Distribution Group.");
					return "addDistGroup";
				}
				if (selectedUsers.size()+availableMembers.size() == SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
					request.getSession().setAttribute("disableAddButton", "Yes");
				else
					request.getSession().setAttribute("disableAddButton", "No");
				}
			}

			if (patients != null){
			  	for(Patient p: patients){
					String pId = String.valueOf(p.getId());
					if( availableMembers != null){
						Iterator iterator = availableMembers.iterator();
						if (iterator != null){
							while (iterator.hasNext()) {															;
								if(((String)iterator.next()).equals(pId)){
									User du = p;
									selectedUsers.add(du);
								}
							}
						}
					}
			  	}
			}

			request.getSession().setAttribute("selectedUsers", selectedUsers);
			return "addDistGroup";
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("<- Remove"))){

			List<User> availablePatients = new ArrayList<User>();

			if(((List<User>)request.getSession().getAttribute("selectedUsers")) != null){
				selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
				if( selectedMembers != null){
					if (selectedUsers.size()-selectedMembers.size() < SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
						request.getSession().setAttribute("disableAddButton", "No");
					else
						request.getSession().setAttribute("disableAddButton", "Yes");
				}
			}

			if (selectedUsers != null){
			  	for(User du: selectedUsers){
					String pId = String.valueOf(du.getId());
					if( selectedMembers != null){
						Iterator iterator = selectedMembers.iterator();
						if (iterator != null){
							while (iterator.hasNext()) {															;
								if(((String)iterator.next()).equals(pId)){
									availablePatients.add(du);
								}
							}
						}
					}
			  	}
			}
			if (availablePatients != null){
			  	for(User du: availablePatients){
					selectedUsers.remove(du);
			  	}
			}

			request.getSession().setAttribute("selectedUsers", selectedUsers);

			return "addDistGroup";
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Save Group"))
			&& (crudVal.equalsIgnoreCase("addDistGroup"))){

			Clinician c = (Clinician)user;
			selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
			if(selectedUsers==null || selectedUsers.size() == 0){
				addActionError("You must add at least one user to the group.");
				return "addDistGroup";
			}

			if (!distGroupName.equals(""))
			{
				DistributionGroup d = new DistributionGroup();

				d.setOwner(c);
				if(getSharedGroup().equals("public")){
					d.setPublicGroup(true);
					d.setVisnId(getVisnId());
				}
				else{
					d.setPublicGroup(false);
					d.setVisnId(null);
				}
				d.setName(distGroupName);
				if(selectedUsers != null){
					d.setMembers(selectedUsers);
				}



				ServiceResponse<DistributionGroup> response = distributionGroupService.createDistributionGroup(c, d);

				d = response.getPayload();
				if(d != null){
					List<Object[]> distList = distributionGroupDao.getAllDistributionGroupsByUserOrShared(c);
					c.setDistGroups(getDistributionGroup(distList));
				}else{
					addActionError("Distribution group names should be unique. Please try with other name.");
					return "addDistGroup";
				}
			}else{
				addActionError("Please enter distribution group name.");
				return "addDistGroup";
			}
			clearDistSessionAttr();
			return STRUTS_RESULT;
		}else if((selectAction!=null) && (selectAction.equalsIgnoreCase("Save Group"))
			&& (crudVal.equalsIgnoreCase("updateDistGroup"))){
			selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");

			if(selectedUsers==null || selectedUsers.size() == 0){
				addActionError("You must add at least one user to the group.");
				return "addDistGroup";
			}

			if (!distGroupName.equals("")){
				DistributionGroup d = (DistributionGroup)request.getSession().getAttribute("distGroupSelect");
				if(d != null){
					d.setName(distGroupName);
					d.setMembers(selectedUsers);
				}
				if(getSharedGroup().equals("public")){
					d.setPublicGroup(true);
					d.setVisnId(getVisnId());
				}
				else{
					d.setPublicGroup(false);
					d.setVisnId(null);
				}

				try{
					distributionGroupService.updateDistributionGroup(d);
				}catch(Exception e){
					if(log.isErrorEnabled()){
						log.error("Expection occured while updating distribution group");
					}
					addActionError("Distribution group names should be unique. Please try with other name.");
					return "addDistGroup";
				}

				Clinician c = (Clinician) user;
				List<Object[]> distList = distributionGroupDao.getAllDistributionGroupsByUserOrShared(c);
				c.setDistGroups(getDistributionGroup(distList));

			}else{
				addActionError("Please enter distribution group name.");
				return "addDistGroup";
			}
			clearDistSessionAttr();
			return STRUTS_RESULT;
		}

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Cancel"))){
			clearDistSessionAttr();
			return STRUTS_RESULT;
		}
		return "addDistGroup";
	}


	// Variables Explanation!!!!
	// availableClinicians - Local Variable -
	// clinicians	- Session attribute  - All Clinicians
	// selectedUsers - Session attribute - All mixed selected list
	// availableMembers- Struts Variable - Display List on the left
	// selectedMembers - Struts Variable - Display List on the right

	public String addClinicianDistGroups(String crudVal){

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("search"))){
			if(lastName.length()<2){
				addActionError("Please enter full last name or the first 2 characters of the last name.");
				return "addDistGroup";
			}

			Clinician c = (Clinician)user;
			CollectionServiceResponse<Clinician> response = userManagementService.searchForClinicians(firstName, lastName, ((Clinician)user).getStationNo(), true);
			Collection<Clinician> clns = response.getCollection();
			request.getSession().setAttribute("clinicians", clns);

			return "addDistGroup";
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Add ->"))){

			clinicians = (List<Clinician>)request.getSession().getAttribute("clinicians");
			if(((List<User>)request.getSession().getAttribute("selectedUsers")) != null){
				selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");

				if( availableMembers != null){
				if (selectedUsers.size()+availableMembers.size() > SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
				{
					addActionError("Only up to 250 Group Members can be added to the Distribution Group.");
					return "addDistGroup";
				}

				if (selectedUsers.size()+availableMembers.size() == SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
					request.getSession().setAttribute("disableAddButton", "Yes");
				else
					request.getSession().setAttribute("disableAddButton", "No");
			}
			}

			if (clinicians != null){
			  	for(Clinician c: clinicians){
					String cId = String.valueOf(c.getId());
					if( availableMembers != null){
						Iterator iterator = availableMembers.iterator();
						if (iterator != null){
							while (iterator.hasNext()) {															;
								if(((String)iterator.next()).equals(cId)){
									User du = c;
									selectedUsers.add(du);
								}
							}
						}
					}
			  	}
			}

			request.getSession().setAttribute("selectedUsers", selectedUsers);

			return "addDistGroup";
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("<- Remove"))){

			List<User> availableClinicians = new ArrayList<User>();

			if(((List<User>)request.getSession().getAttribute("selectedUsers")) != null){
				selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
				if( selectedMembers != null){
					if (selectedUsers.size()-selectedMembers.size() < SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
						request.getSession().setAttribute("disableAddButton", "No");
					else
						request.getSession().setAttribute("disableAddButton", "Yes");
				}
			}

			if (selectedUsers != null){
			  	for(User du: selectedUsers){
					String cId = String.valueOf(du.getId());
					if( selectedMembers != null){
						Iterator iterator = selectedMembers.iterator();
						if (iterator != null){
							while (iterator.hasNext()) {															;
								if(((String)iterator.next()).equals(cId)){
									availableClinicians.add(du);
								}
							}
						}
					}
			  	}
			}
			if (availableClinicians != null){
			  	for(User du: availableClinicians){
					selectedUsers.remove(du);
			  	}
			}

			request.getSession().setAttribute("selectedUsers", selectedUsers);

			return "addDistGroup";
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Save Group"))
			&& (crudVal.equalsIgnoreCase("addDistGroup"))){
			Clinician c = (Clinician)user;
			selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
			if(selectedUsers==null || selectedUsers.size() == 0){
				addActionError("You must add at least one user to the group.");
				return "addDistGroup";
			}
			if (!distGroupName.equals("")){
				DistributionGroup d = new DistributionGroup();

				d.setOwner(c);
				d.setName(distGroupName);
				if(selectedUsers != null){
					d.setMembers(selectedUsers);
				}

				if(getSharedGroup().equals("public")){
					d.setPublicGroup(true);
					d.setVisnId(getVisnId());
				}
				else{
					d.setPublicGroup(false);
					d.setVisnId(null);
				}
				ServiceResponse<DistributionGroup> response = distributionGroupService.createDistributionGroup(c, d);

				d = response.getPayload();


				if(d != null){
					List<Object[]> distList = distributionGroupDao.getAllDistributionGroupsByUserOrShared(c);
					c.setDistGroups(getDistributionGroup(distList));
				}else{
					addActionError("Distribution group names should be unique. Please try with other name.");
					return "addDistGroup";
				}

			}else{
				addActionError("Please enter distribution group name.");
				return "addDistGroup";
			}
			clearDistSessionAttr();
			return STRUTS_RESULT;
		}else if((selectAction!=null) && (selectAction.equalsIgnoreCase("Save Group"))
			&& (crudVal.equalsIgnoreCase("updateDistGroup"))){
			selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
			if(selectedUsers==null || selectedUsers.size() == 0){
				addActionError("You must add at least one user to the group.");
				return "addDistGroup";
			}
			if (!distGroupName.equals("")){
				DistributionGroup d = (DistributionGroup)request.getSession().getAttribute("distGroupSelect");
				if(d != null){
					d.setName(distGroupName);
					d.setMembers(selectedUsers);

				}

				if(getSharedGroup().equals("public")){
					d.setPublicGroup(true);
					d.setVisnId(getVisnId());
				}
				else{
					d.setPublicGroup(false);
					d.setVisnId(null);
				}
				try{
					distributionGroupService.updateDistributionGroup(d);
				}catch(Exception e){
					if(log.isErrorEnabled()){
						log.error("Expection occured while updating distribution group.");
					}
					addActionError("Distribution group names should be unique. Please try with other name.");
					return "addDistGroup";
				}
				Clinician c = (Clinician) user;

				List<Object[]> distList = distributionGroupDao.getAllDistributionGroupsByUserOrShared(c);
				c.setDistGroups(getDistributionGroup(distList));

			}else{
				addActionError("Please enter distribution group name.");
				return "addDistGroup";
			}
			clearDistSessionAttr();
			return STRUTS_RESULT;
		}

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Cancel"))){
			clearDistSessionAttr();
			return STRUTS_RESULT;
		}
		return "addDistGroup";

	}

	/* ---NEW---------------------------------------- */
	public String addClinicianOSFDistGroups(String crudVal){
		String displayVISNSelection = "Yes";
		if(getOtherFacilityVISNSelect()!=null)
		{
			//List VISNs
			//No code required here for initial listing of the VISNs.

			//VISN Selected and LIST Facility
			// --Display selected VISN
			// --Get Name of the Selected VISN
			// --Get the list of Facilities for the Selected VISN

			if (getOtherFacilityVISNSelect().equalsIgnoreCase("ChangeVISN"))
			{
				setVisns(getAllVisns());
				request.getSession().removeAttribute("facilities");
				request.getSession().removeAttribute("disableAddButton");
				request.getSession().removeAttribute("displayVISNSelection");
				request.getSession().removeAttribute("otherFacilityVISNName");
				request.getSession().removeAttribute("otherFacilityVISNId");
				request.getSession().removeAttribute("otherFacilityVISNSelected");
				request.getSession().removeAttribute("otherFacilityFacilityName");
				request.getSession().removeAttribute("otherFacilityFacilityId");
				request.getSession().removeAttribute("otherFacilityFacilitySelected");
			}
			else
			{
				if (getOtherFacilityVISNId() == null)
					setOtherFacilityVISNId((Long)request.getSession().getAttribute("otherFacilityVISNId"));

				if (getOtherFacilityVISNId() != -1)
				{
					//request.getSession().removeAttribute("displayVISNSelection");
					displayVISNSelection = "Yes";
					request.getSession().setAttribute("displayVISNSelection",displayVISNSelection );
					String visnName = ((Facility)getFacilityDao().findById(getOtherFacilityVISNId())).getName();
					request.getSession().setAttribute("otherFacilityVISNName",visnName);
					request.getSession().setAttribute("otherFacilityVISNId",getOtherFacilityVISNId());
					setFacilities(getFacilitiesByVisn(visnName));
					request.getSession().setAttribute("otherFacilityVISNSelected","Yes");
					request.getSession().setAttribute("otherFacilityFacilitySelected","No");
					request.getSession().removeAttribute("otherFacilityFacilityName");
					request.getSession().removeAttribute("otherFacilityFacilityId");
					//request.getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
				}
				else
				{
					//request.getSession().removeAttribute("displayVISNSelection");
					setVisns(getAllVisns());
					displayVISNSelection = "Yes";
					request.getSession().setAttribute("displayVISNSelection",displayVISNSelection );
					request.getSession().setAttribute("otherFacilityVISNSelected","No");
					request.getSession().setAttribute("otherFacilityFacilitySelected","No");
					//request.getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
				}
			}
		}
		else if(getOtherFacilityFacilitySelect() !=null)
		{
			//VISN and Facility Selected
			// --Display selected Facility
			// -- get the name of the Facility selected
			// Check if the patient belongs to the selected facility. if not, display the Yes/No confirmation message.
			// forward screens to Display Tabs (clinician and TG)

			if (getOtherFacilityFacilityId() != -1)
			{
					displayVISNSelection = "Yes";

				//request.getSession().removeAttribute("displayVISNSelection");
				request.getSession().setAttribute("displayVISNSelection",displayVISNSelection );
				String facilityName = ((Facility)getFacilityDao().findById(getOtherFacilityFacilityId())).getName();
				request.getSession().setAttribute("otherFacilityFacilityName",facilityName);
				request.getSession().setAttribute("otherFacilityFacilityId",getOtherFacilityFacilityId());
				request.getSession().setAttribute("otherFacilityFacilitySelected","Yes");
				//request.getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);

		/* ------------------------------- New Upto here -------------------------- */

			}
			else
			{
				displayVISNSelection = "Yes";
				String visnName = ((Facility)getFacilityDao().findById((Long)request.getSession().getAttribute("otherFacilityVISNId"))).getName();
				setFacilities(getFacilitiesByVisn(visnName));
				request.getSession().setAttribute("displayVISNSelection",displayVISNSelection );
				request.getSession().setAttribute("otherFacilityFacilitySelected","No");
				//request.getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			}
		}
		else if(getOtherFacilityVISNCancel()!=null)
		{
			setVisns(getAllVisns());
			request.getSession().removeAttribute("facilities");
			request.getSession().removeAttribute("disableAddButton");
			request.getSession().removeAttribute("displayVISNSelection");
			request.getSession().removeAttribute("otherFacilityVISNName");
			request.getSession().removeAttribute("otherFacilityVISNId");
			request.getSession().removeAttribute("otherFacilityVISNSelected");
			request.getSession().removeAttribute("otherFacilityFacilityName");
			request.getSession().removeAttribute("otherFacilityFacilityId");
			request.getSession().removeAttribute("otherFacilityFacilitySelected");
			//request.getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			return STRUTS_RESULT;
		}
		else if(getOtherFacilityFacilityCancel()!=null)
		{
			setVisns(getAllVisns());
			request.getSession().removeAttribute("facilities");
			request.getSession().removeAttribute("disableAddButton");
			request.getSession().removeAttribute("displayVISNSelection");
			request.getSession().removeAttribute("otherFacilityVISNName");
			request.getSession().removeAttribute("otherFacilityVISNId");
			request.getSession().removeAttribute("otherFacilityVISNSelected");
			request.getSession().removeAttribute("otherFacilityFacilityName");
			request.getSession().removeAttribute("otherFacilityFacilityId");
			request.getSession().removeAttribute("otherFacilityFacilitySelected");
			//request.getSession().setAttribute(POPUPWINDOW,FACILITY_SELECT);
			return STRUTS_RESULT;
		}

		if(selectAction!=null)
		{
			if ((Long)request.getSession().getAttribute("otherFacilityFacilityId") != -1)
			{
				if((selectAction!=null) && (selectAction.equalsIgnoreCase("search")))
				{
					if(lastName.length()<2){
						addActionError("Please enter full last name or the first 2 characters of the last name.");
						return "addDistGroup";
					}

					// Get clinicians from the selected facility
					String facStationNumber = ((Facility)getFacilityDao().findById((Long)request.getSession().getAttribute("otherFacilityFacilityId"))).getStationNumber();

					Clinician c = (Clinician)user;
					CollectionServiceResponse<Clinician> response = userManagementService.searchForClinicians(firstName, lastName, facStationNumber, true);
					Collection<Clinician> clnsOSF = response.getCollection();
					request.getSession().setAttribute("cliniciansOSF", clnsOSF);

					return "addDistGroup";
				}
				if((selectAction!=null) && (selectAction.equalsIgnoreCase("Add ->")))
				{

					cliniciansOSF = (List<Clinician>)request.getSession().getAttribute("cliniciansOSF");
					if(((List<User>)request.getSession().getAttribute("selectedUsers")) != null){
						selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");

				if( availableMembers != null){
						if (selectedUsers.size()+availableMembers.size() > SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
						{
							addActionError("Only up to 250 Group Members can be added to the Distribution Group.");
							return "addDistGroup";
						}

						if (selectedUsers.size()+availableMembers.size() == SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
							request.getSession().setAttribute("disableAddButton", "Yes");
						else
							request.getSession().setAttribute("disableAddButton", "No");
				}
				}

					if (cliniciansOSF != null){
						for(Clinician c: cliniciansOSF){
							String cId = String.valueOf(c.getId());
							if( availableMembers != null){
								Iterator iterator = availableMembers.iterator();
								if (iterator != null){
									while (iterator.hasNext()) {															;
										if(((String)iterator.next()).equals(cId)){
											User du = c;
											selectedUsers.add(du);
										}
									}
								}
							}
						}
					}

					request.getSession().setAttribute("selectedUsers", selectedUsers);

					return "addDistGroup";
				}
				if((selectAction!=null) && (selectAction.equalsIgnoreCase("<- Remove")))
				{

					List<User> availableCliniciansOSF = new ArrayList<User>();

					if(((List<User>)request.getSession().getAttribute("selectedUsers")) != null){
						selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
						if( selectedMembers != null){
							if (selectedUsers.size()-selectedMembers.size() < SM_DISTRIBUTION_LIST_ALLOWED_COUNT)
								request.getSession().setAttribute("disableAddButton", "No");
							else
								request.getSession().setAttribute("disableAddButton", "Yes");
						}
					}

					if (selectedUsers != null){
						for(User du: selectedUsers){
							String cId = String.valueOf(du.getId());
							if( selectedMembers != null){
								Iterator iterator = selectedMembers.iterator();
								if (iterator != null){
									while (iterator.hasNext()) {															;
										if(((String)iterator.next()).equals(cId)){
											availableCliniciansOSF.add(du);
										}
									}
								}
							}
						}
					}
					if (availableCliniciansOSF != null){
						for(User du: availableCliniciansOSF){
							selectedUsers.remove(du);
						}
					}

					request.getSession().setAttribute("selectedUsers", selectedUsers);

					return "addDistGroup";
				}
				if((selectAction!=null) && (selectAction.equalsIgnoreCase("Save Group"))
					&& (crudVal.equalsIgnoreCase("addDistGroup")))
				{
					Clinician c = (Clinician)user;
					selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
					if(selectedUsers==null || selectedUsers.size() == 0){
						addActionError("You must add at least one user to the group.");
						return "addDistGroup";
					}
					if (!distGroupName.equals("")){
						DistributionGroup d = new DistributionGroup();

						d.setOwner(c);
						d.setName(distGroupName);
						if(selectedUsers != null){
							d.setMembers(selectedUsers);
						}

						if(getSharedGroup().equals("public")){
							d.setPublicGroup(true);
							d.setVisnId(getVisnId());
						}
						else{
							d.setPublicGroup(false);
							d.setVisnId(null);
						}
						ServiceResponse<DistributionGroup> response = distributionGroupService.createDistributionGroup(c, d);

						d = response.getPayload();


						if(d != null){
							List<Object[]> distList = distributionGroupDao.getAllDistributionGroupsByUserOrShared(c);
							c.setDistGroups(getDistributionGroup(distList));
						}else{
							addActionError("Distribution group names should be unique. Please try with other name.");
							return "addDistGroup";
						}

					}else{
						addActionError("Please enter distribution group name.");
						return "addDistGroup";
					}
					clearDistSessionAttr();
					return STRUTS_RESULT;
				}else if((selectAction!=null) && (selectAction.equalsIgnoreCase("Save Group"))
					&& (crudVal.equalsIgnoreCase("updateDistGroup")))
				{
					selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
					if(selectedUsers==null || selectedUsers.size() == 0){
						addActionError("You must add at least one user to the group.");
						return "addDistGroup";
					}
					if (!distGroupName.equals("")){
						DistributionGroup d = (DistributionGroup)request.getSession().getAttribute("distGroupSelect");
						if(d != null){
							d.setName(distGroupName);
							d.setMembers(selectedUsers);

						}

						if(getSharedGroup().equals("public")){
							d.setPublicGroup(true);
							d.setVisnId(getVisnId());
						}
						else{
							d.setPublicGroup(false);
							d.setVisnId(null);
						}
						try{
							distributionGroupService.updateDistributionGroup(d);
						}catch(Exception e){
							if(log.isErrorEnabled()){
								log.error("Expection occured while updating distribution group");
							}
							addActionError("Distribution group names should be unique. Please try with other name.");
							return "addDistGroup";
						}
						Clinician c = (Clinician) user;

						List<Object[]> distList = distributionGroupDao.getAllDistributionGroupsByUserOrShared(c);
						c.setDistGroups(getDistributionGroup(distList));

					}else{
						addActionError("Please enter distribution group name.");
						return "addDistGroup";
					}
					clearDistSessionAttr();
					return STRUTS_RESULT;
				}
				if((selectAction!=null) && (selectAction.equalsIgnoreCase("Cancel")))
				{
					clearDistSessionAttr();
					return STRUTS_RESULT;
				}

			return "addDistGroup";
			}
		}
		return "addDistGroup";
	}


	public static final Comparator<DistributionGroup> GROUP_NAME_SORTER = new Comparator<DistributionGroup>() {
		public int compare(DistributionGroup a, DistributionGroup b) {
			if(a == null || b == null) return 0;
			int result = (a.getName().toUpperCase()).compareTo(b.getName().toUpperCase());
			if ( result == 0 ) {
				result = a.getName().toUpperCase().compareTo(b.getName().toUpperCase());
			}
			return result;
		}
	};


	public String editDistGroups(){

		Clinician c = (Clinician) user;
		List<DistributionGroup> dgs = (List<DistributionGroup>)distributionGroupService.
										getDistributionGroupsForClinician(c).getCollection();
		request.getSession().removeAttribute("availableUsers");

		// Validation for distribution group name should be selected in the drop down.(CQ: 5747)
		if(distGroup==null || distGroup.equals("")){
			addActionError("You must select a Group Name.");
			return "preferences";
		}

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Select"))){

			if ((!distGroup.equals("")) && (dgs != null)){

				for (DistributionGroup dg: dgs){
					if(String.valueOf(dg.getId()).equals(distGroup)){
						request.getSession().setAttribute("distGroupSelect", dg);
						request.getSession().setAttribute("distGroupName", dg.getName());
						request.getSession().setAttribute("selectedUsers", dg.getMembers());
					}
				}

			}else{
				return "preferences";
			}
			return "editDistGroups";
		}else if((selectAction!=null) && (selectAction.equalsIgnoreCase("Yes"))){
			if ((!distGroup.equals("")) && (dgs != null)){
				for (DistributionGroup dg: dgs){
					if(String.valueOf(dg.getId()).equals(distGroup)){
						distributionGroupService.deleteDistributionGroup(dg);
					}
				}
			}
			List<Object[]> distList = distributionGroupDao.getAllDistributionGroupsByUserOrShared(c);
			c.setDistGroups(getDistributionGroup(distList));
			return "preferences";
		}

		return "preferences";
	}

	public String editDistGroup(){

		List<User> availableUsers = new ArrayList<User>();
		selectedUsers = (List<User>)request.getSession().getAttribute("selectedUsers");
		if(((List<User>)request.getSession().getAttribute("availableUsers")) != null){
			availableUsers = (List<User>)request.getSession().getAttribute("availableUsers");
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Add ->"))){
			List<User> tempUsers = new ArrayList<User>();
			if (availableUsers != null){
			  	for(User du: availableUsers){
					String cId = String.valueOf(du.getId());
					if( availableMembers != null){
						Iterator iterator = availableMembers.iterator();
						if (iterator != null){
							while (iterator.hasNext()) {															;
								if(((String)iterator.next()).equals(cId)){
									if(log.isInfoEnabled()){
										log.info("editDistGroup Add:User Id:"+cId.toString());
									}
									tempUsers.add(du);
								}
							}
						}
					}
			  	}
			}
			if(tempUsers != null){
				for(User u:tempUsers){
					selectedUsers.add(u);
				}
			}
			Set set = new HashSet(selectedUsers);
			selectedUsers = new ArrayList(set);
			setDistEditSessionAttr();
			return "editDistGroup";
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("<- Remove"))){
			List<User> tempUsers = new ArrayList<User>();
			if (selectedUsers != null){
			  	for(User du: selectedUsers){
					String cId = String.valueOf(du.getId());
					if( selectedMembers != null){
						Iterator iterator = selectedMembers.iterator();
						if (iterator != null){
							while (iterator.hasNext()) {															;
								if(((String)iterator.next()).equals(cId)){
									if(log.isInfoEnabled()){
										log.info("editDistGroup Remove:User Id:"+cId.toString());
									}
									tempUsers.add(du);
								}
							}
						}
					}
			  	}
			}
			if(tempUsers != null){
				for(User u:tempUsers){
					availableUsers.add(u);
					selectedUsers.remove(u);
				}
			}
			Set set = new HashSet(availableUsers);
			availableUsers = new ArrayList(set);
			request.getSession().setAttribute("availableUsers", availableUsers);

			setDistEditSessionAttr();
			return "editDistGroup";
		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Save Group"))){

			if(selectedUsers==null || selectedUsers.size() == 0){
				addActionError("You must add at least one user to the group.");
				return "editDistGroup";
			}
			if (!distGroupName.equals("")){
				DistributionGroup d = (DistributionGroup)request.getSession().getAttribute("distGroupSelect");
				if(d != null){
					d.setName(distGroupName);
					if(selectedUsers != null){
						d.setMembers(selectedUsers);
					}
				}
				if(getSharedGroup().equals("public")){
					d.setPublicGroup(true);
					d.setVisnId(getVisnId());
				}
				else{
					d.setPublicGroup(false);
					d.setVisnId(null);
				}

				try{
					distributionGroupService.updateDistributionGroup(d);
				}catch(Exception e){
					if(log.isErrorEnabled()){
						log.error("Expection occured while updating distribution group");
					}
					addActionError("Distribution group names should be unique. Please try with other name.");
					return "addDistGroup";
				}

				Clinician c = (Clinician) user;

				List<Object[]> distList = distributionGroupDao.getAllDistributionGroupsByUserOrShared(c);
				c.setDistGroups(getDistributionGroup(distList));

			}else{
				addActionError("Please enter distribution group name.");
				return "editDistGroup";
			}
			clearDistSessionAttr();
			return STRUTS_RESULT;
		}

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Cancel"))){
			clearDistSessionAttr();
			return STRUTS_RESULT;
		}
		return "editDistGroup";

	}

	public List getDistributionGroup(List<Object[]> distributionList){

		List<DistributionGroup> distList1 = new ArrayList<DistributionGroup>();
		List<DistributionGroup> distList2 = new ArrayList<DistributionGroup>();
		for(Object[] object : distributionList)
		{
			DistributionGroup distGroup = new DistributionGroup();
			distGroup.setId(new Long(object[0].toString()));
			distGroup.setName(object[1].toString());
			distGroup.setOwner(userDao.findClinicianById(new Long(object[2].toString())));

			if(object[3].toString().equals("1"))
				distGroup.setPublicGroup(true);
			else
				distGroup.setPublicGroup(false);

			if(object[4]!=null)
				distGroup.setVisnId(new Long(object[4].toString()));
			else
				distGroup.setVisnId(null);

			if(!distGroup.isPublicGroup()){
				distList1.add(distGroup);
			}else{
				distList2.add(distGroup);
			}
		}
		Collections.sort(distList1,DIST_GROUP_SORTER);
		Collections.sort(distList2,DIST_GROUP_SORTER);
		distList1.addAll(distList2);

		distList2=null;
		distributionList=null;

		return distList1;
	}

	public String editSearchDistGroup(){
		clearUsers();
		/* Get All VISNs here before loading the DistGroup page */
		setVisns(getAllVisns());

		if(!((distGroupName == null) || distGroupName.equals("") || (distGroupName.equalsIgnoreCase("Enter Group Name")))){
			request.getSession().setAttribute("distGroupName", distGroupName);
		}
		request.getSession().setAttribute("sharedGroup", sharedGroup);
		request.getSession().removeAttribute("facilities");
		request.getSession().removeAttribute("disableAddButton");
		request.getSession().removeAttribute("displayVISNSelection");
		request.getSession().removeAttribute("otherFacilityVISNName");
		request.getSession().removeAttribute("otherFacilityVISNId");
		request.getSession().removeAttribute("otherFacilityVISNSelected");
		request.getSession().removeAttribute("otherFacilityFacilityName");
		request.getSession().removeAttribute("otherFacilityFacilityId");
		request.getSession().removeAttribute("otherFacilityFacilitySelected");
		return "editSearchDistGroup";
	}

	public String editUpdateDistGroup(){

		setVisns(getAllVisns());

		if(!((distGroupName == null) || distGroupName.equals("") || (distGroupName.equalsIgnoreCase("Enter Group Name")))){
			request.getSession().setAttribute("distGroupName", distGroupName);
		}
		request.getSession().setAttribute("sharedGroup", sharedGroup);
		String crudVal = "updateDistGroup";
		if((tab != null) && (tab.equals("1"))){
			String returnVal =  addPatientDistGroups(crudVal);
			return returnVal;

		}else if((tab != null) && (tab.equals("2"))){
			String returnVal =  addClinicianDistGroups(crudVal);
			return returnVal;
		}else if((tab != null) && (tab.equals("3"))){
			String returnVal =  addClinicianOSFDistGroups(crudVal);
			return returnVal;
		}
		return STRUTS_RESULT;
	}

	public void setDistEditSessionAttr(){
		request.getSession().setAttribute("distGroupName", distGroupName);
		request.getSession().setAttribute("sharedGroup", sharedGroup);

		//request.getSession().setAttribute("availableUsers", availableUsers);
		request.getSession().setAttribute("selectedUsers", selectedUsers);
	}

	public void clearDistSessionAttr(){
		request.getSession().removeAttribute("distGroupName");
		request.getSession().removeAttribute("sharedGroup");
		request.getSession().removeAttribute("patients");
		request.getSession().removeAttribute("clinicians");
		request.getSession().removeAttribute("selectedUsers");
		request.getSession().removeAttribute("availableUsers");
		request.getSession().removeAttribute("distGroupSelect");
	}

	public void clearUsers(){
		request.getSession().removeAttribute("patients");
		request.getSession().removeAttribute("clinicians");
	}

	public static final Comparator<DistributionGroup> DIST_GROUP_SORTER = new Comparator<DistributionGroup>() {
		public int compare(DistributionGroup a, DistributionGroup b) {
			if(a == null || b == null) return 0;
			return a.getName().toUpperCase().compareTo(b.getName().toUpperCase());
		}
	};

	public String addRemoveMembers(){

		return STRUTS_RESULT;
	}

	public String saveDistGroup(){

		return STRUTS_RESULT;
	}

	public void setTab(String tab) {
		this.tab = tab.substring(0,1);
	}

	public void setFirstName(String firstName) {
		this.firstName = (firstName == null)?"":firstName.trim();
	}

	public String getFirstName() {
		return firstName;
	}

	public void setLastName(String lastName) {
		this.lastName = (lastName == null)?"":lastName.trim();
	}

	public String getLastName() {
		return lastName;
	}

	public void setNssn(String nssn) {
		this.nssn = (nssn == null)?"":nssn.trim();
	}

	public String getNssn() {
		return nssn;
	}

	public void setSelectAction(String selectAction) {
		this.selectAction = selectAction;
	}

	public String getSelectAction() {
		return selectAction;
	}

	public void setAvailableMembers(List<String> availableMembers) {
		this.availableMembers = availableMembers;
	}

	public void setSelectedMembers(List<String> selectedMembers) {
		this.selectedMembers = selectedMembers;
	}

	public List<String> getAvailableMembers() {
		return availableMembers;
	}

	public List<String> getSelectedMembers() {
		return selectedMembers;
	}

	public void setDistGroupName(String distGroupName) {
		this.distGroupName = ((distGroupName == null) || (distGroupName.equalsIgnoreCase("Enter Group Name")))?"":distGroupName.trim();
	}

	public String getDistGroupName() {
		 return distGroupName;
	}

	public void setDistGroup(String distGroup) {
		this.distGroup = ((distGroup == null) || (distGroup.equalsIgnoreCase("distGroups_DEFAULT")))?"":distGroup;
	}

	public String getDistGroup() {
		return distGroup;
	}

	public String getSharedGroup() {
		return sharedGroup;
	}

	public void setSharedGroup(String sharedGroup) {
		this.sharedGroup = sharedGroup;
	}

	public FacilityDao getFacilityDao() {
		return facilityDao;
	}

	public void setFacilityDao(FacilityDao facilityDao) {
		this.facilityDao = facilityDao;
	}

	public Long getVisnId() {
		return visnId;
	}

	public void setVisnId(Long visnId) {
		this.visnId = visnId;
	}

	public Collection<Facility> getVisns() {
		return visns;
	}

	public void setVisns(Collection<Facility> visns) {
		this.visns = visns;
	}

	public Collection<Facility> getFacilities() {
		return facilities;
	}

	public void setFacilities(Collection<Facility> facilities) {
		this.facilities = facilities;
	}

	public UserDao getUserDao() {
		return userDao;
	}

	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

	public DistributionGroupDao getDistributionGroupDao() {
		return distributionGroupDao;
	}

	public void setDistributionGroupDao(DistributionGroupDao distributionGroupDao) {
		this.distributionGroupDao = distributionGroupDao;
	}

	public String getOtherFacilityVISNCancel() {
		return otherFacilityVISNCancel;
	}

	public String getOtherFacilityFacilityCancel() {
		return otherFacilityFacilityCancel;
	}

	public String getOtherFacilityVISNSelect() {
		return otherFacilityVISNSelect;
	}

	public String getOtherFacilityFacilitySelect() {
		return otherFacilityFacilitySelect;
	}

	public void setOtherFacilityVISNCancel(String otherFacilityVISNCancel) {
		this.otherFacilityVISNCancel = otherFacilityVISNCancel;
	}

	public void setOtherFacilityFacilityCancel(String otherFacilityFacilityCancel) {
		this.otherFacilityFacilityCancel = otherFacilityFacilityCancel;
	}

	public void setOtherFacilityVISNSelect(String otherFacilityVISNSelect) {
		this.otherFacilityVISNSelect = otherFacilityVISNSelect;
	}

	public void setOtherFacilityFacilitySelect(String otherFacilityFacilitySelect) {
		this.otherFacilityFacilitySelect = otherFacilityFacilitySelect;
	}

	public Long getOtherFacilityVISNId() {
		return otherFacilityVISNId;
	}

	public void setOtherFacilityVISNId(Long otherFacilityVISNId) {
		this.otherFacilityVISNId = otherFacilityVISNId;
	}

	public Long getOtherFacilityFacilityId() {
		return otherFacilityFacilityId;
	}

	public void setOtherFacilityFacilityId(Long otherFacilityFacilityId) {
		this.otherFacilityFacilityId = otherFacilityFacilityId;
	}



}
