package gov.va.med.mhv.sm.web.smActions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.foundation.util.ConfigurationManager;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.ContactUs;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.MHVPatient;
import gov.va.med.mhv.sm.service.ContactUsService;
import gov.va.med.mhv.sm.validate.ContactUsValidator;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;

public class ContactUsAction extends ActionSupport implements ServletRequestAware,
	Preparable, ModelDriven {

	private HttpServletRequest request;
	private ContactUsService contactUsService = null;

	private ContactUs contactUs = new ContactUs();
	public  ContactUsValidator contactUsValidator = null;
	private User user = null;
	private UserDao userDao = null;

	private static final List<String> STANDARD_SUBJECTS;
	private static final String OTHER = "Other";
	static {
		List<String> subjects = new ArrayList<String>();
                //JAZZ 26993 add Select Subject to drop-down list
		subjects.add("Select Subject");
		subjects.add("Future Functionality");
		subjects.add("Error Message Displayed");
		subjects.add("Application \"How Do I?\"");
		subjects.add("Compliments");
		subjects.add("Criticisms");
		subjects.add("Login Problems");
		subjects.add("Questions");
		subjects.add(OTHER);
		STANDARD_SUBJECTS = Collections.unmodifiableList(subjects);
	}
	private static final Log log = LogFactory.getLog(ContactUsAction.class);

	public String contactUsInput() throws Exception {
		Properties properties = null;
		log.info("Entering Properties class");
    	String strUserProfileId = "";
    	String strMHVID = "";
//		if ( user != null ) {
//			LOG.info("User email: " + user.getEmail());
//			contactUs.setEmailAddress(user.getEmail());
//			contactUs.setCreatedDate(new Date());
//			// CR 5141 - First name can be null
//			contactUs.setFirstName(user.getFirstName()!=null ? user.getFirstName() :"Null");
//			contactUs.setLastName(user.getLastName());
//			if(user.getUserType() == UserTypeEnum.PATIENT){
//				Patient p = (Patient)user;
//				SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
//				contactUs.setDateOfBirth(sdf.format(p.getDob()));
//
//				//Get MHV ID
//				MHVPatient mhvPatient = getUserDao().findMHVPatientByUserName(user.getUsername());
//				if( mhvPatient == null ) {
//					strMHVID = "";
//					strUserProfileId = "";
//				} else {
//					strMHVID = String.valueOf(mhvPatient.getMhvId());
//					strUserProfileId = String.valueOf(mhvPatient.getUserProfileId());
//				}
//				contactUs.setMHVId(strMHVID);
//				contactUs.setUserProfileId(strUserProfileId);
//				contactUs.setUserName(user.getUsername());
//			} else {
//				contactUs.setMHVId(user.getUsername());
//			}
//			getServletRequest().getSession().setAttribute("MHVID", contactUs.getMHVId());
//			getServletRequest().getSession().setAttribute("DOB", contactUs.getDateOfBirth());
			//String irisServerAddress = getIrisEncodedURL();
			//Referencing just tht no logged in URL
			String irisServerAddress = getIrisNotLoggedInURL();
			getServletRequest().getSession().setAttribute("irisServerAddress", irisServerAddress);
	    	contactUs.setIrisServerAddress(irisServerAddress);
	    	setContactUs(contactUs);
		//}
		return SUCCESS;
	}

    public String getIrisNotLoggedInURL() {
    	return getContactUsRedirectAddress();
    }

    public String getContactUsRedirectAddress() {
		Properties properties = ConfigurationManager.getConfiguration("/sm-iris.properties");
		//System.out.println("ContactUs IrisServerAddress: " + properties.getProperty("contactus.irisServerAddress"));
    	return properties.getProperty("contactus.irisServerAddress");
    }

	public String execute() {
		if ( ! StringUtils.isBlank(getServletRequest().getParameter("cancel")) ) {
			return "CANCEL";
		} else if ( isValid() ) {
			if ( OTHER.equals(getContactUs().getSubject()) ) {
				getContactUs().setSubject(getServletRequest().getParameter("other"));
			}
			// Send email to help desk
			contactUs.setMHVId((String)getServletRequest().getSession().getAttribute("MHVID"));
			contactUs.setDateOfBirth((String)getServletRequest().getSession().getAttribute("DOB"));
			getContactUsService().contactUs(getContactUs());
			return SUCCESS;
		} else {
			return INPUT;
		}
	}

	protected boolean isValid() {
		boolean result = true;
		if ( StringUtils.isBlank(getContactUs().getFirstName()) ) {
			addActionError("First Name is a required field.");
			result = false;
		}
		if ( StringUtils.isBlank(getContactUs().getLastName()) ) {
			addActionError("Last Name is a required field.");
			result = false;
		}
		if ( StringUtils.isBlank(getContactUs().getEmailAddress())
				&& StringUtils.isBlank(getContactUs().getPhoneNumber()) ) {

			addActionError("Email Address/Phone Number: You must enter either an Email Address, or Phone Number in the boxes provided.");
			result = false;
		} else {
			contactUsValidator = new ContactUsValidator();
			if(StringUtils.isNotBlank(getContactUs().getEmailAddress())){
				// Validate Email Address...
				if(!contactUsValidator.isValidEmailAddress(getContactUs().getEmailAddress())){
					addActionError("Invalid Email Address.");
					result = false;
				}
			}

			if(StringUtils.isNotBlank(getContactUs().getPhoneNumber())){
				 // Validate Phone Number...
				 if(!contactUsValidator.isValidPhoneNumber(getContactUs().getPhoneNumber())){
					 addActionError("Invalid Phone Number.");
					 result = false;
				 }
			}
		}

		if(getContactUs().getSubject().equals(OTHER)){
			if((getServletRequest().getParameter("other")).trim().length()==0 ){
				addActionError("If Subject of this contact is Other, please explain");
				result = false;
			}
		}

		if ( StringUtils.isBlank(getContactUs().getComments()) ) {
			addActionError("Comments is a required field.");
			result = false;
		}
		return result;
	}

	public void prepare() throws Exception {
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		this.setContactUsService((ContactUsService)ctx.getBean("contactUsService"));
		user = (User)getServletRequest().getSession().getAttribute(AbstractInboxAction.CURRENT_USER);
		setUserDao((UserDao)ctx.getBean("userDao"));
	}

	public void setServletRequest(HttpServletRequest httpServletRequest) {
		this.request = httpServletRequest;
	}

	public HttpServletRequest getServletRequest() {
		return request;
	}

	public ContactUsService getContactUsService() {
		return contactUsService;
	}

	public void setContactUsService(ContactUsService contactUsService) {
		this.contactUsService = contactUsService;
	}

	public ContactUs getContactUs() {
		return contactUs;
	}

	public void setContactUs(ContactUs contactUs) {
		this.contactUs = contactUs;
	}

	public boolean isPatient() {
		return user == null || ( UserTypeEnum.PATIENT == user.getUserType() );
	}

	public Object getModel() {
		return getContactUs();
	}

	public List<String> getStandardSubjects() {
		return STANDARD_SUBJECTS;
	}

	public UserDao getUserDao() {
		return userDao;
	}

	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

}
