package gov.va.med.mhv.sm.web.smActions;


import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dao.properties.SMPivProperties;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.AuthenticationService;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;


import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClinicianLoginFlow extends AbstractInboxAction {
	
	private static final long serialVersionUID = 6383024689021245788L;
	private static final Log log = LogFactory.getLog(ClinicianLoginFlow.class);
	
	private MailboxService mailboxService;
	private AuthenticationService authenticationService;
	private UserManagementService userManagementService;
	private TriageGroupService triageGroupService;
	private SMPivProperties smPivProperties;
	private int cprsAlertsCount;

	private String DUZ;
	private String station;
	private String networkId;

	private static final String AD_LOGIN="AD_LOGIN";
	private static final String SSO_LOGIN="SSO_LOGIN";
	private static final String SSO_LOGIN_ERROR="SSO_LOGIN_ERROR";
	private static final String CLINICIAN="CLINICIAN";
	private static final String CLINICIAN_ERROR="CLINICIAN_ERROR";
	private static final String CLINICIAN_OPTOUT="CLINICIAN_OPTOUT";
	
	public void prepare() throws Exception {
		super.prepare();
		mailboxService = (MailboxService) getBean("mailboxService");
		authenticationService = (AuthenticationService) getBean(
			"authenticationService");
		userManagementService = (UserManagementService) getBean(
			"userManagementService");
		triageGroupService = (TriageGroupService) getBean("triageGroupService");
		smPivProperties = (SMPivProperties) getBean("smPivProperties"); 
	}
	
	public String loginClinician() {
		setDUZ(getRequest().getParameter("DUZ"));
		setStation(getRequest().getParameter("station"));
		String CLINICIAN_LOGIN_METHOD=SSO_LOGIN;
		
		if(log.isInfoEnabled()){
			log.info("LoginClinician>>>100>>>DUZ: "+getDUZ()+"^Station: "+getStation()+"^SMPIVAuthFlag"+smPivProperties.getSmPivAuthenticationFlag());
		}
		if(smPivProperties.getSmPivAuthenticationFlag()!=null && smPivProperties.getSmPivAuthenticationFlag().equalsIgnoreCase(("true"))){
			if(log.isInfoEnabled()){
				log.info("ClinicianLoginFlow>>>101>>>DUZ :"+getDUZ()+" Login Method=SSO_PIV_LOGIN");
			}
			CLINICIAN_LOGIN_METHOD = SSO_LOGIN;
		}
		else{
			if(log.isInfoEnabled()){
				log.info("ClinicianLoginFlow>>>102>>>DUZ :"+getDUZ()+" Login Method=AD_LOGIN");
			}
			CLINICIAN_LOGIN_METHOD = AD_LOGIN;
		}
		return CLINICIAN_LOGIN_METHOD;
	}
	
	public String loginHome(){
		if(log.isInfoEnabled()){
			log.info("LoginHome>>>103>>>SM_LASTNAME="+getRequest().getHeader("SM_LASTNAME")+"^SM_FIRSTNAME="+getRequest().getHeader("SM_FIRSTNAME")+"^SM_NETWORKID="+getRequest().getHeader("SM_NETWORKID"));
			log.info("LoginHome>>>104>>>DUZ: "+getDUZ()+"^Station: "+getStation());
		}
		
		if(getRequest().getParameter("DUZ")!=null && getRequest().getParameter("DUZ").trim()!="")
				setDUZ(getRequest().getParameter("DUZ"));
		else
				setDUZ(null);
		
		if(getRequest().getParameter("station")!=null && getRequest().getParameter("station").trim()!="")
			setStation(getRequest().getParameter("station"));
		else
			setStation(null);
		
		if(getDUZ()!=null && getStation()!=null && getRequest().getHeader("SM_NETWORKID")!=null && getRequest().getHeader("SM_NETWORKID").trim()!=""){
			return clinicianInbox(getRequest().getHeader("SM_NETWORKID"),getDUZ(),getStation());	
		}else{
			addActionError("System is unable process the user's login. Please try again.");
			if(log.isInfoEnabled()){
				log.info("System is unable process the user's login=>DUZ="+getDUZ()+" Station="+getStation()+" NetworkId "+getRequest().getHeader("SM_NETWORKID"));
			}
			return CLINICIAN_ERROR; 
		}
	}

	private String clinicianInbox(String networkId,String DUZ,String station){
		
		ServiceResponse<Clinician> response = authenticationService.authenticateClinician(station, DUZ, networkId);

		Clinician clinician = response.getPayload();

		if (handleMessages(response)) {
			return CLINICIAN_ERROR;
		}
		
		assert (clinician != null);
		if(clinician.getStatus().equals(UserStatusEnum.OPT_OUT)) {
			if (getRequest() != null) {
				getSession().invalidate();
			}
			getSession().setAttribute("CLINICIANSTATUS","OPT_OUT");
		    return CLINICIAN_OPTOUT;
		}
		openCurrentFolderInMailBox(clinician);
		return CLINICIAN;
	}
	
	
	
	private void openCurrentFolderInMailBox(User user) {
		assert  isClinician(user);
		setCurrentUser(user);
		if (LOG.isDebugEnabled()) {
			LOG.debug("Fetching mailbox for '" + user.getUsername() + "'");
		}
		if (isClinician(user)) {
			int cprsCount = mailboxService.getCPRSAlertsCount(user.getId());
			if(cprsCount!=0){
				setCprsAlertsCount(cprsCount);
			}
			mailboxService.getMailbox((Clinician) user);
			String currentSurrogate = getSurrogateName((Clinician) user);
			getRequest().getSession().setAttribute("currentSurrogate", currentSurrogate);
			int reminderCount = mailboxService.getMessageReminderToday(user.getId());
			if(reminderCount >=1){
				getRequest().getSession().setAttribute("REMINDER_FLAG","YES");	
			}	
			
		}
		setMessageFilterId(user.getMessageFilter().getId());	// set the default message filter Id to display as 'selected' <option> for Bug# 6268.
		setCurrentFolder(getCurrentUserInbox());
		
	}
	public String getSurrogateName(User user) {
		Surrogate surrogate = userManagementService.getCurrentSurrogateFor((Clinician)user);
		String surrogateName = null;
		if(surrogate!=null){
			if(surrogate.getSurrogateType()==ParticipantTypeEnum.CLINICIAN){
			   User surrogateClinician = userManagementService.findById(surrogate.getSurrogateId());
			   surrogateName = surrogateClinician.getName();
			   surrogateClinician = null;
			}
			if(surrogate.getSurrogateType()==ParticipantTypeEnum.TRIAGE_GROUP){
				TriageGroup triageGroup = (TriageGroup)triageGroupService.findTriageGroupById(surrogate.getSurrogateId()).getPayload();
				surrogateName = triageGroup.getName();
				triageGroup=null;
			}
			getRequest().getSession().setAttribute("SURROGATE_ID_TO_REMOVE",surrogate.getId());
		}
		getRequest().getSession().setAttribute("surrogateName",surrogateName);
		return surrogateName;		
	}

	private String loginFailed(String logMessage, String userMessage) {
		if (StringUtils.isBlank(userMessage)) {
			userMessage = "Login attempt failed, due to invalid credentials.";
		}
		addActionError(userMessage);
		if (!StringUtils.isBlank(logMessage)) {
			if(log.isInfoEnabled()){
				log.info("login failed, because " + logMessage);	
			}
			
		} else {
			if(log.isInfoEnabled()){
				log.info("login failed");
			}
		}
		return loginFailed();
	}
	
	private String loginFailed() {
		invalidateSession();
		return "LOGINFAILED";
	}
	
	private String loginFailed(String logMessage) {
		return loginFailed(logMessage, null);
	}
	
	private void invalidateSession() {
		
		if (getRequest() != null) {
			getSession().invalidate();
			getSession().setAttribute(SESSION_ATTRIBUTE_LOGIN_ERRORS, getActionErrors());
		}
	}
	
	public String getDUZ() {
		return (getRequest() != null) ? getRequest().getParameter("DUZ") 
				: null;
	}

	public void setDUZ(String dUZ) {
		DUZ = dUZ;
	}

	public String getStation() {
		return (getRequest() != null) ? getRequest().getParameter("station") 
				: null;
	}

	public void setStation(String station) {
		this.station = station;
	}
	
	public String getNetworkId() {
		return networkId;
	}

	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}
	
	public SMPivProperties getSmPivProperties() {
		return smPivProperties;
	}

	public void setSmPivProperties(SMPivProperties smPivProperties) {
		this.smPivProperties = smPivProperties;
	}
	
	public int getCprsAlertsCount() {
		return cprsAlertsCount;
	}

	public void setCprsAlertsCount(int cprsAlertsCount) {
		this.cprsAlertsCount = cprsAlertsCount;
	}
	
	
}

