package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.crypto.MHVCipher;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Credentials;
import gov.va.med.mhv.sm.model.MhvAuthenticationSubject;
import gov.va.med.mhv.sm.model.MhvIntegrationSettings;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.dao.AddresseeDao;
import gov.va.med.mhv.sm.dao.SurrogateDao;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.model.decorator.MhvAuthenticationSubjectDecorator;
import gov.va.med.mhv.sm.service.AdminService;
import gov.va.med.mhv.sm.service.AuthenticationService;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.MhvIntegrationUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticateTest extends AbstractInboxAction {

	private static final long serialVersionUID = 3848513453789012534L;
	private static final Log LOG = LogFactory.getLog(Authenticate.class);


	private static final SimpleDateFormat DOB_DATE_FORMAT =
		new SimpleDateFormat("MM/dd/yyyy");

	private static final String CANNOT_USE_IN_PRODUCTION_MODE =
		"An attempt was made to use a test method in production mode";

	private MailboxService mailboxService;
	private AuthenticationService authenticationService;
	private UserManagementService userManagementService;
	private TriageGroupService triageGroupService;
	private SurrogateDao surrogateDao;
	private UserDao	userDao;
	private AddresseeDao addresseeDao;
	private MhvIntegrationUtils utils = null;
	private MhvAuthenticationSubject subject = new MhvAuthenticationSubject();
	private AdminService adminService;
	private int cprsAlertsCount;
	
	private String optIn;
	private Credentials credentials = null;

	public void prepare() throws Exception {
		super.prepare();
		mailboxService = (MailboxService) getBean("mailboxService");
		authenticationService = (AuthenticationService) getBean(
			"authenticationService");
		userManagementService = (UserManagementService) getBean(
			"userManagementService");
		triageGroupService = (TriageGroupService) getBean("triageGroupService");
		userDao = (UserDao)getBean("userDao");
		surrogateDao = (SurrogateDao)getBean("surrogateDao");
		utils = (MhvIntegrationUtils) getBean("mhvIntegrationUtils");
		addresseeDao = (AddresseeDao) getBean("addresseeDao");
		adminService = (AdminService) getBean("adminService");
	}

	/**
	 * Provides the authentication method for patient logging in to SM
	 * through MHV.
	 * @return One of the the following values
	 * <ul>
	 * 		<li>LOGINFAILED when the authentication of the patient failed</li>
	 * 		<li>PATIENT when the authentication succeeded and
	 *          the patient has opted-in to SM</li>
	 * 		<li>PATIENT_BLOCKED when the authentication succeeded and
	 *          the patient access to SM has been blocked</li>
	 * 		<li>OPTIN when the authentication succeeded and
	 *          the patient has opted-out or not yet opted-in to SM</li>
	 * </ul>
	 */
	public String loginIntegration() {
		ServiceResponse<Patient> response = (credentials != null)
			? authenticationService.authenticatePatient(credentials)
			: authenticationService.authenticatePatient(subject);
		if (hasError(response)) {
			return loginFailed(getErrorText(response) + " for " +
				MhvAuthenticationSubject.describe(subject));
		}
		Patient patient = response.getPayload();
		if (patient == null) {
			return loginFailed("No patient found for " +
				MhvAuthenticationSubject.describe(subject));
		}
		if (UserStatusEnum.OPT_IN.equals(patient.getStatus())) {
			openCurrentFolderInMailBox(patient);
			return "PATIENT";
		}

		if (UserStatusEnum.BLOCKED.equals(patient.getStatus())) {
			invalidateSession();
			return "PATIENT_BLOCKED";
		}

		setCurrentUser(patient);
		return "OPTIN";
	}


	public void getSurrogateName(User user) {
		Surrogate surrogate = surrogateDao.getCurrentSurrogateFor((Clinician)user);
		String surrogateName = null;
		if(surrogate!=null){
			if(surrogate.getSurrogateType()==ParticipantTypeEnum.CLINICIAN){
			 User surrogateClinician = userDao.findById(surrogate.getSurrogateId());
			 surrogateName = surrogateClinician.getName();
			 surrogateClinician = null;
			}
			if(surrogate.getSurrogateType()==ParticipantTypeEnum.TRIAGE_GROUP){
				TriageGroup triageGroup = (TriageGroup)triageGroupService.findTriageGroupById(surrogate.getSurrogateId()).getPayload();
				surrogateName = triageGroup.getName();
				triageGroup=null;
			}
			getRequest().getSession().setAttribute("SURROGATE_ID_TO_REMOVE",surrogate.getId());
		}
		getRequest().getSession().setAttribute("surrogateName",surrogateName);


	}

	public String getClinicianStation() {
		return (getRequest() != null) ? getRequest().getParameter("station")
			: null;
	}

	public String getDUZ() {
		return (getRequest() != null) ? getRequest().getParameter("DUZ")
			: null;
	}

	public String getOriginalUrl() {
		return (getRequest() != null) ? getRequest().getRequestURL().toString()
			: null;
	}


	public void setUserId(String userId) {
		// Note the difference between userid (used for test methods)
		// and userId (used for patient login from MHV)
		subject.setUserName(userId);
	}


	public void setFirstName(String firstName) {
		subject.setFirstName(firstName);
	}
	public void setLastName(String lastName) {
		subject.setLastName(lastName);
	}
	public void setSource(String source) {
		subject.setSource(source);
	}
	public void setIcn(String icn) {
		subject.setIcn(icn);
	}
	public void setSsn(String ssn) {
		subject.setSsn(ssn);
	}
    public void setAuthenticatedStatus(String authenticatedStatus) {
		subject.setAuthenticated("1".equals(authenticatedStatus));
	}
	public void setEmail(String email) {
		subject.setEmail(email);
	}
	public void setDob(String dob) {
		try {
			subject.setDob(DOB_DATE_FORMAT.parse(dob));
		} catch (ParseException e) {
			LOG.error("Unable to parse DOB (" + dob + ") for " +
				// Must use getParameter, because parameter may not
				// yet be set on this Authenticate instance
				getRequest().getParameter("userId"));
			subject.setDob(null);
		}
	}
	public void setChecksum(String checksum) {
		subject.setChecksum(checksum);
	}
	public void setTimestamp(String timestamp) {
		try {
			subject.setTimestamp(Long.parseLong(timestamp));
		} catch (NumberFormatException e) {
			LOG.error("Unable to parse timestamp (" + timestamp +
					")", e);
			subject.setTimestamp(null);
		}
	}
	public void setVisn(String[] visn) {
		subject.setVisns(visn);
	}
	public void setStation(String[] station) {
		subject.setFacilities(station);
	}
	public void setKey(String key) {
		credentials = new Credentials();
		credentials.setKey(key);
	}

	@Override
	public Log getLog() {
		return LOG;
	}

	/**
	 * Retrieves the 'userid' parameter from the request as a Long value
	 * @return The userid, provided it can be parsed as Long; null otherwise.
	 */
	private Long getUserid() {
		// Note the difference between userid (used for test methods)
		// and userId (used for patient login from MHV)
		String value = getRequest().getParameter("userid");
		try {
			return Long.valueOf(value);
		} catch(NumberFormatException e) {
			LOG.error("Unable to get userId from '" + value + "'", e);
			return null;
		}
	}

	private String loginFailed() {
		invalidateSession();
		return "LOGINFAILED";
	}
	private String loginFailed(String logMessage) {
		return loginFailed(logMessage, null);
	}
	private String loginFailed(String logMessage, String userMessage) {
		if (StringUtils.isBlank(userMessage)) {
			userMessage = "Login attempt failed, due to invalid credentials.";
		}
		addActionError(userMessage);
		if (!StringUtils.isBlank(logMessage)) {
			LOG.error("login failed, because " + logMessage);
		} else {
			LOG.debug("login failed");
		}
		return loginFailed();
	}


	private void invalidateSession() {
		if (getRequest() != null) {
			// The user successfully authenticated against the container,
			// but the credentials provided by the user conflicted with
			// the original request.
			// Therefore, the session must invalidated, such that the user
			// will be forced to re-authenticate and can provide other,
			// correct credentials.
			getSession().invalidate();
			// When upon failure, typically the browser should be redirected
			// to the original. In that case the session is the only way in
			// which to pass error information, such that it can be shown on
			// the authentication form.
			getSession().setAttribute(
				SESSION_ATTRIBUTE_LOGIN_ERRORS, getActionErrors());
		}
	}

	private void openCurrentFolderInMailBox(User user) {
		final boolean isPatient = isPatient(user);
		assert isPatient || isClinician(user);
		setCurrentUser(user);
		if (LOG.isDebugEnabled()) {
			LOG.debug("Fetching mailbox for '" + user.getUsername() + "'");
		}
		if (isPatient) {
			mailboxService.getMailbox((Patient) user);
			/*patientBlockedService = (PatientBlockedService) getBean("patientBlockedService");
			Collection<PatientBlockedTriageGroup> response=patientBlockedService.getPatientBlockedTriageGroupsByPatientId(getCurrentUser().getId()).getCollection();
			if(response!=null && response.size()!=0){
				setBlockedFromAnyTgFlag(true);
			}*/
		} else {
			int cprsCount = mailboxService.getCPRSAlertsCount(user.getId());
			if(cprsCount!=0){
				setCprsAlertsCount(cprsCount);
			}
			
			System.out.println("CPRS NOTES COUNT........."+cprsCount);
			
			mailboxService.getMailbox((Clinician) user);
			getSurrogateName((Clinician) user);
			int reminderCount = addresseeDao.getMessageReminderToday(user.getId());
			if(reminderCount >=1){
				getRequest().getSession().setAttribute("REMINDER_FLAG","YES");
			}

		}
		setMessageFilterId(user.getMessageFilter().getId());	// set the default message filter Id to display as 'selected' <option> for Bug# 6268.
		setCurrentFolder(getCurrentUserInbox());

	}



	//****************************************************************
	//Begin Opt In - Opt Out methods
	//****************************************************************

	public String optInOptOut(){
		User user = getCurrentUser();
		if (user == null) {
			return loginFailed("Authentication failed: user not found",
				"Login attempt failed: invalid username/password combination.");
		}

		if (hasCancelledOptIn()) {
			return (user.getStatus().equals(UserStatusEnum.OPT_IN))
				? "CANCEL" : "OPTIN";
		}

		UserStatusEnum newUserStatus = getNewUserStatus();
		if (UserStatusEnum.OPT_OUT.equals(newUserStatus)) {
			if (hasSubmittedOptOut()) {
				userManagementService.optOutUser(user);
				addActionError("You have successfully opted out of " +
					"'Secure Messaging'.");
				return "OPTOUTCONFIRM";
			}
			return "OPTOUT";
		}

		if (UserStatusEnum.OPT_IN.equals(newUserStatus)) {
			userManagementService.optInUser(user);
			openCurrentFolderInMailBox(user);
			return isPatient(user) ? "PATIENT" : "CLINICIAN";
		}

		addActionError("Authentication Failed: Opt in/Opt out failed.");
		return "OPTIN";
	}

	public void setOptIn(String optIn) {
			this.optIn = optIn;
	}

	public String getOptIn() {
			return optIn;
	}

	private String getOptOutSubmit() {
		return getRequest().getParameter("optOut_submit");
	}

	private boolean hasCancelledOptIn() {
		return "Cancel".equals(getRequest().getParameter("btn_cancel"))
			|| "Cancel".equals(getOptOutSubmit());
	}

	private boolean hasSubmittedOptOut() {
		return "Confirm".equalsIgnoreCase(getOptOutSubmit());
	}

	private UserStatusEnum getNewUserStatus() {
		try {
			Long value = Long.valueOf(getOptIn());
			return UserStatusEnum.valueOf(value);
		} catch (NumberFormatException e) {
			LOG.error("Unable to parse long value from '" + getOptIn() + "'");
			return null;
		}
	}

	//********************************************************************
	//End Opt In - Opt Out methods
	//********************************************************************

	//********************************************************************
	// Start Test related methods
	//********************************************************************

	public String authenticatePatient() {
		if (isProductionMode()) {
			return loginFailed(CANNOT_USE_IN_PRODUCTION_MODE);
		}
		subject = createTestPatientSubject(getUserid());
		return loginIntegration();
	}
	
	public String pcmmRTest() throws Exception{
		String str1 = getRequest().getParameter("helloTemp");
		if(str1!=null){
			System.out.println("PCMMRTEST0======>..."+str1);
			MHVCipher cipher1 = utils.createCipherForPCMMR();
			String str2 = cipher1.encrypt(str1);
			String str3 = cipher1.decrypt(str2);
			System.out.println("PCMMRTEST1======>..."+str2);
			System.out.println("PCMMRTEST2======>..."+str3);
		}else{
			System.out.println("str1 is null");
		}
		return SUCCESS;
	}

	public String authenticateClinician() {
		if (isProductionMode()) {
			return loginFailed(CANNOT_USE_IN_PRODUCTION_MODE);
		}
		Long userId = getUserid();
		ServiceResponse<Clinician> r = authenticationService.
			authenticateClinicianById(userId);
		Clinician clinician = r.getPayload();
		if (clinician == null) {
			return loginFailed("Clinician " + userId + " not found");
		}
		else{
			if(clinician.getStatus().equals(UserStatusEnum.OPT_OUT))
			{
				String error = "Login attempt failed, due to invalid credentials.";
				return loginFailed(error);
			}
		}


		openCurrentFolderInMailBox(clinician);
		return SUCCESS;
	}

	private boolean isProductionMode() {
		return utils.getSettings().isProductionMode();
	}

	private MhvAuthenticationSubject createTestPatientSubject(Long userId) {
		String facilities[] = new String[] {"989","979","994","991","658"};
		if (isProductionMode() || (userId == null)) {
			return null;
		}
		switch (userId.intValue()) {

		    case 1:
				return createPatientSubject("testercl1", "Chemtestone", "Mhvchemlabtestone",
						"705071305", "1012593917V121937", facilities);

		    case 2:
				return createPatientSubject("testercl2", "TestTwo", "Mhvchemlabtesttwo",
						"705071308", "1012638698V344915", facilities);

		    case 3:
				return createPatientSubject("testercl3", "TestThree", "Mhvchemlabtestthree",
						"710988777", "1011218157V958875", facilities);

			case 4:
				return createPatientSubject("testere", "Teste", "mhvjteste",
						"705070005", "1011231189V935260", facilities);

			case 5:
				return createPatientSubject("testerf", "Testf", "mhvjtestf",
						"705070006", "1011231190V196717", facilities);

			case 6:
				return createPatientSubject("testercal", "TestCal", "Mhvjcal",
						"705070028", "1011215535V949791", facilities);
			case 7:
				return createPatientSubject("testerjb7", "Testseven", "Mhvjbtestseven",
						"705071284", "1012593387V162271", facilities);

			case 8:
				return createPatientSubject("testerjb8", "Testeight", "Mhvjbtesteight",
						"705071285", "1012593389V474529", facilities);

			case 9:
				return createPatientSubject("testerjb9", "Testnine", "Mhvjbtestnine",
						"705070006", "1011231189V935265", facilities);
			case 10:
				return createPatientSubject("vets541", "SIMONSON", "MHVTP",
						"666864109", "1012664624V226015", new String[]{"991","994"});

			case 11:
				return createPatientSubject("mhvtbp", "PATIENT", "MHVDAYTB",
						"666292020", "1012662334V423591", new String[]{"994"});
			case 12:
				return createPatientSubject("vets855", "MALA", "MHVTP",
						"666985761", "1012664626V133902", new String[]{"991"});

			case 13:
				return createPatientSubject("rajesh", "SODIUM", "VFESMTP",
						"666837621", "1012848930V524344", new String[]{"991","994"});
				
			case 14:
				return createPatientSubject("vets459", "JULIET", "MHVTP",
						"666837621", "1012664623V592253", new String[]{"991","994"});	
			default:
				return null;
		}
	}

	private MhvAuthenticationSubject createPatientSubject(
		String userName, String firstName, String lastName, String ssn,
		String icn, String[] facilities)
	{
		
		return createPatientSubject(userName, firstName, lastName, ssn,
				new Date(), icn, facilities, "PII                   ");
	}
	private MhvAuthenticationSubject createPatientSubject(
		String userName, String firstName, String lastName, String ssn,
		Date dob, String icn, String[] facilities, String emailAddress)
	{
		MhvAuthenticationSubject subject = new MhvAuthenticationSubject();
		MHVCipher cipher = utils.createCipher();
		MHVCipher cipher1 = utils.createCipherForPCMMR();
		//System.out.println("Encrypted String with cipher..."+cipher.encrypt("HELLO"));
		String encryptedStr = cipher1.encrypt("E#R$t5y6");
		System.out.println("Encrypted Password of PCMM-R with 32 bit KEYLEN..."+encryptedStr);
		System.out.println("Decrypted Password of PCMM-R with 32 bit KEYLEN..."+cipher1.decrypt(encryptedStr));
		
		//System.out.println("Decrypted String with cipher1..."+cipher1.decrypt("66f5a3fb4e36c1befe7ac543dcdc2732"));
		//System.out.println("Decrypted String..."+cipher.decrypt("a0c074674ffd2973b83105e82c97d13d"));
		//System.out.println("Decrypted String......"+cipher1.decrypt("acaf3adefd8545b737e016d0faafa5f7"));
				
		MhvIntegrationSettings settings = utils.getSettings();
		Long timestamp = System.currentTimeMillis() + 5000;
		subject.setTimestamp(timestamp);
		subject.setUserName(userName);
		if(firstName == ""){
			subject.setFirstName("Null");
		}
		else{
			subject.setFirstName(firstName);
		}
		subject.setLastName(lastName);
		subject.setSsn((cipher != null) ? cipher.encrypt(ssn) : ssn);
		
		subject.setDob(dob);
		subject.setIcn((cipher != null) ? cipher.encrypt(icn) : icn);
		subject.setFacilities(facilities);
		subject.setEmail(emailAddress);
		subject.setSource((settings != null) ? settings.getPatientSource()
			: "MHV");
		subject.setAuthenticated(true);
		subject.setChecksum(new MhvAuthenticationSubjectDecorator(subject,
			utils).createChecksum());


		return subject;
	}
	public int getCprsAlertsCount() {
		return cprsAlertsCount;
	}

	public void setCprsAlertsCount(int cprsAlertsCount) {
		this.cprsAlertsCount = cprsAlertsCount;
	}
	
	
	//********************************************************************
	// End Test related methods
	//********************************************************************
}
