package gov.va.med.mhv.sm.web.smActions;

import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.foundation.web.xwork.AbstractBaseActionSupport;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.MessageFilterEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Mailbox;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.util.UserUtils;

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;

@SuppressWarnings("serial")
public abstract class AbstractInboxAction extends AbstractBaseActionSupport {

	public static final String CURRENT_THREAD = "currentThread";
	public static final String CURRENT_FOLDER = "currentFolder";
	public static final String CURRENT_ADDRESSEE = "currentAddressee";
	public static final String CURRENT_MESSAGE = "currentMessage";
	public static final String PREVIOUS_MESSAGES = "previousMessages";
	public static final String CURRENT_USER = "user";
	public static final String NEW_MESSAGE = "newMessage";
	public static final String DRAFT_MSG_ID = "draftMsgId";
	public static final String SEARCH_FORM = "searchForm";
	public static final String INVALID_SEARCH_ID = "invalidSearch";
	public static final String CURRENT_SUBFOLDER = "subfolder";
	

	public static final String SESSION_ATTRIBUTE_LOGIN_ERRORS = 
		AbstractInboxAction.class.getName() + ".loginErrors";
	
	// TODO: Should not use protected members; change to using getter 
	// and setters
	protected Long messageFilterId;
	protected List<MessageFilterEnum> messageFilters;
	protected List<MessageCategoryTypeEnum> messageCategories;
	
	protected Long messageCategoryTypeId;
	protected List<MessageCategoryTypeEnum> messageCategoryTypes;
	protected List<MessageCategoryTypeEnum> messageCategoryTypeEnum;
	
	public AbstractInboxAction() {
		super();
		messageFilters = MessageFilterEnum.toList();
		messageCategories = MessageCategoryTypeEnum.toList();
		//commented out value messageFilterId here and Its been set in Authenticate.java-openCurrentFolderInMailBox()
		//default message filter Id from user object to be displayed as 'selected' in <option> for Bug# 6268.
		
		//messageFilterId = MessageFilterEnum.ALL.getId();   
	}

	@Override
	public Log getLog() {
		return LOG;
	}

	public Long getMessageFilterId() {
		return messageFilterId;
	}
	public void setMessageFilterId(Long messageFilterId) {
		this.messageFilterId = messageFilterId;
	}
	public List<MessageFilterEnum> getMessageFilters() {
		return messageFilters;
	}

	public Long getMessageCategoryTypeId() {
		return messageCategoryTypeId;
	}
	public void setMessageCategoryTypeId(Long messageCategoryTypeId) {
		this.messageCategoryTypeId = messageCategoryTypeId;
	}
	public List<MessageCategoryTypeEnum> getMessageCategoryTypes() {
		return messageCategories;
	}
	
	/**
	 * Retrieves the current user from the session
	 * @return The user (if any) 
	 */
	protected User getCurrentUser() {
		return (User) getSession().getAttribute(CURRENT_USER);
	}
	/**
	 * Set the current user in the session
	 * @param user The user to set in the session 
	 */
	protected void setCurrentUser(User user) {
		getSession().setAttribute(CURRENT_USER, user);
	}

	protected String getCurrentUserName() {
		User user = getCurrentUser();
		return (user != null) ? user.getUsername() : "{No Current User}";
	}
	
	/**
	 * Retrieves the current folder from the session
	 * @return The folder (if any) 
	 */
	protected Folder getCurrentFolder() {
		return (Folder) getSession().getAttribute(CURRENT_FOLDER);
	}
	/**
	 * Set the current folder in the session
	 * @param folder The folder to set in the session 
	 */
	protected void setCurrentFolder(Folder folder) {
		getSession().setAttribute(CURRENT_FOLDER, folder);
	}
	
	protected Mailbox getCurrentUserMailbox() {
		User user = getCurrentUser();
		if (user == null) {
			return null;
		}
		return user.getMailbox();
	}

	protected Map<Long, Folder> getCurrentUserFolders() {
		Mailbox mailbox = getCurrentUserMailbox();
		if (mailbox == null) {
			return null;
		}
		return mailbox.getFolders();
	}
	
	protected void addCurrentUserFolder(Folder folder, boolean makeCurrent) {
		if (folder == null) {
			return;
		}
		Precondition.assertNotNull("folder.id", folder.getId());
		if (makeCurrent) {
			setCurrentFolder(folder);
		}
		Map<Long, Folder> folders = getCurrentUserFolders();
		if (folders == null) {
			return;
		}
		folders.put(folder.getId(), folder);
	}

	protected Folder getCurrentUserInbox() {
		Map<Long, Folder> folders = getCurrentUserFolders();
		if (folders == null) {
			return null;
		}
		Folder folder = folders.get(SystemFolderEnum.INBOX.getId());
		return folder;
	}

	public static boolean isPatient(User user) {
		return UserUtils.isPatient(user);
	}

	public static boolean isClinician(User user) {
		return UserUtils.isClinician(user);
	}
	 
	// Check whether the current user is field testing user for SM attachment
	public  String isFieldTestingUser(String fieldTesters)
	 {
			String isFieldTester="NO";
			
			if(fieldTesters!=null && !fieldTesters.trim().equals(""))
			{
				String[] fieldTestersList = fieldTesters.split( ",\\s*" );
				for(String userName:fieldTestersList){
					
					if(userName.equalsIgnoreCase(getCurrentUserName())){
			    		isFieldTester = "YES";
			    		break;
			    	}
			    }
			}
			return isFieldTester;
	}
}
