package gov.va.med.mhv.sm.web.filter;


import gov.va.med.mhv.sm.thread.CacheSMDomainHandler;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadLocalSessionFilter implements Filter {
	
	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(ThreadLocalSessionFilter.class);
	
	private FilterConfig filterConfig = null;

	public void destroy() {
		this.filterConfig = null;
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		
		CacheSMDomainHandler.resetInstance();
//		CacheSMDomainHandler.getInstance().setApplication("SM WEB");
		chain.doFilter(request, response);
		
	}

	public void init(FilterConfig filterConfig) throws ServletException {
		this.filterConfig = filterConfig;
	}
}
