package gov.va.med.mhv.sm.web.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.web.utils.ut;

public class ExpiredSessionFilter implements Filter {
	
	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(ExpiredSessionFilter.class);
	
	private String sessionTimeOutPage;
	private FilterConfig filterConfig = null;

	public void destroy() {
		this.filterConfig = null;
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {

		HttpServletRequest hreq = (HttpServletRequest)request;
		HttpServletResponse hresp = (HttpServletResponse)response;
		HttpSession session = hreq.getSession();
		
		if (filterConfig == null) {
			//log.info("FilterConfig is null");
			return;
		}

		boolean isSessionExpired = false;
		UserTypeEnum userType = ut.getUserTypeBasedOnHostInRequest(hreq);

		if (userType == UserTypeEnum.ADMINISTRATOR) {
			log.info("Administrators should not be logging into the patient/clinician SM application.");
			return;
		}
		
		if (filterConfig.getInitParameter("SessionTimeOutPage") != null) {
			sessionTimeOutPage = filterConfig.getInitParameter("SessionTimeOutPage");
		} else {
			sessionTimeOutPage = "sessionExpired.jsp";
		}

		// Get requested path
		String requestedPath = hreq.getRequestURI();

		log.debug("Requested path: " + requestedPath);
		
		// Process only if request's not for logon page, StyleSheet or images

		if (!requestedPath.endsWith("index.jsp") // dummy login page
			// session timeout page defined in web.xml
				&& !requestedPath.endsWith(sessionTimeOutPage)
			// test page
				&& !requestedPath.endsWith("index2.jsp")
				
			// dummy login action to authenticate any type of user
				&& !requestedPath.endsWith("login.action")
			// test clinician authentication action to bypass login
				&& !requestedPath.endsWith("authTestClinician.action")
			// test patient authentication action to bypass login
				&& !requestedPath.endsWith("authTestPatient.action")
				
				&& !requestedPath.endsWith("pcmmTest.action")
			// Action URL invoked from CPRS with station and DUZ
			// parameters, routed to LDAP/AD authentication page
				&& !requestedPath.endsWith("loginClinicianIntegration.action")
				
				&& !requestedPath.endsWith("smLoginClinicianIntegration.action")

			// Default session expiration page
				&& !requestedPath.endsWith("sessionExpired.jsp")
			// Temporary action routing to LDAP/AD authentication page
				&& !requestedPath.endsWith("loginPatient.action")
			// Temporary action invoked when patient passes authentication
			// but no patient exists - clears session and redirects to
			// loginPatient.action
				&& !requestedPath.endsWith("loginPatientFailed.action")
			// Show login failure and allow patient to retry
				&& !requestedPath.endsWith("patientLoginFailed.jsp")
			// AD/LDAP authentication page, configured in web.xml
				&& !requestedPath.endsWith("login.jsp")
			// AD/LDAP authentication error page, configured in web.xml
				&& !requestedPath.endsWith("loginError.jsp")
				
				&& !requestedPath.endsWith("loginHome.action")
				
			// Action URL invoked from MHV national portal
				&& !requestedPath.endsWith("loginIntegration.action")){
			// If there's a session open
			if(session.getAttribute("user") == null) {
					isSessionExpired = true;
			} 
		}

		if (isSessionExpired) {
			//log.info("session is expired....  redirecting to session expiration page");
			HttpServletResponseWrapper wrapper = new HttpServletResponseWrapper(hresp);
			wrapper.sendRedirect(wrapper.encodeRedirectURL(hreq.getContextPath() + "/" + sessionTimeOutPage));
		} else {
			//log.info("session is not expired");
			chain.doFilter(request, response);
		}
	}

	public void init(FilterConfig filterConfig) throws ServletException {
		this.filterConfig = filterConfig;
	}
}
