package gov.va.med.mhv.sm.wsclient;

import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.Date;

import gov.va.med.mhv.sm.wsclient.queriessvc.QueryServiceSoapProxy;
import gov.va.med.mhv.sm.wsclient.tiusvc.TIUServiceSoapProxy;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.AdminQueriesSoapProxy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntegrationServiceDelegate {
	private TIUServiceSoapProxy tiuProxy;
	private QueryServiceSoapProxy queriesProxy;
	private AdminQueriesSoapProxy adminQueriesProxy;
	
	private static final Log log = LogFactory.getLog(IntegrationServiceDelegate.class);

	public TIUServiceSoapProxy getTiuProxy() {
		return tiuProxy;
	}

	public void setTiuProxy(TIUServiceSoapProxy tiuPproxy) {
		this.tiuProxy = tiuPproxy;
	}
	
	public QueryServiceSoapProxy getQueriesProxy() {
		return queriesProxy;
	}

	public void setQueriesProxy(
			QueryServiceSoapProxy queriesProxy) {
		this.queriesProxy = queriesProxy;
	}

	
	public AdminQueriesSoapProxy getAdminQueriesProxy() {
		return adminQueriesProxy;
	}

	public void setAdminQueriesProxy(AdminQueriesSoapProxy adminQueriesProxy) {
		this.adminQueriesProxy = adminQueriesProxy;
	}
	
	/*public gov.va.med.mhv.sm.wsclient.tiusvc.AckType postNote(gov.va.med.mhv.sm.wsclient.tiusvc.Patient patient, gov.va.med.mhv.sm.wsclient.tiusvc.Document document, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.tiusvc.AckType result = null;
		result = tiuProxy.postNote(patient, document, station);
		
		return result;
	}*/
	
	public gov.va.med.mhv.sm.wsclient.tiusvc.PostWLCResponse postWLC(java.lang.String station, java.lang.String location, java.lang.String patient, java.lang.String patelig, gov.va.med.mhv.sm.wsclient.tiusvc.PatientClassifications patclass, java.lang.String dssunit, java.util.Calendar procDT, java.lang.String procedure, java.lang.String DUZ, java.lang.String providers, java.lang.String clinic, java.lang.String diagnosis) throws java.rmi.RemoteException{
		gov.va.med.mhv.sm.wsclient.tiusvc.PostWLCResponse result = null;
		result = tiuProxy.postWLC(station, location, patient, patelig,patclass, dssunit, procDT, procedure,DUZ,providers,clinic,diagnosis);
		return result;
	}
	
	/*public gov.va.med.mhv.sm.wsclient.tiusvc.AckType postNoteafterWLC(gov.va.med.mhv.sm.wsclient.tiusvc.Patient patient, gov.va.med.mhv.sm.wsclient.tiusvc.DocumentVLinked document, java.lang.String station) throws java.rmi.RemoteException{
		gov.va.med.mhv.sm.wsclient.tiusvc.AckType result = null;
		result = tiuProxy.postNoteafterWLC(patient, document, station);
		return result;
	}*/
	
	public gov.va.med.mhv.sm.wsclient.tiusvc.AckType postNoteafterWLCwithSMmsgID(gov.va.med.mhv.sm.wsclient.tiusvc.Patient patient, gov.va.med.mhv.sm.wsclient.tiusvc.DocumentVLinked document, java.lang.String station,java.lang.String SMmessageID) throws java.rmi.RemoteException{
		gov.va.med.mhv.sm.wsclient.tiusvc.AckType result = null;
		result = tiuProxy.postNoteafterWLCwithSMmsgID(patient, document, station,SMmessageID);
		return result;
	}
	
	public gov.va.med.mhv.sm.wsclient.tiusvc.DSSUnitQueryResponse getDSSUnits(java.lang.String station, java.lang.String clinic, java.lang.String DUZ) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.tiusvc.DSSUnitQueryResponse result = null;
		result = tiuProxy.getDSSUnits(station, clinic, DUZ);
		return result;
	}

	public gov.va.med.mhv.sm.wsclient.tiusvc.ECSProcedureQueryResponse getECSProcedures(java.lang.String station, java.lang.String locationIen, java.lang.String dssUnitIen) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.tiusvc.ECSProcedureQueryResponse result = null;
		result = tiuProxy.getECSProcedures(station, locationIen, dssUnitIen);
		return result;
	}
	
	public gov.va.med.mhv.sm.wsclient.tiusvc.PatientEClassQueryResponse getPatientEClassifications(java.lang.String station, java.lang.String dssUnitIen, java.lang.String patientIcn) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.tiusvc.PatientEClassQueryResponse result = null;
		result = tiuProxy.getPatientEClassifications(station, dssUnitIen, patientIcn);
		return result;
	}
	
	public gov.va.med.mhv.sm.wsclient.tiusvc.PatientProblemsQueryResponse getPatientProblems(java.lang.String station, java.lang.String patientid) throws java.rmi.RemoteException{
		gov.va.med.mhv.sm.wsclient.tiusvc.PatientProblemsQueryResponse result = null;
		result = tiuProxy.getPatientProblems(station, patientid);
		return result;
	}
	
	 public gov.va.med.mhv.sm.wsclient.tiusvc.DiagnosisQueryResponse getDiagnosis(java.lang.String station, java.lang.String diagnosis) throws java.rmi.RemoteException{
		gov.va.med.mhv.sm.wsclient.tiusvc.DiagnosisQueryResponse result = null;
		result = tiuProxy.getDiagnosis(station, diagnosis);
		return result;
	}
	
	public gov.va.med.mhv.sm.wsclient.queriessvc.PatientDemographicsResponse getPatientDemographics(String ssn, String station) throws RemoteException
	{
		gov.va.med.mhv.sm.wsclient.queriessvc.PatientDemographicsResponse result = null;
		gov.va.med.mhv.sm.wsclient.queriessvc.Patient pt = new gov.va.med.mhv.sm.wsclient.queriessvc.Patient();
		pt.setSSN(new BigDecimal(ssn));
		result = queriesProxy.getPatientDemographics(pt, station);
		return result;
	}

	public gov.va.med.mhv.sm.wsclient.queriessvc.UserLookupResponse getUserDemographics(String lastName, String firstName, String DUZ, String station) throws RemoteException
	{
		gov.va.med.mhv.sm.wsclient.queriessvc.UserLookupResponse result = null;
		result = queriesProxy.getUserDemographics(lastName, firstName, DUZ, station);
		return result;
	}

	/**
	 * Returns a list of PCMM Primary Care Practitioners at a facility
	 * matching user-entered provider/practitioner name.
	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 1.b</li>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM PCMM PROVIDER LOOKUP</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.ProviderLookupResponse getProvidersByNameAndDUZ(String lastName, String firstName, String DUZ, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.ProviderLookupResponse result = null;
		result = adminQueriesProxy.getProvidersByNameAndDUZ(lastName, firstName, DUZ, station);
		return result;
	}


	/**
	 * Returns a list of patients associated with the PCMM Primary Care Practitioner.
	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 1.c.iii</li>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 1.d</li>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM PCMM PROVIDER PATIENTS</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.PCMMProviderPatientsResponse getPatientsByProvider(String IEN, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.PCMMProviderPatientsResponse result = null;
		result = adminQueriesProxy.getPatientsByProvider(IEN, station);
		return result;
	}

	/**
	 * Returns a list of Clinics at a facility
	 * matching user-entered clinic name.
	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 2.b</li>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM CLINIC LOOKUP</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.ClinicLookupResponse getClinicsByName(String name, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.ClinicLookupResponse result = null;
		result = adminQueriesProxy.getClinicsByName(name, station);
		return result;
	}

	/**
	 * Returns a list of SM Clinics at a facility
	 * matching user-entered clinic name and credit stop code.
	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 2.b</li>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM CLINIC LOOKUP</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMClinicLookupResponse getClinicsByNameStopCode(String name, String station, String secondStopCode) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMClinicLookupResponse result = null;
		result = adminQueriesProxy.getClinicsByNameStopCode(name, station, secondStopCode);
		return result;
	}
	
	/**
	 * Returns a list of SM Tiu Titles  at a facility
	 * 	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 2.b</li>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM CLINIC LOOKUP</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMTIUTitleLookupResponse getCPRSTIUTitles(String station, String documentClass) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMTIUTitleLookupResponse result = null;
		result = adminQueriesProxy.getCPRSTIUTitles(station, documentClass);
		return result;
	}
	
	/**
	 * Returns a list of patients with appointments at clinic within x-y date range
	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 2.f</li>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM CLINIC PATIENTS</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.ClinicPatientsResponse getPatientsByClinicAndDate(String IEN, Date beginDate, Date endDate, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.ClinicPatientsResponse result = null;
		result = adminQueriesProxy.getPatientsByClinicAndDate(IEN, beginDate, endDate, station);
		return result;
	}

	/**
	 * Returns a list of CPRS (OE/RR) Teams
	 * matching user-entered team name.
	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 3.b</li>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM TEAM LOOKUP</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.TeamLookupResponse getTeamsByName(String name, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.TeamLookupResponse result = null;
		result = adminQueriesProxy.getTeamsByName(name, station);
		return result;
	}

	/**
	 * Returns a list of patients associated with the CPRS (OE/RR) team
	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 3.c.iii</li>
	 * <li>Group-Patient Linkage Lists [Use Case SM-10], Tech Solution 3.d</li>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM TEAM PATIENTS</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.TeamPatientsResponse getPatientsByTeam(String IEN, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.TeamPatientsResponse result = null;
		result = adminQueriesProxy.getPatientsByTeam(IEN, station);
		return result;
	}

	/**
	 * Returns an array of PCMM providers/clinics/teams that the patient belongs
	 * given clinic appointments within the specified date range.
	 * 
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * On 7/23/2008, it was decided that the patient identifier should be
	 * ICN instead of IEN(DFN) because SM does not routinely have the DFN
	 * for patients (MHV passes the ICN on login).
	 * 
	 * <ul>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM PATIENT RELATIONSHIPS</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.PatientRelationshipsResponse getRelationshipsByPatientAndDate(String ICN, Date beginDate, Date endDate, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.PatientRelationshipsResponse result = null;
		result = adminQueriesProxy.getRelationshipsByPatientAndDt(ICN, beginDate, endDate, station);
		return result;
	}

	/**
	 * Returns a list of users at a facility matching user-entered name.
	 *
	 * See https://subversion.myhealth.DNS   /mhv_docs/trunk/Secure%20Messaging%20System/Supporting%20Documentation/Integration%20Specifications.doc
	 * Version 1.1 - April 24, 2008
	 * <ul>
	 * <li>Auto-update Linkage Lists, Tech Solution, SM USER LOOKUP</li>
	 * </ul>
	 */
	public gov.va.med.mhv.sm.wsclient.adminqueriessvc.UserLookupResponse getUserByNameAndDUZ(String lastName, String firstName, String DUZ, String station) throws RemoteException {
		gov.va.med.mhv.sm.wsclient.adminqueriessvc.UserLookupResponse result = null;
		result = adminQueriesProxy.getUserByNameAndDUZ(lastName, firstName, DUZ, station);
		return result;
	}
}
