package gov.va.med.mhv.sm.wsclient;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * GenericSoapProxy is based on the *SoapProxy class generated by 
 * Eclipse 3.3.
 *
 * Web Service clients are generated using the Apache WSDL2Java utility, see
 * http://subversion.myhealth.DNS   /mhv_sms_ng/branches/hop/mhv-sm-domain/generate_ws_client.bat
 *
 * Eclipse 3.3 used the WSDL2Java utility to generate most of it's files,
 * but it also generated a Proxy class that allow us to add an endpoint and
 * timeout via Spring configuration.  Rather than requiring all developers
 * to use Eclipse 3.3 to regenerate clients, this abstract GenericSoapProxy
 * class was created.  To use it, just extend it, implement the
 * initSoapProxy to get the soap porttype using the generated locator,
 * and add the calls to the generated soap methods.
 *
 * T is the generated Soap interface
 */
public abstract class GenericSoapProxy<T extends java.rmi.Remote> {

	private static final Log log = LogFactory.getLog(GenericSoapProxy.class);
	
	protected String _endpoint = null;
	protected T genericSoap_PortType = null;
	protected int timeout = 10000;

	public GenericSoapProxy() {
		_initGenericSoapProxy();
	}

	public GenericSoapProxy(String endpoint) {
		_endpoint = endpoint;
		_initGenericSoapProxy();
	}

	/**
	 * Intended to be overridden like:
	 * <code>
	 * protected GeneratedSoap_PortType initSoapProxy()
	 *              throws javax.xml.rpc.ServiceException {
	 *     GeneratedLocator locator = new GeneratedLocator();
	 *     return locator.getGeneratedSoap();
	 * }
	 * </code>
	 **/
	protected abstract T initSoapProxy() throws javax.xml.rpc.ServiceException;
	
	protected void _initGenericSoapProxy() {
		try {
			genericSoap_PortType = initSoapProxy();
			if (genericSoap_PortType != null) {
				if (_endpoint != null)
					((javax.xml.rpc.Stub)genericSoap_PortType)._setProperty("javax.xml.rpc.service.endpoint.address", _endpoint);
				else
					_endpoint = (String)((javax.xml.rpc.Stub)genericSoap_PortType)._getProperty("javax.xml.rpc.service.endpoint.address");
				
				int theTimeout = this.getTimeout();
				((org.apache.axis.client.Stub)genericSoap_PortType).setTimeout(theTimeout);
			}
		}
		catch (javax.xml.rpc.ServiceException serviceException) {
			serviceException.printStackTrace();
		}
	}

  public String getEndpoint() {
    return _endpoint;
  }
  
  public void setEndpoint(String endpoint) {
    _endpoint = endpoint;
    if (genericSoap_PortType != null)
      ((javax.xml.rpc.Stub)genericSoap_PortType)._setProperty("javax.xml.rpc.service.endpoint.address", _endpoint);
    
  }
  
  public T getSoap() {
    if (genericSoap_PortType == null)
		_initGenericSoapProxy();
    return genericSoap_PortType;
  }
  

	public int getTimeout() {
		return timeout;
	}

	public void setTimeout(int timeout) {
		this.timeout = timeout;
		((org.apache.axis.client.Stub)getSoap()).setTimeout(timeout);
	}
  
}
