package gov.va.med.mhv.sm.util;

import gov.va.med.mhv.sm.service.impl.SendMessageServiceImpl;

import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XSSWrapperUtils {
	
	private XSSWrapperUtils() {
	}
	private static final Log log = LogFactory.getLog(XSSWrapperUtils.class);
	
	public static String sanitizeInput(String value) {
	    if (value != null) {
	    	//log.info("Inside the XSSWrapperUtils.santizeInput....."+value);
	        // Avoid null characters
	        value = value.replaceAll("", "");
	
	        // Avoid anything between script tags
	        Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", Pattern.CASE_INSENSITIVE);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        // Avoid anything in a src='...' type of expression
	        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\'(.*?)\\\'", Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        // Remove any lonesome </script> tag
	        scriptPattern = Pattern.compile("</script>", Pattern.CASE_INSENSITIVE);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        // Remove any lonesome <script ...> tag
	        scriptPattern = Pattern.compile("<script(.*?)>", Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        // Avoid eval(...) expressions
	        scriptPattern = Pattern.compile("eval\\((.*?)\\)", Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        // Avoid expression(...) expressions
	        scriptPattern = Pattern.compile("expression\\((.*?)\\)", Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        // Avoid javascript:... expressions
	        scriptPattern = Pattern.compile("javascript:", Pattern.CASE_INSENSITIVE);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        // Avoid vbscript:... expressions
	        scriptPattern = Pattern.compile("vbscript:", Pattern.CASE_INSENSITIVE);
	        value = scriptPattern.matcher(value).replaceAll("");
	
	        // Avoid onload= expressions
	        scriptPattern = Pattern.compile("onload(.*?)=", Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
	        value = scriptPattern.matcher(value).replaceAll("");
	    }
	    //log.info("After sanitized....."+value);
	    return value;
	}
}
