package gov.va.med.mhv.sm.util;

import gov.va.med.mhv.sm.dao.properties.SMWorkloadProperties;
import gov.va.med.mhv.sm.service.response.messages.SmsServiceMessages;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WorkloadUtil {

	// Returns the Name from the actual Text delimitted by '^'
	public static String getName(String actualText){
		if(actualText!=null){
			return actualText.substring(actualText.indexOf('^')+1,actualText.length());	
		}else{
			return null;
		}
	}
	
	//Returns the Ien from the actual Text delimitted by '^'
	public static String getIen(String actualText){
		if(actualText!=null){
			return actualText.substring(0,actualText.indexOf('^'));	
		}else{
			return null;
		}
	}
	
	public static String getNameWithIen(String str1, String str2){
		StringBuilder strBuilder = new StringBuilder(str1);
		strBuilder.append("^").append(str2);
		return strBuilder.toString();
	}
	
	
	public static Map sortedMap(Map unsortMap) {
		 
		List list = new LinkedList(unsortMap.entrySet());
 
		// sort list based on comparator
		Collections.sort(list, new Comparator() {
			public int compare(Object o1, Object o2) {
				return ((Comparable) ((Map.Entry) (o1)).getValue())
                                       .compareTo(((Map.Entry) (o2)).getValue());
			}
		});
 
		// put sorted list into map again
                //LinkedHashMap make sure order in which keys were inserted
		Map sortedMap = new LinkedHashMap();
		for (Iterator it = list.iterator(); it.hasNext();) {
			Map.Entry entry = (Map.Entry) it.next();
			sortedMap.put(entry.getKey(), entry.getValue());
		}
		return sortedMap;
	}
	
	// Check whether the current user's Facility is field testing facility and return the boolean.
	public static boolean isCurrentUserIsFieldTester(String usersStationNo,String fields)
	{
		boolean stationExists=false;
		String fieldList= fields;
		if(fieldList!=null && !fieldList.trim().equals(""))
		{
			String[] facilitiesList = fieldList.split( ",\\s*" ); 
			for(String stationNumber:facilitiesList){
		    	if(stationNumber.equals(usersStationNo)){
		    		stationExists = true;
		    		break;
		    	}
		    }
		}
		return stationExists;
	}
	
	public static String getProvidersWithDelimiter(String primaryProvider, String secProvider[]){
		StringBuilder str = new StringBuilder(primaryProvider);
		if(secProvider!=null){
			for (String str1 : secProvider) {
				if(!str1.equalsIgnoreCase(primaryProvider))str.append(";").append(str1);
			}
		}
		return str.toString();
	}
	
	public static Date getSystemDateTime(){
		return new Date();
	}
	
	public static String getProcedureDateTime(Date dateTime){
		 DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
		 return dateFormat.format(dateTime);
	}
	

	public static String getDSSErrorMessage(SMWorkloadProperties workloadProperties,String errorCode,String paramName){
		StringBuilder strBuilder1 = new StringBuilder();
		String dssErrorMessage = "";
		if(errorCode.startsWith(SmsServiceMessages.DSS_UNITS_ERROR1)){
			strBuilder1 = strBuilder1.append(workloadProperties.getWorkloadErrorDSS1());
			dssErrorMessage = MessageFormat.format(strBuilder1.toString(), paramName);
		}
		else if(errorCode.startsWith(SmsServiceMessages.DSS_UNITS_ERROR2)){
			dssErrorMessage = strBuilder1.append(workloadProperties.getWorkloadErrorDSS2()).toString();
			dssErrorMessage = MessageFormat.format(strBuilder1.toString(), paramName);
		}
		else if(errorCode.startsWith(SmsServiceMessages.DSS_UNITS_ERROR3)){
			dssErrorMessage = strBuilder1.append(workloadProperties.getWorkloadErrorDSS3()).toString();
		}
		else if(errorCode.startsWith(SmsServiceMessages.DSS_UNITS_ERROR4)){
			dssErrorMessage = strBuilder1.append(workloadProperties.getWorkloadErrorDSS4()).toString();
		}
		else if(errorCode.startsWith(SmsServiceMessages.DIAGNOSIS_ERR1)){
			dssErrorMessage = strBuilder1.append(workloadProperties.getWorkloadDiagnosisErr1()).toString();
			dssErrorMessage = MessageFormat.format(strBuilder1.toString(), paramName);
		}
		else if(errorCode.startsWith(SmsServiceMessages.DIAGNOSIS_ERR2)){
			dssErrorMessage = strBuilder1.append(workloadProperties.getWorkloadDiagnosisErr2()).toString();
		}
		else if(errorCode.startsWith(SmsServiceMessages.DIAGNOSIS_ERR3)){
			dssErrorMessage = strBuilder1.append(workloadProperties.getWorkloadDiagnosisErr3()).toString();
		}
		else if(errorCode.startsWith(SmsServiceMessages.DIAGNOSIS_ERR4)){
			dssErrorMessage = strBuilder1.append(workloadProperties.getWorkloadDiagnosisErr4()).toString();
		}
		else{
			dssErrorMessage = strBuilder1.append(workloadProperties.getWorkloadError()).toString();
		}
		
		return dssErrorMessage;
	}
	
	
}
