package gov.va.med.mhv.sm.util;

import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.model.SystemFolder;


public class SystemFolderFactory {

	public static SystemFolder createInboxFolder(){
		return createFolder(SystemFolderEnum.INBOX);
	}
	
	public static SystemFolder createSentFolder(){
		return createFolder(SystemFolderEnum.SENT);
	}
	
	public static SystemFolder createDraftsFolder(){
		return createFolder(SystemFolderEnum.DRAFTS);
	}
	
	public static SystemFolder createDeletedFolder(){
		return createFolder(SystemFolderEnum.DELETED);
	}
	
	public static SystemFolder createCompletedFolder(){
		return createFolder(SystemFolderEnum.COMPLETED);
	}
	
	public static SystemFolder createEscalatedFolder(){
		return createFolder(SystemFolderEnum.ESCALATED);
	}
	
	public static SystemFolder createFolder(SystemFolderEnum s){
		SystemFolder f = new SystemFolder();
		f.setId(s.getId());
		f.setName(s.getName());
		return f;
	}
	
	
}
