package gov.va.med.mhv.sm.util;

import gov.va.med.mhv.sm.enumeration.ReportingPeriodEnum;
import gov.va.med.mhv.sm.model.report.SelectElement;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PeriodsHelper {
	private static final Log log = LogFactory.getLog(PeriodsHelper.class);

	private static String[] monthsLong = {"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
	private static String[] monthsShort = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
	private static List<SelectElement> months = new ArrayList<SelectElement>();
	private static List<SelectElement> quarters = new ArrayList<SelectElement>();
	private static List<SelectElement> fiscal_years = new ArrayList<SelectElement>();
	private static List<SelectElement> weeks = new ArrayList<SelectElement>();
	private static int START_YEAR = 2008;
	private static int START_WEEK = 1;
	private static final String QUARTER_TXT = "Quarter ";


	public synchronized static List<SelectElement> getListOfWeeks() {
		//Fill in the weeks
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int week = cal.get(Calendar.WEEK_OF_YEAR);

		//Find current week
		cal.set(Calendar.DAY_OF_WEEK, 1);
		cal.set(Calendar.HOUR, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.AM_PM, 0);
		String currStart = DateUtils.getEnglishDateTimeSeconds(cal.getTime());

		cal.set(Calendar.DAY_OF_WEEK, 7);
		cal.set(Calendar.HOUR, 11);
		cal.set(Calendar.MINUTE, 59);
		cal.set(Calendar.SECOND, 59);
		cal.set(Calendar.AM_PM, 1);
		String currEnd = DateUtils.getEnglishDateTimeSeconds(cal.getTime());

		if( weeks.size() == 0 || !(weeks.get(weeks.size()-1).getValue().equals(currStart + "|" + currEnd))) {
			List<SelectElement> tmpWeeks = new ArrayList<SelectElement>();

			for( int y = START_YEAR; y <= year; y++ ) {
				for( int w = 0; w < 52; w++ ) {
					if( y == START_YEAR && w == 0) w = START_WEEK;
					if( w == week && y == year )
						break;
					cal.set(Calendar.WEEK_OF_YEAR, w);
					cal.set(Calendar.YEAR, y);
					cal.set(Calendar.DAY_OF_WEEK, 1);
					cal.set(Calendar.HOUR, 0);
					cal.set(Calendar.MINUTE, 0);
					cal.set(Calendar.SECOND, 0);
					cal.set(Calendar.AM_PM, 0);
					String startDisplay = DateUtils.getEnglishDate(cal.getTime());
					String startValue = DateUtils.getEnglishDateTimeSeconds(cal.getTime());

					cal.set(Calendar.DAY_OF_WEEK, 7);
					cal.set(Calendar.HOUR, 11);
					cal.set(Calendar.MINUTE, 59);
					cal.set(Calendar.SECOND, 59);
					cal.set(Calendar.AM_PM, 1);
					String endDisplay = DateUtils.getEnglishDate(cal.getTime());
					String endValue = DateUtils.getEnglishDateTimeSeconds(cal.getTime());
					tmpWeeks.add(new SelectElement(startDisplay+" - "+endDisplay, startValue + "|" + endValue ));
				}
			}
			weeks = tmpWeeks;
		}

		return weeks;
	}

	public synchronized static List<SelectElement> getListOfMonths() {
		Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) - 1;

		//If January go back to dec prior year
		if( month == -1 ) { month = 11; year = year - 1; }

		//Check to make sure current month/year are in the list since it's cached
		if( months.size() == 0 || !months.get(months.size()-1).getName().contains(monthsShort[month]) ) {
			List<SelectElement> tmpMonths = new ArrayList<SelectElement>();
			for( int y = START_YEAR; y <= year; y++ ) {
				for( int m = 0; m <= 11; m++) {
					if( y == year && m > month ){
						break;
					}
					else {
						tmpMonths.add(new SelectElement(monthsShort[m]+ " " + y, getStartDateForMonthAndYear(m,y)+"|"+getEndDateForMonthAndYear(m,y)));
					}
				}
			}
			months = tmpMonths;
		}

		return months;
	}

	public static String getStartDateForYear( int year ) {
		return getStartDateForMonthAndYear(0,year);
	}
	public static String getStartDateForMonthAndYear( int month, int year ) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.MONTH, month);
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.DAY_OF_MONTH,1);
		cal.set(Calendar.HOUR, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.AM_PM, 0);
		return DateUtils.getEnglishDateTimeSeconds(cal.getTime());
	}

	public static String getEndDateForYear( int year ) {
		return getEndDateForMonthAndYear(11,year);
	}
	public static String getEndDateForMonthAndYear( int month, int year ) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.MONTH, month);
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.HOUR, 11);
		cal.set(Calendar.MINUTE, 59);
		cal.set(Calendar.SECOND, 59);
		cal.set(Calendar.AM_PM, 1);
		int lastDate = cal.getActualMaximum(Calendar.DATE);
		cal.set(Calendar.DATE, lastDate);
		return DateUtils.getEnglishDateTimeSeconds(cal.getTime());
	}

	public synchronized static List<SelectElement> getListOfQuarters() {
		return getListOfQuarters(Calendar.getInstance());
	}

	public synchronized static List<SelectElement> getListOfQuarters( Calendar cal ) {

		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH);

		int currentQuarter=0;
		if(month>=9&&month<=11)currentQuarter=1;
		else if(month>=0&&month<=2)currentQuarter=2;
		else if(month>=3&&month<=5)currentQuarter=3;
		else if(month>=6&&month<=8)currentQuarter=4;

		int q = 0;
		int prevq = 0;
		boolean repopulate = false;

		if( quarters.size() > 0 ) {
			Calendar current = (Calendar)cal.clone();
			Calendar cal2 = (Calendar)cal.clone();
			String value = quarters.get(quarters.size()-1).getValue();
			String timestamp = value.substring(value.indexOf("|")+1);

			try {
				cal2.setTime(DateUtils.parseDateNoLeniency(timestamp,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT));
				cal2.add(Calendar.MONTH,3);
			} catch (ParseException e) {
				log.error("Unable to parse " + cal2);
			}

			if(current.after(cal2)) {
				repopulate = true;
			}
		}

		if( quarters.size() == 0 || repopulate) {
			List<SelectElement> newQuarters = new ArrayList<SelectElement>();
			//Fill the values.
			for( int y = START_YEAR; y <= year; y++ ) {
				for( int m = 0; m <= 11; m++) {
					if(m>=9&&m<=11)q=1;
					else if(m>=0&&m<=2)q=2;
					else if(m>=3&&m<=5)q=3;
					else if(m>=6&&m<=8)q=4;

					if( q == prevq ) {
						continue;
					} else {
						prevq = q;
					}

					int currFY = (q==1?y+1:y);

					if( (y == year && q == currentQuarter) ) {
						break;
					}
					else {
						String startDate = null;
						if( q == 1 )
							startDate = getStartDateForMonthAndYear(9,y);
						else if( q == 2 )
							startDate = getStartDateForMonthAndYear(0,y);
						else if( q == 3 )
							startDate = getStartDateForMonthAndYear(3,y);
						else if( q == 4 )
							startDate = getStartDateForMonthAndYear(6,y);

						String endDate = null;
						if( q == 1 )
							endDate = getEndDateForMonthAndYear(11,y);
						else if( q == 2 )
							endDate = getEndDateForMonthAndYear(2,y);
						else if( q == 3 )
							endDate = getEndDateForMonthAndYear(5,y);
						else if( q == 4 )
							endDate = getEndDateForMonthAndYear(8,y);

						newQuarters.add(new SelectElement(QUARTER_TXT + q + ", " + currFY , startDate + "|" + endDate ));
					}
				}
			}
			Collections.sort(newQuarters, SelectElement.QUARTER_SORTER);
			quarters = newQuarters;
		}

		return quarters;
	}

	public synchronized static List<SelectElement> getListOfFiscalYears() {
		Calendar cal = Calendar.getInstance();
		return getListOfFiscalYears(cal);
	}

	public synchronized static List<SelectElement> getListOfFiscalYears(Calendar current) {
		boolean repopulate = false;

		if( fiscal_years.size() > 0 ) {
			Calendar cal2 = Calendar.getInstance();
			String value = fiscal_years.get(fiscal_years.size()-1).getValue();
			String timestamp = value.substring(value.indexOf("|")+1);

			try {
				cal2.setTime(DateUtils.parseDateNoLeniency(timestamp,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT));
				cal2.add(Calendar.MONTH,12);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			if(current.after(cal2)) {
				repopulate = true;
			}
		}

		if( fiscal_years.size() == 0 || repopulate) {
			List<SelectElement> newFiscalYears = new ArrayList<SelectElement>();

			List<SelectElement> list = getListOfQuarters(current);

			for(SelectElement elem: list) {
				if( elem.getName().contains(QUARTER_TXT+"4") ) {
					String stdt = elem.getValue().substring(0,elem.getValue().indexOf('|'));
					Date d = null;
					try {
						d = DateUtils.parseDateNoLeniency(stdt,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
					} catch (ParseException e) {
						log.error("Unable to parse " + stdt);
					}

					Calendar dt = Calendar.getInstance();
					dt.setTime(d);
					int yr = dt.get(Calendar.YEAR);
					String startDate = getStartDateForMonthAndYear(9,yr-1);
					String endDate = getEndDateForMonthAndYear(8,yr);
					newFiscalYears.add(new SelectElement("FY " + yr , startDate + "|" + endDate ));
				}
			}

			Collections.sort(newFiscalYears);
			fiscal_years = newFiscalYears;
		}

		return fiscal_years;
	}


	public static Date getStartDateForDateParameter( String param ) throws ParseException {
		Date d = DateUtils.parseDateNoLeniency(param,DateUtils.ENGLISH_DATE_FORMAT);
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.set(Calendar.HOUR, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.AM_PM, 0);
		return cal.getTime();
	}

	public static Date getEndDateForDateParameter( String param ) throws ParseException {
		Date d = DateUtils.parseDateNoLeniency(param,DateUtils.ENGLISH_DATE_FORMAT);
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.set(Calendar.HOUR, 11);
		cal.set(Calendar.MINUTE, 59);
		cal.set(Calendar.SECOND, 59);
		cal.set(Calendar.AM_PM, 1);
//		System.out.println("------------>"+DateUtils.getEnglishDate(cal.getTime()));

		return cal.getTime();
	}

	public static Date getStartDateForWeekParameter( String param ) {
		if( param == null || param.length()==0 || param.equals("-1")) return null;
		String startDate = param.substring(0,param.indexOf('|'));
		Date d = null;
		try {
			d = DateUtils.parseDateNoLeniency(startDate,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
		} catch (ParseException e) {
			log.error("Unable to parse " + startDate);
		}
		return d;
	}

	public static Date getEndDateForWeekParameter( String param ) {
		if( param == null || param.length()==0 || param.equals("-1")) return null;
		String startDate = param.substring(param.indexOf('|')+1);
		Date d = null;
		try {
			d = DateUtils.parseDateNoLeniency(startDate,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
		} catch (ParseException e) {
			log.error("Unable to parse " + startDate);
		}
		return d;
	}

	public static Date getStartDateForMonthParameter( String param ) {
		if( param == null || param.length()==0 || param.equals("-1")) return null;
		String startDate = param.substring(0,param.indexOf('|'));
		Date d = null;
		try {
			d = DateUtils.parseDateNoLeniency(startDate,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
		} catch (ParseException e) {
			log.error("Unable to parse " + startDate);
		}
		return d;
	}

	public static Date getEndDateForMonthParameter( String param ) {
		if( param == null || param.length()==0 || param.equals("-1")) return null;
		String startDate = param.substring(param.indexOf('|')+1);
		Date d = null;
		try {
			d = DateUtils.parseDateNoLeniency(startDate,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
		} catch (ParseException e) {
			log.error("Unable to parse " + startDate);
		}
		return d;
	}

	public static Date getStartDateForQuarterParameter( String param ) {
		if( param == null || param.length()==0 || param.equals("-1")) return null;
		String startDate = param.substring(0,param.indexOf('|'));
		Date d = null;
		try {
			d = DateUtils.parseDateNoLeniency(startDate,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
		} catch (ParseException e) {
			log.error("Unable to parse " + startDate);
		}
		return d;
	}

	public static Date getEndDateForQuarterParameter( String param ) {
		if( param == null || param.length()==0 || param.equals("-1")) return null;
		String startDate = param.substring(param.indexOf('|')+1);
		Date d = null;
		try {
			d = DateUtils.parseDateNoLeniency(startDate,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
		} catch (ParseException e) {
			log.error("Unable to parse " + startDate);
		}
		return d;
	}

	public static Date getStartDateForYearParameter( String param ) {
		if( param == null || param.length()==0 || param.equals("-1")) return null;
		String startDate = param.substring(0,param.indexOf('|'));
		Date d = null;
		try {
			d = DateUtils.parseDateNoLeniency(startDate,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
		} catch (ParseException e) {
			log.error("Unable to parse " + startDate);
		}
		return d;
	}

	public static Date getEndDateForYearParameter( String param ) {
		if( param == null || param.length()==0 || param.equals("-1")) return null;
		String startDate = param.substring(param.indexOf('|')+1);
		Date d = null;
		try {
			d = DateUtils.parseDateNoLeniency(startDate,DateUtils.ENGLISH_DATE_TIME_SEC_FORMAT);
		} catch (ParseException e) {
			log.error("Unable to parse " + startDate);
		}
		return d;
	}


	public static List<String> create(Date start, Date end, ReportingPeriodEnum period) {
		//For now just regenerate the dates
		List<SelectElement> dates = null;
		List<String> result = new ArrayList<String>();

		switch(period) {
			case FISCAL_YEAR:
				dates = getListOfFiscalYears();
				for( SelectElement d: dates) {
					//SPECIAL CASE BECAUSE FISCAL YEAR SPANS TWO YEARS SO WE USE 1/1/{fiscal year -or- end date}
					if( !getStartDateForYearParameter(d.getValue()).before(start) && !getStartDateForYearParameter(d.getValue()).after(end))
						result.add("01/01/"+DateUtils.getEnglishDateYearOnly(getEndDateForYearParameter(d.getValue())));
				}
				break;
			case QUARTER:
				dates = getListOfQuarters();
				for( SelectElement d: dates) {
					if( !getStartDateForQuarterParameter(d.getValue()).before(start) && !getStartDateForQuarterParameter(d.getValue()).after(end))
						result.add(DateUtils.getEnglishDate(getStartDateForQuarterParameter(d.getValue())));
				}
				break;
			case MONTH:
				dates = getListOfMonths();
				for( SelectElement d: dates) {
					if( !getStartDateForMonthParameter(d.getValue()).before(start) && !getStartDateForMonthParameter(d.getValue()).after(end))
					result.add(DateUtils.getEnglishDate(getStartDateForMonthParameter(d.getValue())));
				}
				break;
			case WEEK:
				dates = getListOfWeeks();
				for( SelectElement d: dates) {
					if( !getStartDateForWeekParameter(d.getValue()).before(start) && !getStartDateForWeekParameter(d.getValue()).after(end))
					result.add(DateUtils.getEnglishDate(getStartDateForWeekParameter(d.getValue())));
				}
				break;
			case DAY:
				Calendar cal = Calendar.getInstance();
				cal.setTime(start);
				cal.add(Calendar.HOUR,2);  //To manage Daylight savings...

				Calendar cal2 = Calendar.getInstance();
				cal2.setTime(end);

				for( int i = 1; i<365; i++ ) {
					if(cal.after(cal2) ) {
						break;
					}
					result.add(DateUtils.getEnglishDate(cal.getTime()));
					cal.add(Calendar.HOUR,24);
				}
				break;
		}
		if( log.isInfoEnabled()) {
			log.info("result has " + result.size() + " elements");
		}
		return result;
	}

	public static String getQuarterYearForMonthYear(String month, String year) {
		int q=0;
		switch(Integer.parseInt(month)) {
			case 1:
			case 2:
			case 3:q=2; break;
			case 4:
			case 5:
			case 6:q=3; break;
			case 7:
			case 8:
			case 9: q=4; break;
			case 10:
			case 11:
			case 12: q=1; break;
		}
		return String.valueOf(q)+", "+String.valueOf(Integer.parseInt(year)+(q==1?1:0));
	}


	public static void main(String arg[]) {
		//System.out.println(getListOfFiscalYears().toString());
		//for(SelectElement s: getListOfFiscalYears()) {
		//	System.out.println(s.getName());
		//}
		//System.out.println(getListOfQuarters().toString());

		//System.out.println(getListOfFiscalYears());

//		for(SelectElement s: getListOfQuarters()) {
//			System.out.println(s.getName());
//		}
//
		/*Calendar c = Calendar.getInstance();
		try{ Thread.sleep(1000); } catch(Exception e) {}
		for( int i = 0; i<15; i++) {
			c.add(Calendar.MONTH,3);
			System.out.println("--"+DateUtils.getEnglishDate(c.getTime())+"-----------------------------------");
			for(SelectElement s: getListOfFiscalYears(c)) {
				System.out.println(s.getName() +" - "+ s.getValue());
			}
		}*/

		//System.out.println(getListOfMonths().toString());
		//System.out.println(getListOfWeeks().toString());
	}

//	public static void main(String arg[]) {
//		Calendar c = Calendar.getInstance();
//		c.add(Calendar.DATE,-21);
//		for(int i = 1; i <= 30; i++) {
//			Date d = new Date(c.getTimeInMillis()+(H24*i));
//			System.out.println(DateUtils.getEnglishDateTimeSeconds(d));
//		}
//	}
}
