package gov.va.med.mhv.sm.util;

import gov.va.med.mhv.foundation.crypto.ChecksumCalculator;
import gov.va.med.mhv.foundation.crypto.MHVCipher;
import gov.va.med.mhv.foundation.crypto.PasswordBasedKey;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.dao.MhvIntegrationSettingsDao;
import gov.va.med.mhv.sm.model.MhvIntegrationSettings;

import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MhvIntegrationUtils {
	
	private static final Log LOG = LogFactory.getLog(MhvIntegrationUtils.class);
	
	private final MhvIntegrationSettingsDao mhvIntegrationSettingsDao;
	
	
	
	public MhvIntegrationUtils(
		MhvIntegrationSettingsDao mhvIntegrationSettingsDao)
	{
		Precondition.assertNotNull("mhvIntegrationSettingsDao", 
				mhvIntegrationSettingsDao); 
		this.mhvIntegrationSettingsDao = mhvIntegrationSettingsDao;
	}
	
	public MhvIntegrationSettings getSettings() {
		return mhvIntegrationSettingsDao.getSettings();
	}
	
	public String calculateChecksum(Long timestamp, String lastName, 
		String[] stations, String[]  visns, Boolean national) 
	{
		StringBuilder result = new StringBuilder();
		result.append(timestamp);
		result.append(lastName);
		if (stations != null) {
			for(String station: stations) {
				result.append(station);
			}
		}
		if (visns != null) {
			for(String visn: visns) {
				result.append(visn);
			}
		}
		if (national != null) {
			result.append(national);
		}
		try {
			return (new ChecksumCalculator(getSettings().getSeed())).calculate(
				result.toString());
		} catch (NoSuchAlgorithmException e) {
			LOG.error("Failed to create the default check sum calculator. " +
				ChecksumCalculator.DEFAULT_ALGORITHM + 
				" provider must not be available in the used JVM", e);
			return null;
		}
	}

	public MHVCipher createCipher() {
		String encryptionPassword = getSettings().getEncryptionPassword();
		return (encryptionPassword != null)
			? new MHVCipher(new PasswordBasedKey(encryptionPassword))
			: null;
	}
	
	public MHVCipher createCipherForPCMMR() {
		String pcmmrEncryptionKey = getSettings().getPcmmrEncryptionKey();
		return (pcmmrEncryptionKey != null)
			? new MHVCipher(new PasswordBasedKey(pcmmrEncryptionKey,"PCMM"))
			: null;
	}
	
	public String getBase64EncryptedAuth(String userName, String password){
		String encryptedString = null;
		String decryptedPassword = createCipherForPCMMR().decrypt(password);
		try{
			String authenticationString = userName + ":" + decryptedPassword ;
			byte[] encAuthentication = Base64.encodeBase64(authenticationString.getBytes());
			encryptedString = new String(encAuthentication);
		}
		catch(Exception exp){
			if(LOG.isErrorEnabled()){
				LOG.error(("MhvIntegrationUtils=>Exception Occured getBase64EncryptedAuth=>"+exp));
			}
		}
		return encryptedString;
	} 

}
