package gov.va.med.mhv.sm.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import org.apache.commons.lang.time.DateFormatUtils;

public class DateUtils {

	public static String ENGLISH_DATE_FORMAT = "MM/dd/yyyy";
	public static String ENGLISH_DATE_TIME_FORMAT = "MM/dd/yyyy hh:mm a";
	public static String ENGLISH_DATE_TIME_SEC_FORMAT = "MM/dd/yyyy hh:mm:ss a";
	public static String ENGLISH_TIME_FORMAT = "hh:mm a";
	public static String ENGLISH_DATE_MONTH_DAY_ONLY_FORMAT = "MM/dd";
	public static String ENGLISH_DATE_YEAR_ONLY_FORMAT = "yyyy";
	public static String ENGLISH_DATE_DASH = "MM-dd-yyyy";
	public static String ENGLISH_DAYOFWEEK_FORMAT="EEE MMM dd yyyy @ HHmm";
	public static String ENGLISH_DD_MMM_YYYY_FORMAT="dd MMM yyyy @ HHmm";
	
	public static Date parseDate(String date, String format) throws ParseException {
		Date response = null;
		if (date != null) {
			SimpleDateFormat formatter = new SimpleDateFormat(format);
			response = formatter.parse(date);
		}
		return response;
	}

	public static Date parseDateNoLeniency(String date, String format) throws ParseException {
		Date response = null;
		if (date != null) {
			SimpleDateFormat formatter = new SimpleDateFormat(format);
			formatter.setLenient(false);
			response = formatter.parse(date);
		}
		return response;
	}

	public static Date parseFullDateTimeNoLeniency(String dt) throws ParseException {
		Date response = null;
		if (dt != null) {
			SimpleDateFormat formatter = new SimpleDateFormat(ENGLISH_DATE_TIME_FORMAT);
			formatter.setLenient(false);
			response = formatter.parse(dt);
		}
		return response;
	}

	public static Date parseFullDateTime(String dt) throws ParseException {
		Date response = null;
		if (dt != null) {
			SimpleDateFormat formatter = new SimpleDateFormat(ENGLISH_DATE_TIME_FORMAT);
			response = formatter.parse(dt);
		}
		return response;
	}

	public static String formatDate(Date date, String format) {
		if (date != null) {
			SimpleDateFormat formatter = new SimpleDateFormat(format);
			return formatter.format(date);
		} else
			return "";
	}
	
	public static String getEnglishDateMonthDayOnly(Date d) {
		return formatDate(d, ENGLISH_DATE_MONTH_DAY_ONLY_FORMAT);
	}

	public static String getEnglishDateYearOnly(Date d) {
		return formatDate(d, ENGLISH_DATE_YEAR_ONLY_FORMAT);
	}

	public static String getEnglishTime(Date d) {
		return formatDate(d, ENGLISH_TIME_FORMAT);
	}

	public static String getEnglishDate(Date d) {
		return formatDate(d, ENGLISH_DATE_FORMAT);
	}

	public static String getEnglishDateTime(Date d) {
		return formatDate(d, ENGLISH_DATE_TIME_FORMAT);
	}

	public static String getEnglishDateTimeSeconds(Date d) {
		return formatDate(d, ENGLISH_DATE_TIME_SEC_FORMAT);
	}

	public static Date dateOnly(Date a) throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat(ENGLISH_DATE_FORMAT);
		String x = formatDate(a, ENGLISH_DATE_FORMAT);
		return sdf.parse(x);
	}

	public static boolean isToday(Date a) {
		return isSameDay(a, new Date());
	}

	public static boolean isSameDay(Date a, Date b) {
		try {
			Date x = dateOnly(a);
			Date y = dateOnly(b);
			return x.equals(y);
		} catch (ParseException e) {
			return false;
		}
	}

	public static Date getLastYear() {
		Calendar c = Calendar.getInstance();
		c.add(Calendar.YEAR, -1);
		return c.getTime();
	}

	public static Date convertDateToTimeZone(Date date, String toZone) throws ParseException {
		Date result = null;
		TimeZone tz = TimeZone.getTimeZone(toZone);
		String tzTimeStr = DateFormatUtils.format(date, ENGLISH_DATE_TIME_FORMAT, tz, null);
		result =  org.apache.commons.lang.time.DateUtils.parseDate(tzTimeStr, new String[] {ENGLISH_DATE_TIME_FORMAT});
		return result;
	}

	public static long HOUR_IN_MILLIS = 1000*60*60;

	public static long getTimeOffset(TimeZone targetTimeZone) {
		TimeZone currentTimeZone = Calendar.getInstance().getTimeZone();
		int offset = targetTimeZone.getRawOffset() - currentTimeZone.getRawOffset();
		if( offset == 0 ) {
			return 0;
		}
		return (offset);
	}

	//Returns the offset with -difference from UTC so if we are in GMT-5 it will return "-5".
	public static int getHoursOffsetFromUTC(Calendar c) {
		TimeZone currentTimeZone = c.getTimeZone();
		TimeZone utc = TimeZone.getTimeZone("UTC");
		int offset = (int)((currentTimeZone.getRawOffset() - utc.getRawOffset())/HOUR_IN_MILLIS);
		return offset;
	}

	public static void main(String arg[]){
			Calendar c = Calendar.getInstance();
			c.add(Calendar.HOUR,getHoursOffsetFromUTC(Calendar.getInstance()));
	}

}
