package gov.va.med.mhv.sm.util;

import gov.va.med.mhv.foundation.util.ConfigurationManager;
import gov.va.med.mhv.sm.service.impl.EmailServiceImpl;

import java.util.Properties;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContactUsUtil {

	private static final Log log = LogFactory.getLog(ContactUsUtil.class);
	
	private static final Properties PROPS; 
	
	static {
		String fileName = "sm-contactus.properties";
		Properties configFile = ConfigurationManager.getConfiguration("/" + fileName);
		if ( configFile != null ) 
		{
			PROPS = configFile;
		} 
		else
		{
			log.error("Could not find properties file: " + fileName);
			PROPS = new Properties();
		}
	}
		
	public static String getContactUsMessage() {
	
		return PROPS.getProperty("contactus.message");
	}
	
	public static String getContactUsThankuMessage(){
		
		return PROPS.getProperty("contactus.thankyou.message");
	}
	
}
